#include <SyFi.h>
#include <Dof_Ptv.h>

//double Ptv::tolerance = 0.0001; 


using namespace SyFi; 
using namespace std; 

int main() {


    Dof_Ptv dof(true,true); 

    // initialization of Ptv used as dof 
    double x[2];
    x[0] = 0.0; x[1] = 0.0;  
    Ptv p(2,x); 


    // first triangle 
    p[0] = 0.0; p[1] = 0.0;  
    dof.insert_dof(0,1,p); 

    p[0] = 1.0; p[1] = 0.0;  
    dof.insert_dof(0,2,p); 

    p[0] = 0.0; p[1] = 1.0;  
    dof.insert_dof(0,3,p); 

    // second triangle 
    p[0] = 1.0; p[1] = 1.0;  
    dof.insert_dof(1,1,p); 

    p[0] = 1.0; p[1] = 0.0;  
    dof.insert_dof(1,2,p); 

    p[0] = 0.0; p[1] = 1.0;  
    dof.insert_dof(1,3,p); 



    // print out the global dofs
    // and their corresponding local dofs

    vector_ii vec; 
    pair<unsigned int,unsigned int> index; 
    Ptv exdof; 
    for (int i=0; i< dof.size(); i++) {
        exdof = dof.glob_dof(i); 
        cout <<"global dof " <<i<<" dof "<<exdof<<endl; 
//        vec = dof.glob2loc(i);
        for (unsigned int j=0; j<vec.size(); j++) { 
            index = vec[j]; 
            cout <<"  element "<<index.first<<" local dof "<<index.second<<endl; 
        }
    }
}



