// Copyright (C) 2009 Kent-Andre Mardal
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.
//
// Modified by Martin Alnæs 2009.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes the divergence matrix.

#include <dolfin.h>
#include "generated_code/DivMatrix.h"

using namespace dolfin;
using namespace DivMatrix;

int main()
{
  UnitSquare mesh(1, 1);

  BilinearForm::TrialSpace V(mesh);
  BilinearForm::TestSpace Q(mesh);

  BilinearForm a(Q, V);

  Matrix A; 
  assemble(A, a); 
  A.disp(); 

  return 0;
}

