/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_DIFF_SUMMARIZE_H
#define _SVN_DIFF_SUMMARIZE_H

// sc
#include "svn.h"
#include "util/String.h"

// sc
#include <svn_client.h>
#include "subversion/svn_diff_summarize.h"


namespace svn
{
class WcEntry;
class Lock;


// svn_client_diff_summarize_kind_t
enum DiffSummarizeKind
{
  DiffSummarize_Normal    = svn_client_diff_summarize_kind_normal,
  DiffSummarize_Added     = svn_client_diff_summarize_kind_added,
  DiffSummarize_Modified  = svn_client_diff_summarize_kind_modified,
  DiffSummarize_Deleted   = svn_client_diff_summarize_kind_deleted
};


// svn_client_diff_summarize_t
class DiffSummarize
{
public:
  DiffSummarize( const svn_client_diff_summarize_t* );
  DiffSummarize( const DiffSummarize& src );
  ~DiffSummarize();

  const sc::String& getName() const;
  DiffSummarizeKind getKind() const;
  bool              hasPropChanges() const;
  NodeKind          getNodeKind() const;

  bool isDir() const;

private:
  sc::String        _name;
  DiffSummarizeKind _kind;
  bool              _propChanged;
  NodeKind          _nodeKind;
};

} // namespace

#endif // _SVN_DIFF_SUMMARIZE_H

