/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * The grantlee's plugin to define filters.
 *
 * @author Stephane MANKOWSKI
 */
#include "skggrantleefilters.h"

#include <QtPlugin>

#include "skgdocumentfilter.h"
#include "skgobjectfilter.h"
#include "skgtraces.h"

SKGGrantleeFilters::SKGGrantleeFilters(QObject* iParent): QObject(iParent)
{
    SKGTRACEINFUNC(10);
}

SKGGrantleeFilters::~SKGGrantleeFilters()
{
    SKGTRACEINFUNC(10);
}

QHash< QString, Grantlee::Filter* > SKGGrantleeFilters::filters(const QString& iName)
{
    Q_UNUSED(iName);

    QHash<QString, Grantlee::Filter*> filtersList;
    filtersList.insert(QLatin1String("table"), new SKGDocumentTableFilter());
    filtersList.insert(QLatin1String("display"), new SKGDocumentDisplayFilter());
    filtersList.insert(QLatin1String("att"), new SKGObjectFilter());
    filtersList.insert(QLatin1String("money"), new SKGMoneyFilter());
    filtersList.insert(QLatin1String("percent"), new SKGPercentFilter());
    filtersList.insert(QLatin1String("dump"), new SKGDumpFilter());
    filtersList.insert(QLatin1String("encode"), new SKGUrlEncodeFilter());
    return filtersList;
}

Q_EXPORT_PLUGIN2(grantlee_skgfilters, SKGGrantleeFilters)   // NOLINT(readability/fn_size)
