#ifndef DSRGLWINDOW_H
#define DSRGLWINDOW_H

#include "molecule.h"
#include "dsrgui.h"

class DSRGlWindow : public QGLWidget
{
  Q_OBJECT

public:
  DSRGlWindow(QWidget *parent, Molecule *m, DSRMol header, QString fragment);
  virtual ~DSRGlWindow();
  CEnvironment xd;//!< MyAtom list of the molecule
  CEnvironment selFragAt;//! MyAtom list of selected fragment atoms
  CEnvironment fita;
  Connection bonds;//!< MyBond list of the molecule
  Connection fitabonds;
  Molecule *m_molecule;
  QString source_atoms;
  QCheckBox *showFit;
  QCheckBox *showFitLabel;
public slots:
  void display_fragment(DSRMol frag);
  void makeInfo();
  void clear_molecule();
signals:
  void sourceStringChanged();
  void updateInfo(QString);
protected:
  void initializeGL();
  void resizeGL(int width, int height);
  void paintGL();
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event); 
  void wheelEvent(QWheelEvent *event);
private:
  QFont myFont; //!< a font for the atom labels
  Molecule mole;
  GLint vp[4];
  void draw();
  double L, moux, mouy;
  void tryfit();
  virtual QSize sizeHint() const;
  virtual QSize minimumSizeHint() const;
};

#endif // DSRGLWINDOW_H
