from __future__ import print_function
from _mock import _Mock




MatchLevel = _Mock()

re = _Mock()

InvalidAlias = 'nada'

class AbstractTangoValidator(_Mock):
  pass
  protocol_prefix = 'tango://'
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="

class AttributeNameValidator(_Mock):
  pass
  attr = "/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class ConfigurationNameValidator(_Mock):
  pass
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  conf = "\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class DatabaseNameValidator(_Mock):
  pass
  complete_name = '(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})'
  db = '(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})'
  normal_name = '(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})'
  protocol_prefix = '((?P<scheme>tango)://)?'
  short_name = '(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})'
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="

class DatabaseQueryValidator(_Mock):
  pass
  complete_name = '(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)'
  normal_name = '(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)'
  protocol_prefix = 'tango://'
  query = '\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)'
  short_name = '\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)'
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="

class DeviceNameValidator(_Mock):
  pass
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  dev = "(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class DeviceQueryValidator(_Mock):
  pass
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)"
  protocol_prefix = 'tango://'
  query = '\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?query=(?P<query>[\\w\\-_]+)(?P<params>(\\?param=[\\w\\*\\?\\%\\-_]+)*)"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="

class Singleton(_Mock):
  pass


