// Copyright (C) 1999-2015
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __segment_h__
#define __segment_h__

#include "marker.h"
#include "list.h"

class Segment : public Marker {
 protected:
  List<Vertex> vertex;

  void renderX(Drawable, Coord::InternalSystem, RenderMode);
  void renderPS(int);
#ifdef MAC_OSX_TK
  void renderMACOSX();
#endif
#ifdef __WIN32
  void renderWIN32();
#endif

  void updateHandles();

  void moveVertex(const Vector&, int);
  void recalcCenter();

public:
  Segment(const Segment&);
  Segment(Base* p, const Vector& ctr,
	  const Vector& b,
	  const char* clr, int* dsh,
	  int wth, const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);
  Segment(Base* p, const List<Vertex>& v, 
	  const char* clr, int* dsh,
	  int wth, const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);

  virtual Marker* dup() {return new Segment(*this);}
  void updateCoords(const Matrix&);

  void edit(const Vector&, int);
  void rotate(const Vector&, int);

  void createVertex(int, const Vector&);
  void deleteVertex(int);
  int getSegment(const Vector&);
  void reset(const Vector&);

  void list(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int, int);
  void listXML(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat);
};

#endif
