#!/bin/bash
# bbou@ac-toulouse.fr
# 2006-04-13    
# conf/config-elinux.sh

### P A R A M S
# none
module=sadms
packages="checkpolicy setools"

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...

### S T A R T

function setup()
{
[ "$1" == "-v" ] && echo "+checking tools ${packages}"
for p in ${packages}; do
	if ! ${PACKAGETEST} ${p} > /dev/null ; then
		[ "$1" == "-v" ] && echo "${p} needed"
		yum -y install ${p}
	fi
done
}

function install()
{
echo "+fixing selinux policy to allow joining Active Directory"
echo "compile policy module ${module}"
if ! checkmodule -M -m -o ${module}.mod ${module}.te; then
	echo "${module}.te did not compile"
	return 1
fi

echo "package policy module ${module}"
if ! semodule_package -o ${module}.pp -m ${module}.mod; then
	echo "${module}.mod did not package"
	return 2
fi

echo "loading policy module ${module}"
if ! semodule -i ${module}.pp; then
	echo "${module}.pp did not load"
	return 3
fi
return 0
}

function status()
{
echo "current selinux policy:"
sesearch --allow -s samba_net_t -t ldap_port -c tcp_socket | grep '^allow'
sesearch --allow -s samba_net_t -t samba_var_t -c file | grep '^allow'
}

function remove()
{
echo "+removing ${module} policy module"
if ! semodule -r ${module}; then
	echo "failed to remove ${module} policy module"
	return 1
fi
return 0
}

function sethomes()
{
	setsebool -P samba_enable_home_dirs=1
}

function resethomes()
{
	setsebool -P samba_enable_home_dirs=0
}

function gethomes()
{
	getsebool samba_enable_home_dirs
}

setup
case $1 in
	install)
		status
		install
		status
		;;
	remove)
		remove
		status
		;;
	status)
		status
		;;
	sethomes)
		sethomes
		gethomes
		;;
	resethomes)
		resethomes
		gethomes
		;;
	gethomes)
		gethomes
		;;
	*)
		echo "Usage: $0 install|remove|statusi|sethomes|resethomes|gethomes"
esac

