#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:36:08 
# _install-kerberos.sh 

### P A R A M S

MYNARGS=$#
MYPAM="$1"
if [ "${MYPAM}" == "-pam" ];then
	shift
else
	MYPAM=
fi
MYREALM="$1"
MYDNS="$2"
MYKDC="$3"
if [ ${MYNARGS} -lt 3 ]
then
	echo "Incorrect number of parameters"
	exit 1
fi

### I N C L U D E

. ./_include.sh

### S T A R T

# S T A T U S
[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
echo '0' > /var/lib/sadms/kerberos

# H E A D E R
echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "configure Kerberos"
echo "-------------------------------------------------------------------------------"
echo "[BEGIN]"
# make sure real is uppercase
realm=`echo "${MYREALM}" | tr '[:lower:]' '[:upper:]'`

# make sure real is uppercase
pushd conf > /dev/null
./config-kerberos.sh "${realm}" "${MYDNS}" "${MYKDC}"
popd > /dev/null
echo "[END]"
