# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_upload_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    blob_type = kwargs.pop('blob_type', "BlockBlob")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    content_length = kwargs.pop('content_length')  # type: int
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    transactional_content_md5 = kwargs.pop('transactional_content_md5', None)  # type: Optional[bytearray]
    blob_content_type = kwargs.pop('blob_content_type', None)  # type: Optional[str]
    blob_content_encoding = kwargs.pop('blob_content_encoding', None)  # type: Optional[str]
    blob_content_language = kwargs.pop('blob_content_language', None)  # type: Optional[str]
    blob_content_md5 = kwargs.pop('blob_content_md5', None)  # type: Optional[bytearray]
    blob_cache_control = kwargs.pop('blob_cache_control', None)  # type: Optional[str]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    blob_content_disposition = kwargs.pop('blob_content_disposition', None)  # type: Optional[str]
    encryption_key = kwargs.pop('encryption_key', None)  # type: Optional[str]
    encryption_key_sha256 = kwargs.pop('encryption_key_sha256', None)  # type: Optional[str]
    encryption_algorithm = kwargs.pop('encryption_algorithm', None)  # type: Optional[Union[str, "_models.EncryptionAlgorithmType"]]
    encryption_scope = kwargs.pop('encryption_scope', None)  # type: Optional[str]
    tier = kwargs.pop('tier', None)  # type: Optional[Union[str, "_models.AccessTierOptional"]]
    if_modified_since = kwargs.pop('if_modified_since', None)  # type: Optional[datetime.datetime]
    if_unmodified_since = kwargs.pop('if_unmodified_since', None)  # type: Optional[datetime.datetime]
    if_match = kwargs.pop('if_match', None)  # type: Optional[str]
    if_none_match = kwargs.pop('if_none_match', None)  # type: Optional[str]
    if_tags = kwargs.pop('if_tags', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]
    blob_tags_string = kwargs.pop('blob_tags_string', None)  # type: Optional[str]
    immutability_policy_expiry = kwargs.pop('immutability_policy_expiry', None)  # type: Optional[datetime.datetime]
    immutability_policy_mode = kwargs.pop('immutability_policy_mode', None)  # type: Optional[Union[str, "_models.BlobImmutabilityPolicyMode"]]
    legal_hold = kwargs.pop('legal_hold', None)  # type: Optional[bool]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{containerName}/{blob}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-blob-type'] = _SERIALIZER.header("blob_type", blob_type, 'str')
    if transactional_content_md5 is not None:
        _header_parameters['Content-MD5'] = _SERIALIZER.header("transactional_content_md5", transactional_content_md5, 'bytearray')
    _header_parameters['Content-Length'] = _SERIALIZER.header("content_length", content_length, 'long')
    if blob_content_type is not None:
        _header_parameters['x-ms-blob-content-type'] = _SERIALIZER.header("blob_content_type", blob_content_type, 'str')
    if blob_content_encoding is not None:
        _header_parameters['x-ms-blob-content-encoding'] = _SERIALIZER.header("blob_content_encoding", blob_content_encoding, 'str')
    if blob_content_language is not None:
        _header_parameters['x-ms-blob-content-language'] = _SERIALIZER.header("blob_content_language", blob_content_language, 'str')
    if blob_content_md5 is not None:
        _header_parameters['x-ms-blob-content-md5'] = _SERIALIZER.header("blob_content_md5", blob_content_md5, 'bytearray')
    if blob_cache_control is not None:
        _header_parameters['x-ms-blob-cache-control'] = _SERIALIZER.header("blob_cache_control", blob_cache_control, 'str')
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if blob_content_disposition is not None:
        _header_parameters['x-ms-blob-content-disposition'] = _SERIALIZER.header("blob_content_disposition", blob_content_disposition, 'str')
    if encryption_key is not None:
        _header_parameters['x-ms-encryption-key'] = _SERIALIZER.header("encryption_key", encryption_key, 'str')
    if encryption_key_sha256 is not None:
        _header_parameters['x-ms-encryption-key-sha256'] = _SERIALIZER.header("encryption_key_sha256", encryption_key_sha256, 'str')
    if encryption_algorithm is not None:
        _header_parameters['x-ms-encryption-algorithm'] = _SERIALIZER.header("encryption_algorithm", encryption_algorithm, 'str')
    if encryption_scope is not None:
        _header_parameters['x-ms-encryption-scope'] = _SERIALIZER.header("encryption_scope", encryption_scope, 'str')
    if tier is not None:
        _header_parameters['x-ms-access-tier'] = _SERIALIZER.header("tier", tier, 'str')
    if if_modified_since is not None:
        _header_parameters['If-Modified-Since'] = _SERIALIZER.header("if_modified_since", if_modified_since, 'rfc-1123')
    if if_unmodified_since is not None:
        _header_parameters['If-Unmodified-Since'] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')
    if if_match is not None:
        _header_parameters['If-Match'] = _SERIALIZER.header("if_match", if_match, 'str')
    if if_none_match is not None:
        _header_parameters['If-None-Match'] = _SERIALIZER.header("if_none_match", if_none_match, 'str')
    if if_tags is not None:
        _header_parameters['x-ms-if-tags'] = _SERIALIZER.header("if_tags", if_tags, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    if blob_tags_string is not None:
        _header_parameters['x-ms-tags'] = _SERIALIZER.header("blob_tags_string", blob_tags_string, 'str')
    if immutability_policy_expiry is not None:
        _header_parameters['x-ms-immutability-policy-until-date'] = _SERIALIZER.header("immutability_policy_expiry", immutability_policy_expiry, 'rfc-1123')
    if immutability_policy_mode is not None:
        _header_parameters['x-ms-immutability-policy-mode'] = _SERIALIZER.header("immutability_policy_mode", immutability_policy_mode, 'str')
    if legal_hold is not None:
        _header_parameters['x-ms-legal-hold'] = _SERIALIZER.header("legal_hold", legal_hold, 'bool')
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_put_blob_from_url_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    blob_type = kwargs.pop('blob_type', "BlockBlob")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    content_length = kwargs.pop('content_length')  # type: int
    copy_source = kwargs.pop('copy_source')  # type: str
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    transactional_content_md5 = kwargs.pop('transactional_content_md5', None)  # type: Optional[bytearray]
    blob_content_type = kwargs.pop('blob_content_type', None)  # type: Optional[str]
    blob_content_encoding = kwargs.pop('blob_content_encoding', None)  # type: Optional[str]
    blob_content_language = kwargs.pop('blob_content_language', None)  # type: Optional[str]
    blob_content_md5 = kwargs.pop('blob_content_md5', None)  # type: Optional[bytearray]
    blob_cache_control = kwargs.pop('blob_cache_control', None)  # type: Optional[str]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    blob_content_disposition = kwargs.pop('blob_content_disposition', None)  # type: Optional[str]
    encryption_key = kwargs.pop('encryption_key', None)  # type: Optional[str]
    encryption_key_sha256 = kwargs.pop('encryption_key_sha256', None)  # type: Optional[str]
    encryption_algorithm = kwargs.pop('encryption_algorithm', None)  # type: Optional[Union[str, "_models.EncryptionAlgorithmType"]]
    encryption_scope = kwargs.pop('encryption_scope', None)  # type: Optional[str]
    tier = kwargs.pop('tier', None)  # type: Optional[Union[str, "_models.AccessTierOptional"]]
    if_modified_since = kwargs.pop('if_modified_since', None)  # type: Optional[datetime.datetime]
    if_unmodified_since = kwargs.pop('if_unmodified_since', None)  # type: Optional[datetime.datetime]
    if_match = kwargs.pop('if_match', None)  # type: Optional[str]
    if_none_match = kwargs.pop('if_none_match', None)  # type: Optional[str]
    if_tags = kwargs.pop('if_tags', None)  # type: Optional[str]
    source_if_modified_since = kwargs.pop('source_if_modified_since', None)  # type: Optional[datetime.datetime]
    source_if_unmodified_since = kwargs.pop('source_if_unmodified_since', None)  # type: Optional[datetime.datetime]
    source_if_match = kwargs.pop('source_if_match', None)  # type: Optional[str]
    source_if_none_match = kwargs.pop('source_if_none_match', None)  # type: Optional[str]
    source_if_tags = kwargs.pop('source_if_tags', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]
    source_content_md5 = kwargs.pop('source_content_md5', None)  # type: Optional[bytearray]
    blob_tags_string = kwargs.pop('blob_tags_string', None)  # type: Optional[str]
    copy_source_blob_properties = kwargs.pop('copy_source_blob_properties', None)  # type: Optional[bool]
    copy_source_authorization = kwargs.pop('copy_source_authorization', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{containerName}/{blob}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['x-ms-blob-type'] = _SERIALIZER.header("blob_type", blob_type, 'str')
    if transactional_content_md5 is not None:
        _header_parameters['Content-MD5'] = _SERIALIZER.header("transactional_content_md5", transactional_content_md5, 'bytearray')
    _header_parameters['Content-Length'] = _SERIALIZER.header("content_length", content_length, 'long')
    if blob_content_type is not None:
        _header_parameters['x-ms-blob-content-type'] = _SERIALIZER.header("blob_content_type", blob_content_type, 'str')
    if blob_content_encoding is not None:
        _header_parameters['x-ms-blob-content-encoding'] = _SERIALIZER.header("blob_content_encoding", blob_content_encoding, 'str')
    if blob_content_language is not None:
        _header_parameters['x-ms-blob-content-language'] = _SERIALIZER.header("blob_content_language", blob_content_language, 'str')
    if blob_content_md5 is not None:
        _header_parameters['x-ms-blob-content-md5'] = _SERIALIZER.header("blob_content_md5", blob_content_md5, 'bytearray')
    if blob_cache_control is not None:
        _header_parameters['x-ms-blob-cache-control'] = _SERIALIZER.header("blob_cache_control", blob_cache_control, 'str')
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if blob_content_disposition is not None:
        _header_parameters['x-ms-blob-content-disposition'] = _SERIALIZER.header("blob_content_disposition", blob_content_disposition, 'str')
    if encryption_key is not None:
        _header_parameters['x-ms-encryption-key'] = _SERIALIZER.header("encryption_key", encryption_key, 'str')
    if encryption_key_sha256 is not None:
        _header_parameters['x-ms-encryption-key-sha256'] = _SERIALIZER.header("encryption_key_sha256", encryption_key_sha256, 'str')
    if encryption_algorithm is not None:
        _header_parameters['x-ms-encryption-algorithm'] = _SERIALIZER.header("encryption_algorithm", encryption_algorithm, 'str')
    if encryption_scope is not None:
        _header_parameters['x-ms-encryption-scope'] = _SERIALIZER.header("encryption_scope", encryption_scope, 'str')
    if tier is not None:
        _header_parameters['x-ms-access-tier'] = _SERIALIZER.header("tier", tier, 'str')
    if if_modified_since is not None:
        _header_parameters['If-Modified-Since'] = _SERIALIZER.header("if_modified_since", if_modified_since, 'rfc-1123')
    if if_unmodified_since is not None:
        _header_parameters['If-Unmodified-Since'] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')
    if if_match is not None:
        _header_parameters['If-Match'] = _SERIALIZER.header("if_match", if_match, 'str')
    if if_none_match is not None:
        _header_parameters['If-None-Match'] = _SERIALIZER.header("if_none_match", if_none_match, 'str')
    if if_tags is not None:
        _header_parameters['x-ms-if-tags'] = _SERIALIZER.header("if_tags", if_tags, 'str')
    if source_if_modified_since is not None:
        _header_parameters['x-ms-source-if-modified-since'] = _SERIALIZER.header("source_if_modified_since", source_if_modified_since, 'rfc-1123')
    if source_if_unmodified_since is not None:
        _header_parameters['x-ms-source-if-unmodified-since'] = _SERIALIZER.header("source_if_unmodified_since", source_if_unmodified_since, 'rfc-1123')
    if source_if_match is not None:
        _header_parameters['x-ms-source-if-match'] = _SERIALIZER.header("source_if_match", source_if_match, 'str')
    if source_if_none_match is not None:
        _header_parameters['x-ms-source-if-none-match'] = _SERIALIZER.header("source_if_none_match", source_if_none_match, 'str')
    if source_if_tags is not None:
        _header_parameters['x-ms-source-if-tags'] = _SERIALIZER.header("source_if_tags", source_if_tags, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    if source_content_md5 is not None:
        _header_parameters['x-ms-source-content-md5'] = _SERIALIZER.header("source_content_md5", source_content_md5, 'bytearray')
    if blob_tags_string is not None:
        _header_parameters['x-ms-tags'] = _SERIALIZER.header("blob_tags_string", blob_tags_string, 'str')
    _header_parameters['x-ms-copy-source'] = _SERIALIZER.header("copy_source", copy_source, 'str')
    if copy_source_blob_properties is not None:
        _header_parameters['x-ms-copy-source-blob-properties'] = _SERIALIZER.header("copy_source_blob_properties", copy_source_blob_properties, 'bool')
    if copy_source_authorization is not None:
        _header_parameters['x-ms-copy-source-authorization'] = _SERIALIZER.header("copy_source_authorization", copy_source_authorization, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_stage_block_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "block")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    block_id = kwargs.pop('block_id')  # type: str
    content_length = kwargs.pop('content_length')  # type: int
    transactional_content_md5 = kwargs.pop('transactional_content_md5', None)  # type: Optional[bytearray]
    transactional_content_crc64 = kwargs.pop('transactional_content_crc64', None)  # type: Optional[bytearray]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    encryption_key = kwargs.pop('encryption_key', None)  # type: Optional[str]
    encryption_key_sha256 = kwargs.pop('encryption_key_sha256', None)  # type: Optional[str]
    encryption_algorithm = kwargs.pop('encryption_algorithm', None)  # type: Optional[Union[str, "_models.EncryptionAlgorithmType"]]
    encryption_scope = kwargs.pop('encryption_scope', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{containerName}/{blob}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    _query_parameters['blockid'] = _SERIALIZER.query("block_id", block_id, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Content-Length'] = _SERIALIZER.header("content_length", content_length, 'long')
    if transactional_content_md5 is not None:
        _header_parameters['Content-MD5'] = _SERIALIZER.header("transactional_content_md5", transactional_content_md5, 'bytearray')
    if transactional_content_crc64 is not None:
        _header_parameters['x-ms-content-crc64'] = _SERIALIZER.header("transactional_content_crc64", transactional_content_crc64, 'bytearray')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if encryption_key is not None:
        _header_parameters['x-ms-encryption-key'] = _SERIALIZER.header("encryption_key", encryption_key, 'str')
    if encryption_key_sha256 is not None:
        _header_parameters['x-ms-encryption-key-sha256'] = _SERIALIZER.header("encryption_key_sha256", encryption_key_sha256, 'str')
    if encryption_algorithm is not None:
        _header_parameters['x-ms-encryption-algorithm'] = _SERIALIZER.header("encryption_algorithm", encryption_algorithm, 'str')
    if encryption_scope is not None:
        _header_parameters['x-ms-encryption-scope'] = _SERIALIZER.header("encryption_scope", encryption_scope, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_stage_block_from_url_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "block")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    block_id = kwargs.pop('block_id')  # type: str
    content_length = kwargs.pop('content_length')  # type: int
    source_url = kwargs.pop('source_url')  # type: str
    source_range = kwargs.pop('source_range', None)  # type: Optional[str]
    source_content_md5 = kwargs.pop('source_content_md5', None)  # type: Optional[bytearray]
    source_contentcrc64 = kwargs.pop('source_contentcrc64', None)  # type: Optional[bytearray]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    encryption_key = kwargs.pop('encryption_key', None)  # type: Optional[str]
    encryption_key_sha256 = kwargs.pop('encryption_key_sha256', None)  # type: Optional[str]
    encryption_algorithm = kwargs.pop('encryption_algorithm', None)  # type: Optional[Union[str, "_models.EncryptionAlgorithmType"]]
    encryption_scope = kwargs.pop('encryption_scope', None)  # type: Optional[str]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    source_if_modified_since = kwargs.pop('source_if_modified_since', None)  # type: Optional[datetime.datetime]
    source_if_unmodified_since = kwargs.pop('source_if_unmodified_since', None)  # type: Optional[datetime.datetime]
    source_if_match = kwargs.pop('source_if_match', None)  # type: Optional[str]
    source_if_none_match = kwargs.pop('source_if_none_match', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]
    copy_source_authorization = kwargs.pop('copy_source_authorization', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{containerName}/{blob}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    _query_parameters['blockid'] = _SERIALIZER.query("block_id", block_id, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Content-Length'] = _SERIALIZER.header("content_length", content_length, 'long')
    _header_parameters['x-ms-copy-source'] = _SERIALIZER.header("source_url", source_url, 'str')
    if source_range is not None:
        _header_parameters['x-ms-source-range'] = _SERIALIZER.header("source_range", source_range, 'str')
    if source_content_md5 is not None:
        _header_parameters['x-ms-source-content-md5'] = _SERIALIZER.header("source_content_md5", source_content_md5, 'bytearray')
    if source_contentcrc64 is not None:
        _header_parameters['x-ms-source-content-crc64'] = _SERIALIZER.header("source_contentcrc64", source_contentcrc64, 'bytearray')
    if encryption_key is not None:
        _header_parameters['x-ms-encryption-key'] = _SERIALIZER.header("encryption_key", encryption_key, 'str')
    if encryption_key_sha256 is not None:
        _header_parameters['x-ms-encryption-key-sha256'] = _SERIALIZER.header("encryption_key_sha256", encryption_key_sha256, 'str')
    if encryption_algorithm is not None:
        _header_parameters['x-ms-encryption-algorithm'] = _SERIALIZER.header("encryption_algorithm", encryption_algorithm, 'str')
    if encryption_scope is not None:
        _header_parameters['x-ms-encryption-scope'] = _SERIALIZER.header("encryption_scope", encryption_scope, 'str')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if source_if_modified_since is not None:
        _header_parameters['x-ms-source-if-modified-since'] = _SERIALIZER.header("source_if_modified_since", source_if_modified_since, 'rfc-1123')
    if source_if_unmodified_since is not None:
        _header_parameters['x-ms-source-if-unmodified-since'] = _SERIALIZER.header("source_if_unmodified_since", source_if_unmodified_since, 'rfc-1123')
    if source_if_match is not None:
        _header_parameters['x-ms-source-if-match'] = _SERIALIZER.header("source_if_match", source_if_match, 'str')
    if source_if_none_match is not None:
        _header_parameters['x-ms-source-if-none-match'] = _SERIALIZER.header("source_if_none_match", source_if_none_match, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    if copy_source_authorization is not None:
        _header_parameters['x-ms-copy-source-authorization'] = _SERIALIZER.header("copy_source_authorization", copy_source_authorization, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_commit_block_list_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "blocklist")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    blob_cache_control = kwargs.pop('blob_cache_control', None)  # type: Optional[str]
    blob_content_type = kwargs.pop('blob_content_type', None)  # type: Optional[str]
    blob_content_encoding = kwargs.pop('blob_content_encoding', None)  # type: Optional[str]
    blob_content_language = kwargs.pop('blob_content_language', None)  # type: Optional[str]
    blob_content_md5 = kwargs.pop('blob_content_md5', None)  # type: Optional[bytearray]
    transactional_content_md5 = kwargs.pop('transactional_content_md5', None)  # type: Optional[bytearray]
    transactional_content_crc64 = kwargs.pop('transactional_content_crc64', None)  # type: Optional[bytearray]
    metadata = kwargs.pop('metadata', None)  # type: Optional[Dict[str, str]]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    blob_content_disposition = kwargs.pop('blob_content_disposition', None)  # type: Optional[str]
    encryption_key = kwargs.pop('encryption_key', None)  # type: Optional[str]
    encryption_key_sha256 = kwargs.pop('encryption_key_sha256', None)  # type: Optional[str]
    encryption_algorithm = kwargs.pop('encryption_algorithm', None)  # type: Optional[Union[str, "_models.EncryptionAlgorithmType"]]
    encryption_scope = kwargs.pop('encryption_scope', None)  # type: Optional[str]
    tier = kwargs.pop('tier', None)  # type: Optional[Union[str, "_models.AccessTierOptional"]]
    if_modified_since = kwargs.pop('if_modified_since', None)  # type: Optional[datetime.datetime]
    if_unmodified_since = kwargs.pop('if_unmodified_since', None)  # type: Optional[datetime.datetime]
    if_match = kwargs.pop('if_match', None)  # type: Optional[str]
    if_none_match = kwargs.pop('if_none_match', None)  # type: Optional[str]
    if_tags = kwargs.pop('if_tags', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]
    blob_tags_string = kwargs.pop('blob_tags_string', None)  # type: Optional[str]
    immutability_policy_expiry = kwargs.pop('immutability_policy_expiry', None)  # type: Optional[datetime.datetime]
    immutability_policy_mode = kwargs.pop('immutability_policy_mode', None)  # type: Optional[Union[str, "_models.BlobImmutabilityPolicyMode"]]
    legal_hold = kwargs.pop('legal_hold', None)  # type: Optional[bool]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{containerName}/{blob}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if blob_cache_control is not None:
        _header_parameters['x-ms-blob-cache-control'] = _SERIALIZER.header("blob_cache_control", blob_cache_control, 'str')
    if blob_content_type is not None:
        _header_parameters['x-ms-blob-content-type'] = _SERIALIZER.header("blob_content_type", blob_content_type, 'str')
    if blob_content_encoding is not None:
        _header_parameters['x-ms-blob-content-encoding'] = _SERIALIZER.header("blob_content_encoding", blob_content_encoding, 'str')
    if blob_content_language is not None:
        _header_parameters['x-ms-blob-content-language'] = _SERIALIZER.header("blob_content_language", blob_content_language, 'str')
    if blob_content_md5 is not None:
        _header_parameters['x-ms-blob-content-md5'] = _SERIALIZER.header("blob_content_md5", blob_content_md5, 'bytearray')
    if transactional_content_md5 is not None:
        _header_parameters['Content-MD5'] = _SERIALIZER.header("transactional_content_md5", transactional_content_md5, 'bytearray')
    if transactional_content_crc64 is not None:
        _header_parameters['x-ms-content-crc64'] = _SERIALIZER.header("transactional_content_crc64", transactional_content_crc64, 'bytearray')
    if metadata is not None:
        _header_parameters['x-ms-meta'] = _SERIALIZER.header("metadata", metadata, '{str}')
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if blob_content_disposition is not None:
        _header_parameters['x-ms-blob-content-disposition'] = _SERIALIZER.header("blob_content_disposition", blob_content_disposition, 'str')
    if encryption_key is not None:
        _header_parameters['x-ms-encryption-key'] = _SERIALIZER.header("encryption_key", encryption_key, 'str')
    if encryption_key_sha256 is not None:
        _header_parameters['x-ms-encryption-key-sha256'] = _SERIALIZER.header("encryption_key_sha256", encryption_key_sha256, 'str')
    if encryption_algorithm is not None:
        _header_parameters['x-ms-encryption-algorithm'] = _SERIALIZER.header("encryption_algorithm", encryption_algorithm, 'str')
    if encryption_scope is not None:
        _header_parameters['x-ms-encryption-scope'] = _SERIALIZER.header("encryption_scope", encryption_scope, 'str')
    if tier is not None:
        _header_parameters['x-ms-access-tier'] = _SERIALIZER.header("tier", tier, 'str')
    if if_modified_since is not None:
        _header_parameters['If-Modified-Since'] = _SERIALIZER.header("if_modified_since", if_modified_since, 'rfc-1123')
    if if_unmodified_since is not None:
        _header_parameters['If-Unmodified-Since'] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')
    if if_match is not None:
        _header_parameters['If-Match'] = _SERIALIZER.header("if_match", if_match, 'str')
    if if_none_match is not None:
        _header_parameters['If-None-Match'] = _SERIALIZER.header("if_none_match", if_none_match, 'str')
    if if_tags is not None:
        _header_parameters['x-ms-if-tags'] = _SERIALIZER.header("if_tags", if_tags, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    if blob_tags_string is not None:
        _header_parameters['x-ms-tags'] = _SERIALIZER.header("blob_tags_string", blob_tags_string, 'str')
    if immutability_policy_expiry is not None:
        _header_parameters['x-ms-immutability-policy-until-date'] = _SERIALIZER.header("immutability_policy_expiry", immutability_policy_expiry, 'rfc-1123')
    if immutability_policy_mode is not None:
        _header_parameters['x-ms-immutability-policy-mode'] = _SERIALIZER.header("immutability_policy_mode", immutability_policy_mode, 'str')
    if legal_hold is not None:
        _header_parameters['x-ms-legal-hold'] = _SERIALIZER.header("legal_hold", legal_hold, 'bool')
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_block_list_request(
    url,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    comp = kwargs.pop('comp', "blocklist")  # type: str
    version = kwargs.pop('version', "2021-04-10")  # type: str
    snapshot = kwargs.pop('snapshot', None)  # type: Optional[str]
    list_type = kwargs.pop('list_type', "committed")  # type: Union[str, "_models.BlockListType"]
    timeout = kwargs.pop('timeout', None)  # type: Optional[int]
    lease_id = kwargs.pop('lease_id', None)  # type: Optional[str]
    if_tags = kwargs.pop('if_tags', None)  # type: Optional[str]
    request_id_parameter = kwargs.pop('request_id_parameter', None)  # type: Optional[str]

    accept = "application/xml"
    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{containerName}/{blob}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, 'str', skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['comp'] = _SERIALIZER.query("comp", comp, 'str')
    if snapshot is not None:
        _query_parameters['snapshot'] = _SERIALIZER.query("snapshot", snapshot, 'str')
    _query_parameters['blocklisttype'] = _SERIALIZER.query("list_type", list_type, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'int', minimum=0)

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if lease_id is not None:
        _header_parameters['x-ms-lease-id'] = _SERIALIZER.header("lease_id", lease_id, 'str')
    if if_tags is not None:
        _header_parameters['x-ms-if-tags'] = _SERIALIZER.header("if_tags", if_tags, 'str')
    _header_parameters['x-ms-version'] = _SERIALIZER.header("version", version, 'str')
    if request_id_parameter is not None:
        _header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("request_id_parameter", request_id_parameter, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

# fmt: on
class BlockBlobOperations(object):
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.blob.AzureBlobStorage`'s
        :attr:`block_blob` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        args = list(args)
        self._client = args.pop(0) if args else kwargs.pop("client")
        self._config = args.pop(0) if args else kwargs.pop("config")
        self._serialize = args.pop(0) if args else kwargs.pop("serializer")
        self._deserialize = args.pop(0) if args else kwargs.pop("deserializer")


    @distributed_trace
    def upload(  # pylint: disable=inconsistent-return-statements
        self,
        content_length,  # type: int
        body,  # type: IO
        timeout=None,  # type: Optional[int]
        transactional_content_md5=None,  # type: Optional[bytearray]
        metadata=None,  # type: Optional[Dict[str, str]]
        tier=None,  # type: Optional[Union[str, "_models.AccessTierOptional"]]
        request_id_parameter=None,  # type: Optional[str]
        blob_tags_string=None,  # type: Optional[str]
        immutability_policy_expiry=None,  # type: Optional[datetime.datetime]
        immutability_policy_mode=None,  # type: Optional[Union[str, "_models.BlobImmutabilityPolicyMode"]]
        legal_hold=None,  # type: Optional[bool]
        blob_http_headers=None,  # type: Optional["_models.BlobHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        cpk_info=None,  # type: Optional["_models.CpkInfo"]
        cpk_scope_info=None,  # type: Optional["_models.CpkScopeInfo"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """The Upload Block Blob operation updates the content of an existing block blob. Updating an
        existing block blob overwrites any existing metadata on the blob. Partial updates are not
        supported with Put Blob; the content of the existing blob is overwritten with the content of
        the new blob. To perform a partial update of the content of a block blob, use the Put Block
        List operation.

        :param content_length: The length of the request.
        :type content_length: long
        :param body: Initial data.
        :type body: IO
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param transactional_content_md5: Specify the transactional md5 for the body, to be validated
         by the service. Default value is None.
        :type transactional_content_md5: bytearray
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information. Default value is None.
        :type metadata: dict[str, str]
        :param tier: Optional. Indicates the tier to be set on the blob. Default value is None.
        :type tier: str or ~azure.storage.blob.models.AccessTierOptional
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param blob_tags_string: Optional.  Used to set blob tags in various blob operations. Default
         value is None.
        :type blob_tags_string: str
        :param immutability_policy_expiry: Specifies the date time when the blobs immutability policy
         is set to expire. Default value is None.
        :type immutability_policy_expiry: ~datetime.datetime
        :param immutability_policy_mode: Specifies the immutability policy mode to set on the blob.
         Default value is None.
        :type immutability_policy_mode: str or ~azure.storage.blob.models.BlobImmutabilityPolicyMode
        :param legal_hold: Specified if a legal hold should be set on the blob. Default value is None.
        :type legal_hold: bool
        :param blob_http_headers: Parameter group. Default value is None.
        :type blob_http_headers: ~azure.storage.blob.models.BlobHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group. Default value is None.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group. Default value is None.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword blob_type: Specifies the type of blob to create: block blob, page blob, or append
         blob. Default value is "BlockBlob". Note that overriding this default value may result in
         unsupported behavior.
        :paramtype blob_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        blob_type = kwargs.pop('blob_type', "BlockBlob")  # type: str
        content_type = kwargs.pop('content_type', "application/octet-stream")  # type: Optional[str]

        _blob_content_type = None
        _blob_content_encoding = None
        _blob_content_language = None
        _blob_content_md5 = None
        _blob_cache_control = None
        _lease_id = None
        _blob_content_disposition = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_algorithm = None
        _encryption_scope = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if blob_http_headers is not None:
            _blob_content_type = blob_http_headers.blob_content_type
            _blob_content_encoding = blob_http_headers.blob_content_encoding
            _blob_content_language = blob_http_headers.blob_content_language
            _blob_content_md5 = blob_http_headers.blob_content_md5
            _blob_cache_control = blob_http_headers.blob_cache_control
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if blob_http_headers is not None:
            _blob_content_disposition = blob_http_headers.blob_content_disposition
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
            _encryption_algorithm = cpk_info.encryption_algorithm
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        _content = body

        request = build_upload_request(
            url=self._config.url,
            blob_type=blob_type,
            version=self._config.version,
            content_type=content_type,
            content=_content,
            content_length=content_length,
            timeout=timeout,
            transactional_content_md5=transactional_content_md5,
            blob_content_type=_blob_content_type,
            blob_content_encoding=_blob_content_encoding,
            blob_content_language=_blob_content_language,
            blob_content_md5=_blob_content_md5,
            blob_cache_control=_blob_cache_control,
            metadata=metadata,
            lease_id=_lease_id,
            blob_content_disposition=_blob_content_disposition,
            encryption_key=_encryption_key,
            encryption_key_sha256=_encryption_key_sha256,
            encryption_algorithm=_encryption_algorithm,
            encryption_scope=_encryption_scope,
            tier=tier,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            if_match=_if_match,
            if_none_match=_if_none_match,
            if_tags=_if_tags,
            request_id_parameter=request_id_parameter,
            blob_tags_string=blob_tags_string,
            immutability_policy_expiry=immutability_policy_expiry,
            immutability_policy_mode=immutability_policy_mode,
            legal_hold=legal_hold,
            template_url=self.upload.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    upload.metadata = {'url': "{url}/{containerName}/{blob}"}  # type: ignore


    @distributed_trace
    def put_blob_from_url(  # pylint: disable=inconsistent-return-statements
        self,
        content_length,  # type: int
        copy_source,  # type: str
        timeout=None,  # type: Optional[int]
        transactional_content_md5=None,  # type: Optional[bytearray]
        metadata=None,  # type: Optional[Dict[str, str]]
        tier=None,  # type: Optional[Union[str, "_models.AccessTierOptional"]]
        request_id_parameter=None,  # type: Optional[str]
        source_content_md5=None,  # type: Optional[bytearray]
        blob_tags_string=None,  # type: Optional[str]
        copy_source_blob_properties=None,  # type: Optional[bool]
        copy_source_authorization=None,  # type: Optional[str]
        blob_http_headers=None,  # type: Optional["_models.BlobHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        cpk_info=None,  # type: Optional["_models.CpkInfo"]
        cpk_scope_info=None,  # type: Optional["_models.CpkScopeInfo"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        source_modified_access_conditions=None,  # type: Optional["_models.SourceModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """The Put Blob from URL operation creates a new Block Blob where the contents of the blob are
        read from a given URL.  This API is supported beginning with the 2020-04-08 version. Partial
        updates are not supported with Put Blob from URL; the content of an existing blob is
        overwritten with the content of the new blob.  To perform partial updates to a block blob’s
        contents using a source URL, use the Put Block from URL API in conjunction with Put Block List.

        :param content_length: The length of the request.
        :type content_length: long
        :param copy_source: Specifies the name of the source page blob snapshot. This value is a URL of
         up to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
         would appear in a request URI. The source blob must either be public or must be authenticated
         via a shared access signature.
        :type copy_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param transactional_content_md5: Specify the transactional md5 for the body, to be validated
         by the service. Default value is None.
        :type transactional_content_md5: bytearray
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information. Default value is None.
        :type metadata: dict[str, str]
        :param tier: Optional. Indicates the tier to be set on the blob. Default value is None.
        :type tier: str or ~azure.storage.blob.models.AccessTierOptional
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param source_content_md5: Specify the md5 calculated for the range of bytes that must be read
         from the copy source. Default value is None.
        :type source_content_md5: bytearray
        :param blob_tags_string: Optional.  Used to set blob tags in various blob operations. Default
         value is None.
        :type blob_tags_string: str
        :param copy_source_blob_properties: Optional, default is true.  Indicates if properties from
         the source blob should be copied.
        :type copy_source_blob_properties: bool
        :param copy_source_authorization: Only Bearer type is supported. Credentials should be a valid
         OAuth access token to copy source. Default value is None.
        :type copy_source_authorization: str
        :param blob_http_headers: Parameter group. Default value is None.
        :type blob_http_headers: ~azure.storage.blob.models.BlobHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group. Default value is None.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group. Default value is None.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param source_modified_access_conditions: Parameter group. Default value is None.
        :type source_modified_access_conditions:
         ~azure.storage.blob.models.SourceModifiedAccessConditions
        :keyword blob_type: Specifies the type of blob to create: block blob, page blob, or append
         blob. Default value is "BlockBlob". Note that overriding this default value may result in
         unsupported behavior.
        :paramtype blob_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        blob_type = kwargs.pop('blob_type', "BlockBlob")  # type: str

        _blob_content_type = None
        _blob_content_encoding = None
        _blob_content_language = None
        _blob_content_md5 = None
        _blob_cache_control = None
        _lease_id = None
        _blob_content_disposition = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_algorithm = None
        _encryption_scope = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        _source_if_tags = None
        if blob_http_headers is not None:
            _blob_content_type = blob_http_headers.blob_content_type
            _blob_content_encoding = blob_http_headers.blob_content_encoding
            _blob_content_language = blob_http_headers.blob_content_language
            _blob_content_md5 = blob_http_headers.blob_content_md5
            _blob_cache_control = blob_http_headers.blob_cache_control
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if blob_http_headers is not None:
            _blob_content_disposition = blob_http_headers.blob_content_disposition
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
            _encryption_algorithm = cpk_info.encryption_algorithm
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        if source_modified_access_conditions is not None:
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match
            _source_if_tags = source_modified_access_conditions.source_if_tags

        request = build_put_blob_from_url_request(
            url=self._config.url,
            blob_type=blob_type,
            version=self._config.version,
            content_length=content_length,
            copy_source=copy_source,
            timeout=timeout,
            transactional_content_md5=transactional_content_md5,
            blob_content_type=_blob_content_type,
            blob_content_encoding=_blob_content_encoding,
            blob_content_language=_blob_content_language,
            blob_content_md5=_blob_content_md5,
            blob_cache_control=_blob_cache_control,
            metadata=metadata,
            lease_id=_lease_id,
            blob_content_disposition=_blob_content_disposition,
            encryption_key=_encryption_key,
            encryption_key_sha256=_encryption_key_sha256,
            encryption_algorithm=_encryption_algorithm,
            encryption_scope=_encryption_scope,
            tier=tier,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            if_match=_if_match,
            if_none_match=_if_none_match,
            if_tags=_if_tags,
            source_if_modified_since=_source_if_modified_since,
            source_if_unmodified_since=_source_if_unmodified_since,
            source_if_match=_source_if_match,
            source_if_none_match=_source_if_none_match,
            source_if_tags=_source_if_tags,
            request_id_parameter=request_id_parameter,
            source_content_md5=source_content_md5,
            blob_tags_string=blob_tags_string,
            copy_source_blob_properties=copy_source_blob_properties,
            copy_source_authorization=copy_source_authorization,
            template_url=self.put_blob_from_url.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    put_blob_from_url.metadata = {'url': "{url}/{containerName}/{blob}"}  # type: ignore


    @distributed_trace
    def stage_block(  # pylint: disable=inconsistent-return-statements
        self,
        block_id,  # type: str
        content_length,  # type: int
        body,  # type: IO
        transactional_content_md5=None,  # type: Optional[bytearray]
        transactional_content_crc64=None,  # type: Optional[bytearray]
        timeout=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        cpk_info=None,  # type: Optional["_models.CpkInfo"]
        cpk_scope_info=None,  # type: Optional["_models.CpkScopeInfo"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """The Stage Block operation creates a new block to be committed as part of a blob.

        :param block_id: A valid Base64 string value that identifies the block. Prior to encoding, the
         string must be less than or equal to 64 bytes in size. For a given blob, the length of the
         value specified for the blockid parameter must be the same size for each block.
        :type block_id: str
        :param content_length: The length of the request.
        :type content_length: long
        :param body: Initial data.
        :type body: IO
        :param transactional_content_md5: Specify the transactional md5 for the body, to be validated
         by the service. Default value is None.
        :type transactional_content_md5: bytearray
        :param transactional_content_crc64: Specify the transactional crc64 for the body, to be
         validated by the service. Default value is None.
        :type transactional_content_crc64: bytearray
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group. Default value is None.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group. Default value is None.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :keyword comp: comp. Default value is "block". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "block")  # type: str
        content_type = kwargs.pop('content_type', "application/octet-stream")  # type: Optional[str]

        _lease_id = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_algorithm = None
        _encryption_scope = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
            _encryption_algorithm = cpk_info.encryption_algorithm
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        _content = body

        request = build_stage_block_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            content_type=content_type,
            content=_content,
            block_id=block_id,
            content_length=content_length,
            transactional_content_md5=transactional_content_md5,
            transactional_content_crc64=transactional_content_crc64,
            timeout=timeout,
            lease_id=_lease_id,
            encryption_key=_encryption_key,
            encryption_key_sha256=_encryption_key_sha256,
            encryption_algorithm=_encryption_algorithm,
            encryption_scope=_encryption_scope,
            request_id_parameter=request_id_parameter,
            template_url=self.stage_block.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    stage_block.metadata = {'url': "{url}/{containerName}/{blob}"}  # type: ignore


    @distributed_trace
    def stage_block_from_url(  # pylint: disable=inconsistent-return-statements
        self,
        block_id,  # type: str
        content_length,  # type: int
        source_url,  # type: str
        source_range=None,  # type: Optional[str]
        source_content_md5=None,  # type: Optional[bytearray]
        source_contentcrc64=None,  # type: Optional[bytearray]
        timeout=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        copy_source_authorization=None,  # type: Optional[str]
        cpk_info=None,  # type: Optional["_models.CpkInfo"]
        cpk_scope_info=None,  # type: Optional["_models.CpkScopeInfo"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        source_modified_access_conditions=None,  # type: Optional["_models.SourceModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """The Stage Block operation creates a new block to be committed as part of a blob where the
        contents are read from a URL.

        :param block_id: A valid Base64 string value that identifies the block. Prior to encoding, the
         string must be less than or equal to 64 bytes in size. For a given blob, the length of the
         value specified for the blockid parameter must be the same size for each block.
        :type block_id: str
        :param content_length: The length of the request.
        :type content_length: long
        :param source_url: Specify a URL to the copy source.
        :type source_url: str
        :param source_range: Bytes of source data in the specified range. Default value is None.
        :type source_range: str
        :param source_content_md5: Specify the md5 calculated for the range of bytes that must be read
         from the copy source. Default value is None.
        :type source_content_md5: bytearray
        :param source_contentcrc64: Specify the crc64 calculated for the range of bytes that must be
         read from the copy source. Default value is None.
        :type source_contentcrc64: bytearray
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param copy_source_authorization: Only Bearer type is supported. Credentials should be a valid
         OAuth access token to copy source. Default value is None.
        :type copy_source_authorization: str
        :param cpk_info: Parameter group. Default value is None.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group. Default value is None.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param source_modified_access_conditions: Parameter group. Default value is None.
        :type source_modified_access_conditions:
         ~azure.storage.blob.models.SourceModifiedAccessConditions
        :keyword comp: comp. Default value is "block". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "block")  # type: str

        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_algorithm = None
        _encryption_scope = None
        _lease_id = None
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
            _encryption_algorithm = cpk_info.encryption_algorithm
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if source_modified_access_conditions is not None:
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match

        request = build_stage_block_from_url_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            block_id=block_id,
            content_length=content_length,
            source_url=source_url,
            source_range=source_range,
            source_content_md5=source_content_md5,
            source_contentcrc64=source_contentcrc64,
            timeout=timeout,
            encryption_key=_encryption_key,
            encryption_key_sha256=_encryption_key_sha256,
            encryption_algorithm=_encryption_algorithm,
            encryption_scope=_encryption_scope,
            lease_id=_lease_id,
            source_if_modified_since=_source_if_modified_since,
            source_if_unmodified_since=_source_if_unmodified_since,
            source_if_match=_source_if_match,
            source_if_none_match=_source_if_none_match,
            request_id_parameter=request_id_parameter,
            copy_source_authorization=copy_source_authorization,
            template_url=self.stage_block_from_url.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    stage_block_from_url.metadata = {'url': "{url}/{containerName}/{blob}"}  # type: ignore


    @distributed_trace
    def commit_block_list(  # pylint: disable=inconsistent-return-statements
        self,
        blocks,  # type: "_models.BlockLookupList"
        timeout=None,  # type: Optional[int]
        transactional_content_md5=None,  # type: Optional[bytearray]
        transactional_content_crc64=None,  # type: Optional[bytearray]
        metadata=None,  # type: Optional[Dict[str, str]]
        tier=None,  # type: Optional[Union[str, "_models.AccessTierOptional"]]
        request_id_parameter=None,  # type: Optional[str]
        blob_tags_string=None,  # type: Optional[str]
        immutability_policy_expiry=None,  # type: Optional[datetime.datetime]
        immutability_policy_mode=None,  # type: Optional[Union[str, "_models.BlobImmutabilityPolicyMode"]]
        legal_hold=None,  # type: Optional[bool]
        blob_http_headers=None,  # type: Optional["_models.BlobHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        cpk_info=None,  # type: Optional["_models.CpkInfo"]
        cpk_scope_info=None,  # type: Optional["_models.CpkScopeInfo"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """The Commit Block List operation writes a blob by specifying the list of block IDs that make up
        the blob. In order to be written as part of a blob, a block must have been successfully written
        to the server in a prior Put Block operation. You can call Put Block List to update a blob by
        uploading only those blocks that have changed, then committing the new and existing blocks
        together. You can do this by specifying whether to commit a block from the committed block list
        or from the uncommitted block list, or to commit the most recently uploaded version of the
        block, whichever list it may belong to.

        :param blocks: Blob Blocks.
        :type blocks: ~azure.storage.blob.models.BlockLookupList
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param transactional_content_md5: Specify the transactional md5 for the body, to be validated
         by the service. Default value is None.
        :type transactional_content_md5: bytearray
        :param transactional_content_crc64: Specify the transactional crc64 for the body, to be
         validated by the service. Default value is None.
        :type transactional_content_crc64: bytearray
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information. Default value is None.
        :type metadata: dict[str, str]
        :param tier: Optional. Indicates the tier to be set on the blob. Default value is None.
        :type tier: str or ~azure.storage.blob.models.AccessTierOptional
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param blob_tags_string: Optional.  Used to set blob tags in various blob operations. Default
         value is None.
        :type blob_tags_string: str
        :param immutability_policy_expiry: Specifies the date time when the blobs immutability policy
         is set to expire. Default value is None.
        :type immutability_policy_expiry: ~datetime.datetime
        :param immutability_policy_mode: Specifies the immutability policy mode to set on the blob.
         Default value is None.
        :type immutability_policy_mode: str or ~azure.storage.blob.models.BlobImmutabilityPolicyMode
        :param legal_hold: Specified if a legal hold should be set on the blob. Default value is None.
        :type legal_hold: bool
        :param blob_http_headers: Parameter group. Default value is None.
        :type blob_http_headers: ~azure.storage.blob.models.BlobHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group. Default value is None.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group. Default value is None.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "blocklist". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "blocklist")  # type: str
        content_type = kwargs.pop('content_type', "application/xml")  # type: Optional[str]

        _blob_cache_control = None
        _blob_content_type = None
        _blob_content_encoding = None
        _blob_content_language = None
        _blob_content_md5 = None
        _lease_id = None
        _blob_content_disposition = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_algorithm = None
        _encryption_scope = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if blob_http_headers is not None:
            _blob_cache_control = blob_http_headers.blob_cache_control
            _blob_content_type = blob_http_headers.blob_content_type
            _blob_content_encoding = blob_http_headers.blob_content_encoding
            _blob_content_language = blob_http_headers.blob_content_language
            _blob_content_md5 = blob_http_headers.blob_content_md5
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if blob_http_headers is not None:
            _blob_content_disposition = blob_http_headers.blob_content_disposition
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
            _encryption_algorithm = cpk_info.encryption_algorithm
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        _content = self._serialize.body(blocks, 'BlockLookupList', is_xml=True)

        request = build_commit_block_list_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            content_type=content_type,
            content=_content,
            timeout=timeout,
            blob_cache_control=_blob_cache_control,
            blob_content_type=_blob_content_type,
            blob_content_encoding=_blob_content_encoding,
            blob_content_language=_blob_content_language,
            blob_content_md5=_blob_content_md5,
            transactional_content_md5=transactional_content_md5,
            transactional_content_crc64=transactional_content_crc64,
            metadata=metadata,
            lease_id=_lease_id,
            blob_content_disposition=_blob_content_disposition,
            encryption_key=_encryption_key,
            encryption_key_sha256=_encryption_key_sha256,
            encryption_algorithm=_encryption_algorithm,
            encryption_scope=_encryption_scope,
            tier=tier,
            if_modified_since=_if_modified_since,
            if_unmodified_since=_if_unmodified_since,
            if_match=_if_match,
            if_none_match=_if_none_match,
            if_tags=_if_tags,
            request_id_parameter=request_id_parameter,
            blob_tags_string=blob_tags_string,
            immutability_policy_expiry=immutability_policy_expiry,
            immutability_policy_mode=immutability_policy_mode,
            legal_hold=legal_hold,
            template_url=self.commit_block_list.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    commit_block_list.metadata = {'url': "{url}/{containerName}/{blob}"}  # type: ignore


    @distributed_trace
    def get_block_list(
        self,
        snapshot=None,  # type: Optional[str]
        list_type="committed",  # type: Union[str, "_models.BlockListType"]
        timeout=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.BlockList"
        """The Get Block List operation retrieves the list of blocks that have been uploaded as part of a
        block blob.

        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating
         a Snapshot of a Blob.</a>`. Default value is None.
        :type snapshot: str
        :param list_type: Specifies whether to return the list of committed blocks, the list of
         uncommitted blocks, or both lists together. Default value is "committed".
        :type list_type: str or ~azure.storage.blob.models.BlockListType
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group. Default value is None.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword comp: comp. Default value is "blocklist". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlockList, or the result of cls(response)
        :rtype: ~azure.storage.blob.models.BlockList
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.BlockList"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "blocklist")  # type: str

        _lease_id = None
        _if_tags = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_tags = modified_access_conditions.if_tags

        request = build_get_block_list_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            snapshot=snapshot,
            list_type=list_type,
            timeout=timeout,
            lease_id=_lease_id,
            if_tags=_if_tags,
            request_id_parameter=request_id_parameter,
            template_url=self.get_block_list.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['x-ms-blob-content-length']=self._deserialize('long', response.headers.get('x-ms-blob-content-length'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('BlockList', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_block_list.metadata = {'url': "{url}/{containerName}/{blob}"}  # type: ignore

