# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class MetricNamespace(msrest.serialization.Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :ivar id: The ID of the metric namespace.
    :vartype id: str
    :ivar type: The type of the namespace.
    :vartype type: str
    :ivar name: The escaped name of the namespace.
    :vartype name: str
    :ivar classification: Kind of namespace. Possible values include: "Platform", "Custom", "Qos".
    :vartype classification: str or
     ~$(python-base-namespace).v2017_12_01_preview.models.NamespaceClassification
    :ivar properties: Properties which include the fully qualified namespace name.
    :vartype properties: ~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespaceName
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'classification': {'key': 'classification', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MetricNamespaceName'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        type: Optional[str] = None,
        name: Optional[str] = None,
        classification: Optional[Union[str, "NamespaceClassification"]] = None,
        properties: Optional["MetricNamespaceName"] = None,
        **kwargs
    ):
        """
        :keyword id: The ID of the metric namespace.
        :paramtype id: str
        :keyword type: The type of the namespace.
        :paramtype type: str
        :keyword name: The escaped name of the namespace.
        :paramtype name: str
        :keyword classification: Kind of namespace. Possible values include: "Platform", "Custom",
         "Qos".
        :paramtype classification: str or
         ~$(python-base-namespace).v2017_12_01_preview.models.NamespaceClassification
        :keyword properties: Properties which include the fully qualified namespace name.
        :paramtype properties: ~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespaceName
        """
        super(MetricNamespace, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.classification = classification
        self.properties = properties


class MetricNamespaceCollection(msrest.serialization.Model):
    """Represents collection of metric namespaces.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The values for the metric namespaces.
    :vartype value: list[~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespace]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricNamespace]'},
    }

    def __init__(
        self,
        *,
        value: List["MetricNamespace"],
        **kwargs
    ):
        """
        :keyword value: Required. The values for the metric namespaces.
        :paramtype value: list[~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespace]
        """
        super(MetricNamespaceCollection, self).__init__(**kwargs)
        self.value = value


class MetricNamespaceName(msrest.serialization.Model):
    """The fully qualified metric namespace name.

    :ivar metric_namespace_name: The metric namespace name.
    :vartype metric_namespace_name: str
    """

    _attribute_map = {
        'metric_namespace_name': {'key': 'metricNamespaceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_namespace_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword metric_namespace_name: The metric namespace name.
        :paramtype metric_namespace_name: str
        """
        super(MetricNamespaceName, self).__init__(**kwargs)
        self.metric_namespace_name = metric_namespace_name
