# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._batch_management_client_enums import *


class ActivateApplicationPackageParameters(msrest.serialization.Model):
    """Parameters for an activating an application package.

    All required parameters must be populated in order to send to Azure.

    :ivar format: Required. The format of the application package binary file.
    :vartype format: str
    """

    _validation = {
        'format': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        format: str,
        **kwargs
    ):
        """
        :keyword format: Required. The format of the application package binary file.
        :paramtype format: str
        """
        super(ActivateApplicationPackageParameters, self).__init__(**kwargs)
        self.format = format


class ProxyResource(msrest.serialization.Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class Application(ProxyResource):
    """Contains information about an application in a Batch account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar display_name: The display name for the application.
    :vartype display_name: str
    :ivar allow_updates: A value indicating whether packages within the application may be
     overwritten using the same version string.
    :vartype allow_updates: bool
    :ivar default_version: The package to use if a client requests the application but does not
     specify a version. This property can only be set to the name of an existing package.
    :vartype default_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'allow_updates': {'key': 'properties.allowUpdates', 'type': 'bool'},
        'default_version': {'key': 'properties.defaultVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        allow_updates: Optional[bool] = None,
        default_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: The display name for the application.
        :paramtype display_name: str
        :keyword allow_updates: A value indicating whether packages within the application may be
         overwritten using the same version string.
        :paramtype allow_updates: bool
        :keyword default_version: The package to use if a client requests the application but does not
         specify a version. This property can only be set to the name of an existing package.
        :paramtype default_version: str
        """
        super(Application, self).__init__(**kwargs)
        self.display_name = display_name
        self.allow_updates = allow_updates
        self.default_version = default_version


class ApplicationPackage(ProxyResource):
    """An application package which represents a particular version of an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar state: The current state of the application package. Possible values include: "Pending",
     "Active".
    :vartype state: str or ~azure.mgmt.batch.models.PackageState
    :ivar format: The format of the application package, if the package is active.
    :vartype format: str
    :ivar storage_url: The URL for the application package in Azure Storage.
    :vartype storage_url: str
    :ivar storage_url_expiry: The UTC time at which the Azure Storage URL will expire.
    :vartype storage_url_expiry: ~datetime.datetime
    :ivar last_activation_time: The time at which the package was last activated, if the package is
     active.
    :vartype last_activation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
        'format': {'readonly': True},
        'storage_url': {'readonly': True},
        'storage_url_expiry': {'readonly': True},
        'last_activation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'storage_url': {'key': 'properties.storageUrl', 'type': 'str'},
        'storage_url_expiry': {'key': 'properties.storageUrlExpiry', 'type': 'iso-8601'},
        'last_activation_time': {'key': 'properties.lastActivationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationPackage, self).__init__(**kwargs)
        self.state = None
        self.format = None
        self.storage_url = None
        self.storage_url_expiry = None
        self.last_activation_time = None


class ApplicationPackageReference(msrest.serialization.Model):
    """Link to an application package inside the batch account.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The ID of the application package to install. This must be inside the same
     batch account as the pool. This can either be a reference to a specific version or the default
     version if one exists.
    :vartype id: str
    :ivar version: If this is omitted, and no default version is specified for this application,
     the request fails with the error code InvalidApplicationPackageReferences. If you are calling
     the REST API directly, the HTTP status code is 409.
    :vartype version: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. The ID of the application package to install. This must be inside the
         same batch account as the pool. This can either be a reference to a specific version or the
         default version if one exists.
        :paramtype id: str
        :keyword version: If this is omitted, and no default version is specified for this application,
         the request fails with the error code InvalidApplicationPackageReferences. If you are calling
         the REST API directly, the HTTP status code is 409.
        :paramtype version: str
        """
        super(ApplicationPackageReference, self).__init__(**kwargs)
        self.id = id
        self.version = version


class AutoScaleRun(msrest.serialization.Model):
    """The results and errors from an execution of a pool autoscale formula.

    All required parameters must be populated in order to send to Azure.

    :ivar evaluation_time: Required. The time at which the autoscale formula was last evaluated.
    :vartype evaluation_time: ~datetime.datetime
    :ivar results: Each variable value is returned in the form $variable=value, and variables are
     separated by semicolons.
    :vartype results: str
    :ivar error: An error that occurred when autoscaling a pool.
    :vartype error: ~azure.mgmt.batch.models.AutoScaleRunError
    """

    _validation = {
        'evaluation_time': {'required': True},
    }

    _attribute_map = {
        'evaluation_time': {'key': 'evaluationTime', 'type': 'iso-8601'},
        'results': {'key': 'results', 'type': 'str'},
        'error': {'key': 'error', 'type': 'AutoScaleRunError'},
    }

    def __init__(
        self,
        *,
        evaluation_time: datetime.datetime,
        results: Optional[str] = None,
        error: Optional["AutoScaleRunError"] = None,
        **kwargs
    ):
        """
        :keyword evaluation_time: Required. The time at which the autoscale formula was last evaluated.
        :paramtype evaluation_time: ~datetime.datetime
        :keyword results: Each variable value is returned in the form $variable=value, and variables
         are separated by semicolons.
        :paramtype results: str
        :keyword error: An error that occurred when autoscaling a pool.
        :paramtype error: ~azure.mgmt.batch.models.AutoScaleRunError
        """
        super(AutoScaleRun, self).__init__(**kwargs)
        self.evaluation_time = evaluation_time
        self.results = results
        self.error = error


class AutoScaleRunError(msrest.serialization.Model):
    """An error that occurred when autoscaling a pool.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. An identifier for the error. Codes are invariant and are intended to be
     consumed programmatically.
    :vartype code: str
    :ivar message: Required. A message describing the error, intended to be suitable for display in
     a user interface.
    :vartype message: str
    :ivar details: Additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.AutoScaleRunError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AutoScaleRunError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["AutoScaleRunError"]] = None,
        **kwargs
    ):
        """
        :keyword code: Required. An identifier for the error. Codes are invariant and are intended to
         be consumed programmatically.
        :paramtype code: str
        :keyword message: Required. A message describing the error, intended to be suitable for display
         in a user interface.
        :paramtype message: str
        :keyword details: Additional details about the error.
        :paramtype details: list[~azure.mgmt.batch.models.AutoScaleRunError]
        """
        super(AutoScaleRunError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class AutoScaleSettings(msrest.serialization.Model):
    """AutoScale settings for the pool.

    All required parameters must be populated in order to send to Azure.

    :ivar formula: Required. A formula for the desired number of compute nodes in the pool.
    :vartype formula: str
    :ivar evaluation_interval: If omitted, the default value is 15 minutes (PT15M).
    :vartype evaluation_interval: ~datetime.timedelta
    """

    _validation = {
        'formula': {'required': True},
    }

    _attribute_map = {
        'formula': {'key': 'formula', 'type': 'str'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        formula: str,
        evaluation_interval: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword formula: Required. A formula for the desired number of compute nodes in the pool.
        :paramtype formula: str
        :keyword evaluation_interval: If omitted, the default value is 15 minutes (PT15M).
        :paramtype evaluation_interval: ~datetime.timedelta
        """
        super(AutoScaleSettings, self).__init__(**kwargs)
        self.formula = formula
        self.evaluation_interval = evaluation_interval


class AutoStorageBaseProperties(msrest.serialization.Model):
    """The properties related to the auto-storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account_id: Required. The resource ID of the storage account to be used for
     auto-storage account.
    :vartype storage_account_id: str
    :ivar authentication_mode: The authentication mode which the Batch service will use to manage
     the auto-storage account. Possible values include: "StorageKeys",
     "BatchAccountManagedIdentity". Default value: "StorageKeys".
    :vartype authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
    :ivar node_identity_reference: The identity referenced here must be assigned to pools which
     have compute nodes that need access to auto-storage.
    :vartype node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _validation = {
        'storage_account_id': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'node_identity_reference': {'key': 'nodeIdentityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        storage_account_id: str,
        authentication_mode: Optional[Union[str, "AutoStorageAuthenticationMode"]] = "StorageKeys",
        node_identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        """
        :keyword storage_account_id: Required. The resource ID of the storage account to be used for
         auto-storage account.
        :paramtype storage_account_id: str
        :keyword authentication_mode: The authentication mode which the Batch service will use to
         manage the auto-storage account. Possible values include: "StorageKeys",
         "BatchAccountManagedIdentity". Default value: "StorageKeys".
        :paramtype authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
        :keyword node_identity_reference: The identity referenced here must be assigned to pools which
         have compute nodes that need access to auto-storage.
        :paramtype node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
        """
        super(AutoStorageBaseProperties, self).__init__(**kwargs)
        self.storage_account_id = storage_account_id
        self.authentication_mode = authentication_mode
        self.node_identity_reference = node_identity_reference


class AutoStorageProperties(AutoStorageBaseProperties):
    """Contains information about the auto-storage account associated with a Batch account.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account_id: Required. The resource ID of the storage account to be used for
     auto-storage account.
    :vartype storage_account_id: str
    :ivar authentication_mode: The authentication mode which the Batch service will use to manage
     the auto-storage account. Possible values include: "StorageKeys",
     "BatchAccountManagedIdentity". Default value: "StorageKeys".
    :vartype authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
    :ivar node_identity_reference: The identity referenced here must be assigned to pools which
     have compute nodes that need access to auto-storage.
    :vartype node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    :ivar last_key_sync: Required. The UTC time at which storage keys were last synchronized with
     the Batch account.
    :vartype last_key_sync: ~datetime.datetime
    """

    _validation = {
        'storage_account_id': {'required': True},
        'last_key_sync': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'node_identity_reference': {'key': 'nodeIdentityReference', 'type': 'ComputeNodeIdentityReference'},
        'last_key_sync': {'key': 'lastKeySync', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        storage_account_id: str,
        last_key_sync: datetime.datetime,
        authentication_mode: Optional[Union[str, "AutoStorageAuthenticationMode"]] = "StorageKeys",
        node_identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        """
        :keyword storage_account_id: Required. The resource ID of the storage account to be used for
         auto-storage account.
        :paramtype storage_account_id: str
        :keyword authentication_mode: The authentication mode which the Batch service will use to
         manage the auto-storage account. Possible values include: "StorageKeys",
         "BatchAccountManagedIdentity". Default value: "StorageKeys".
        :paramtype authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
        :keyword node_identity_reference: The identity referenced here must be assigned to pools which
         have compute nodes that need access to auto-storage.
        :paramtype node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
        :keyword last_key_sync: Required. The UTC time at which storage keys were last synchronized
         with the Batch account.
        :paramtype last_key_sync: ~datetime.datetime
        """
        super(AutoStorageProperties, self).__init__(storage_account_id=storage_account_id, authentication_mode=authentication_mode, node_identity_reference=node_identity_reference, **kwargs)
        self.last_key_sync = last_key_sync


class AutoUserSpecification(msrest.serialization.Model):
    """Specifies the parameters for the auto user that runs a task on the Batch service.

    :ivar scope: The default value is Pool. If the pool is running Windows a value of Task should
     be specified if stricter isolation between tasks is required. For example, if the task mutates
     the registry in a way which could impact other tasks, or if certificates have been specified on
     the pool which should not be accessible by normal tasks but should be accessible by start
     tasks. Possible values include: "Task", "Pool".
    :vartype scope: str or ~azure.mgmt.batch.models.AutoUserScope
    :ivar elevation_level: The default value is nonAdmin. Possible values include: "NonAdmin",
     "Admin".
    :vartype elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scope: Optional[Union[str, "AutoUserScope"]] = None,
        elevation_level: Optional[Union[str, "ElevationLevel"]] = None,
        **kwargs
    ):
        """
        :keyword scope: The default value is Pool. If the pool is running Windows a value of Task
         should be specified if stricter isolation between tasks is required. For example, if the task
         mutates the registry in a way which could impact other tasks, or if certificates have been
         specified on the pool which should not be accessible by normal tasks but should be accessible
         by start tasks. Possible values include: "Task", "Pool".
        :paramtype scope: str or ~azure.mgmt.batch.models.AutoUserScope
        :keyword elevation_level: The default value is nonAdmin. Possible values include: "NonAdmin",
         "Admin".
        :paramtype elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
        """
        super(AutoUserSpecification, self).__init__(**kwargs)
        self.scope = scope
        self.elevation_level = elevation_level


class AzureBlobFileSystemConfiguration(msrest.serialization.Model):
    """Information used to connect to an Azure Storage Container using Blobfuse.

    All required parameters must be populated in order to send to Azure.

    :ivar account_name: Required. The Azure Storage Account name.
    :vartype account_name: str
    :ivar container_name: Required. The Azure Blob Storage Container name.
    :vartype container_name: str
    :ivar account_key: This property is mutually exclusive with both sasKey and identity; exactly
     one must be specified.
    :vartype account_key: str
    :ivar sas_key: This property is mutually exclusive with both accountKey and identity; exactly
     one must be specified.
    :vartype sas_key: str
    :ivar blobfuse_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :vartype blobfuse_options: str
    :ivar relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :vartype relative_mount_path: str
    :ivar identity_reference: This property is mutually exclusive with both accountKey and sasKey;
     exactly one must be specified.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _validation = {
        'account_name': {'required': True},
        'container_name': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'sas_key': {'key': 'sasKey', 'type': 'str'},
        'blobfuse_options': {'key': 'blobfuseOptions', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'identity_reference': {'key': 'identityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        container_name: str,
        relative_mount_path: str,
        account_key: Optional[str] = None,
        sas_key: Optional[str] = None,
        blobfuse_options: Optional[str] = None,
        identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        """
        :keyword account_name: Required. The Azure Storage Account name.
        :paramtype account_name: str
        :keyword container_name: Required. The Azure Blob Storage Container name.
        :paramtype container_name: str
        :keyword account_key: This property is mutually exclusive with both sasKey and identity;
         exactly one must be specified.
        :paramtype account_key: str
        :keyword sas_key: This property is mutually exclusive with both accountKey and identity;
         exactly one must be specified.
        :paramtype sas_key: str
        :keyword blobfuse_options: These are 'net use' options in Windows and 'mount' options in Linux.
        :paramtype blobfuse_options: str
        :keyword relative_mount_path: Required. All file systems are mounted relative to the Batch
         mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :paramtype relative_mount_path: str
        :keyword identity_reference: This property is mutually exclusive with both accountKey and
         sasKey; exactly one must be specified.
        :paramtype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
        """
        super(AzureBlobFileSystemConfiguration, self).__init__(**kwargs)
        self.account_name = account_name
        self.container_name = container_name
        self.account_key = account_key
        self.sas_key = sas_key
        self.blobfuse_options = blobfuse_options
        self.relative_mount_path = relative_mount_path
        self.identity_reference = identity_reference


class AzureFileShareConfiguration(msrest.serialization.Model):
    """Information used to connect to an Azure Fileshare.

    All required parameters must be populated in order to send to Azure.

    :ivar account_name: Required. The Azure Storage account name.
    :vartype account_name: str
    :ivar azure_file_url: Required. This is of the form 'https://{account}.file.core.windows.net/'.
    :vartype azure_file_url: str
    :ivar account_key: Required. The Azure Storage account key.
    :vartype account_key: str
    :ivar relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :vartype relative_mount_path: str
    :ivar mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :vartype mount_options: str
    """

    _validation = {
        'account_name': {'required': True},
        'azure_file_url': {'required': True},
        'account_key': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'azure_file_url': {'key': 'azureFileUrl', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        azure_file_url: str,
        account_key: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword account_name: Required. The Azure Storage account name.
        :paramtype account_name: str
        :keyword azure_file_url: Required. This is of the form
         'https://{account}.file.core.windows.net/'.
        :paramtype azure_file_url: str
        :keyword account_key: Required. The Azure Storage account key.
        :paramtype account_key: str
        :keyword relative_mount_path: Required. All file systems are mounted relative to the Batch
         mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :paramtype relative_mount_path: str
        :keyword mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        :paramtype mount_options: str
        """
        super(AzureFileShareConfiguration, self).__init__(**kwargs)
        self.account_name = account_name
        self.azure_file_url = azure_file_url
        self.account_key = account_key
        self.relative_mount_path = relative_mount_path
        self.mount_options = mount_options


class Resource(msrest.serialization.Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class BatchAccount(Resource):
    """Contains information about an Azure Batch account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the Batch account.
    :vartype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    :ivar account_endpoint: The account endpoint used to interact with the Batch service.
    :vartype account_endpoint: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Invalid", "Creating", "Deleting", "Succeeded", "Failed", "Cancelled".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.ProvisioningState
    :ivar pool_allocation_mode: The allocation mode for creating pools in the Batch account.
     Possible values include: "BatchService", "UserSubscription".
    :vartype pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: Identifies the Azure key vault associated with a Batch account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar public_network_access: If not specified, the default value is 'enabled'. Possible values
     include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     Batch account.
    :vartype private_endpoint_connections: list[~azure.mgmt.batch.models.PrivateEndpointConnection]
    :ivar auto_storage: Contains information about the auto-storage account associated with a Batch
     account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageProperties
    :ivar encryption: Configures how customer data is encrypted inside the Batch account. By
     default, accounts are encrypted using a Microsoft managed key. For additional control, a
     customer-managed key can be used instead.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar dedicated_core_quota: For accounts with PoolAllocationMode set to UserSubscription, quota
     is managed on the subscription so this value is not returned.
    :vartype dedicated_core_quota: int
    :ivar low_priority_core_quota: For accounts with PoolAllocationMode set to UserSubscription,
     quota is managed on the subscription so this value is not returned.
    :vartype low_priority_core_quota: int
    :ivar dedicated_core_quota_per_vm_family: A list of the dedicated core quota per Virtual
     Machine family for the Batch account. For accounts with PoolAllocationMode set to
     UserSubscription, quota is managed on the subscription so this value is not returned.
    :vartype dedicated_core_quota_per_vm_family:
     list[~azure.mgmt.batch.models.VirtualMachineFamilyCoreQuota]
    :ivar dedicated_core_quota_per_vm_family_enforced: Batch is transitioning its core quota system
     for dedicated cores to be enforced per Virtual Machine family. During this transitional phase,
     the dedicated core quota per Virtual Machine family may not yet be enforced. If this flag is
     false, dedicated core quota is enforced via the old dedicatedCoreQuota property on the account
     and does not consider Virtual Machine family. If this flag is true, dedicated core quota is
     enforced via the dedicatedCoreQuotaPerVMFamily property on the account, and the old
     dedicatedCoreQuota does not apply.
    :vartype dedicated_core_quota_per_vm_family_enforced: bool
    :ivar pool_quota: The pool quota for the Batch account.
    :vartype pool_quota: int
    :ivar active_job_and_job_schedule_quota: The active job and job schedule quota for the Batch
     account.
    :vartype active_job_and_job_schedule_quota: int
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'account_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'pool_allocation_mode': {'readonly': True},
        'key_vault_reference': {'readonly': True},
        'public_network_access': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'auto_storage': {'readonly': True},
        'encryption': {'readonly': True},
        'dedicated_core_quota': {'readonly': True},
        'low_priority_core_quota': {'readonly': True},
        'dedicated_core_quota_per_vm_family': {'readonly': True},
        'dedicated_core_quota_per_vm_family_enforced': {'readonly': True},
        'pool_quota': {'readonly': True},
        'active_job_and_job_schedule_quota': {'readonly': True},
        'allowed_authentication_modes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'BatchAccountIdentity'},
        'account_endpoint': {'key': 'properties.accountEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'str'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'dedicated_core_quota': {'key': 'properties.dedicatedCoreQuota', 'type': 'int'},
        'low_priority_core_quota': {'key': 'properties.lowPriorityCoreQuota', 'type': 'int'},
        'dedicated_core_quota_per_vm_family': {'key': 'properties.dedicatedCoreQuotaPerVMFamily', 'type': '[VirtualMachineFamilyCoreQuota]'},
        'dedicated_core_quota_per_vm_family_enforced': {'key': 'properties.dedicatedCoreQuotaPerVMFamilyEnforced', 'type': 'bool'},
        'pool_quota': {'key': 'properties.poolQuota', 'type': 'int'},
        'active_job_and_job_schedule_quota': {'key': 'properties.activeJobAndJobScheduleQuota', 'type': 'int'},
        'allowed_authentication_modes': {'key': 'properties.allowedAuthenticationModes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        identity: Optional["BatchAccountIdentity"] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the Batch account.
        :paramtype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
        """
        super(BatchAccount, self).__init__(**kwargs)
        self.identity = identity
        self.account_endpoint = None
        self.provisioning_state = None
        self.pool_allocation_mode = None
        self.key_vault_reference = None
        self.public_network_access = None
        self.private_endpoint_connections = None
        self.auto_storage = None
        self.encryption = None
        self.dedicated_core_quota = None
        self.low_priority_core_quota = None
        self.dedicated_core_quota_per_vm_family = None
        self.dedicated_core_quota_per_vm_family_enforced = None
        self.pool_quota = None
        self.active_job_and_job_schedule_quota = None
        self.allowed_authentication_modes = None


class BatchAccountCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create operation.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. The region in which to create the account.
    :vartype location: str
    :ivar tags: A set of tags. The user-specified tags associated with the account.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the Batch account.
    :vartype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    :ivar auto_storage: The properties related to the auto-storage account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :ivar pool_allocation_mode: The pool allocation mode also affects how clients may authenticate
     to the Batch Service API. If the mode is BatchService, clients may authenticate using access
     keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active
     Directory. The default is BatchService. Possible values include: "BatchService",
     "UserSubscription".
    :vartype pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: A reference to the Azure key vault associated with the Batch
     account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar public_network_access: If not specified, the default value is 'enabled'. Possible values
     include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar encryption: Configures how customer data is encrypted inside the Batch account. By
     default, accounts are encrypted using a Microsoft managed key. For additional control, a
     customer-managed key can be used instead.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'BatchAccountIdentity'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'str'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'allowed_authentication_modes': {'key': 'properties.allowedAuthenticationModes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["BatchAccountIdentity"] = None,
        auto_storage: Optional["AutoStorageBaseProperties"] = None,
        pool_allocation_mode: Optional[Union[str, "PoolAllocationMode"]] = None,
        key_vault_reference: Optional["KeyVaultReference"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        encryption: Optional["EncryptionProperties"] = None,
        allowed_authentication_modes: Optional[List[Union[str, "AuthenticationMode"]]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The region in which to create the account.
        :paramtype location: str
        :keyword tags: A set of tags. The user-specified tags associated with the account.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the Batch account.
        :paramtype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
        :keyword auto_storage: The properties related to the auto-storage account.
        :paramtype auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
        :keyword pool_allocation_mode: The pool allocation mode also affects how clients may
         authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate
         using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use
         Azure Active Directory. The default is BatchService. Possible values include: "BatchService",
         "UserSubscription".
        :paramtype pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
        :keyword key_vault_reference: A reference to the Azure key vault associated with the Batch
         account.
        :paramtype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
        :keyword public_network_access: If not specified, the default value is 'enabled'. Possible
         values include: "Enabled", "Disabled". Default value: "Enabled".
        :paramtype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
        :keyword encryption: Configures how customer data is encrypted inside the Batch account. By
         default, accounts are encrypted using a Microsoft managed key. For additional control, a
         customer-managed key can be used instead.
        :paramtype encryption: ~azure.mgmt.batch.models.EncryptionProperties
        :keyword allowed_authentication_modes: List of allowed authentication modes for the Batch
         account that can be used to authenticate with the data plane. This does not affect
         authentication with the control plane.
        :paramtype allowed_authentication_modes: list[str or
         ~azure.mgmt.batch.models.AuthenticationMode]
        """
        super(BatchAccountCreateParameters, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.identity = identity
        self.auto_storage = auto_storage
        self.pool_allocation_mode = pool_allocation_mode
        self.key_vault_reference = key_vault_reference
        self.public_network_access = public_network_access
        self.encryption = encryption
        self.allowed_authentication_modes = allowed_authentication_modes


class BatchAccountIdentity(msrest.serialization.Model):
    """The identity of the Batch account, if configured. This is used when the user specifies 'Microsoft.KeyVault' as their Batch account encryption configuration or when ``ManagedIdentity`` is selected as the auto-storage authentication mode.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal id of the Batch account. This property will only be provided
     for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the Batch account. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Required. The type of identity used for the Batch account. Possible values include:
     "SystemAssigned", "UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.batch.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Batch account.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentities}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ResourceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentities"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. The type of identity used for the Batch account. Possible values
         include: "SystemAssigned", "UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.batch.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the Batch
         account.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
        """
        super(BatchAccountIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class BatchAccountKeys(msrest.serialization.Model):
    """A set of Azure Batch account keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_name: The Batch account name.
    :vartype account_name: str
    :ivar primary: The primary key associated with the account.
    :vartype primary: str
    :ivar secondary: The secondary key associated with the account.
    :vartype secondary: str
    """

    _validation = {
        'account_name': {'readonly': True},
        'primary': {'readonly': True},
        'secondary': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BatchAccountKeys, self).__init__(**kwargs)
        self.account_name = None
        self.primary = None
        self.secondary = None


class BatchAccountListResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :ivar value: The collection of Batch accounts returned by the listing operation.
    :vartype value: list[~azure.mgmt.batch.models.BatchAccount]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BatchAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BatchAccount"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of Batch accounts returned by the listing operation.
        :paramtype value: list[~azure.mgmt.batch.models.BatchAccount]
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super(BatchAccountListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BatchAccountRegenerateKeyParameters(msrest.serialization.Model):
    """Parameters supplied to the RegenerateKey operation.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Required. The type of account key to regenerate. Possible values include:
     "Primary", "Secondary".
    :vartype key_name: str or ~azure.mgmt.batch.models.AccountKeyType
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Union[str, "AccountKeyType"],
        **kwargs
    ):
        """
        :keyword key_name: Required. The type of account key to regenerate. Possible values include:
         "Primary", "Secondary".
        :paramtype key_name: str or ~azure.mgmt.batch.models.AccountKeyType
        """
        super(BatchAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class BatchAccountUpdateParameters(msrest.serialization.Model):
    """Parameters for updating an Azure Batch account.

    :ivar tags: A set of tags. The user-specified tags associated with the account.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the Batch account.
    :vartype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    :ivar auto_storage: The properties related to the auto-storage account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :ivar encryption: Configures how customer data is encrypted inside the Batch account. By
     default, accounts are encrypted using a Microsoft managed key. For additional control, a
     customer-managed key can be used instead.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'BatchAccountIdentity'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'allowed_authentication_modes': {'key': 'properties.allowedAuthenticationModes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["BatchAccountIdentity"] = None,
        auto_storage: Optional["AutoStorageBaseProperties"] = None,
        encryption: Optional["EncryptionProperties"] = None,
        allowed_authentication_modes: Optional[List[Union[str, "AuthenticationMode"]]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The user-specified tags associated with the account.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the Batch account.
        :paramtype identity: ~azure.mgmt.batch.models.BatchAccountIdentity
        :keyword auto_storage: The properties related to the auto-storage account.
        :paramtype auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
        :keyword encryption: Configures how customer data is encrypted inside the Batch account. By
         default, accounts are encrypted using a Microsoft managed key. For additional control, a
         customer-managed key can be used instead.
        :paramtype encryption: ~azure.mgmt.batch.models.EncryptionProperties
        :keyword allowed_authentication_modes: List of allowed authentication modes for the Batch
         account that can be used to authenticate with the data plane. This does not affect
         authentication with the control plane.
        :paramtype allowed_authentication_modes: list[str or
         ~azure.mgmt.batch.models.AuthenticationMode]
        """
        super(BatchAccountUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.auto_storage = auto_storage
        self.encryption = encryption
        self.allowed_authentication_modes = allowed_authentication_modes


class BatchLocationQuota(msrest.serialization.Model):
    """Quotas associated with a Batch region for a particular subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_quota: The number of Batch accounts that may be created under the subscription in
     the specified region.
    :vartype account_quota: int
    """

    _validation = {
        'account_quota': {'readonly': True},
    }

    _attribute_map = {
        'account_quota': {'key': 'accountQuota', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BatchLocationQuota, self).__init__(**kwargs)
        self.account_quota = None


class BatchPoolIdentity(msrest.serialization.Model):
    """The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the updated identities.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of identity used for the Batch Pool. Possible values include:
     "UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.batch.models.PoolIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Batch pool.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentities}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "PoolIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentities"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. The type of identity used for the Batch Pool. Possible values include:
         "UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.batch.models.PoolIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the Batch pool.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
        """
        super(BatchPoolIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Certificate(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :vartype thumbprint_algorithm: str
    :ivar thumbprint: This must match the thumbprint from the name.
    :vartype thumbprint: str
    :ivar format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :vartype format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar provisioning_state: Possible values include: "Succeeded", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar provisioning_state_transition_time: The time at which the certificate entered its current
     state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar previous_provisioning_state: The previous provisioned state of the resource. Possible
     values include: "Succeeded", "Deleting", "Failed".
    :vartype previous_provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar previous_provisioning_state_transition_time: The time at which the certificate entered
     its previous state.
    :vartype previous_provisioning_state_transition_time: ~datetime.datetime
    :ivar public_data: The public key of the certificate.
    :vartype public_data: str
    :ivar delete_certificate_error: This is only returned when the certificate provisioningState is
     'Failed'.
    :vartype delete_certificate_error: ~azure.mgmt.batch.models.DeleteCertificateError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'previous_provisioning_state': {'readonly': True},
        'previous_provisioning_state_transition_time': {'readonly': True},
        'public_data': {'readonly': True},
        'delete_certificate_error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'previous_provisioning_state': {'key': 'properties.previousProvisioningState', 'type': 'str'},
        'previous_provisioning_state_transition_time': {'key': 'properties.previousProvisioningStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'properties.publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'properties.deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        **kwargs
    ):
        """
        :keyword thumbprint_algorithm: This must match the first portion of the certificate name.
         Currently required to be 'SHA1'.
        :paramtype thumbprint_algorithm: str
        :keyword thumbprint: This must match the thumbprint from the name.
        :paramtype thumbprint: str
        :keyword format: The format of the certificate - either Pfx or Cer. If omitted, the default is
         Pfx. Possible values include: "Pfx", "Cer".
        :paramtype format: str or ~azure.mgmt.batch.models.CertificateFormat
        """
        super(Certificate, self).__init__(**kwargs)
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.previous_provisioning_state = None
        self.previous_provisioning_state_transition_time = None
        self.public_data = None
        self.delete_certificate_error = None


class CertificateBaseProperties(msrest.serialization.Model):
    """Base certificate properties.

    :ivar thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :vartype thumbprint_algorithm: str
    :ivar thumbprint: This must match the thumbprint from the name.
    :vartype thumbprint: str
    :ivar format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :vartype format: str or ~azure.mgmt.batch.models.CertificateFormat
    """

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        **kwargs
    ):
        """
        :keyword thumbprint_algorithm: This must match the first portion of the certificate name.
         Currently required to be 'SHA1'.
        :paramtype thumbprint_algorithm: str
        :keyword thumbprint: This must match the thumbprint from the name.
        :paramtype thumbprint: str
        :keyword format: The format of the certificate - either Pfx or Cer. If omitted, the default is
         Pfx. Possible values include: "Pfx", "Cer".
        :paramtype format: str or ~azure.mgmt.batch.models.CertificateFormat
        """
        super(CertificateBaseProperties, self).__init__(**kwargs)
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format


class CertificateCreateOrUpdateParameters(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :vartype thumbprint_algorithm: str
    :ivar thumbprint: This must match the thumbprint from the name.
    :vartype thumbprint: str
    :ivar format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :vartype format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar data: The maximum size is 10KB.
    :vartype data: str
    :ivar password: This must not be specified if the certificate format is Cer.
    :vartype password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword thumbprint_algorithm: This must match the first portion of the certificate name.
         Currently required to be 'SHA1'.
        :paramtype thumbprint_algorithm: str
        :keyword thumbprint: This must match the thumbprint from the name.
        :paramtype thumbprint: str
        :keyword format: The format of the certificate - either Pfx or Cer. If omitted, the default is
         Pfx. Possible values include: "Pfx", "Cer".
        :paramtype format: str or ~azure.mgmt.batch.models.CertificateFormat
        :keyword data: The maximum size is 10KB.
        :paramtype data: str
        :keyword password: This must not be specified if the certificate format is Cer.
        :paramtype password: str
        """
        super(CertificateCreateOrUpdateParameters, self).__init__(**kwargs)
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
        self.data = data
        self.password = password


class CertificateCreateOrUpdateProperties(CertificateBaseProperties):
    """Certificate properties for create operations.

    All required parameters must be populated in order to send to Azure.

    :ivar thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :vartype thumbprint_algorithm: str
    :ivar thumbprint: This must match the thumbprint from the name.
    :vartype thumbprint: str
    :ivar format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :vartype format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar data: Required. The maximum size is 10KB.
    :vartype data: str
    :ivar password: This must not be specified if the certificate format is Cer.
    :vartype password: str
    """

    _validation = {
        'data': {'required': True},
    }

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data: str,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword thumbprint_algorithm: This must match the first portion of the certificate name.
         Currently required to be 'SHA1'.
        :paramtype thumbprint_algorithm: str
        :keyword thumbprint: This must match the thumbprint from the name.
        :paramtype thumbprint: str
        :keyword format: The format of the certificate - either Pfx or Cer. If omitted, the default is
         Pfx. Possible values include: "Pfx", "Cer".
        :paramtype format: str or ~azure.mgmt.batch.models.CertificateFormat
        :keyword data: Required. The maximum size is 10KB.
        :paramtype data: str
        :keyword password: This must not be specified if the certificate format is Cer.
        :paramtype password: str
        """
        super(CertificateCreateOrUpdateProperties, self).__init__(thumbprint_algorithm=thumbprint_algorithm, thumbprint=thumbprint, format=format, **kwargs)
        self.data = data
        self.password = password


class CertificateProperties(CertificateBaseProperties):
    """Certificate properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :vartype thumbprint_algorithm: str
    :ivar thumbprint: This must match the thumbprint from the name.
    :vartype thumbprint: str
    :ivar format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :vartype format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar provisioning_state: Possible values include: "Succeeded", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar provisioning_state_transition_time: The time at which the certificate entered its current
     state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar previous_provisioning_state: The previous provisioned state of the resource. Possible
     values include: "Succeeded", "Deleting", "Failed".
    :vartype previous_provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar previous_provisioning_state_transition_time: The time at which the certificate entered
     its previous state.
    :vartype previous_provisioning_state_transition_time: ~datetime.datetime
    :ivar public_data: The public key of the certificate.
    :vartype public_data: str
    :ivar delete_certificate_error: This is only returned when the certificate provisioningState is
     'Failed'.
    :vartype delete_certificate_error: ~azure.mgmt.batch.models.DeleteCertificateError
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'previous_provisioning_state': {'readonly': True},
        'previous_provisioning_state_transition_time': {'readonly': True},
        'public_data': {'readonly': True},
        'delete_certificate_error': {'readonly': True},
    }

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'provisioning_state_transition_time': {'key': 'provisioningStateTransitionTime', 'type': 'iso-8601'},
        'previous_provisioning_state': {'key': 'previousProvisioningState', 'type': 'str'},
        'previous_provisioning_state_transition_time': {'key': 'previousProvisioningStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        **kwargs
    ):
        """
        :keyword thumbprint_algorithm: This must match the first portion of the certificate name.
         Currently required to be 'SHA1'.
        :paramtype thumbprint_algorithm: str
        :keyword thumbprint: This must match the thumbprint from the name.
        :paramtype thumbprint: str
        :keyword format: The format of the certificate - either Pfx or Cer. If omitted, the default is
         Pfx. Possible values include: "Pfx", "Cer".
        :paramtype format: str or ~azure.mgmt.batch.models.CertificateFormat
        """
        super(CertificateProperties, self).__init__(thumbprint_algorithm=thumbprint_algorithm, thumbprint=thumbprint, format=format, **kwargs)
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.previous_provisioning_state = None
        self.previous_provisioning_state_transition_time = None
        self.public_data = None
        self.delete_certificate_error = None


class CertificateReference(msrest.serialization.Model):
    """A reference to a certificate to be installed on compute nodes in a pool. This must exist inside the same account as the pool.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The fully qualified ID of the certificate to install on the pool. This must
     be inside the same batch account as the pool.
    :vartype id: str
    :ivar store_location: The default value is currentUser. This property is applicable only for
     pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with
     virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the
     certificates are stored in a directory inside the task working directory and an environment
     variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For
     certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home
     directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     Possible values include: "CurrentUser", "LocalMachine".
    :vartype store_location: str or ~azure.mgmt.batch.models.CertificateStoreLocation
    :ivar store_name: This property is applicable only for pools configured with Windows nodes
     (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a
     Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed,
     TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be
     used. The default value is My.
    :vartype store_name: str
    :ivar visibility: Which user accounts on the compute node should have access to the private
     data of the certificate.
    :vartype visibility: list[str or ~azure.mgmt.batch.models.CertificateVisibility]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'store_location': {'key': 'storeLocation', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: str,
        store_location: Optional[Union[str, "CertificateStoreLocation"]] = None,
        store_name: Optional[str] = None,
        visibility: Optional[List[Union[str, "CertificateVisibility"]]] = None,
        **kwargs
    ):
        """
        :keyword id: Required. The fully qualified ID of the certificate to install on the pool. This
         must be inside the same batch account as the pool.
        :paramtype id: str
        :keyword store_location: The default value is currentUser. This property is applicable only for
         pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with
         virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the
         certificates are stored in a directory inside the task working directory and an environment
         variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For
         certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home
         directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
         Possible values include: "CurrentUser", "LocalMachine".
        :paramtype store_location: str or ~azure.mgmt.batch.models.CertificateStoreLocation
        :keyword store_name: This property is applicable only for pools configured with Windows nodes
         (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a
         Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed,
         TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be
         used. The default value is My.
        :paramtype store_name: str
        :keyword visibility: Which user accounts on the compute node should have access to the private
         data of the certificate.
        :paramtype visibility: list[str or ~azure.mgmt.batch.models.CertificateVisibility]
        """
        super(CertificateReference, self).__init__(**kwargs)
        self.id = id
        self.store_location = store_location
        self.store_name = store_name
        self.visibility = visibility


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters for a check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name to check for availability.
    :vartype name: str
    :ivar type: The resource type. Has constant value: "Microsoft.Batch/batchAccounts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Batch/batchAccounts"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The name to check for availability.
        :paramtype name: str
        """
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Batch account name could not be used. The Reason element
     is only returned if NameAvailable is false. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.batch.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CIFSMountConfiguration(msrest.serialization.Model):
    """Information used to connect to a CIFS file system.

    All required parameters must be populated in order to send to Azure.

    :ivar username: Required. The user to use for authentication against the CIFS file system.
    :vartype username: str
    :ivar source: Required. The URI of the file system to mount.
    :vartype source: str
    :ivar relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :vartype relative_mount_path: str
    :ivar mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :vartype mount_options: str
    :ivar password: Required. The password to use for authentication against the CIFS file system.
    :vartype password: str
    """

    _validation = {
        'username': {'required': True},
        'source': {'required': True},
        'relative_mount_path': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: str,
        source: str,
        relative_mount_path: str,
        password: str,
        mount_options: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword username: Required. The user to use for authentication against the CIFS file system.
        :paramtype username: str
        :keyword source: Required. The URI of the file system to mount.
        :paramtype source: str
        :keyword relative_mount_path: Required. All file systems are mounted relative to the Batch
         mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :paramtype relative_mount_path: str
        :keyword mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        :paramtype mount_options: str
        :keyword password: Required. The password to use for authentication against the CIFS file
         system.
        :paramtype password: str
        """
        super(CIFSMountConfiguration, self).__init__(**kwargs)
        self.username = username
        self.source = source
        self.relative_mount_path = relative_mount_path
        self.mount_options = mount_options
        self.password = password


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Batch service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.batch.models.CloudErrorBody]
        """
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CloudServiceConfiguration(msrest.serialization.Model):
    """The configuration for nodes in a pool based on the Azure Cloud Services platform.

    All required parameters must be populated in order to send to Azure.

    :ivar os_family: Required. Possible values are: 2 - OS Family 2, equivalent to Windows Server
     2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to
     Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6,
     equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases
     (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
    :vartype os_family: str
    :ivar os_version: The default value is * which specifies the latest operating system version
     for the specified OS family.
    :vartype os_version: str
    """

    _validation = {
        'os_family': {'required': True},
    }

    _attribute_map = {
        'os_family': {'key': 'osFamily', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_family: str,
        os_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword os_family: Required. Possible values are: 2 - OS Family 2, equivalent to Windows
         Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4,
         equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 -
         OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS
         Releases
         (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        :paramtype os_family: str
        :keyword os_version: The default value is * which specifies the latest operating system version
         for the specified OS family.
        :paramtype os_version: str
        """
        super(CloudServiceConfiguration, self).__init__(**kwargs)
        self.os_family = os_family
        self.os_version = os_version


class ComputeNodeIdentityReference(msrest.serialization.Model):
    """The reference to a user assigned identity associated with the Batch pool which a compute node will use.

    :ivar resource_id: The ARM resource id of the user assigned identity.
    :vartype resource_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: The ARM resource id of the user assigned identity.
        :paramtype resource_id: str
        """
        super(ComputeNodeIdentityReference, self).__init__(**kwargs)
        self.resource_id = resource_id


class ContainerConfiguration(msrest.serialization.Model):
    """The configuration for container-enabled pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The container technology to be used. Has constant value: "DockerCompatible".
    :vartype type: str
    :ivar container_image_names: This is the full image reference, as would be specified to "docker
     pull". An image will be sourced from the default Docker registry unless the image is fully
     qualified with an alternative registry.
    :vartype container_image_names: list[str]
    :ivar container_registries: If any images must be downloaded from a private registry which
     requires credentials, then those credentials must be provided here.
    :vartype container_registries: list[~azure.mgmt.batch.models.ContainerRegistry]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'container_image_names': {'key': 'containerImageNames', 'type': '[str]'},
        'container_registries': {'key': 'containerRegistries', 'type': '[ContainerRegistry]'},
    }

    type = "DockerCompatible"

    def __init__(
        self,
        *,
        container_image_names: Optional[List[str]] = None,
        container_registries: Optional[List["ContainerRegistry"]] = None,
        **kwargs
    ):
        """
        :keyword container_image_names: This is the full image reference, as would be specified to
         "docker pull". An image will be sourced from the default Docker registry unless the image is
         fully qualified with an alternative registry.
        :paramtype container_image_names: list[str]
        :keyword container_registries: If any images must be downloaded from a private registry which
         requires credentials, then those credentials must be provided here.
        :paramtype container_registries: list[~azure.mgmt.batch.models.ContainerRegistry]
        """
        super(ContainerConfiguration, self).__init__(**kwargs)
        self.container_image_names = container_image_names
        self.container_registries = container_registries


class ContainerRegistry(msrest.serialization.Model):
    """A private container registry.

    :ivar user_name: The user name to log into the registry server.
    :vartype user_name: str
    :ivar password: The password to log into the registry server.
    :vartype password: str
    :ivar registry_server: If omitted, the default is "docker.io".
    :vartype registry_server: str
    :ivar identity_reference: The reference to a user assigned identity associated with the Batch
     pool which a compute node will use.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _attribute_map = {
        'user_name': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'registry_server': {'key': 'registryServer', 'type': 'str'},
        'identity_reference': {'key': 'identityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        registry_server: Optional[str] = None,
        identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        """
        :keyword user_name: The user name to log into the registry server.
        :paramtype user_name: str
        :keyword password: The password to log into the registry server.
        :paramtype password: str
        :keyword registry_server: If omitted, the default is "docker.io".
        :paramtype registry_server: str
        :keyword identity_reference: The reference to a user assigned identity associated with the
         Batch pool which a compute node will use.
        :paramtype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
        """
        super(ContainerRegistry, self).__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.registry_server = registry_server
        self.identity_reference = identity_reference


class DataDisk(msrest.serialization.Model):
    """Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.

    All required parameters must be populated in order to send to Azure.

    :ivar lun: Required. The lun is used to uniquely identify each data disk. If attaching multiple
     disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
    :vartype lun: int
    :ivar caching: Values are:
    
      none - The caching mode for the disk is not enabled.
      readOnly - The caching mode for the disk is read only.
      readWrite - The caching mode for the disk is read and write.
    
      The default value for caching is none. For information about the caching options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Possible values include: "None", "ReadOnly", "ReadWrite".
    :vartype caching: str or ~azure.mgmt.batch.models.CachingType
    :ivar disk_size_gb: Required. The initial disk size in GB when creating new data disk.
    :vartype disk_size_gb: int
    :ivar storage_account_type: If omitted, the default is "Standard_LRS". Values are:
    
      Standard_LRS - The data disk should use standard locally redundant storage.
      Premium_LRS - The data disk should use premium locally redundant storage. Possible values
     include: "Standard_LRS", "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.batch.models.StorageAccountType
    """

    _validation = {
        'lun': {'required': True},
        'disk_size_gb': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: int,
        disk_size_gb: int,
        caching: Optional[Union[str, "CachingType"]] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        **kwargs
    ):
        """
        :keyword lun: Required. The lun is used to uniquely identify each data disk. If attaching
         multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        :paramtype lun: int
        :keyword caching: Values are:
        
          none - The caching mode for the disk is not enabled.
          readOnly - The caching mode for the disk is read only.
          readWrite - The caching mode for the disk is read and write.
        
          The default value for caching is none. For information about the caching options see:
         https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
         Possible values include: "None", "ReadOnly", "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.batch.models.CachingType
        :keyword disk_size_gb: Required. The initial disk size in GB when creating new data disk.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: If omitted, the default is "Standard_LRS". Values are:
        
          Standard_LRS - The data disk should use standard locally redundant storage.
          Premium_LRS - The data disk should use premium locally redundant storage. Possible values
         include: "Standard_LRS", "Premium_LRS".
        :paramtype storage_account_type: str or ~azure.mgmt.batch.models.StorageAccountType
        """
        super(DataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class DeleteCertificateError(msrest.serialization.Model):
    """An error response from the Batch service.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. An identifier for the error. Codes are invariant and are intended to be
     consumed programmatically.
    :vartype code: str
    :ivar message: Required. A message describing the error, intended to be suitable for display in
     a user interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.DeleteCertificateError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DeleteCertificateError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["DeleteCertificateError"]] = None,
        **kwargs
    ):
        """
        :keyword code: Required. An identifier for the error. Codes are invariant and are intended to
         be consumed programmatically.
        :paramtype code: str
        :keyword message: Required. A message describing the error, intended to be suitable for display
         in a user interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.batch.models.DeleteCertificateError]
        """
        super(DeleteCertificateError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class DeploymentConfiguration(msrest.serialization.Model):
    """Deployment configuration properties.

    :ivar cloud_service_configuration: This property and virtualMachineConfiguration are mutually
     exclusive and one of the properties must be specified. This property cannot be specified if the
     Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
    :vartype cloud_service_configuration: ~azure.mgmt.batch.models.CloudServiceConfiguration
    :ivar virtual_machine_configuration: This property and cloudServiceConfiguration are mutually
     exclusive and one of the properties must be specified.
    :vartype virtual_machine_configuration: ~azure.mgmt.batch.models.VirtualMachineConfiguration
    """

    _attribute_map = {
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
    }

    def __init__(
        self,
        *,
        cloud_service_configuration: Optional["CloudServiceConfiguration"] = None,
        virtual_machine_configuration: Optional["VirtualMachineConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword cloud_service_configuration: This property and virtualMachineConfiguration are
         mutually exclusive and one of the properties must be specified. This property cannot be
         specified if the Batch account was created with its poolAllocationMode property set to
         'UserSubscription'.
        :paramtype cloud_service_configuration: ~azure.mgmt.batch.models.CloudServiceConfiguration
        :keyword virtual_machine_configuration: This property and cloudServiceConfiguration are
         mutually exclusive and one of the properties must be specified.
        :paramtype virtual_machine_configuration: ~azure.mgmt.batch.models.VirtualMachineConfiguration
        """
        super(DeploymentConfiguration, self).__init__(**kwargs)
        self.cloud_service_configuration = cloud_service_configuration
        self.virtual_machine_configuration = virtual_machine_configuration


class DetectorListResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :ivar value: The collection of Batch account detectors returned by the listing operation.
    :vartype value: list[~azure.mgmt.batch.models.DetectorResponse]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DetectorResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of Batch account detectors returned by the listing operation.
        :paramtype value: list[~azure.mgmt.batch.models.DetectorResponse]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(DetectorListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DetectorResponse(ProxyResource):
    """Contains the information for a detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar value: A base64 encoded string that represents the content of a detector.
    :vartype value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A base64 encoded string that represents the content of a detector.
        :paramtype value: str
        """
        super(DetectorResponse, self).__init__(**kwargs)
        self.value = value


class DiffDiskSettings(msrest.serialization.Model):
    """Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.

    :ivar placement: This property can be used by user in the request to choose which location the
     operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For
     more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size
     requirements for Windows VMs at
     https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
     and Linux VMs at
     https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
     The only acceptable values to pass in are None and "CacheDisk". The default value is None.
    :vartype placement: str
    """

    _attribute_map = {
        'placement': {'key': 'placement', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        placement: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword placement: This property can be used by user in the request to choose which location
         the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning.
         For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk
         size requirements for Windows VMs at
         https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
         and Linux VMs at
         https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
         The only acceptable values to pass in are None and "CacheDisk". The default value is None.
        :paramtype placement: str
        """
        super(DiffDiskSettings, self).__init__(**kwargs)
        self.placement = placement


class DiskEncryptionConfiguration(msrest.serialization.Model):
    """The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.

    :ivar targets: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
     "TemporaryDisk" must be specified.
    :vartype targets: list[str or ~azure.mgmt.batch.models.DiskEncryptionTarget]
    """

    _attribute_map = {
        'targets': {'key': 'targets', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        targets: Optional[List[Union[str, "DiskEncryptionTarget"]]] = None,
        **kwargs
    ):
        """
        :keyword targets: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk"
         and "TemporaryDisk" must be specified.
        :paramtype targets: list[str or ~azure.mgmt.batch.models.DiskEncryptionTarget]
        """
        super(DiskEncryptionConfiguration, self).__init__(**kwargs)
        self.targets = targets


class EncryptionProperties(msrest.serialization.Model):
    """Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.

    :ivar key_source: Type of the key source. Possible values include: "Microsoft.Batch",
     "Microsoft.KeyVault".
    :vartype key_source: str or ~azure.mgmt.batch.models.KeySource
    :ivar key_vault_properties: Additional details when using Microsoft.KeyVault.
    :vartype key_vault_properties: ~azure.mgmt.batch.models.KeyVaultProperties
    """

    _attribute_map = {
        'key_source': {'key': 'keySource', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(
        self,
        *,
        key_source: Optional[Union[str, "KeySource"]] = None,
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        **kwargs
    ):
        """
        :keyword key_source: Type of the key source. Possible values include: "Microsoft.Batch",
         "Microsoft.KeyVault".
        :paramtype key_source: str or ~azure.mgmt.batch.models.KeySource
        :keyword key_vault_properties: Additional details when using Microsoft.KeyVault.
        :paramtype key_vault_properties: ~azure.mgmt.batch.models.KeyVaultProperties
        """
        super(EncryptionProperties, self).__init__(**kwargs)
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EndpointDependency(msrest.serialization.Model):
    """A domain name and connection details used to access a dependency.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_name: The domain name of the dependency. Domain names may be fully qualified or
     may contain a * wildcard.
    :vartype domain_name: str
    :ivar description: Human-readable supplemental information about the dependency and when it is
     applicable.
    :vartype description: str
    :ivar endpoint_details: The list of connection details for this endpoint.
    :vartype endpoint_details: list[~azure.mgmt.batch.models.EndpointDetail]
    """

    _validation = {
        'domain_name': {'readonly': True},
        'description': {'readonly': True},
        'endpoint_details': {'readonly': True},
    }

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = None
        self.description = None
        self.endpoint_details = None


class EndpointDetail(msrest.serialization.Model):
    """Details about the connection between the Batch service and the endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    """

    _validation = {
        'port': {'readonly': True},
    }

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(EndpointDetail, self).__init__(**kwargs)
        self.port = None


class EnvironmentSetting(msrest.serialization.Model):
    """An environment variable to be set on a task process.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the environment variable.
    :vartype name: str
    :ivar value: The value of the environment variable.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the environment variable.
        :paramtype name: str
        :keyword value: The value of the environment variable.
        :paramtype value: str
        """
        super(EnvironmentSetting, self).__init__(**kwargs)
        self.name = name
        self.value = value


class FixedScaleSettings(msrest.serialization.Model):
    """Fixed scale settings for the pool.

    :ivar resize_timeout: The default value is 15 minutes. Timeout values use ISO 8601 format. For
     example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less
     than 5 minutes, the Batch service rejects the request with an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :vartype resize_timeout: ~datetime.timedelta
    :ivar target_dedicated_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes must
     be set.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes
     must be set.
    :vartype target_low_priority_nodes: int
    :ivar node_deallocation_option: If omitted, the default value is Requeue. Possible values
     include: "Requeue", "Terminate", "TaskCompletion", "RetainedData".
    :vartype node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    """

    _attribute_map = {
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resize_timeout: Optional[datetime.timedelta] = None,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        node_deallocation_option: Optional[Union[str, "ComputeNodeDeallocationOption"]] = None,
        **kwargs
    ):
        """
        :keyword resize_timeout: The default value is 15 minutes. Timeout values use ISO 8601 format.
         For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value
         less than 5 minutes, the Batch service rejects the request with an error; if you are calling
         the REST API directly, the HTTP status code is 400 (Bad Request).
        :paramtype resize_timeout: ~datetime.timedelta
        :keyword target_dedicated_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes
         must be set.
        :paramtype target_dedicated_nodes: int
        :keyword target_low_priority_nodes: At least one of targetDedicatedNodes,
         targetLowPriorityNodes must be set.
        :paramtype target_low_priority_nodes: int
        :keyword node_deallocation_option: If omitted, the default value is Requeue. Possible values
         include: "Requeue", "Terminate", "TaskCompletion", "RetainedData".
        :paramtype node_deallocation_option: str or
         ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
        """
        super(FixedScaleSettings, self).__init__(**kwargs)
        self.resize_timeout = resize_timeout
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.node_deallocation_option = node_deallocation_option


class ImageReference(msrest.serialization.Model):
    """A reference to an Azure Virtual Machines Marketplace image or the Azure Image resource of a custom Virtual Machine. To get the list of all imageReferences verified by Azure Batch, see the 'List supported node agent SKUs' operation.

    :ivar publisher: For example, Canonical or MicrosoftWindowsServer.
    :vartype publisher: str
    :ivar offer: For example, UbuntuServer or WindowsServer.
    :vartype offer: str
    :ivar sku: For example, 18.04-LTS or 2022-datacenter.
    :vartype sku: str
    :ivar version: A value of 'latest' can be specified to select the latest version of an image.
     If omitted, the default is 'latest'.
    :vartype version: str
    :ivar id: This property is mutually exclusive with other properties. The Shared Image Gallery
     image must have replicas in the same region as the Azure Batch account. For information about
     the firewall settings for the Batch node agent to communicate with the Batch service see
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
    :vartype id: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword publisher: For example, Canonical or MicrosoftWindowsServer.
        :paramtype publisher: str
        :keyword offer: For example, UbuntuServer or WindowsServer.
        :paramtype offer: str
        :keyword sku: For example, 18.04-LTS or 2022-datacenter.
        :paramtype sku: str
        :keyword version: A value of 'latest' can be specified to select the latest version of an
         image. If omitted, the default is 'latest'.
        :paramtype version: str
        :keyword id: This property is mutually exclusive with other properties. The Shared Image
         Gallery image must have replicas in the same region as the Azure Batch account. For information
         about the firewall settings for the Batch node agent to communicate with the Batch service see
         https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        :paramtype id: str
        """
        super(ImageReference, self).__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.id = id


class InboundNatPool(msrest.serialization.Model):
    """A inbound NAT pool that can be used to address specific ports on compute nodes in a Batch pool externally.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name must be unique within a Batch pool, can contain letters,
     numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end
     with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values
     are provided the request fails with HTTP status code 400.
    :vartype name: str
    :ivar protocol: Required. The protocol of the endpoint. Possible values include: "TCP", "UDP".
    :vartype protocol: str or ~azure.mgmt.batch.models.InboundEndpointProtocol
    :ivar backend_port: Required. This must be unique within a Batch pool. Acceptable values are
     between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved
     values are provided the request fails with HTTP status code 400.
    :vartype backend_port: int
    :ivar frontend_port_range_start: Required. Acceptable values range between 1 and 65534 except
     ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and
     cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP
     status code 400.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: Required. Acceptable values range between 1 and 65534 except
     ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool
     must be distinct and cannot overlap. If any reserved or overlapping values are provided the
     request fails with HTTP status code 400.
    :vartype frontend_port_range_end: int
    :ivar network_security_group_rules: The maximum number of rules that can be specified across
     all the endpoints on a Batch pool is 25. If no network security group rules are specified, a
     default rule will be created to allow inbound access to the specified backendPort. If the
     maximum number of network security group rules is exceeded the request fails with HTTP status
     code 400.
    :vartype network_security_group_rules: list[~azure.mgmt.batch.models.NetworkSecurityGroupRule]
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'backend_port': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'frontend_port_range_start': {'key': 'frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'frontendPortRangeEnd', 'type': 'int'},
        'network_security_group_rules': {'key': 'networkSecurityGroupRules', 'type': '[NetworkSecurityGroupRule]'},
    }

    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "InboundEndpointProtocol"],
        backend_port: int,
        frontend_port_range_start: int,
        frontend_port_range_end: int,
        network_security_group_rules: Optional[List["NetworkSecurityGroupRule"]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name must be unique within a Batch pool, can contain letters,
         numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end
         with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values
         are provided the request fails with HTTP status code 400.
        :paramtype name: str
        :keyword protocol: Required. The protocol of the endpoint. Possible values include: "TCP",
         "UDP".
        :paramtype protocol: str or ~azure.mgmt.batch.models.InboundEndpointProtocol
        :keyword backend_port: Required. This must be unique within a Batch pool. Acceptable values are
         between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved
         values are provided the request fails with HTTP status code 400.
        :paramtype backend_port: int
        :keyword frontend_port_range_start: Required. Acceptable values range between 1 and 65534
         except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct
         and cannot overlap. If any reserved or overlapping values are provided the request fails with
         HTTP status code 400.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: Required. Acceptable values range between 1 and 65534 except
         ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool
         must be distinct and cannot overlap. If any reserved or overlapping values are provided the
         request fails with HTTP status code 400.
        :paramtype frontend_port_range_end: int
        :keyword network_security_group_rules: The maximum number of rules that can be specified across
         all the endpoints on a Batch pool is 25. If no network security group rules are specified, a
         default rule will be created to allow inbound access to the specified backendPort. If the
         maximum number of network security group rules is exceeded the request fails with HTTP status
         code 400.
        :paramtype network_security_group_rules:
         list[~azure.mgmt.batch.models.NetworkSecurityGroupRule]
        """
        super(InboundNatPool, self).__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.backend_port = backend_port
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.network_security_group_rules = network_security_group_rules


class KeyVaultProperties(msrest.serialization.Model):
    """KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.

    :ivar key_identifier: Full path to the versioned secret. Example
     https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. To be usable
     the following prerequisites must be met:
    
      The Batch Account has a System Assigned identity
      The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
      The KeyVault has soft-delete and purge protection enabled.
    :vartype key_identifier: str
    """

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_identifier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_identifier: Full path to the versioned secret. Example
         https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. To be usable
         the following prerequisites must be met:
        
          The Batch Account has a System Assigned identity
          The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
          The KeyVault has soft-delete and purge protection enabled.
        :paramtype key_identifier: str
        """
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = key_identifier


class KeyVaultReference(msrest.serialization.Model):
    """Identifies the Azure key vault associated with a Batch account.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The resource ID of the Azure key vault associated with the Batch account.
    :vartype id: str
    :ivar url: Required. The URL of the Azure key vault associated with the Batch account.
    :vartype url: str
    """

    _validation = {
        'id': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        url: str,
        **kwargs
    ):
        """
        :keyword id: Required. The resource ID of the Azure key vault associated with the Batch
         account.
        :paramtype id: str
        :keyword url: Required. The URL of the Azure key vault associated with the Batch account.
        :paramtype url: str
        """
        super(KeyVaultReference, self).__init__(**kwargs)
        self.id = id
        self.url = url


class LinuxUserConfiguration(msrest.serialization.Model):
    """Properties used to create a user account on a Linux node.

    :ivar uid: The uid and gid properties must be specified together or not at all. If not
     specified the underlying operating system picks the uid.
    :vartype uid: int
    :ivar gid: The uid and gid properties must be specified together or not at all. If not
     specified the underlying operating system picks the gid.
    :vartype gid: int
    :ivar ssh_private_key: The private key must not be password protected. The private key is used
     to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux
     pool when the pool's enableInterNodeCommunication property is true (it is ignored if
     enableInterNodeCommunication is false). It does this by placing the key pair into the user's
     .ssh directory. If not specified, password-less SSH is not configured between nodes (no
     modification of the user's .ssh directory is done).
    :vartype ssh_private_key: str
    """

    _attribute_map = {
        'uid': {'key': 'uid', 'type': 'int'},
        'gid': {'key': 'gid', 'type': 'int'},
        'ssh_private_key': {'key': 'sshPrivateKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uid: Optional[int] = None,
        gid: Optional[int] = None,
        ssh_private_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword uid: The uid and gid properties must be specified together or not at all. If not
         specified the underlying operating system picks the uid.
        :paramtype uid: int
        :keyword gid: The uid and gid properties must be specified together or not at all. If not
         specified the underlying operating system picks the gid.
        :paramtype gid: int
        :keyword ssh_private_key: The private key must not be password protected. The private key is
         used to automatically configure asymmetric-key based authentication for SSH between nodes in a
         Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if
         enableInterNodeCommunication is false). It does this by placing the key pair into the user's
         .ssh directory. If not specified, password-less SSH is not configured between nodes (no
         modification of the user's .ssh directory is done).
        :paramtype ssh_private_key: str
        """
        super(LinuxUserConfiguration, self).__init__(**kwargs)
        self.uid = uid
        self.gid = gid
        self.ssh_private_key = ssh_private_key


class ListApplicationPackagesResult(msrest.serialization.Model):
    """The result of performing list application packages.

    :ivar value: The list of application packages.
    :vartype value: list[~azure.mgmt.batch.models.ApplicationPackage]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationPackage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationPackage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of application packages.
        :paramtype value: list[~azure.mgmt.batch.models.ApplicationPackage]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(ListApplicationPackagesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListApplicationsResult(msrest.serialization.Model):
    """The result of performing list applications.

    :ivar value: The list of applications.
    :vartype value: list[~azure.mgmt.batch.models.Application]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Application]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Application"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of applications.
        :paramtype value: list[~azure.mgmt.batch.models.Application]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super(ListApplicationsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListCertificatesResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :ivar value: The collection of returned certificates.
    :vartype value: list[~azure.mgmt.batch.models.Certificate]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Certificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of returned certificates.
        :paramtype value: list[~azure.mgmt.batch.models.Certificate]
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super(ListCertificatesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListPoolsResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :ivar value: The collection of returned pools.
    :vartype value: list[~azure.mgmt.batch.models.Pool]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Pool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Pool"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of returned pools.
        :paramtype value: list[~azure.mgmt.batch.models.Pool]
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super(ListPoolsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListPrivateEndpointConnectionsResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :ivar value: The collection of returned private endpoint connection.
    :vartype value: list[~azure.mgmt.batch.models.PrivateEndpointConnection]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of returned private endpoint connection.
        :paramtype value: list[~azure.mgmt.batch.models.PrivateEndpointConnection]
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super(ListPrivateEndpointConnectionsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListPrivateLinkResourcesResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :ivar value: The collection of returned private link resources.
    :vartype value: list[~azure.mgmt.batch.models.PrivateLinkResource]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of returned private link resources.
        :paramtype value: list[~azure.mgmt.batch.models.PrivateLinkResource]
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super(ListPrivateLinkResourcesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MetadataItem(msrest.serialization.Model):
    """The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the metadata item.
    :vartype name: str
    :ivar value: Required. The value of the metadata item.
    :vartype value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the metadata item.
        :paramtype name: str
        :keyword value: Required. The value of the metadata item.
        :paramtype value: str
        """
        super(MetadataItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class MountConfiguration(msrest.serialization.Model):
    """The file system to mount on each node.

    :ivar azure_blob_file_system_configuration: This property is mutually exclusive with all other
     properties.
    :vartype azure_blob_file_system_configuration:
     ~azure.mgmt.batch.models.AzureBlobFileSystemConfiguration
    :ivar nfs_mount_configuration: This property is mutually exclusive with all other properties.
    :vartype nfs_mount_configuration: ~azure.mgmt.batch.models.NFSMountConfiguration
    :ivar cifs_mount_configuration: This property is mutually exclusive with all other properties.
    :vartype cifs_mount_configuration: ~azure.mgmt.batch.models.CIFSMountConfiguration
    :ivar azure_file_share_configuration: This property is mutually exclusive with all other
     properties.
    :vartype azure_file_share_configuration: ~azure.mgmt.batch.models.AzureFileShareConfiguration
    """

    _attribute_map = {
        'azure_blob_file_system_configuration': {'key': 'azureBlobFileSystemConfiguration', 'type': 'AzureBlobFileSystemConfiguration'},
        'nfs_mount_configuration': {'key': 'nfsMountConfiguration', 'type': 'NFSMountConfiguration'},
        'cifs_mount_configuration': {'key': 'cifsMountConfiguration', 'type': 'CIFSMountConfiguration'},
        'azure_file_share_configuration': {'key': 'azureFileShareConfiguration', 'type': 'AzureFileShareConfiguration'},
    }

    def __init__(
        self,
        *,
        azure_blob_file_system_configuration: Optional["AzureBlobFileSystemConfiguration"] = None,
        nfs_mount_configuration: Optional["NFSMountConfiguration"] = None,
        cifs_mount_configuration: Optional["CIFSMountConfiguration"] = None,
        azure_file_share_configuration: Optional["AzureFileShareConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword azure_blob_file_system_configuration: This property is mutually exclusive with all
         other properties.
        :paramtype azure_blob_file_system_configuration:
         ~azure.mgmt.batch.models.AzureBlobFileSystemConfiguration
        :keyword nfs_mount_configuration: This property is mutually exclusive with all other
         properties.
        :paramtype nfs_mount_configuration: ~azure.mgmt.batch.models.NFSMountConfiguration
        :keyword cifs_mount_configuration: This property is mutually exclusive with all other
         properties.
        :paramtype cifs_mount_configuration: ~azure.mgmt.batch.models.CIFSMountConfiguration
        :keyword azure_file_share_configuration: This property is mutually exclusive with all other
         properties.
        :paramtype azure_file_share_configuration: ~azure.mgmt.batch.models.AzureFileShareConfiguration
        """
        super(MountConfiguration, self).__init__(**kwargs)
        self.azure_blob_file_system_configuration = azure_blob_file_system_configuration
        self.nfs_mount_configuration = nfs_mount_configuration
        self.cifs_mount_configuration = cifs_mount_configuration
        self.azure_file_share_configuration = azure_file_share_configuration


class NetworkConfiguration(msrest.serialization.Model):
    """The network configuration for a pool.

    :ivar subnet_id: The virtual network must be in the same region and subscription as the Azure
     Batch account. The specified subnet should have enough free IP addresses to accommodate the
     number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will
     partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch'
     service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control
     (RBAC) role for the specified VNet. The specified subnet must allow communication from the
     Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by
     checking if the specified VNet has any associated Network Security Groups (NSG). If
     communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch
     service will set the state of the compute nodes to unusable. If the specified VNet has any
     associated Network Security Groups (NSG), then a few reserved system ports must be enabled for
     inbound communication. For pools created with a virtual machine configuration, enable ports
     29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with
     a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound
     connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic'
     VNETs are supported. For more details see:
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
    :vartype subnet_id: str
    :ivar dynamic_v_net_assignment_scope: The scope of dynamic vnet assignment. Possible values
     include: "none", "job".
    :vartype dynamic_v_net_assignment_scope: str or
     ~azure.mgmt.batch.models.DynamicVNetAssignmentScope
    :ivar endpoint_configuration: Pool endpoint configuration is only supported on pools with the
     virtualMachineConfiguration property.
    :vartype endpoint_configuration: ~azure.mgmt.batch.models.PoolEndpointConfiguration
    :ivar public_ip_address_configuration: This property is only supported on Pools with the
     virtualMachineConfiguration property.
    :vartype public_ip_address_configuration: ~azure.mgmt.batch.models.PublicIPAddressConfiguration
    """

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'dynamic_v_net_assignment_scope': {'key': 'dynamicVNetAssignmentScope', 'type': 'str'},
        'endpoint_configuration': {'key': 'endpointConfiguration', 'type': 'PoolEndpointConfiguration'},
        'public_ip_address_configuration': {'key': 'publicIPAddressConfiguration', 'type': 'PublicIPAddressConfiguration'},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        dynamic_v_net_assignment_scope: Optional[Union[str, "DynamicVNetAssignmentScope"]] = None,
        endpoint_configuration: Optional["PoolEndpointConfiguration"] = None,
        public_ip_address_configuration: Optional["PublicIPAddressConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword subnet_id: The virtual network must be in the same region and subscription as the
         Azure Batch account. The specified subnet should have enough free IP addresses to accommodate
         the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool
         will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch'
         service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control
         (RBAC) role for the specified VNet. The specified subnet must allow communication from the
         Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by
         checking if the specified VNet has any associated Network Security Groups (NSG). If
         communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch
         service will set the state of the compute nodes to unusable. If the specified VNet has any
         associated Network Security Groups (NSG), then a few reserved system ports must be enabled for
         inbound communication. For pools created with a virtual machine configuration, enable ports
         29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with
         a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound
         connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic'
         VNETs are supported. For more details see:
         https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        :paramtype subnet_id: str
        :keyword dynamic_v_net_assignment_scope: The scope of dynamic vnet assignment. Possible values
         include: "none", "job".
        :paramtype dynamic_v_net_assignment_scope: str or
         ~azure.mgmt.batch.models.DynamicVNetAssignmentScope
        :keyword endpoint_configuration: Pool endpoint configuration is only supported on pools with
         the virtualMachineConfiguration property.
        :paramtype endpoint_configuration: ~azure.mgmt.batch.models.PoolEndpointConfiguration
        :keyword public_ip_address_configuration: This property is only supported on Pools with the
         virtualMachineConfiguration property.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.batch.models.PublicIPAddressConfiguration
        """
        super(NetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = subnet_id
        self.dynamic_v_net_assignment_scope = dynamic_v_net_assignment_scope
        self.endpoint_configuration = endpoint_configuration
        self.public_ip_address_configuration = public_ip_address_configuration


class NetworkSecurityGroupRule(msrest.serialization.Model):
    """A network security group rule to apply to an inbound endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar priority: Required. Priorities within a pool must be unique and are evaluated in order of
     priority. The lower the number the higher the priority. For example, rules could be specified
     with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence
     over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or
     duplicate values are provided the request fails with HTTP status code 400.
    :vartype priority: int
    :ivar access: Required. The action that should be taken for a specified IP address, subnet
     range or tag. Possible values include: "Allow", "Deny".
    :vartype access: str or ~azure.mgmt.batch.models.NetworkSecurityGroupRuleAccess
    :ivar source_address_prefix: Required. Valid values are a single IP address (i.e. 10.10.10.10),
     IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values
     are provided the request fails with HTTP status code 400.
    :vartype source_address_prefix: str
    :ivar source_port_ranges: Valid values are '\ *' (for all ports 0 - 65535) or arrays of ports
     or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges
     or ports can't overlap. If any other values are provided the request fails with HTTP status
     code 400. Default value will be *.
    :vartype source_port_ranges: list[str]
    """

    _validation = {
        'priority': {'required': True},
        'access': {'required': True},
        'source_address_prefix': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'access': {'key': 'access', 'type': 'str'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        priority: int,
        access: Union[str, "NetworkSecurityGroupRuleAccess"],
        source_address_prefix: str,
        source_port_ranges: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword priority: Required. Priorities within a pool must be unique and are evaluated in order
         of priority. The lower the number the higher the priority. For example, rules could be
         specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes
         precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any
         reserved or duplicate values are provided the request fails with HTTP status code 400.
        :paramtype priority: int
        :keyword access: Required. The action that should be taken for a specified IP address, subnet
         range or tag. Possible values include: "Allow", "Deny".
        :paramtype access: str or ~azure.mgmt.batch.models.NetworkSecurityGroupRuleAccess
        :keyword source_address_prefix: Required. Valid values are a single IP address (i.e.
         10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any
         other values are provided the request fails with HTTP status code 400.
        :paramtype source_address_prefix: str
        :keyword source_port_ranges: Valid values are '\ *' (for all ports 0 - 65535) or arrays of
         ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port
         ranges or ports can't overlap. If any other values are provided the request fails with HTTP
         status code 400. Default value will be *.
        :paramtype source_port_ranges: list[str]
        """
        super(NetworkSecurityGroupRule, self).__init__(**kwargs)
        self.priority = priority
        self.access = access
        self.source_address_prefix = source_address_prefix
        self.source_port_ranges = source_port_ranges


class NFSMountConfiguration(msrest.serialization.Model):
    """Information used to connect to an NFS file system.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Required. The URI of the file system to mount.
    :vartype source: str
    :ivar relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :vartype relative_mount_path: str
    :ivar mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :vartype mount_options: str
    """

    _validation = {
        'source': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source: Required. The URI of the file system to mount.
        :paramtype source: str
        :keyword relative_mount_path: Required. All file systems are mounted relative to the Batch
         mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :paramtype relative_mount_path: str
        :keyword mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        :paramtype mount_options: str
        """
        super(NFSMountConfiguration, self).__init__(**kwargs)
        self.source = source
        self.relative_mount_path = relative_mount_path
        self.mount_options = mount_options


class NodePlacementConfiguration(msrest.serialization.Model):
    """Allocation configuration used by Batch Service to provision the nodes.

    :ivar policy: Allocation policy used by Batch Service to provision the nodes. If not specified,
     Batch will use the regional policy. Possible values include: "Regional", "Zonal".
    :vartype policy: str or ~azure.mgmt.batch.models.NodePlacementPolicyType
    """

    _attribute_map = {
        'policy': {'key': 'policy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy: Optional[Union[str, "NodePlacementPolicyType"]] = None,
        **kwargs
    ):
        """
        :keyword policy: Allocation policy used by Batch Service to provision the nodes. If not
         specified, Batch will use the regional policy. Possible values include: "Regional", "Zonal".
        :paramtype policy: str or ~azure.mgmt.batch.models.NodePlacementPolicyType
        """
        super(NodePlacementConfiguration, self).__init__(**kwargs)
        self.policy = policy


class Operation(msrest.serialization.Model):
    """A REST API operation.

    :ivar name: This is of the format {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that describes the operation.
    :vartype display: ~azure.mgmt.batch.models.OperationDisplay
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar properties: Any object.
    :vartype properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword name: This is of the format {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: The object that describes the operation.
        :paramtype display: ~azure.mgmt.batch.models.OperationDisplay
        :keyword origin: The intended executor of the operation.
        :paramtype origin: str
        :keyword properties: Any object.
        :paramtype properties: any
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar operation: For example: read, write, delete, or listKeys/action.
    :vartype operation: str
    :ivar resource: The resource type on which the operation is performed.
    :vartype resource: str
    :ivar description: The friendly name of the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Friendly name of the resource provider.
        :paramtype provider: str
        :keyword operation: For example: read, write, delete, or listKeys/action.
        :paramtype operation: str
        :keyword resource: The resource type on which the operation is performed.
        :paramtype resource: str
        :keyword description: The friendly name of the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    :ivar value: The list of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.batch.models.Operation]
    :ivar next_link: The URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of operations supported by the resource provider.
        :paramtype value: list[~azure.mgmt.batch.models.Operation]
        :keyword next_link: The URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSDisk(msrest.serialization.Model):
    """Settings for the operating system disk of the virtual machine.

    :ivar ephemeral_os_disk_settings: Specifies the ephemeral Disk Settings for the operating
     system disk used by the virtual machine.
    :vartype ephemeral_os_disk_settings: ~azure.mgmt.batch.models.DiffDiskSettings
    """

    _attribute_map = {
        'ephemeral_os_disk_settings': {'key': 'ephemeralOSDiskSettings', 'type': 'DiffDiskSettings'},
    }

    def __init__(
        self,
        *,
        ephemeral_os_disk_settings: Optional["DiffDiskSettings"] = None,
        **kwargs
    ):
        """
        :keyword ephemeral_os_disk_settings: Specifies the ephemeral Disk Settings for the operating
         system disk used by the virtual machine.
        :paramtype ephemeral_os_disk_settings: ~azure.mgmt.batch.models.DiffDiskSettings
        """
        super(OSDisk, self).__init__(**kwargs)
        self.ephemeral_os_disk_settings = ephemeral_os_disk_settings


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """A collection of related endpoints from the same service for which the Batch service requires outbound access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category: The type of service that the Batch service connects to.
    :vartype category: str
    :ivar endpoints: The endpoints for this service to which the Batch service makes outbound
     calls.
    :vartype endpoints: list[~azure.mgmt.batch.models.EndpointDependency]
    """

    _validation = {
        'category': {'readonly': True},
        'endpoints': {'readonly': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = None
        self.endpoints = None


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Values returned by the List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The collection of outbound network dependency endpoints returned by the listing
     operation.
    :vartype value: list[~azure.mgmt.batch.models.OutboundEnvironmentEndpoint]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Pool(ProxyResource):
    """Contains information about a pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar identity: The type of identity used for the Batch Pool.
    :vartype identity: ~azure.mgmt.batch.models.BatchPoolIdentity
    :ivar display_name: The display name need not be unique and can contain any Unicode characters
     up to a maximum length of 1024.
    :vartype display_name: str
    :ivar last_modified: This is the last time at which the pool level data, such as the
     targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes
     such as a compute node changing state.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the pool.
    :vartype creation_time: ~datetime.datetime
    :ivar provisioning_state: The current state of the pool. Possible values include: "Succeeded",
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.PoolProvisioningState
    :ivar provisioning_state_transition_time: The time at which the pool entered its current state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar allocation_state: Whether the pool is resizing. Possible values include: "Steady",
     "Resizing", "Stopping".
    :vartype allocation_state: str or ~azure.mgmt.batch.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the pool entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar vm_size: For information about available sizes of virtual machines for Cloud Services
     pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services
     (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch
     supports all Cloud Services VM sizes except ExtraSmall. For information about available VM
     sizes for pools using images from the Virtual Machines Marketplace (pools created with
     virtualMachineConfiguration) see Sizes for Virtual Machines (Linux)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for
     Virtual Machines (Windows)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch
     supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS,
     STANDARD_DS, and STANDARD_DSV2 series).
    :vartype vm_size: str
    :ivar deployment_configuration: Using CloudServiceConfiguration specifies that the nodes should
     be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure
     Virtual Machines (IaaS).
    :vartype deployment_configuration: ~azure.mgmt.batch.models.DeploymentConfiguration
    :ivar current_dedicated_nodes: The number of compute nodes currently in the pool.
    :vartype current_dedicated_nodes: int
    :ivar current_low_priority_nodes: The number of Spot/low-priority compute nodes currently in
     the pool.
    :vartype current_low_priority_nodes: int
    :ivar scale_settings: Defines the desired size of the pool. This can either be 'fixedScale'
     where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula
     which is periodically reevaluated. If this property is not specified, the pool will have a
     fixed scale with 0 targetDedicatedNodes.
    :vartype scale_settings: ~azure.mgmt.batch.models.ScaleSettings
    :ivar auto_scale_run: This property is set only if the pool automatically scales, i.e.
     autoScaleSettings are used.
    :vartype auto_scale_run: ~azure.mgmt.batch.models.AutoScaleRun
    :ivar inter_node_communication: This imposes restrictions on which nodes can be assigned to the
     pool. Enabling this value can reduce the chance of the requested number of nodes to be
     allocated in the pool. If not specified, this value defaults to 'Disabled'. Possible values
     include: "Enabled", "Disabled".
    :vartype inter_node_communication: str or ~azure.mgmt.batch.models.InterNodeCommunicationState
    :ivar network_configuration: The network configuration for a pool.
    :vartype network_configuration: ~azure.mgmt.batch.models.NetworkConfiguration
    :ivar task_slots_per_node: The default value is 1. The maximum value is the smaller of 4 times
     the number of cores of the vmSize of the pool or 256.
    :vartype task_slots_per_node: int
    :ivar task_scheduling_policy: If not specified, the default is spread.
    :vartype task_scheduling_policy: ~azure.mgmt.batch.models.TaskSchedulingPolicy
    :ivar user_accounts: The list of user accounts to be created on each node in the pool.
    :vartype user_accounts: list[~azure.mgmt.batch.models.UserAccount]
    :ivar metadata: The Batch service does not assign any meaning to metadata; it is solely for the
     use of user code.
    :vartype metadata: list[~azure.mgmt.batch.models.MetadataItem]
    :ivar start_task: In an PATCH (update) operation, this property can be set to an empty object
     to remove the start task from the pool.
    :vartype start_task: ~azure.mgmt.batch.models.StartTask
    :ivar certificates: For Windows compute nodes, the Batch service installs the certificates to
     the specified certificate store and location. For Linux compute nodes, the certificates are
     stored in a directory inside the task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates
     with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory
     (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
    :vartype certificates: list[~azure.mgmt.batch.models.CertificateReference]
    :ivar application_packages: Changes to application package references affect all new compute
     nodes joining the pool, but do not affect compute nodes that are already in the pool until they
     are rebooted or reimaged. There is a maximum of 10 application package references on any given
     pool.
    :vartype application_packages: list[~azure.mgmt.batch.models.ApplicationPackageReference]
    :ivar application_licenses: The list of application licenses must be a subset of available
     Batch service application licenses. If a license is requested which is not supported, pool
     creation will fail.
    :vartype application_licenses: list[str]
    :ivar resize_operation_status: Describes either the current operation (if the pool
     AllocationState is Resizing) or the previously completed operation (if the AllocationState is
     Steady).
    :vartype resize_operation_status: ~azure.mgmt.batch.models.ResizeOperationStatus
    :ivar mount_configuration: This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
    :vartype mount_configuration: list[~azure.mgmt.batch.models.MountConfiguration]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified': {'readonly': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'current_dedicated_nodes': {'readonly': True},
        'current_low_priority_nodes': {'readonly': True},
        'auto_scale_run': {'readonly': True},
        'resize_operation_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'BatchPoolIdentity'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'allocation_state': {'key': 'properties.allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'properties.allocationStateTransitionTime', 'type': 'iso-8601'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'deployment_configuration': {'key': 'properties.deploymentConfiguration', 'type': 'DeploymentConfiguration'},
        'current_dedicated_nodes': {'key': 'properties.currentDedicatedNodes', 'type': 'int'},
        'current_low_priority_nodes': {'key': 'properties.currentLowPriorityNodes', 'type': 'int'},
        'scale_settings': {'key': 'properties.scaleSettings', 'type': 'ScaleSettings'},
        'auto_scale_run': {'key': 'properties.autoScaleRun', 'type': 'AutoScaleRun'},
        'inter_node_communication': {'key': 'properties.interNodeCommunication', 'type': 'str'},
        'network_configuration': {'key': 'properties.networkConfiguration', 'type': 'NetworkConfiguration'},
        'task_slots_per_node': {'key': 'properties.taskSlotsPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'properties.taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'user_accounts': {'key': 'properties.userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'properties.metadata', 'type': '[MetadataItem]'},
        'start_task': {'key': 'properties.startTask', 'type': 'StartTask'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateReference]'},
        'application_packages': {'key': 'properties.applicationPackages', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'properties.applicationLicenses', 'type': '[str]'},
        'resize_operation_status': {'key': 'properties.resizeOperationStatus', 'type': 'ResizeOperationStatus'},
        'mount_configuration': {'key': 'properties.mountConfiguration', 'type': '[MountConfiguration]'},
    }

    def __init__(
        self,
        *,
        identity: Optional["BatchPoolIdentity"] = None,
        display_name: Optional[str] = None,
        vm_size: Optional[str] = None,
        deployment_configuration: Optional["DeploymentConfiguration"] = None,
        scale_settings: Optional["ScaleSettings"] = None,
        inter_node_communication: Optional[Union[str, "InterNodeCommunicationState"]] = None,
        network_configuration: Optional["NetworkConfiguration"] = None,
        task_slots_per_node: Optional[int] = None,
        task_scheduling_policy: Optional["TaskSchedulingPolicy"] = None,
        user_accounts: Optional[List["UserAccount"]] = None,
        metadata: Optional[List["MetadataItem"]] = None,
        start_task: Optional["StartTask"] = None,
        certificates: Optional[List["CertificateReference"]] = None,
        application_packages: Optional[List["ApplicationPackageReference"]] = None,
        application_licenses: Optional[List[str]] = None,
        mount_configuration: Optional[List["MountConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword identity: The type of identity used for the Batch Pool.
        :paramtype identity: ~azure.mgmt.batch.models.BatchPoolIdentity
        :keyword display_name: The display name need not be unique and can contain any Unicode
         characters up to a maximum length of 1024.
        :paramtype display_name: str
        :keyword vm_size: For information about available sizes of virtual machines for Cloud Services
         pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services
         (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch
         supports all Cloud Services VM sizes except ExtraSmall. For information about available VM
         sizes for pools using images from the Virtual Machines Marketplace (pools created with
         virtualMachineConfiguration) see Sizes for Virtual Machines (Linux)
         (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for
         Virtual Machines (Windows)
         (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch
         supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS,
         STANDARD_DS, and STANDARD_DSV2 series).
        :paramtype vm_size: str
        :keyword deployment_configuration: Using CloudServiceConfiguration specifies that the nodes
         should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses
         Azure Virtual Machines (IaaS).
        :paramtype deployment_configuration: ~azure.mgmt.batch.models.DeploymentConfiguration
        :keyword scale_settings: Defines the desired size of the pool. This can either be 'fixedScale'
         where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula
         which is periodically reevaluated. If this property is not specified, the pool will have a
         fixed scale with 0 targetDedicatedNodes.
        :paramtype scale_settings: ~azure.mgmt.batch.models.ScaleSettings
        :keyword inter_node_communication: This imposes restrictions on which nodes can be assigned to
         the pool. Enabling this value can reduce the chance of the requested number of nodes to be
         allocated in the pool. If not specified, this value defaults to 'Disabled'. Possible values
         include: "Enabled", "Disabled".
        :paramtype inter_node_communication: str or
         ~azure.mgmt.batch.models.InterNodeCommunicationState
        :keyword network_configuration: The network configuration for a pool.
        :paramtype network_configuration: ~azure.mgmt.batch.models.NetworkConfiguration
        :keyword task_slots_per_node: The default value is 1. The maximum value is the smaller of 4
         times the number of cores of the vmSize of the pool or 256.
        :paramtype task_slots_per_node: int
        :keyword task_scheduling_policy: If not specified, the default is spread.
        :paramtype task_scheduling_policy: ~azure.mgmt.batch.models.TaskSchedulingPolicy
        :keyword user_accounts: The list of user accounts to be created on each node in the pool.
        :paramtype user_accounts: list[~azure.mgmt.batch.models.UserAccount]
        :keyword metadata: The Batch service does not assign any meaning to metadata; it is solely for
         the use of user code.
        :paramtype metadata: list[~azure.mgmt.batch.models.MetadataItem]
        :keyword start_task: In an PATCH (update) operation, this property can be set to an empty
         object to remove the start task from the pool.
        :paramtype start_task: ~azure.mgmt.batch.models.StartTask
        :keyword certificates: For Windows compute nodes, the Batch service installs the certificates
         to the specified certificate store and location. For Linux compute nodes, the certificates are
         stored in a directory inside the task working directory and an environment variable
         AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates
         with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory
         (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        :paramtype certificates: list[~azure.mgmt.batch.models.CertificateReference]
        :keyword application_packages: Changes to application package references affect all new compute
         nodes joining the pool, but do not affect compute nodes that are already in the pool until they
         are rebooted or reimaged. There is a maximum of 10 application package references on any given
         pool.
        :paramtype application_packages: list[~azure.mgmt.batch.models.ApplicationPackageReference]
        :keyword application_licenses: The list of application licenses must be a subset of available
         Batch service application licenses. If a license is requested which is not supported, pool
         creation will fail.
        :paramtype application_licenses: list[str]
        :keyword mount_configuration: This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
        :paramtype mount_configuration: list[~azure.mgmt.batch.models.MountConfiguration]
        """
        super(Pool, self).__init__(**kwargs)
        self.identity = identity
        self.display_name = display_name
        self.last_modified = None
        self.creation_time = None
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.vm_size = vm_size
        self.deployment_configuration = deployment_configuration
        self.current_dedicated_nodes = None
        self.current_low_priority_nodes = None
        self.scale_settings = scale_settings
        self.auto_scale_run = None
        self.inter_node_communication = inter_node_communication
        self.network_configuration = network_configuration
        self.task_slots_per_node = task_slots_per_node
        self.task_scheduling_policy = task_scheduling_policy
        self.user_accounts = user_accounts
        self.metadata = metadata
        self.start_task = start_task
        self.certificates = certificates
        self.application_packages = application_packages
        self.application_licenses = application_licenses
        self.resize_operation_status = None
        self.mount_configuration = mount_configuration


class PoolEndpointConfiguration(msrest.serialization.Model):
    """The endpoint configuration for a pool.

    All required parameters must be populated in order to send to Azure.

    :ivar inbound_nat_pools: Required. The maximum number of inbound NAT pools per Batch pool is 5.
     If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code
     400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
    :vartype inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
    """

    _validation = {
        'inbound_nat_pools': {'required': True},
    }

    _attribute_map = {
        'inbound_nat_pools': {'key': 'inboundNatPools', 'type': '[InboundNatPool]'},
    }

    def __init__(
        self,
        *,
        inbound_nat_pools: List["InboundNatPool"],
        **kwargs
    ):
        """
        :keyword inbound_nat_pools: Required. The maximum number of inbound NAT pools per Batch pool is
         5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status
         code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
        :paramtype inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
        """
        super(PoolEndpointConfiguration, self).__init__(**kwargs)
        self.inbound_nat_pools = inbound_nat_pools


class PrivateEndpoint(msrest.serialization.Model):
    """The private endpoint of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM resource identifier of the private endpoint. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/privateEndpoints/{privateEndpoint}.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(ProxyResource):
    """Contains information about a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the private endpoint connection. Possible
     values include: "Succeeded", "Updating", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.PrivateEndpointConnectionProvisioningState
    :ivar private_endpoint: The private endpoint of the private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.batch.models.PrivateEndpoint
    :ivar private_link_service_connection_state: The private link service connection state of the
     private endpoint connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.batch.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The private endpoint of the private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.batch.models.PrivateEndpoint
        :keyword private_link_service_connection_state: The private link service connection state of
         the private endpoint connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.batch.models.PrivateLinkServiceConnectionState
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkResource(ProxyResource):
    """Contains information about a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar group_id: The group id is used to establish the private link connection.
    :vartype group_id: str
    :ivar required_members: The list of required members that are used to establish the private
     link connection.
    :vartype required_members: list[str]
    :ivar required_zone_names: The list of required zone names for the private DNS resource name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The private link service connection state of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The status of the Batch private endpoint connection. Possible values
     include: "Approved", "Pending", "Rejected", "Disconnected".
    :vartype status: str or ~azure.mgmt.batch.models.PrivateLinkServiceConnectionStatus
    :ivar description: Description of the private Connection state.
    :vartype description: str
    :ivar action_required: Action required on the private connection state.
    :vartype action_required: str
    """

    _validation = {
        'status': {'required': True},
        'action_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PrivateLinkServiceConnectionStatus"],
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Required. The status of the Batch private endpoint connection. Possible values
         include: "Approved", "Pending", "Rejected", "Disconnected".
        :paramtype status: str or ~azure.mgmt.batch.models.PrivateLinkServiceConnectionStatus
        :keyword description: Description of the private Connection state.
        :paramtype description: str
        """
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = None


class PublicIPAddressConfiguration(msrest.serialization.Model):
    """The public IP Address configuration of the networking configuration of a Pool.

    :ivar provision: The default value is BatchManaged. Possible values include: "BatchManaged",
     "UserManaged", "NoPublicIPAddresses".
    :vartype provision: str or ~azure.mgmt.batch.models.IPAddressProvisioningType
    :ivar ip_address_ids: The number of IPs specified here limits the maximum size of the Pool -
     100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For
     example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each
     element of this collection is of the form:
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
    :vartype ip_address_ids: list[str]
    """

    _attribute_map = {
        'provision': {'key': 'provision', 'type': 'str'},
        'ip_address_ids': {'key': 'ipAddressIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        provision: Optional[Union[str, "IPAddressProvisioningType"]] = None,
        ip_address_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword provision: The default value is BatchManaged. Possible values include: "BatchManaged",
         "UserManaged", "NoPublicIPAddresses".
        :paramtype provision: str or ~azure.mgmt.batch.models.IPAddressProvisioningType
        :keyword ip_address_ids: The number of IPs specified here limits the maximum size of the Pool -
         100 dedicated nodes or 100 Spot/low-priority nodes can be allocated for each public IP. For
         example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each
         element of this collection is of the form:
         /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        :paramtype ip_address_ids: list[str]
        """
        super(PublicIPAddressConfiguration, self).__init__(**kwargs)
        self.provision = provision
        self.ip_address_ids = ip_address_ids


class ResizeError(msrest.serialization.Model):
    """An error that occurred when resizing a pool.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. An identifier for the error. Codes are invariant and are intended to be
     consumed programmatically.
    :vartype code: str
    :ivar message: Required. A message describing the error, intended to be suitable for display in
     a user interface.
    :vartype message: str
    :ivar details: Additional details about the error.
    :vartype details: list[~azure.mgmt.batch.models.ResizeError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ResizeError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["ResizeError"]] = None,
        **kwargs
    ):
        """
        :keyword code: Required. An identifier for the error. Codes are invariant and are intended to
         be consumed programmatically.
        :paramtype code: str
        :keyword message: Required. A message describing the error, intended to be suitable for display
         in a user interface.
        :paramtype message: str
        :keyword details: Additional details about the error.
        :paramtype details: list[~azure.mgmt.batch.models.ResizeError]
        """
        super(ResizeError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class ResizeOperationStatus(msrest.serialization.Model):
    """Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).

    :ivar target_dedicated_nodes: The desired number of dedicated compute nodes in the pool.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/low-priority compute nodes in the
     pool.
    :vartype target_low_priority_nodes: int
    :ivar resize_timeout: The default value is 15 minutes. The minimum value is 5 minutes. If you
     specify a value less than 5 minutes, the Batch service returns an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :vartype resize_timeout: ~datetime.timedelta
    :ivar node_deallocation_option: The default value is requeue. Possible values include:
     "Requeue", "Terminate", "TaskCompletion", "RetainedData".
    :vartype node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    :ivar start_time: The time when this resize operation was started.
    :vartype start_time: ~datetime.datetime
    :ivar errors: This property is set only if an error occurred during the last pool resize, and
     only when the pool allocationState is Steady.
    :vartype errors: list[~azure.mgmt.batch.models.ResizeError]
    """

    _attribute_map = {
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ResizeError]'},
    }

    def __init__(
        self,
        *,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        resize_timeout: Optional[datetime.timedelta] = None,
        node_deallocation_option: Optional[Union[str, "ComputeNodeDeallocationOption"]] = None,
        start_time: Optional[datetime.datetime] = None,
        errors: Optional[List["ResizeError"]] = None,
        **kwargs
    ):
        """
        :keyword target_dedicated_nodes: The desired number of dedicated compute nodes in the pool.
        :paramtype target_dedicated_nodes: int
        :keyword target_low_priority_nodes: The desired number of Spot/low-priority compute nodes in
         the pool.
        :paramtype target_low_priority_nodes: int
        :keyword resize_timeout: The default value is 15 minutes. The minimum value is 5 minutes. If
         you specify a value less than 5 minutes, the Batch service returns an error; if you are calling
         the REST API directly, the HTTP status code is 400 (Bad Request).
        :paramtype resize_timeout: ~datetime.timedelta
        :keyword node_deallocation_option: The default value is requeue. Possible values include:
         "Requeue", "Terminate", "TaskCompletion", "RetainedData".
        :paramtype node_deallocation_option: str or
         ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
        :keyword start_time: The time when this resize operation was started.
        :paramtype start_time: ~datetime.datetime
        :keyword errors: This property is set only if an error occurred during the last pool resize,
         and only when the pool allocationState is Steady.
        :paramtype errors: list[~azure.mgmt.batch.models.ResizeError]
        """
        super(ResizeOperationStatus, self).__init__(**kwargs)
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.resize_timeout = resize_timeout
        self.node_deallocation_option = node_deallocation_option
        self.start_time = start_time
        self.errors = errors


class ResourceFile(msrest.serialization.Model):
    """A single file or multiple files to be downloaded to a compute node.

    :ivar auto_storage_container_name: The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be specified.
    :vartype auto_storage_container_name: str
    :ivar storage_container_url: The autoStorageContainerName, storageContainerUrl and httpUrl
     properties are mutually exclusive and one of them must be specified. This URL must be readable
     and listable from compute nodes. There are three ways to get such a URL for a container in
     Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on
     the container, use a managed identity with read and list permissions, or set the ACL for the
     container to allow public access.
    :vartype storage_container_url: str
    :ivar http_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are
     mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage,
     it must be readable from compute nodes. There are three ways to get such a URL for a blob in
     Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob,
     use a managed identity with read permission, or set the ACL for the blob or its container to
     allow public access.
    :vartype http_url: str
    :ivar blob_prefix: The property is valid only when autoStorageContainerName or
     storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a
     prefix is not specified, all the files in the container will be downloaded.
    :vartype blob_prefix: str
    :ivar file_path: If the httpUrl property is specified, the filePath is required and describes
     the path which the file will be downloaded to, including the filename. Otherwise, if the
     autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and
     is the directory to download the files to. In the case where filePath is used as a directory,
     any directory structure already associated with the input data will be retained in full and
     appended to the specified filePath directory. The specified relative path cannot break out of
     the task's working directory (for example by using '..').
    :vartype file_path: str
    :ivar file_mode: This property applies only to files being downloaded to Linux compute nodes.
     It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows
     node. If this property is not specified for a Linux node, then a default value of 0770 is
     applied to the file.
    :vartype file_mode: str
    :ivar identity_reference: The reference to a user assigned identity associated with the Batch
     pool which a compute node will use.
    :vartype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _attribute_map = {
        'auto_storage_container_name': {'key': 'autoStorageContainerName', 'type': 'str'},
        'storage_container_url': {'key': 'storageContainerUrl', 'type': 'str'},
        'http_url': {'key': 'httpUrl', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
        'identity_reference': {'key': 'identityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        auto_storage_container_name: Optional[str] = None,
        storage_container_url: Optional[str] = None,
        http_url: Optional[str] = None,
        blob_prefix: Optional[str] = None,
        file_path: Optional[str] = None,
        file_mode: Optional[str] = None,
        identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        """
        :keyword auto_storage_container_name: The autoStorageContainerName, storageContainerUrl and
         httpUrl properties are mutually exclusive and one of them must be specified.
        :paramtype auto_storage_container_name: str
        :keyword storage_container_url: The autoStorageContainerName, storageContainerUrl and httpUrl
         properties are mutually exclusive and one of them must be specified. This URL must be readable
         and listable from compute nodes. There are three ways to get such a URL for a container in
         Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on
         the container, use a managed identity with read and list permissions, or set the ACL for the
         container to allow public access.
        :paramtype storage_container_url: str
        :keyword http_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are
         mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage,
         it must be readable from compute nodes. There are three ways to get such a URL for a blob in
         Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob,
         use a managed identity with read permission, or set the ACL for the blob or its container to
         allow public access.
        :paramtype http_url: str
        :keyword blob_prefix: The property is valid only when autoStorageContainerName or
         storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a
         prefix is not specified, all the files in the container will be downloaded.
        :paramtype blob_prefix: str
        :keyword file_path: If the httpUrl property is specified, the filePath is required and
         describes the path which the file will be downloaded to, including the filename. Otherwise, if
         the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional
         and is the directory to download the files to. In the case where filePath is used as a
         directory, any directory structure already associated with the input data will be retained in
         full and appended to the specified filePath directory. The specified relative path cannot break
         out of the task's working directory (for example by using '..').
        :paramtype file_path: str
        :keyword file_mode: This property applies only to files being downloaded to Linux compute
         nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a
         Windows node. If this property is not specified for a Linux node, then a default value of 0770
         is applied to the file.
        :paramtype file_mode: str
        :keyword identity_reference: The reference to a user assigned identity associated with the
         Batch pool which a compute node will use.
        :paramtype identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
        """
        super(ResourceFile, self).__init__(**kwargs)
        self.auto_storage_container_name = auto_storage_container_name
        self.storage_container_url = storage_container_url
        self.http_url = http_url
        self.blob_prefix = blob_prefix
        self.file_path = file_path
        self.file_mode = file_mode
        self.identity_reference = identity_reference


class ScaleSettings(msrest.serialization.Model):
    """Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.

    :ivar fixed_scale: This property and autoScale are mutually exclusive and one of the properties
     must be specified.
    :vartype fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
    :ivar auto_scale: This property and fixedScale are mutually exclusive and one of the properties
     must be specified.
    :vartype auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
    """

    _attribute_map = {
        'fixed_scale': {'key': 'fixedScale', 'type': 'FixedScaleSettings'},
        'auto_scale': {'key': 'autoScale', 'type': 'AutoScaleSettings'},
    }

    def __init__(
        self,
        *,
        fixed_scale: Optional["FixedScaleSettings"] = None,
        auto_scale: Optional["AutoScaleSettings"] = None,
        **kwargs
    ):
        """
        :keyword fixed_scale: This property and autoScale are mutually exclusive and one of the
         properties must be specified.
        :paramtype fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
        :keyword auto_scale: This property and fixedScale are mutually exclusive and one of the
         properties must be specified.
        :paramtype auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
        """
        super(ScaleSettings, self).__init__(**kwargs)
        self.fixed_scale = fixed_scale
        self.auto_scale = auto_scale


class SkuCapability(msrest.serialization.Model):
    """A SKU capability, such as the number of cores.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the feature.
    :vartype name: str
    :ivar value: The value of the feature.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SkuCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None


class StartTask(msrest.serialization.Model):
    """In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.

    :ivar command_line: The command line does not run under a shell, and therefore cannot take
     advantage of shell features such as environment variable expansion. If you want to take
     advantage of such features, you should invoke the shell in the command line, for example using
     "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other
     properties of the startTask are specified.
    :vartype command_line: str
    :ivar resource_files: A list of files that the Batch service will download to the compute node
     before running the command line.
    :vartype resource_files: list[~azure.mgmt.batch.models.ResourceFile]
    :ivar environment_settings: A list of environment variable settings for the start task.
    :vartype environment_settings: list[~azure.mgmt.batch.models.EnvironmentSetting]
    :ivar user_identity: If omitted, the task runs as a non-administrative user unique to the task.
    :vartype user_identity: ~azure.mgmt.batch.models.UserIdentity
    :ivar max_task_retry_count: The Batch service retries a task if its exit code is nonzero. Note
     that this value specifically controls the number of retries. The Batch service will try the
     task once, and may then retry up to this limit. For example, if the maximum retry count is 3,
     Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count
     is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch
     service retries the task without limit.
    :vartype max_task_retry_count: int
    :ivar wait_for_success: If true and the start task fails on a compute node, the Batch service
     retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still
     not completed successfully after all retries, then the Batch service marks the compute node
     unusable, and will not schedule tasks to it. This condition can be detected via the node state
     and scheduling error detail. If false, the Batch service will not wait for the start task to
     complete. In this case, other tasks can start executing on the compute node while the start
     task is still running; and even if the start task fails, new tasks will continue to be
     scheduled on the node. The default is true.
    :vartype wait_for_success: bool
    :ivar container_settings: When this is specified, all directories recursively below the
     AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the
     container, all task environment variables are mapped into the container, and the task command
     line is executed in the container.
    :vartype container_settings: ~azure.mgmt.batch.models.TaskContainerSettings
    """

    _attribute_map = {
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
        'wait_for_success': {'key': 'waitForSuccess', 'type': 'bool'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
    }

    def __init__(
        self,
        *,
        command_line: Optional[str] = None,
        resource_files: Optional[List["ResourceFile"]] = None,
        environment_settings: Optional[List["EnvironmentSetting"]] = None,
        user_identity: Optional["UserIdentity"] = None,
        max_task_retry_count: Optional[int] = None,
        wait_for_success: Optional[bool] = None,
        container_settings: Optional["TaskContainerSettings"] = None,
        **kwargs
    ):
        """
        :keyword command_line: The command line does not run under a shell, and therefore cannot take
         advantage of shell features such as environment variable expansion. If you want to take
         advantage of such features, you should invoke the shell in the command line, for example using
         "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other
         properties of the startTask are specified.
        :paramtype command_line: str
        :keyword resource_files: A list of files that the Batch service will download to the compute
         node before running the command line.
        :paramtype resource_files: list[~azure.mgmt.batch.models.ResourceFile]
        :keyword environment_settings: A list of environment variable settings for the start task.
        :paramtype environment_settings: list[~azure.mgmt.batch.models.EnvironmentSetting]
        :keyword user_identity: If omitted, the task runs as a non-administrative user unique to the
         task.
        :paramtype user_identity: ~azure.mgmt.batch.models.UserIdentity
        :keyword max_task_retry_count: The Batch service retries a task if its exit code is nonzero.
         Note that this value specifically controls the number of retries. The Batch service will try
         the task once, and may then retry up to this limit. For example, if the maximum retry count is
         3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry
         count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the
         Batch service retries the task without limit.
        :paramtype max_task_retry_count: int
        :keyword wait_for_success: If true and the start task fails on a compute node, the Batch
         service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task
         has still not completed successfully after all retries, then the Batch service marks the
         compute node unusable, and will not schedule tasks to it. This condition can be detected via
         the node state and scheduling error detail. If false, the Batch service will not wait for the
         start task to complete. In this case, other tasks can start executing on the compute node while
         the start task is still running; and even if the start task fails, new tasks will continue to
         be scheduled on the node. The default is true.
        :paramtype wait_for_success: bool
        :keyword container_settings: When this is specified, all directories recursively below the
         AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the
         container, all task environment variables are mapped into the container, and the task command
         line is executed in the container.
        :paramtype container_settings: ~azure.mgmt.batch.models.TaskContainerSettings
        """
        super(StartTask, self).__init__(**kwargs)
        self.command_line = command_line
        self.resource_files = resource_files
        self.environment_settings = environment_settings
        self.user_identity = user_identity
        self.max_task_retry_count = max_task_retry_count
        self.wait_for_success = wait_for_success
        self.container_settings = container_settings


class SupportedSku(msrest.serialization.Model):
    """Describes a Batch supported SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar family_name: The family name of the SKU.
    :vartype family_name: str
    :ivar capabilities: A collection of capabilities which this SKU supports.
    :vartype capabilities: list[~azure.mgmt.batch.models.SkuCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'family_name': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family_name': {'key': 'familyName', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '[SkuCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportedSku, self).__init__(**kwargs)
        self.name = None
        self.family_name = None
        self.capabilities = None


class SupportedSkusResult(msrest.serialization.Model):
    """The Batch List supported SKUs operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The list of SKUs available for the Batch service in the location.
    :vartype value: list[~azure.mgmt.batch.models.SupportedSku]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SupportedSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SupportedSku"],
        **kwargs
    ):
        """
        :keyword value: Required. The list of SKUs available for the Batch service in the location.
        :paramtype value: list[~azure.mgmt.batch.models.SupportedSku]
        """
        super(SupportedSkusResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TaskContainerSettings(msrest.serialization.Model):
    """The container settings for a task.

    All required parameters must be populated in order to send to Azure.

    :ivar container_run_options: These additional options are supplied as arguments to the "docker
     create" command, in addition to those controlled by the Batch Service.
    :vartype container_run_options: str
    :ivar image_name: Required. This is the full image reference, as would be specified to "docker
     pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
    :vartype image_name: str
    :ivar registry: This setting can be omitted if was already provided at pool creation.
    :vartype registry: ~azure.mgmt.batch.models.ContainerRegistry
    :ivar working_directory: A flag to indicate where the container task working directory is. The
     default is 'taskWorkingDirectory'. Possible values include: "TaskWorkingDirectory",
     "ContainerImageDefault".
    :vartype working_directory: str or ~azure.mgmt.batch.models.ContainerWorkingDirectory
    """

    _validation = {
        'image_name': {'required': True},
    }

    _attribute_map = {
        'container_run_options': {'key': 'containerRunOptions', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'ContainerRegistry'},
        'working_directory': {'key': 'workingDirectory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        image_name: str,
        container_run_options: Optional[str] = None,
        registry: Optional["ContainerRegistry"] = None,
        working_directory: Optional[Union[str, "ContainerWorkingDirectory"]] = None,
        **kwargs
    ):
        """
        :keyword container_run_options: These additional options are supplied as arguments to the
         "docker create" command, in addition to those controlled by the Batch Service.
        :paramtype container_run_options: str
        :keyword image_name: Required. This is the full image reference, as would be specified to
         "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a
         default.
        :paramtype image_name: str
        :keyword registry: This setting can be omitted if was already provided at pool creation.
        :paramtype registry: ~azure.mgmt.batch.models.ContainerRegistry
        :keyword working_directory: A flag to indicate where the container task working directory is.
         The default is 'taskWorkingDirectory'. Possible values include: "TaskWorkingDirectory",
         "ContainerImageDefault".
        :paramtype working_directory: str or ~azure.mgmt.batch.models.ContainerWorkingDirectory
        """
        super(TaskContainerSettings, self).__init__(**kwargs)
        self.container_run_options = container_run_options
        self.image_name = image_name
        self.registry = registry
        self.working_directory = working_directory


class TaskSchedulingPolicy(msrest.serialization.Model):
    """Specifies how tasks should be distributed across compute nodes.

    All required parameters must be populated in order to send to Azure.

    :ivar node_fill_type: Required. How tasks should be distributed across compute nodes. Possible
     values include: "Spread", "Pack".
    :vartype node_fill_type: str or ~azure.mgmt.batch.models.ComputeNodeFillType
    """

    _validation = {
        'node_fill_type': {'required': True},
    }

    _attribute_map = {
        'node_fill_type': {'key': 'nodeFillType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        node_fill_type: Union[str, "ComputeNodeFillType"],
        **kwargs
    ):
        """
        :keyword node_fill_type: Required. How tasks should be distributed across compute nodes.
         Possible values include: "Spread", "Pack".
        :paramtype node_fill_type: str or ~azure.mgmt.batch.models.ComputeNodeFillType
        """
        super(TaskSchedulingPolicy, self).__init__(**kwargs)
        self.node_fill_type = node_fill_type


class UserAccount(msrest.serialization.Model):
    """Properties used to create a user on an Azure Batch node.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the user account.
    :vartype name: str
    :ivar password: Required. The password for the user account.
    :vartype password: str
    :ivar elevation_level: nonAdmin - The auto user is a standard user without elevated access.
     admin - The auto user is a user with elevated access and operates with full Administrator
     permissions. The default value is nonAdmin. Possible values include: "NonAdmin", "Admin".
    :vartype elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    :ivar linux_user_configuration: This property is ignored if specified on a Windows pool. If not
     specified, the user is created with the default options.
    :vartype linux_user_configuration: ~azure.mgmt.batch.models.LinuxUserConfiguration
    :ivar windows_user_configuration: This property can only be specified if the user is on a
     Windows pool. If not specified and on a Windows pool, the user is created with the default
     options.
    :vartype windows_user_configuration: ~azure.mgmt.batch.models.WindowsUserConfiguration
    """

    _validation = {
        'name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'str'},
        'linux_user_configuration': {'key': 'linuxUserConfiguration', 'type': 'LinuxUserConfiguration'},
        'windows_user_configuration': {'key': 'windowsUserConfiguration', 'type': 'WindowsUserConfiguration'},
    }

    def __init__(
        self,
        *,
        name: str,
        password: str,
        elevation_level: Optional[Union[str, "ElevationLevel"]] = None,
        linux_user_configuration: Optional["LinuxUserConfiguration"] = None,
        windows_user_configuration: Optional["WindowsUserConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the user account.
        :paramtype name: str
        :keyword password: Required. The password for the user account.
        :paramtype password: str
        :keyword elevation_level: nonAdmin - The auto user is a standard user without elevated access.
         admin - The auto user is a user with elevated access and operates with full Administrator
         permissions. The default value is nonAdmin. Possible values include: "NonAdmin", "Admin".
        :paramtype elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
        :keyword linux_user_configuration: This property is ignored if specified on a Windows pool. If
         not specified, the user is created with the default options.
        :paramtype linux_user_configuration: ~azure.mgmt.batch.models.LinuxUserConfiguration
        :keyword windows_user_configuration: This property can only be specified if the user is on a
         Windows pool. If not specified and on a Windows pool, the user is created with the default
         options.
        :paramtype windows_user_configuration: ~azure.mgmt.batch.models.WindowsUserConfiguration
        """
        super(UserAccount, self).__init__(**kwargs)
        self.name = name
        self.password = password
        self.elevation_level = elevation_level
        self.linux_user_configuration = linux_user_configuration
        self.windows_user_configuration = windows_user_configuration


class UserAssignedIdentities(msrest.serialization.Model):
    """The list of associated user identities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentities, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserIdentity(msrest.serialization.Model):
    """Specify either the userName or autoUser property, but not both.

    :ivar user_name: The userName and autoUser properties are mutually exclusive; you must specify
     one but not both.
    :vartype user_name: str
    :ivar auto_user: The userName and autoUser properties are mutually exclusive; you must specify
     one but not both.
    :vartype auto_user: ~azure.mgmt.batch.models.AutoUserSpecification
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'auto_user': {'key': 'autoUser', 'type': 'AutoUserSpecification'},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        auto_user: Optional["AutoUserSpecification"] = None,
        **kwargs
    ):
        """
        :keyword user_name: The userName and autoUser properties are mutually exclusive; you must
         specify one but not both.
        :paramtype user_name: str
        :keyword auto_user: The userName and autoUser properties are mutually exclusive; you must
         specify one but not both.
        :paramtype auto_user: ~azure.mgmt.batch.models.AutoUserSpecification
        """
        super(UserIdentity, self).__init__(**kwargs)
        self.user_name = user_name
        self.auto_user = auto_user


class VirtualMachineConfiguration(msrest.serialization.Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual Machines infrastructure.

    All required parameters must be populated in order to send to Azure.

    :ivar image_reference: Required. A reference to an Azure Virtual Machines Marketplace image or
     the Azure Image resource of a custom Virtual Machine. To get the list of all imageReferences
     verified by Azure Batch, see the 'List supported node agent SKUs' operation.
    :vartype image_reference: ~azure.mgmt.batch.models.ImageReference
    :ivar node_agent_sku_id: Required. The Batch node agent is a program that runs on each node in
     the pool, and provides the command-and-control interface between the node and the Batch
     service. There are different implementations of the node agent, known as SKUs, for different
     operating systems. You must specify a node agent SKU which matches the selected image
     reference. To get the list of supported node agent SKUs along with their list of verified image
     references, see the 'List supported node agent SKUs' operation.
    :vartype node_agent_sku_id: str
    :ivar windows_configuration: This property must not be specified if the imageReference
     specifies a Linux OS image.
    :vartype windows_configuration: ~azure.mgmt.batch.models.WindowsConfiguration
    :ivar data_disks: This property must be specified if the compute nodes in the pool need to have
     empty data disks attached to them.
    :vartype data_disks: list[~azure.mgmt.batch.models.DataDisk]
    :ivar license_type: This only applies to images that contain the Windows operating system, and
     should only be used when you hold valid on-premises licenses for the nodes which will be
     deployed. If omitted, no on-premises licensing discount is applied. Values are:
    
      Windows_Server - The on-premises license is for Windows Server.
      Windows_Client - The on-premises license is for Windows Client.
    :vartype license_type: str
    :ivar container_configuration: If specified, setup is performed on each node in the pool to
     allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must
     specify the containerSettings property, and all other tasks may specify it.
    :vartype container_configuration: ~azure.mgmt.batch.models.ContainerConfiguration
    :ivar disk_encryption_configuration: If specified, encryption is performed on each node in the
     pool during node provisioning.
    :vartype disk_encryption_configuration: ~azure.mgmt.batch.models.DiskEncryptionConfiguration
    :ivar node_placement_configuration: This configuration will specify rules on how nodes in the
     pool will be physically allocated.
    :vartype node_placement_configuration: ~azure.mgmt.batch.models.NodePlacementConfiguration
    :ivar extensions: If specified, the extensions mentioned in this configuration will be
     installed on each node.
    :vartype extensions: list[~azure.mgmt.batch.models.VMExtension]
    :ivar os_disk: Contains configuration for ephemeral OSDisk settings.
    :vartype os_disk: ~azure.mgmt.batch.models.OSDisk
    """

    _validation = {
        'image_reference': {'required': True},
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSkuId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'ContainerConfiguration'},
        'disk_encryption_configuration': {'key': 'diskEncryptionConfiguration', 'type': 'DiskEncryptionConfiguration'},
        'node_placement_configuration': {'key': 'nodePlacementConfiguration', 'type': 'NodePlacementConfiguration'},
        'extensions': {'key': 'extensions', 'type': '[VMExtension]'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
    }

    def __init__(
        self,
        *,
        image_reference: "ImageReference",
        node_agent_sku_id: str,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        data_disks: Optional[List["DataDisk"]] = None,
        license_type: Optional[str] = None,
        container_configuration: Optional["ContainerConfiguration"] = None,
        disk_encryption_configuration: Optional["DiskEncryptionConfiguration"] = None,
        node_placement_configuration: Optional["NodePlacementConfiguration"] = None,
        extensions: Optional[List["VMExtension"]] = None,
        os_disk: Optional["OSDisk"] = None,
        **kwargs
    ):
        """
        :keyword image_reference: Required. A reference to an Azure Virtual Machines Marketplace image
         or the Azure Image resource of a custom Virtual Machine. To get the list of all imageReferences
         verified by Azure Batch, see the 'List supported node agent SKUs' operation.
        :paramtype image_reference: ~azure.mgmt.batch.models.ImageReference
        :keyword node_agent_sku_id: Required. The Batch node agent is a program that runs on each node
         in the pool, and provides the command-and-control interface between the node and the Batch
         service. There are different implementations of the node agent, known as SKUs, for different
         operating systems. You must specify a node agent SKU which matches the selected image
         reference. To get the list of supported node agent SKUs along with their list of verified image
         references, see the 'List supported node agent SKUs' operation.
        :paramtype node_agent_sku_id: str
        :keyword windows_configuration: This property must not be specified if the imageReference
         specifies a Linux OS image.
        :paramtype windows_configuration: ~azure.mgmt.batch.models.WindowsConfiguration
        :keyword data_disks: This property must be specified if the compute nodes in the pool need to
         have empty data disks attached to them.
        :paramtype data_disks: list[~azure.mgmt.batch.models.DataDisk]
        :keyword license_type: This only applies to images that contain the Windows operating system,
         and should only be used when you hold valid on-premises licenses for the nodes which will be
         deployed. If omitted, no on-premises licensing discount is applied. Values are:
        
          Windows_Server - The on-premises license is for Windows Server.
          Windows_Client - The on-premises license is for Windows Client.
        :paramtype license_type: str
        :keyword container_configuration: If specified, setup is performed on each node in the pool to
         allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must
         specify the containerSettings property, and all other tasks may specify it.
        :paramtype container_configuration: ~azure.mgmt.batch.models.ContainerConfiguration
        :keyword disk_encryption_configuration: If specified, encryption is performed on each node in
         the pool during node provisioning.
        :paramtype disk_encryption_configuration: ~azure.mgmt.batch.models.DiskEncryptionConfiguration
        :keyword node_placement_configuration: This configuration will specify rules on how nodes in
         the pool will be physically allocated.
        :paramtype node_placement_configuration: ~azure.mgmt.batch.models.NodePlacementConfiguration
        :keyword extensions: If specified, the extensions mentioned in this configuration will be
         installed on each node.
        :paramtype extensions: list[~azure.mgmt.batch.models.VMExtension]
        :keyword os_disk: Contains configuration for ephemeral OSDisk settings.
        :paramtype os_disk: ~azure.mgmt.batch.models.OSDisk
        """
        super(VirtualMachineConfiguration, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.node_agent_sku_id = node_agent_sku_id
        self.windows_configuration = windows_configuration
        self.data_disks = data_disks
        self.license_type = license_type
        self.container_configuration = container_configuration
        self.disk_encryption_configuration = disk_encryption_configuration
        self.node_placement_configuration = node_placement_configuration
        self.extensions = extensions
        self.os_disk = os_disk


class VirtualMachineFamilyCoreQuota(msrest.serialization.Model):
    """A VM Family and its associated core quota for the Batch account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The Virtual Machine family name.
    :vartype name: str
    :ivar core_quota: The core quota for the VM family for the Batch account.
    :vartype core_quota: int
    """

    _validation = {
        'name': {'readonly': True},
        'core_quota': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'core_quota': {'key': 'coreQuota', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(VirtualMachineFamilyCoreQuota, self).__init__(**kwargs)
        self.name = None
        self.core_quota = None


class VMExtension(msrest.serialization.Model):
    """The configuration for virtual machine extensions.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the virtual machine extension.
    :vartype name: str
    :ivar publisher: Required. The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Required. The type of the extensions.
    :vartype type: str
    :ivar type_handler_version: The version of script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Any object.
    :vartype settings: any
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: any
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'object'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'object'},
        'provision_after_extensions': {'key': 'provisionAfterExtensions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        type: str,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        provision_after_extensions: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the virtual machine extension.
        :paramtype name: str
        :keyword publisher: Required. The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Required. The type of the extensions.
        :paramtype type: str
        :keyword type_handler_version: The version of script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Any object.
        :paramtype settings: any
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: any
        :keyword provision_after_extensions: Collection of extension names after which this extension
         needs to be provisioned.
        :paramtype provision_after_extensions: list[str]
        """
        super(VMExtension, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provision_after_extensions = provision_after_extensions


class WindowsConfiguration(msrest.serialization.Model):
    """Windows operating system settings to apply to the virtual machine.

    :ivar enable_automatic_updates: If omitted, the default value is true.
    :vartype enable_automatic_updates: bool
    """

    _attribute_map = {
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enable_automatic_updates: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enable_automatic_updates: If omitted, the default value is true.
        :paramtype enable_automatic_updates: bool
        """
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.enable_automatic_updates = enable_automatic_updates


class WindowsUserConfiguration(msrest.serialization.Model):
    """Properties used to create a user account on a Windows node.

    :ivar login_mode: Specifies login mode for the user. The default value for
     VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools
     is batch mode. Possible values include: "Batch", "Interactive".
    :vartype login_mode: str or ~azure.mgmt.batch.models.LoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        login_mode: Optional[Union[str, "LoginMode"]] = None,
        **kwargs
    ):
        """
        :keyword login_mode: Specifies login mode for the user. The default value for
         VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools
         is batch mode. Possible values include: "Batch", "Interactive".
        :paramtype login_mode: str or ~azure.mgmt.batch.models.LoginMode
        """
        super(WindowsUserConfiguration, self).__init__(**kwargs)
        self.login_mode = login_mode
