# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class ActiveDirectoryObject(msrest.serialization.Model):
    """The Active Directory Object that will be used for authenticating the token of a container registry.

    :param object_id: The user/group/application object ID for Active Directory Object that will be
     used for authenticating the token of a container registry.
    :type object_id: str
    :param tenant_id: The tenant ID of user/group/application object Active Directory Object that
     will be used for authenticating the token of a container registry.
    :type tenant_id: str
    """

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActiveDirectoryObject, self).__init__(**kwargs)
        self.object_id = kwargs.get('object_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class GenerateCredentialsParameters(msrest.serialization.Model):
    """The parameters used to generate credentials for a specified token or user of a container registry.

    :param token_id: The resource ID of the token for which credentials have to be generated.
    :type token_id: str
    :param expiry: The expiry date of the generated credentials after which the credentials become
     invalid.
    :type expiry: ~datetime.datetime
    :param name: Specifies name of the password which should be regenerated if any -- password1 or
     password2. Possible values include: "password1", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPasswordName
    """

    _attribute_map = {
        'token_id': {'key': 'tokenId', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GenerateCredentialsParameters, self).__init__(**kwargs)
        self.token_id = kwargs.get('token_id', None)
        self.expiry = kwargs.get('expiry', None)
        self.name = kwargs.get('name', None)


class GenerateCredentialsResult(msrest.serialization.Model):
    """The response from the GenerateCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords: list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[TokenPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GenerateCredentialsResult, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.passwords = kwargs.get('passwords', None)


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ScopeMap(ProxyResource):
    """An object that represents a scope map for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SystemData
    :param description: The user friendly description of the scope map.
    :type description: str
    :ivar type_properties_type: The type of the scope map. E.g. BuildIn scope map.
    :vartype type_properties_type: str
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    :param actions: The list of scoped permissions for registry artifacts.
     E.g. repositories/repository-name/content/read,
     repositories/repository-name/metadata/write.
    :type actions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeMap, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.type_properties_type = None
        self.creation_date = None
        self.provisioning_state = None
        self.actions = kwargs.get('actions', None)


class ScopeMapListResult(msrest.serialization.Model):
    """The result of a request to list scope maps for a container registry.

    :param value: The list of scope maps. Since this list may be incomplete, the nextLink field
     should be used to request the next list of scope maps.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.ScopeMap]
    :param next_link: The URI that can be used to request the next list of scope maps.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScopeMap]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeMapListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ScopeMapUpdateParameters(msrest.serialization.Model):
    """The properties for updating the scope map.

    :param description: The user friendly description of the scope map.
    :type description: str
    :param actions: The list of scope permissions for registry artifacts.
     E.g. repositories/repository-name/pull,
     repositories/repository-name/delete.
    :type actions: list[str]
    """

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeMapUpdateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.actions = kwargs.get('actions', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.LastModifiedByType
    :param last_modified_at: The timestamp of resource modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Token(ProxyResource):
    """An object that represents a token for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2019_05_01_preview.models.SystemData
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ProvisioningState
    :param scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :type scope_map_id: str
    :param credentials: The credentials that can be used for authenticating the token.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCredentialsProperties
    :param status: The status of the token example enabled or disabled. Possible values include:
     "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'scope_map_id': {'key': 'properties.scopeMapId', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'TokenCredentialsProperties'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Token, self).__init__(**kwargs)
        self.creation_date = None
        self.provisioning_state = None
        self.scope_map_id = kwargs.get('scope_map_id', None)
        self.credentials = kwargs.get('credentials', None)
        self.status = kwargs.get('status', None)


class TokenCertificate(msrest.serialization.Model):
    """The properties of a certificate used for authenticating a token.

    :param name:  Possible values include: "certificate1", "certificate2".
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCertificateName
    :param expiry: The expiry datetime of the certificate.
    :type expiry: ~datetime.datetime
    :param thumbprint: The thumbprint of the certificate.
    :type thumbprint: str
    :param encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format
     that will be used for authenticating the token.
    :type encoded_pem_certificate: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'encoded_pem_certificate': {'key': 'encodedPemCertificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenCertificate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.expiry = kwargs.get('expiry', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.encoded_pem_certificate = kwargs.get('encoded_pem_certificate', None)


class TokenCredentialsProperties(msrest.serialization.Model):
    """The properties of the credentials that can be used for authenticating the token.

    :param active_directory_object: The Active Directory Object that will be used for
     authenticating the token of a container registry.
    :type active_directory_object:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.ActiveDirectoryObject
    :param certificates:
    :type certificates:
     list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCertificate]
    :param passwords:
    :type passwords: list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPassword]
    """

    _attribute_map = {
        'active_directory_object': {'key': 'activeDirectoryObject', 'type': 'ActiveDirectoryObject'},
        'certificates': {'key': 'certificates', 'type': '[TokenCertificate]'},
        'passwords': {'key': 'passwords', 'type': '[TokenPassword]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenCredentialsProperties, self).__init__(**kwargs)
        self.active_directory_object = kwargs.get('active_directory_object', None)
        self.certificates = kwargs.get('certificates', None)
        self.passwords = kwargs.get('passwords', None)


class TokenListResult(msrest.serialization.Model):
    """The result of a request to list tokens for a container registry.

    :param value: The list of tokens. Since this list may be incomplete, the nextLink field should
     be used to request the next list of tokens.
    :type value: list[~azure.mgmt.containerregistry.v2019_05_01_preview.models.Token]
    :param next_link: The URI that can be used to request the next list of tokens.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Token]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TokenPassword(msrest.serialization.Model):
    """The password that will be used for authenticating the token of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param creation_time: The creation datetime of the password.
    :type creation_time: ~datetime.datetime
    :param expiry: The expiry datetime of the password.
    :type expiry: ~datetime.datetime
    :param name: The password name "password1" or "password2". Possible values include:
     "password1", "password2".
    :type name: str or ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenPasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenPassword, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.expiry = kwargs.get('expiry', None)
        self.name = kwargs.get('name', None)
        self.value = None


class TokenUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a token.

    :param scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :type scope_map_id: str
    :param status: The status of the token example enabled or disabled. Possible values include:
     "enabled", "disabled".
    :type status: str or ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenStatus
    :param credentials: The credentials that can be used for authenticating the token.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCredentialsProperties
    """

    _attribute_map = {
        'scope_map_id': {'key': 'properties.scopeMapId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'TokenCredentialsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenUpdateParameters, self).__init__(**kwargs)
        self.scope_map_id = kwargs.get('scope_map_id', None)
        self.status = kwargs.get('status', None)
        self.credentials = kwargs.get('credentials', None)
