# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EmailReceiver(Model):
    """An email receiver.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The name of the email receiver. Names must be unique across
     all receivers within an action group.
    :type name: str
    :param email_address: The email address of this receiver.
    :type email_address: str
    :ivar status: The receiver status of the e-mail. Possible values include:
     'NotSpecified', 'Enabled', 'Disabled'
    :vartype status: str or :class:`ReceiverStatus
     <azure.mgmt.monitor.models.ReceiverStatus>`
    """

    _validation = {
        'name': {'required': True},
        'email_address': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'email_address': {'key': 'emailAddress', 'type': 'str'},
        'status': {'key': 'status', 'type': 'ReceiverStatus'},
    }

    def __init__(self, name, email_address):
        self.name = name
        self.email_address = email_address
        self.status = None
