//
//  PRPreviewController.m
//  PRICE
//
//  Created by Riccardo Mottola on 2/19/10.
//  Copyright 2010 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.


#import "PRPreviewController.h"


@implementation PRPreviewController

- (id)init
{
  if ((self = [super init]))
  {
    [NSBundle loadNibNamed:@"Preview" owner:self];
  }
  return self;
}

- (void)setFilterController: (PRFilterController *)controller
{
  filterController = controller;
}

- (void)showPreview
{
  [previewWindow orderFront: self];
}

- (void)hidePreview
{
  [previewWindow orderOut: self];
}

/** returns wether continuous update of the preview is desired or not */
- (BOOL)continuous
{
    if ([buttContinuous state] == NSOnState)
        return YES;
    return NO;
}

- (void)setContinuous :(BOOL)flag
{
    if (flag == YES)
        [buttContinuous setState: NSOnState];
    else
        [buttContinuous setState: NSOffState];
}


- (IBAction)cleanPreview:(id)sender
{
    [view setImage:nil];
}

- (IBAction)updatePreview:(id)sender
{
  PRImage *img;
  
  img = [filterController filteredImage];
  [view setImage:img];
  [view scaleFrameBy:1.0];
}

/* ---- FilterProgress protocol methods */

- (void)setTitle:(NSString *)title
{
}

- (void)setProgress:(double)progress
{
    [progressBar setDoubleValue:progress];    
    [previewWindow displayIfNeeded];
    [previewWindow flushWindowIfNeeded];
}

- (void)setActivity:(NSString *)title
{
    [activityDescription setStringValue:title];
    [previewWindow displayIfNeeded];
}


@end
