=========
 PRADS
=========

---------------------------------------------
Passive Real-time Asset Detection System
---------------------------------------------

:Author: Edward Bjarte Fjellskål <edwardfjellskaal@gmail.com>
:Author: Kacper Wysocki <comotion@users.sf.net>
:Date:   2010-06-17
:Copyright: GPL
:Version: 0.2
:Manual section: 1
:Manual group: networking

SYNOPSIS
========

  prads -i eth1 -v

DESCRIPTION
===========

PRADS is a Passive Real-time Asset Detection System.

PRADS employs digital fingerprints to recognize services on the wire, 
and can be used to map your network and monitor for changes in real time.

Real-time passive traffic analysis will also let you detect assets that 
are just connected to the network for a short period of time, since PRADS
can glean useful information from every packet.

PRADS aims to be the one-stop-shop for passive asset detection, and currently
does MAC lookups, TCP and UDP OS fingerprinting as well as client and service
application matching and a connection state table. Various output plugins
include logfile and FIFO and make PRADS a useful replacement for p0f, pads and sancp.

PRADS was built from the ground up for a small footprint and modern networks with IPv6 and gigabits of throughput.

OPTIONS
=======

 -i <iface>      Network device <iface> (default: eth0).
 -r <file>       Read pcap <file>.
 -c <file>       Read config from <file>.
 -b <filter>     Apply Berkeley packet filter <filter>.
 -u <user>       Run as user <user>   (Default: uid 1).
 -g <group>      Run as group <group> (Default: gid 1).
 -d              Do not drop privileges.
 -a <nets>       Specify home nets (eg: '192.168.0.0/25,10.0.0.0/255.0.0.0').
 -D              Daemonize.
 -p <pidfile>    Name of pidfile - inside chroot.
 -l <file>       Log assets to <file> (default: '%s')\n", config.assetlog.
 -f <FIFO>       Log assets to <FIFO>.
 -B              Log connections to ringbuffer.
 -C <dir>        Chroot into <dir> before dropping privs.
 -XFRMSAK        Flag picker: X - clear flags, F:FIN, R:RST, M:MAC, S:SYN, A:ACK, K:SYNACK
 -UTtI           Service checks: U:UDP, T:TCP-server, I:ICMP, t:TCP-cLient
 -P              DHCP fingerprinting.
 -s <snaplen>    Dump <snaplen> bytes of each payload.
 -v              Verbose output - repeat for more verbosity.
 -q              Quiet - try harder not to produce output.
 -L <dir>        log cxtracker type output to <dir> (will be owned by <uid>).
 -O              Connection tracking [O]utput - per-packet!
 -x              Conne[x]ion tracking output  - New, expired and ended.
 -Z              Passive DNS (Experimental).
 -H              DHCP fingerprinting (Expermiental).
 -h              This help message.

PROBLEMS
========

1. Doesn't detect everything out there :-P
2. This man page.

SEE ALSO
========

* PRADS <http://prads.projects.linpro.no/>
* p0f <http://lcamtuf.coredump.cx/p0f.shtml>
* PADS <http://passive.sourceforge.net/>

BUGS
====

Report bugs here:

- http://github.com/gamelinux/prads/issues 

For general questions:

- http://projects.linpro.no/mailman/listinfo/prads-devel 
- http://projects.linpro.no/mailman/listinfo/prads-users

