//
// Prepare.h
//
// $Id: //poco/1.3/Data/include/Poco/Data/Prepare.h#2 $
//
// Library: Data
// Package: DataCore
// Module:  Prepare
//
// Definition of the Prepare class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_Prepare_INCLUDED
#define Data_Prepare_INCLUDED


#include "Poco/Data/Data.h"
#include "Poco/Data/AbstractPrepare.h"
#include "Poco/Data/TypeHandler.h"
#include <cstddef>
#include <map>
#include <set>
#include <vector>


namespace Poco {
namespace Data {


class BLOB;


template<typename T>
class Prepare: public AbstractPrepare
	/// Class for calling the appropriate AbstractPreparation method.
{
public:
	Prepare(AbstractPreparation* pPrepare, std::size_t pos, const T& val): AbstractPrepare(pPrepare), _pos(pos), _val(val)
		/// Creates the Prepare.
	{
	}

	~Prepare()
		/// Destroys the Prepare.
	{
	}

	void prepare()
		/// Prepares data.
	{
		TypeHandler<T>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	const T&    _val;
};


template<typename T>
class Prepare<std::vector<T> >: public AbstractPrepare
	/// Class for calling the appropriate AbstractPreparation method.
{
public:
	Prepare(AbstractPreparation* pPrepare, std::size_t pos, const T& val): AbstractPrepare(pPrepare), _pos(pos), _val(val)
		/// Creates the Prepare.
	{
	}

	~Prepare()
		/// Destroys the Prepare.
	{
	}

	void prepare()
		/// Prepares data.
	{
		TypeHandler<T>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	const T&    _val;
};


template<typename T>
class Prepare<std::set<T> >: public AbstractPrepare
	/// Class for calling the appropriate AbstractPreparation method.
{
public:
	Prepare(AbstractPreparation* pPrepare, std::size_t pos, const T& val): AbstractPrepare(pPrepare), _pos(pos), _val(val)
		/// Creates the Prepare.
	{
	}

	~Prepare()
		/// Destroys the Prepare.
	{
	}

	void prepare()
		/// Prepares data.
	{
		TypeHandler<T>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	const T&    _val;
};


template<typename T>
class Prepare<std::multiset<T> >: public AbstractPrepare
	/// Class for calling the appropriate AbstractPreparation method.
{
public:
	Prepare(AbstractPreparation* pPrepare, std::size_t pos, const T& val): AbstractPrepare(pPrepare), _pos(pos), _val(val)
		/// Creates the Prepare.
	{
	}

	~Prepare()
		/// Destroys the Prepare.
	{
	}

	void prepare()
		/// Prepares data.
	{
		TypeHandler<T>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	const T&    _val;
};


template<typename K, typename V>
class Prepare<std::map<K, V> >: public AbstractPrepare
	/// Class for calling the appropriate AbstractPreparation method.
{
public:
	Prepare(AbstractPreparation* pPrepare, std::size_t pos, const V& val): AbstractPrepare(pPrepare), _pos(pos), _val(val)
		/// Creates the Prepare.
	{
	}

	~Prepare()
		/// Destroys the Prepare.
	{
	}

	void prepare()
		/// Prepares data.
	{
		TypeHandler<V>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	const V&    _val;
};


template<typename K, typename V>
class Prepare<std::multimap<K, V> >: public AbstractPrepare
	/// Class for calling the appropriate AbstractPreparation method.
{
public:
	Prepare(AbstractPreparation* pPrepare, std::size_t pos, const V& val): AbstractPrepare(pPrepare), _pos(pos), _val(val)
		/// Creates the Prepare.
	{
	}

	~Prepare()
		/// Destroys the Prepare.
	{
	}

	void prepare()
		/// Prepares data.
	{
		TypeHandler<V>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	const V&    _val;
};


} } // namespace Poco::Data


#endif // Data_Prepare_INCLUDED
