
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <png.h>
#include "tws.h"

struct moon_s
{
   png_bytep bitmap;
   int	     width;
   int	     height;
   int       xbytes;
};

typedef struct moon_s moon_t;
   
struct image_s
{
   png_bytep bitmap;
   png_bytep *rowps;
   int       width;
   int       height;
   int       xbytes;
};

typedef struct image_s image_t;

struct star_s
{
   int width;
   int height;
   unsigned char data[5];
};

void fail(const char * s, ...);

double phase( double pdate, double *pphase, double *mage, double *dist,
	      double *angdia, double *sudist, double *suangdia );
double jtime( struct tws* t );
struct tws *dtwstime();

image_t *imagecreate( int width, int height );
void imagedestroy( image_t *image );

moon_t *mooncreate();
void moondestroy( moon_t *moon );
void mooncopy( image_t *image, moon_t *moondata, int x, int y, int blackflag );

void pngwrite( image_t *image, char* filename );

