
# Mbed: framework for [PlatformIO](https://platformio.org)

The mbed framework The mbed SDK has been designed to provide enough hardware abstraction to be intuitive and concise, yet powerful enough to build complex projects. It is built on the low-level ARM CMSIS APIs, allowing you to code down to the metal if needed. In addition to RTOS, USB and Networking libraries, a cookbook of hundreds of reusable peripheral and module libraries have been built on top of the SDK by the mbed Developer Community.

* [Home](https://platformio.org/frameworks/mbed) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/mbed.html)

# Examples

- [Atmel SAM](https://github.com/platformio/platform-atmelsam)
  * [arduino-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-blink)
  * [arduino-briki-internal-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-briki-internal-libs)
  * [arduino-external-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-internal-libs)
  * [arduino-web-thing-led](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-web-thing-led)
  * [mbed-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-serial)
  * [simba-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/simba-blink)
  * [zephyr-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-blink)
  * [zephyr-drivers-i2c-scanner](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-drivers-i2c-scanner)
  * [zephyr-subsys-logger](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-subsys-logger)

- [Freescale Kinetis](https://github.com/platformio/platform-freescalekinetis)
  * [mbed-blink](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-events)
  * [mbed-rtos](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos)
  * [mbed-rtos-ethernet](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-ethernet)
  * [mbed-rtos-tls-client](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-tls-client)
  * [mbed-serial](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-serial)
  * [zephyr-blink](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/zephyr-blink)
  * [zephyr-net-telnet](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/zephyr-net-telnet)
  * [zephyr-sensor-sx9500](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/zephyr-sensor-sx9500)

- [Maxim 32](https://github.com/platformio/platform-maxim32)
  * [mbed-blink](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-events)
  * [mbed-rtos](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-rtos)
  * [mbed-serial](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-serial)

- [Nordic nRF51](https://github.com/platformio/platform-nordicnrf51)
  * [arduino-ble-led](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/arduino-ble-led)
  * [arduino-blink](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/arduino-blink)
  * [arduino-internal-libs](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/arduino-internal-libs)
  * [mbed-ble-thermometer](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-ble-thermometer)
  * [mbed-blink](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-blink)
  * [mbed-events](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/mbed-serial)
  * [zephyr-ble-eddystone](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/zephyr-ble-eddystone)
  * [zephyr-blink](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/zephyr-blink)
  * [zephyr-drivers-entropy](https://github.com/platformio/platform-nordicnrf51/tree/master/examples/zephyr-drivers-entropy)

- [Nordic nRF52](https://github.com/platformio/platform-nordicnrf52)
  * [arduino-ble-led](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-ble-led)
  * [arduino-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-blink)
  * [arduino-bluefruit-bleuart](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-bluefruit-bleuart)
  * [arduino-nina-b1-generic-example](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-nina-b1-generic-example)
  * [arduino-serial-plotter](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-serial-plotter)
  * [mbed-ble-thermometer](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-ble-thermometer)
  * [mbed-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-events)
  * [mbed-nfc](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-nfc)
  * [mbed-rtos](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-rtos)
  * [mbed-serial](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-serial)
  * [zephyr-ble-beacon](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-ble-beacon)
  * [zephyr-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-blink)
  * [zephyr-net-echo-client](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-net-echo-client)
  * [zephyr-subsys-nvs](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-subsys-nvs)

- [NXP i.MX RT](https://github.com/platformio/platform-nxpimxrt)
  * [mbed-blink](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/mbed-blink)
  * [mbed-rtos-ethernet](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/mbed-rtos-ethernet)
  * [zephyr-blink](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/zephyr-blink)
  * [zephyr-synchronization](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/zephyr-synchronization)

- [NXP LPC](https://github.com/platformio/platform-nxplpc)
  * [mbed-blink](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-blink)
  * [mbed-custom-target](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-custom-target)
  * [mbed-dsp](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-events)
  * [mbed-rtos](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos)
  * [mbed-rtos-ethernet](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos-ethernet)
  * [mbed-serial](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-serial)
  * [zephyr-blink](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-blink)
  * [zephyr-drivers-watchdog](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-drivers-watchdog)
  * [zephyr-synchronization](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-synchronization)

- [RISC-V GAP](https://github.com/pioplus/platform-riscv_gap)
  * [gapuino-mbed-autotiler-cifar10](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-autotiler-cifar10)
  * [gapuino-mbed-driver-cpp-raw-serial](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-cpp-raw-serial)
  * [gapuino-mbed-driver-hyper-flash](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-hyper-flash)
  * [gapuino-mbed-driver-hyper-rtc-alarm](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-hyper-rtc-alarm)
  * [gapuino-mbed-events-queue](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-events-queue)
  * [gapuino-mbed-features-cluster-dma](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-features-cluster-dma)
  * [gapuino-mbed-features-filesystem](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-features-filesystem)
  * [gapuino-mbed-fft2d](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-fft2d)
  * [gapuino-mbed-matadd](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-matadd)
  * [gapuino-mbed-os-irq](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-os-irq)
  * [gapuino-mbed-os-memory-pool](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-mbed-os-memory-pool)
  * [gapuino-pulp-os-autotiler-bilinear-resize](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-autotiler-bilinear-resize)
  * [gapuino-pulp-os-autotiler-cifar10](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-autotiler-cifar10)
  * [gapuino-pulp-os-filesystem](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-filesystem)
  * [gapuino-pulp-os-hello-world](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-hello-world)
  * [gapuino-pulp-os-i2c-eeprom](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-i2c-eeprom)
  * [gapuino-pulp-os-kernel-dma](https://github.com/pioplus/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-kernel-dma)

- [Silicon Labs EFM32](https://github.com/platformio/platform-siliconlabsefm32)
  * [mbed-blink](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-serial)
  * [zephyr-blink](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/zephyr-blink)
  * [zephyr-sensor-vl53l0x](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/zephyr-sensor-vl53l0x)
  * [zephyr-subsys-console-getline](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/zephyr-subsys-console-getline)

- [ST STM32](https://github.com/platformio/platform-ststm32)
  * [arduino-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-internal-libs)
  * [arduino-mxchip-azureiot](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-azureiot)
  * [arduino-mxchip-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-filesystem)
  * [arduino-mxchip-sensors](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-sensors)
  * [arduino-mxchip-wifiscan](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-wifiscan)
  * [cmsis-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/cmsis-blink)
  * [libopencm3-1bitsy](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-1bitsy)
  * [libopencm3-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-blink)
  * [mbed-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-blink)
  * [mbed-custom-target](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-custom-target)
  * [mbed-dsp](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-events)
  * [mbed-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-filesystem)
  * [mbed-rtos](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos)
  * [mbed-rtos-ethernet](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet)
  * [mbed-rtos-ethernet-tls](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet-tls)
  * [mbed-rtos-mesh-minimal](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-mesh-minimal)
  * [mbed-rtos-semaphore](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-semaphore)
  * [mbed-serial](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-serial)
  * [spl-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/spl-blink)
  * [stm32cube-hal-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-blink)
  * [stm32cube-ll-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-ll-blink)
  * [zephyr-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-blink)
  * [zephyr-cpp-synchronization](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-cpp-synchronization)
  * [zephyr-drivers-can](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-drivers-can)
  * [zephyr-net-https-client](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-net-https-client)
  * [zephyr-subsys-usb-hid-mouse](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-subsys-usb-hid-mouse)

- [Teensy](https://github.com/platformio/platform-teensy)
  * [arduino-blink](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-blink)
  * [arduino-hid-usb-mouse](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-hid-usb-mouse)
  * [arduino-internal-libs](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-internal-libs)
  * [mbed-blink](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-serial)

- [WIZNet W7500](https://github.com/platformio/platform-wiznet7500)
  * [mbed-blink](https://github.com/platformio/platform-wiznet7500/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-wiznet7500/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-wiznet7500/tree/master/examples/mbed-events)
  * [mbed-rtos](https://github.com/platformio/platform-wiznet7500/tree/master/examples/mbed-rtos)
  * [mbed-serial](https://github.com/platformio/platform-wiznet7500/tree/master/examples/mbed-serial)

