/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "messages.h"

Resultat messages_message(TRAVAIL(General) general , TRAVAIL_SCALAIRE(DescripteurFichier) sortie , TRAVAIL_SCALAIRE(Message) message , TRAVAIL(MessageParametres) messageparametres)
{
	/* Ralise un affichage sur la sortie de message indique
	 * dans la structure general. Cette structure contient
	 * galement la localisation en vigueur.
	 */
	STOCKAGE(General) temporaire;
	TRAVAIL_SCALAIRE(Langue) langue;
	TRAVAIL_SCALAIRE(Charset) charset;
	DEBUTZONESECURISEE
	SECURISE(environnement_lecture_langue(CHAMP_TRAVAIL(general , environnement),R_T_(langue)));
	SECURISE(environnement_lecture_charset(CHAMP_TRAVAIL(general , environnement),R_T_(charset)));
	switch(langue)
	{
		case T_S_(LANGUE_FR):
			switch(charset)
			{
				case T_S_(CHARSET_ISO):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Erreur   ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Attention");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            dans le fichier %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            inclus depuis le fichier %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Mmoire insuffisante pour la poursuite de la compilation");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Option -%c non reconnue. Utilisez l'option -h pour obtenir la liste des options disponibles",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Commande %s mal place",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Commande de texte mal place");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Commande #%c mal place",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Commande #%s mal place",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Commande #%d mal place",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Option %s dfinie  l'intrieur de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Redfinition de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Appel de la macro %s non dfinie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Appel rcursif de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Appel de la macro %s avec %d paramtre(s) au lieu des %d attendu(s)",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Erreur de syntaxe prs du symbole %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Inclusion rcursive du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Fichier de sortie dj spcifi");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en criture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Impossible d'xcuter PlanFacile dans le rpertoire courant");
							break;
						case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
							fprintf(sortie,"Le chemin menant au fichier %s est invalide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
							fprintf(sortie,"Le fichier %s est inexistant",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
							fprintf(sortie,"Le fichier %s est un rpertoire ou de type bloc",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en lecture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Impossible d'ouvrir le fichier de nom vide en lecture");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Tentative d'ouverture du fichier %s pour #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"Aucun fichier n'a pu tre ouvert pour #standard");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Redfinition du style pour les sections de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Redfinition du style par dfaut pour les sections");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Redfinition du style pour les rfrences de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Redfinition du style par dfaut des rfrences");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Redfinition du style de message");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Redfinition de l'entte de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Redfinition du pied de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Redfinition du niveau racine");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de section");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de rfrence");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du niveau racine");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Impossible de dterminer le niveau racine");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"Redfinition de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
							fprintf(sortie,"Ide de rfrence vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
							fprintf(sortie,"Ide manquante de rfrence vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
							fprintf(sortie,"Ide gnrique de rfrence vide incorrecte");
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Pertinence de la dpendance depuis l'ide %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Indice d'ide manquante incorrect");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Redfinition de l'ide manquante par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Redfinition de l'ide manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Rfrence parente d'ide gnrique incorrecte");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Redfinition de l'ide gnrique par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Redfinition de l'ide gnrique de rfrence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"Dpendance depuis l'ide %s non utilise pour le calcul du plan",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
							fprintf(sortie,"Dpendance depuis l'ide de rfrence vide non utilise pour le calcul du plan");
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Impossible de dterminer l'ide racine");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Ajout d'une ide racine au document");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Ide %s non atteignable depuis la racine du document",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
							fprintf(sortie,"Format de section non dfini pour l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
							fprintf(sortie,"Format de rfrence non dfini pour la rfrence %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
							fprintf(sortie,"Ide manquante d'indice %d non dfinie",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
							fprintf(sortie,"Ide gnrique de rfrence parente %s non dfinie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
							fprintf(sortie,"Dpendance depuis l'ide %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE):
							fprintf(sortie,"Dpendance depuis l'ide de rfrence vide incorrecte");
							break;
						case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
							fprintf(sortie,"Indice de rfrence %s incorrect",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
							fprintf(sortie,"Nom de section de niveau %s indfini",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document gnr par PlanFacile 2.0 : %d ide(s) traite(s), dont %d manquante(s) et %d gnrique(s), ainsi que %d rfrence(s) traite(s) dont %d irrductible(s).",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Verbeux %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE):
							fprintf(sortie,"Analyse du code source");
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
							fprintf(sortie,"Analyse du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
							fprintf(sortie,"Inclusion du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
							fprintf(sortie,"Fin de l'analyse du fichier inclus");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES):
							fprintf(sortie,"Retouches sur le flux");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
							fprintf(sortie,"Paramtre d'indice %d trouv",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
							fprintf(sortie,"Macro normale %s dfinie avec %d paramtres",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
							fprintf(sortie,"Macro boucle %s dfinie avec %d paramtres obligatoires",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
							fprintf(sortie,"Dfragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
							fprintf(sortie,"Suppression de la commande d'inclusion du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
							fprintf(sortie,"Suppression de la commande d'inclusion standard");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS):
							fprintf(sortie,"Rduction des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
							fprintf(sortie,"Recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
							fprintf(sortie,"Enregistrement de l'option %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
							fprintf(sortie,"Abandon de l'option %s place dans un commentaire",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
							fprintf(sortie,"Abandon de l'option %s place dans la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
							fprintf(sortie,"Premire recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
							fprintf(sortie,"Nouvelle recherche d'option requise");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
							fprintf(sortie,"Toutes les options ont t trouves");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
							fprintf(sortie,"Rduction des commandes de slection de code");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
							fprintf(sortie,"Rduction de la commande de label %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS):
							fprintf(sortie,"Rduction des macros");
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
							fprintf(sortie,"Macro normale %s trouve",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
							fprintf(sortie,"Macro boucle %s trouve",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
							fprintf(sortie,"Remplacement du paramtre %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
							fprintf(sortie,"Itration numro %d de la macro %s",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION):
							fprintf(sortie,"Vrification smantique");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
							fprintf(sortie,"Erreur utilisateur trouve");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
							fprintf(sortie,"Avertissement utilisateur trouv");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
							fprintf(sortie,"Dfragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES):
							fprintf(sortie,"Enregistrement des styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
							fprintf(sortie,"Enregistrement des styles de section");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
							fprintf(sortie,"Enregistrement du style de section par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de section de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
							fprintf(sortie,"Enregistrement des autres styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
							fprintf(sortie,"Enregistrement du style de rfrence par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de rfrence de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
							fprintf(sortie,"Enregistrement du style de message");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
							fprintf(sortie,"Enregistrement du style d'entte de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
							fprintf(sortie,"Enregistrement du style de pied de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
							fprintf(sortie,"Slection du niveau %d pour le niveau de la racine",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES):
							fprintf(sortie,"Enregistrement des ides");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
							fprintf(sortie,"Enregistrement des ides prsentes");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
							fprintf(sortie,"Enregistrement de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
							fprintf(sortie,"Enregistrement de la dpendance depuis l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
							fprintf(sortie,"Enregistrement des ides automatiques");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'ide manquante par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'ide manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'ide gnrique par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'ide gnrique de rfrence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
							fprintf(sortie,"Gnration du graphe de dpendances");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
							fprintf(sortie,"Sans ides, pas de calcul de plan possible");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
							fprintf(sortie,"Graphe contenant %d ide(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
							fprintf(sortie,"Graphe contenant %d dpendance(s) dont %d inutile(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
							fprintf(sortie,"Recherche de l'ide racine");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
							fprintf(sortie,"Vrification de la topologie du graphe");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
							fprintf(sortie,"Transformation et compltion du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
							fprintf(sortie,"Transformation de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
							fprintf(sortie,"Transformation d'une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
							fprintf(sortie,"Compltion de la rfrence depuis l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
							fprintf(sortie,"Compltion de la rfrence depuis l'ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE):
							fprintf(sortie,"Gnration du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
							fprintf(sortie,"Gnration du texte du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
							fprintf(sortie,"Gnration de l'entte du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
							fprintf(sortie,"Gnration de l'ide de rfrence %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
							fprintf(sortie,"Gnration d'une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
							fprintf(sortie,"Gnration d'une rfrence irrductible vers l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
							fprintf(sortie,"Gnration d'une rfrence irrductible vers une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
							fprintf(sortie,"Gnration d'une rfrence provenant d'une dpendance");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
							fprintf(sortie,"Gnration d'une rfrence rductible vers l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
							fprintf(sortie,"Gnration d'une rfrence rductible vers une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
							fprintf(sortie,"Gnration d'une rfrence extrieure d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
							fprintf(sortie,"Gnration d'une liste de rfrences extrieures");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
							fprintf(sortie,"Gnration du pied du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
							fprintf(sortie,"Production du document sur la sortie");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
							fprintf(sortie,"Production du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
							fprintf(sortie,"Production des statistiques internes du plan");
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage : planfacile <options> <fichiers sources>\n\n\nOptions :\n\n\tGnral :\n\n-h\t\tAffiche cette aide.\n-V\t\tAffiche la license et le droit de copie.\n-v\t\tMode verbeux. (A placer plusieurs fois, si ncessaire).\n-o <fichier>\tFichier de sortie. Si cette option\n\t\tn'est pas indique, la sortie standard est utilise.\n-a\t\tEquivalent  -SICYmgAdDpEcylGNTMUPRt.\n-n\t\tEquivalent  -uir.\n-e\t\tTransforme tous les avertissements en erreur.\n-W\t\tDsactive l'affichage des positions dans le source\n\t\tdes avertissements et des erreurs. (Plus rapide et moins\n\t\tgourmand en mmoire)\n-w\t\tAffiche les chemins absolus des fichiers sources dans les\n\t\tmessages du compilateur. (Gourmand en mmoire)\n\n\tFichiers sources :\n\n-S\t\tIgnore les fichiers sources non ouvrables en lecture.\n-I\t\tIgnore les inclusions rcursives de fichiers.\n-s\t\tAffiche le comportement de #standard, et termine sur\n\t\tune erreur en cas d'chec.\n\n\tCompilation :\n\n-O <option>\tDfinit une option de compilation.\n-u\t\tDsactive l'affichage des avertissements utilisateurs.\n-C\t\tIgnore les commandes mal places dans les fichiers\n\t\tsources.\n\n\tIdes :\n\n-i\t\tDsactive l'affichage des redfinitions d'ides.\n-Y\t\tIgnore les ides dont la rfrence est vide.\n-m\t\tIgnore les ides manquantes dont l'indice est incorrect.\n-g\t\tIgnore les ides gnriques dont la rfrence  l'ide\n\t\tparente est incorrecte.\n-r\t\tDsactive l'affichage de l'ajout ventuel d'une ide\n\t\tracine.\n-A\t\tIgnore les ides automatiques non rsolues.\n\n\tDpendances et rfrences :\n\n-d\t\tIgnore les dpendances dont la source est incorrecte.\n-D\t\tIndique les dpendances non utilises pour le calcul du plan.\n-p\t\tIgnore les dpendances dont la pertinence est incorrecte.\n-E\t\tIgnore les rfrences extrieures dont l'indice est incorrect.\n\n\tStyles :\n\n-c\t\tTransmet les commentaires du source dans le document.\n-y\t\tAffiche toute redfinition de style.\n-l\t\tIgnore toute dfinition de style dont l'indice est incorrect.\n-G\t\tIgnore les ides dont le style de section n'est pas dfini.\n-N\t\tIgnore les rfrences dont le style n'est pas dfini.\n-T\t\tIgnore les noms de sections dans les rfrences, lorsqu'ils ne\n\t\tsont pas dfinis.\n\n\tMacros :\n\n-M\t\tAffiche toute redfinition de macro.\n-U\t\tIgnore les appels de macros dont le nom n'est pas dfini.\n-P\t\tAjuste le nombre de paramtres des macros lors des appels,\n\t\tconformment  leur dfinition.\n-R\t\tIgnore les appels rcursifs de macro.\n-t\t\tIgnore les commandes de dfinition d'option dans les macros.\n\n\tRemarque :\n\n\t\tToutes les options, hormis -o, -O et -v, fonctionnent\n\t\tcomme des bascules : placer deux fois une option ne change\n\t\tpas le comportement du compilateur.\n\n\nFichiers sources :\n\n\t\tLes diffrents fichiers sont lus dans l'ordre\n\t\tdonn en ligne de commande. - sera quivalent \n\t\tl'entre standard. Si aucun fichier n'est indiqu,\n\t\tl'entre standard sera implicitement dsigne.\n\n");
							break;
						default:
							fprintf(sortie,"(Message non dfini)");
							break;
					}
					break;
				case T_S_(CHARSET_UTF8):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Erreur   ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Attention");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            dans le fichier %s à la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            inclus depuis le fichier %s à la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Mémoire insuffisante pour la poursuite de la compilation");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Option -%c non reconnue. Utilisez l'option -h pour obtenir la liste des options disponibles",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Commande %s mal placée",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Commande de texte mal placée");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Commande #%c mal placée",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Commande #%s mal placée",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Commande #%d mal placée",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Option %s définie à l'intérieur de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Redéfinition de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Appel de la macro %s non définie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Appel récursif de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Appel de la macro %s avec %d paramètre(s) au lieu des %d attendu(s)",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Erreur de syntaxe près du symbole %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Inclusion récursive du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Fichier de sortie déjà spécifié");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en écriture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Impossible d'éxécuter PlanFacile dans le répertoire courant");
							break;
						case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
							fprintf(sortie,"Le chemin menant au fichier %s est invalide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
							fprintf(sortie,"Le fichier %s est inexistant",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
							fprintf(sortie,"Le fichier %s est un répertoire ou de type bloc",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en lecture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Impossible d'ouvrir le fichier de nom vide en lecture");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Tentative d'ouverture du fichier %s pour #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"Aucun fichier n'a pu être ouvert pour #standard");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Redéfinition du style pour les sections de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Redéfinition du style par défaut pour les sections");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Redéfinition du style pour les références de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Redéfinition du style par défaut des références");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Redéfinition du style de message");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Redéfinition de l'entête de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Redéfinition du pied de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Redéfinition du niveau racine");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la définition du format de section");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la définition du format de référence");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la définition du niveau racine");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Impossible de déterminer le niveau racine");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"Redéfinition de l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
							fprintf(sortie,"Idée de référence vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
							fprintf(sortie,"Idée manquante de référence vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
							fprintf(sortie,"Idée générique de référence vide incorrecte");
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Pertinence de la dépendance depuis l'idée %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Indice d'idée manquante incorrect");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Redéfinition de l'idée manquante par défaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Redéfinition de l'idée manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Référence parente d'idée générique incorrecte");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Redéfinition de l'idée générique par défaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Redéfinition de l'idée générique de référence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"Dépendance depuis l'idée %s non utilisée pour le calcul du plan",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
							fprintf(sortie,"Dépendance depuis l'idée de référence vide non utilisée pour le calcul du plan");
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Impossible de déterminer l'idée racine");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Ajout d'une idée racine au document");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Idée %s non atteignable depuis la racine du document",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
							fprintf(sortie,"Format de section non défini pour l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
							fprintf(sortie,"Format de référence non défini pour la référence %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
							fprintf(sortie,"Idée manquante d'indice %d non définie",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
							fprintf(sortie,"Idée générique de référence parente %s non définie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
							fprintf(sortie,"Dépendance depuis l'idée %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE):
							fprintf(sortie,"Dépendance depuis l'idée de référence vide incorrecte");
							break;
						case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
							fprintf(sortie,"Indice de référence %s incorrect",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
							fprintf(sortie,"Nom de section de niveau %s indéfini",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document généré par PlanFacile 2.0 : %d idée(s) traitée(s), dont %d manquante(s) et %d générique(s), ainsi que %d référence(s) traitée(s) dont %d irréductible(s).",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Verbeux %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE):
							fprintf(sortie,"Analyse du code source");
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
							fprintf(sortie,"Analyse du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
							fprintf(sortie,"Inclusion du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
							fprintf(sortie,"Fin de l'analyse du fichier inclus");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES):
							fprintf(sortie,"Retouches sur le flux");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
							fprintf(sortie,"Paramètre d'indice %d trouvé",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
							fprintf(sortie,"Macro normale %s définie avec %d paramètres",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
							fprintf(sortie,"Macro boucle %s définie avec %d paramètres obligatoires",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
							fprintf(sortie,"Défragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
							fprintf(sortie,"Suppression de la commande d'inclusion du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
							fprintf(sortie,"Suppression de la commande d'inclusion standard");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS):
							fprintf(sortie,"Réduction des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
							fprintf(sortie,"Recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
							fprintf(sortie,"Enregistrement de l'option %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
							fprintf(sortie,"Abandon de l'option %s placée dans un commentaire",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
							fprintf(sortie,"Abandon de l'option %s placée dans la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
							fprintf(sortie,"Première recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
							fprintf(sortie,"Nouvelle recherche d'option requise");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
							fprintf(sortie,"Toutes les options ont été trouvées");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
							fprintf(sortie,"Réduction des commandes de sélection de code");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
							fprintf(sortie,"Réduction de la commande de label %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS):
							fprintf(sortie,"Réduction des macros");
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
							fprintf(sortie,"Macro normale %s trouvée",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
							fprintf(sortie,"Macro boucle %s trouvée",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
							fprintf(sortie,"Remplacement du paramètre %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
							fprintf(sortie,"Itération numéro %d de la macro %s",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION):
							fprintf(sortie,"Vérification sémantique");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
							fprintf(sortie,"Erreur utilisateur trouvée");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
							fprintf(sortie,"Avertissement utilisateur trouvé");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
							fprintf(sortie,"Défragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES):
							fprintf(sortie,"Enregistrement des styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
							fprintf(sortie,"Enregistrement des styles de section");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
							fprintf(sortie,"Enregistrement du style de section par défaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de section de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
							fprintf(sortie,"Enregistrement des autres styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
							fprintf(sortie,"Enregistrement du style de référence par défaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de référence de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
							fprintf(sortie,"Enregistrement du style de message");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
							fprintf(sortie,"Enregistrement du style d'entête de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
							fprintf(sortie,"Enregistrement du style de pied de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
							fprintf(sortie,"Sélection du niveau %d pour le niveau de la racine",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES):
							fprintf(sortie,"Enregistrement des idées");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
							fprintf(sortie,"Enregistrement des idées présentes");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
							fprintf(sortie,"Enregistrement de l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
							fprintf(sortie,"Enregistrement de la dépendance depuis l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
							fprintf(sortie,"Enregistrement des idées automatiques");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'idée manquante par défaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'idée manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'idée générique par défaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'idée générique de référence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
							fprintf(sortie,"Génération du graphe de dépendances");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
							fprintf(sortie,"Sans idées, pas de calcul de plan possible");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
							fprintf(sortie,"Graphe contenant %d idée(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
							fprintf(sortie,"Graphe contenant %d dépendance(s) dont %d inutile(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
							fprintf(sortie,"Recherche de l'idée racine");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
							fprintf(sortie,"Vérification de la topologie du graphe");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
							fprintf(sortie,"Transformation et complétion du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
							fprintf(sortie,"Transformation de l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
							fprintf(sortie,"Transformation d'une idée de référence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
							fprintf(sortie,"Complétion de la référence depuis l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
							fprintf(sortie,"Complétion de la référence depuis l'idée de référence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE):
							fprintf(sortie,"Génération du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
							fprintf(sortie,"Génération du texte du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
							fprintf(sortie,"Génération de l'entête du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
							fprintf(sortie,"Génération de l'idée de référence %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
							fprintf(sortie,"Génération d'une idée de référence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
							fprintf(sortie,"Génération d'une référence irréductible vers l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
							fprintf(sortie,"Génération d'une référence irréductible vers une idée de référence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
							fprintf(sortie,"Génération d'une référence provenant d'une dépendance");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
							fprintf(sortie,"Génération d'une référence réductible vers l'idée %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
							fprintf(sortie,"Génération d'une référence réductible vers une idée de référence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
							fprintf(sortie,"Génération d'une référence extérieure d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
							fprintf(sortie,"Génération d'une liste de références extérieures");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
							fprintf(sortie,"Génération du pied du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
							fprintf(sortie,"Production du document sur la sortie");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
							fprintf(sortie,"Production du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
							fprintf(sortie,"Production des statistiques internes du plan");
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage : planfacile <options> <fichiers sources>\n\n\nOptions :\n\n\tGénéral :\n\n-h\t\tAffiche cette aide.\n-V\t\tAffiche la license et le droit de copie.\n-v\t\tMode verbeux. (A placer plusieurs fois, si nécessaire).\n-o <fichier>\tFichier de sortie. Si cette option\n\t\tn'est pas indiquée, la sortie standard est utilisée.\n-a\t\tEquivalent à -SICYmgAdDpEcylGNTMUPRt.\n-n\t\tEquivalent à -uir.\n-e\t\tTransforme tous les avertissements en erreur.\n-W\t\tDésactive l'affichage des positions dans le source\n\t\tdes avertissements et des erreurs. (Plus rapide et moins\n\t\tgourmand en mémoire)\n-w\t\tAffiche les chemins absolus des fichiers sources dans les\n\t\tmessages du compilateur. (Gourmand en mémoire)\n\n\tFichiers sources :\n\n-S\t\tIgnore les fichiers sources non ouvrables en lecture.\n-I\t\tIgnore les inclusions récursives de fichiers.\n-s\t\tAffiche le comportement de #standard, et termine sur\n\t\tune erreur en cas d'échec.\n\n\tCompilation :\n\n-O <option>\tDéfinit une option de compilation.\n-u\t\tDésactive l'affichage des avertissements utilisateurs.\n-C\t\tIgnore les commandes mal placées dans les fichiers\n\t\tsources.\n\n\tIdées :\n\n-i\t\tDésactive l'affichage des redéfinitions d'idées.\n-Y\t\tIgnore les idées dont la référence est vide.\n-m\t\tIgnore les idées manquantes dont l'indice est incorrect.\n-g\t\tIgnore les idées génériques dont la référence à l'idée\n\t\tparente est incorrecte.\n-r\t\tDésactive l'affichage de l'ajout éventuel d'une idée\n\t\tracine.\n-A\t\tIgnore les idées automatiques non résolues.\n\n\tDépendances et références :\n\n-d\t\tIgnore les dépendances dont la source est incorrecte.\n-D\t\tIndique les dépendances non utilisées pour le calcul du plan.\n-p\t\tIgnore les dépendances dont la pertinence est incorrecte.\n-E\t\tIgnore les références extérieures dont l'indice est incorrect.\n\n\tStyles :\n\n-c\t\tTransmet les commentaires du source dans le document.\n-y\t\tAffiche toute redéfinition de style.\n-l\t\tIgnore toute définition de style dont l'indice est incorrect.\n-G\t\tIgnore les idées dont le style de section n'est pas défini.\n-N\t\tIgnore les références dont le style n'est pas défini.\n-T\t\tIgnore les noms de sections dans les références, lorsqu'ils ne\n\t\tsont pas définis.\n\n\tMacros :\n\n-M\t\tAffiche toute redéfinition de macro.\n-U\t\tIgnore les appels de macros dont le nom n'est pas défini.\n-P\t\tAjuste le nombre de paramètres des macros lors des appels,\n\t\tconformément à leur définition.\n-R\t\tIgnore les appels récursifs de macro.\n-t\t\tIgnore les commandes de définition d'option dans les macros.\n\n\tRemarque :\n\n\t\tToutes les options, hormis -o, -O et -v, fonctionnent\n\t\tcomme des bascules : placer deux fois une option ne change\n\t\tpas le comportement du compilateur.\n\n\nFichiers sources :\n\n\t\tLes différents fichiers sont lus dans l'ordre\n\t\tdonné en ligne de commande. - sera équivalent à\n\t\tl'entrée standard. Si aucun fichier n'est indiqué,\n\t\tl'entrée standard sera implicitement désignée.\n\n");
							break;
						default:
							fprintf(sortie,"(Message non défini)");
							break;
					}
					break;
				case T_S_(CHARSET_ASCII):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Erreur   ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Attention");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            dans le fichier %s a la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            inclus depuis le fichier %s a la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Memoire insuffisante pour la poursuite de la compilation");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Option -%c non reconnue. Utilisez l'option -h pour obtenir la liste des options disponibles",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Commande %s mal placee",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Commande de texte mal placee");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Commande #%c mal placee",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Commande #%s mal placee",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Commande #%d mal placee",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Option %s definie a l'interieur de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Redefinition de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Appel de la macro %s non definie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Appel recursif de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Appel de la macro %s avec %d parametre(s) au lieu des %d attendu(s)",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Erreur de syntaxe pres du symbole %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Inclusion recursive du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Fichier de sortie deja specifie");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en ecriture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Impossible d'executer PlanFacile dans le repertoire courant");
							break;
						case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
							fprintf(sortie,"Le chemin menant au fichier %s est invalide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
							fprintf(sortie,"Le fichier %s est inexistant",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
							fprintf(sortie,"Le fichier %s est un repertoire ou de type bloc",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en lecture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Impossible d'ouvrir le fichier de nom vide en lecture");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Tentative d'ouverture du fichier %s pour #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"Aucun fichier n'a pu etre ouvert pour #standard");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Redefinition du style pour les sections de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Redefinition du style par defaut pour les sections");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Redefinition du style pour les references de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Redefinition du style par defaut des references");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Redefinition du style de message");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Redefinition de l'entete de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Redefinition du pied de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Redefinition du niveau racine");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la definition du format de section");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la definition du format de reference");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la definition du niveau racine");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Impossible de determiner le niveau racine");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"Redefinition de l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
							fprintf(sortie,"Idee de reference vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
							fprintf(sortie,"Idee manquante de reference vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
							fprintf(sortie,"Idee generique de reference vide incorrecte");
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Pertinence de la dependance depuis l'idee %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Indice d'idee manquante incorrect");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Redefinition de l'idee manquante par defaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Redefinition de l'idee manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Reference parente d'idee generique incorrecte");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Redefinition de l'idee generique par defaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Redefinition de l'idee generique de reference parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"Dependance depuis l'idee %s non utilisee pour le calcul du plan",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
							fprintf(sortie,"Dependance depuis l'idee de reference vide non utilisee pour le calcul du plan");
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Impossible de determiner l'idee racine");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Ajout d'une idee racine au document");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Idee %s non atteignable depuis la racine du document",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
							fprintf(sortie,"Format de section non defini pour l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
							fprintf(sortie,"Format de reference non defini pour la reference %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
							fprintf(sortie,"Idee manquante d'indice %d non definie",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
							fprintf(sortie,"Idee generique de reference parente %s non definie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
							fprintf(sortie,"Dependance depuis l'idee %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE):
							fprintf(sortie,"Dependance depuis l'idee de reference vide incorrecte");
							break;
						case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
							fprintf(sortie,"Indice de reference %s incorrect",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
							fprintf(sortie,"Nom de section de niveau %s indefini",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document genere par PlanFacile 2.0 : %d idee(s) traitee(s), dont %d manquante(s) et %d generique(s), ainsi que %d reference(s) traitee(s) dont %d irreductible(s).",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Verbeux %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE):
							fprintf(sortie,"Analyse du code source");
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
							fprintf(sortie,"Analyse du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
							fprintf(sortie,"Inclusion du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
							fprintf(sortie,"Fin de l'analyse du fichier inclus");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES):
							fprintf(sortie,"Retouches sur le flux");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
							fprintf(sortie,"Parametre d'indice %d trouve",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
							fprintf(sortie,"Macro normale %s definie avec %d parametres",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
							fprintf(sortie,"Macro boucle %s definie avec %d parametres obligatoires",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
							fprintf(sortie,"Defragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
							fprintf(sortie,"Suppression de la commande d'inclusion du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
							fprintf(sortie,"Suppression de la commande d'inclusion standard");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS):
							fprintf(sortie,"Reduction des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
							fprintf(sortie,"Recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
							fprintf(sortie,"Enregistrement de l'option %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
							fprintf(sortie,"Abandon de l'option %s placee dans un commentaire",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
							fprintf(sortie,"Abandon de l'option %s placee dans la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
							fprintf(sortie,"Premiere recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
							fprintf(sortie,"Nouvelle recherche d'option requise");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
							fprintf(sortie,"Toutes les options ont ete trouvees");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
							fprintf(sortie,"Reduction des commandes de selection de code");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
							fprintf(sortie,"Reduction de la commande de label %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS):
							fprintf(sortie,"Reduction des macros");
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
							fprintf(sortie,"Macro normale %s trouvee",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
							fprintf(sortie,"Macro boucle %s trouvee",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
							fprintf(sortie,"Remplacement du parametre %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
							fprintf(sortie,"Iteration numero %d de la macro %s",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION):
							fprintf(sortie,"Verification semantique");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
							fprintf(sortie,"Erreur utilisateur trouvee");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
							fprintf(sortie,"Avertissement utilisateur trouve");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
							fprintf(sortie,"Defragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES):
							fprintf(sortie,"Enregistrement des styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
							fprintf(sortie,"Enregistrement des styles de section");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
							fprintf(sortie,"Enregistrement du style de section par defaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de section de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
							fprintf(sortie,"Enregistrement des autres styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
							fprintf(sortie,"Enregistrement du style de reference par defaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de reference de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
							fprintf(sortie,"Enregistrement du style de message");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
							fprintf(sortie,"Enregistrement du style d'entete de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
							fprintf(sortie,"Enregistrement du style de pied de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
							fprintf(sortie,"Selection du niveau %d pour le niveau de la racine",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES):
							fprintf(sortie,"Enregistrement des idees");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
							fprintf(sortie,"Enregistrement des idees presentes");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
							fprintf(sortie,"Enregistrement de l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
							fprintf(sortie,"Enregistrement de la dependance depuis l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
							fprintf(sortie,"Enregistrement des idees automatiques");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'idee manquante par defaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'idee manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'idee generique par defaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'idee generique de reference parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
							fprintf(sortie,"Generation du graphe de dependances");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
							fprintf(sortie,"Sans idees, pas de calcul de plan possible");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
							fprintf(sortie,"Graphe contenant %d idee(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
							fprintf(sortie,"Graphe contenant %d dependance(s) dont %d inutile(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
							fprintf(sortie,"Recherche de l'idee racine");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
							fprintf(sortie,"Verification de la topologie du graphe");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
							fprintf(sortie,"Transformation et completion du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
							fprintf(sortie,"Transformation de l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
							fprintf(sortie,"Transformation d'une idee de reference vide");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
							fprintf(sortie,"Completion de la reference depuis l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
							fprintf(sortie,"Completion de la reference depuis l'idee de reference vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE):
							fprintf(sortie,"Generation du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
							fprintf(sortie,"Generation du texte du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
							fprintf(sortie,"Generation de l'entete du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
							fprintf(sortie,"Generation de l'idee de reference %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
							fprintf(sortie,"Generation d'une idee de reference vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
							fprintf(sortie,"Generation d'une reference irreductible vers l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
							fprintf(sortie,"Generation d'une reference irreductible vers une idee de reference vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
							fprintf(sortie,"Generation d'une reference provenant d'une dependance");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
							fprintf(sortie,"Generation d'une reference reductible vers l'idee %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
							fprintf(sortie,"Generation d'une reference reductible vers une idee de reference vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
							fprintf(sortie,"Generation d'une reference exterieure d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
							fprintf(sortie,"Generation d'une liste de references exterieures");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
							fprintf(sortie,"Generation du pied du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
							fprintf(sortie,"Production du document sur la sortie");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
							fprintf(sortie,"Production du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
							fprintf(sortie,"Production des statistiques internes du plan");
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage : planfacile <options> <fichiers sources>\n\n\nOptions :\n\n\tGeneral :\n\n-h\t\tAffiche cette aide.\n-V\t\tAffiche la license et le droit de copie.\n-v\t\tMode verbeux. (A placer plusieurs fois, si necessaire).\n-o <fichier>\tFichier de sortie. Si cette option\n\t\tn'est pas indiquee, la sortie standard est utilisee.\n-a\t\tEquivalent a -SICYmgAdDpEcylGNTMUPRt.\n-n\t\tEquivalent a -uir.\n-e\t\tTransforme tous les avertissements en erreur.\n-W\t\tDesactive l'affichage des positions dans le source\n\t\tdes avertissements et des erreurs. (Plus rapide et moins\n\t\tgourmand en memoire)\n-w\t\tAffiche les chemins absolus des fichiers sources dans les\n\t\tmessages du compilateur. (Gourmand en memoire)\n\n\tFichiers sources :\n\n-S\t\tIgnore les fichiers sources non ouvrables en lecture.\n-I\t\tIgnore les inclusions recursives de fichiers.\n-s\t\tAffiche le comportement de #standard, et termine sur\n\t\tune erreur en cas d'echec.\n\n\tCompilation :\n\n-O <option>\tDefinit une option de compilation.\n-u\t\tDesactive l'affichage des avertissements utilisateurs.\n-C\t\tIgnore les commandes mal placees dans les fichiers\n\t\tsources.\n\n\tIdees :\n\n-i\t\tDesactive l'affichage des redefinitions d'idees.\n-Y\t\tIgnore les idees dont la reference est vide.\n-m\t\tIgnore les idees manquantes dont l'indice est incorrect.\n-g\t\tIgnore les idees generiques dont la reference a l'idee\n\t\tparente est incorrecte.\n-r\t\tDesactive l'affichage de l'ajout eventuel d'une idee\n\t\tracine.\n-A\t\tIgnore les idees automatiques non resolues.\n\n\tDependances et references :\n\n-d\t\tIgnore les dependances dont la source est incorrecte.\n-D\t\tIndique les dependances non utilisees pour le calcul du plan.\n-p\t\tIgnore les dependances dont la pertinence est incorrecte.\n-E\t\tIgnore les references exterieures dont l'indice est incorrect.\n\n\tStyles :\n\n-c\t\tTransmet les commentaires du source dans le document.\n-y\t\tAffiche toute redefinition de style.\n-l\t\tIgnore toute definition de style dont l'indice est incorrect.\n-G\t\tIgnore les idees dont le style de section n'est pas defini.\n-N\t\tIgnore les references dont le style n'est pas defini.\n-T\t\tIgnore les noms de sections dans les references, lorsqu'ils ne\n\t\tsont pas definis.\n\n\tMacros :\n\n-M\t\tAffiche toute redefinition de macro.\n-U\t\tIgnore les appels de macros dont le nom n'est pas defini.\n-P\t\tAjuste le nombre de parametres des macros lors des appels,\n\t\tconformement a leur definition.\n-R\t\tIgnore les appels recursifs de macro.\n-t\t\tIgnore les commandes de definition d'option dans les macros.\n\n\tRemarque :\n\n\t\tToutes les options, hormis -o, -O et -v, fonctionnent\n\t\tcomme des bascules : placer deux fois une option ne change\n\t\tpas le comportement du compilateur.\n\n\nFichiers sources :\n\n\t\tLes differents fichiers sont lus dans l'ordre\n\t\tdonne en ligne de commande. - sera equivalent a\n\t\tl'entree standard. Si aucun fichier n'est indique,\n\t\tl'entree standard sera implicitement designee.\n\n");
							break;
						default:
							fprintf(sortie,"(Message non defini)");
							break;
					}
					break;
				default:
					temporaire=NULL;
					SECURISE(general_copie_speciale(general,T_S(temporaire)));
					SECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(CHARSET_ISO)));
					SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
					SECURISE(general_destruction(T_S(temporaire)));
					break;
			}
			break;
		case T_S_(LANGUE_EN):
			switch(charset)
			{
				case T_S_(CHARSET_ISO):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Error    ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Warning  ");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            in file %s, line %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            included from file %s, line %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Insufficient memory");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Wrong option -%c. Use -h option to get help on the available options",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Misplaced %s command",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Misplaced text command");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Misplaced #%c command",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Misplaced #%s command",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Misplaced #%d command",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Option %s defined in the macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Macro %s redefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Undefined macro %s call",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Recursive call of macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Macro %s defined with %d parameter(s), but used with %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Syntax error near %s token",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Recursive inclusion of %s file",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Output file already specified");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"Impossible to write in %s file",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Impossible to run PlanFacile in the current directory");
							break;
						case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
							fprintf(sortie,"Invalid path to %s file",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
							fprintf(sortie,"%s file is not present",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
							fprintf(sortie,"%s is a directory or a block type file",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Impossible to read %s file",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Impossible to open empty name file");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Try to open %s file for #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"No file could be opened for #standard");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Section style of level %d redefined",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Section style of default level redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Reference style of level %d redefined",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Reference style of default level redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Message style redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Document head style redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Document foot style redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Root level redefined");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Invalid level for section style definition");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Invalid level for reference style definition");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Invalid level for root level definition");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Impossible to determine root level");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"%s idea redefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
							fprintf(sortie,"Idea with empty reference not allowed");
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
							fprintf(sortie,"Missing idea with empty reference not allowed");
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
							fprintf(sortie,"Generic idea with empty reference not allowed");
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Invalid weighting of the dependency from %s idea",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Invalid index of missing idea");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Default missing idea redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Missing idea with index %d redefined",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Invalid parent reference of generic idea");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Default generic idea redefined");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Generic idea with %s parent reference redefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"Dependency from %s idea not used for table of contents computation",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
							fprintf(sortie,"Dependency with empty reference not used for table of contents computation");
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Impossible to determine root idea");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Root idea added to the document");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Impossible to reach %s idea from the root idea",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
							fprintf(sortie,"Section format for %s idea undefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
							fprintf(sortie,"Reference format for %s reference undefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
							fprintf(sortie,"Missing idea with index %d undefined",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
							fprintf(sortie,"Generic idea with parent reference %s undefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
							fprintf(sortie,"Invalid dependency from %s idea",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE):
							fprintf(sortie,"Invalid dependency from an empty reference idea");
							break;
						case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
							fprintf(sortie,"Invalid reference index %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
							fprintf(sortie,"Section name of level %s undefined",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document generated by PlanFacile 2.0 : %d idea(s) produced, with %d missing(s) and %d generic(s). %d reference(s) produced with %d unreduced.",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Verbose %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE):
							fprintf(sortie,"Source code analysis");
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
							fprintf(sortie,"Source file %s analysis",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
							fprintf(sortie,"Inclusion of source file %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
							fprintf(sortie,"End of included file analysis");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES):
							fprintf(sortie,"Data flow completion");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
							fprintf(sortie,"Parameter #%d found",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
							fprintf(sortie,"Normal macro %s defined with %d parameter(s)",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
							fprintf(sortie,"Loop macro %s defined with %d parameter(s)",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
							fprintf(sortie,"Defragmentation of data flow of type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
							fprintf(sortie,"Include command of file %s deleted",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
							fprintf(sortie,"Standard command deleted");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS):
							fprintf(sortie,"Option reduction");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
							fprintf(sortie,"Defined option search");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
							fprintf(sortie,"Option %s found",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
							fprintf(sortie,"Option %s discarded in comment",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
							fprintf(sortie,"Option %s defined inside the %s macro",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
							fprintf(sortie,"First option research");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
							fprintf(sortie,"Another option research required");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
							fprintf(sortie,"All options have been found");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
							fprintf(sortie,"Reduction of code selection commands");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
							fprintf(sortie,"Command with %s label reduced",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS):
							fprintf(sortie,"Macro reduction");
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
							fprintf(sortie,"Normal %s macro found",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
							fprintf(sortie,"Loop %s macro found",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
							fprintf(sortie,"Parameter %d replaced",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
							fprintf(sortie,"Iteration number %d in %s macro",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION):
							fprintf(sortie,"Semantic check");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
							fprintf(sortie,"User error found");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
							fprintf(sortie,"User warning found");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
							fprintf(sortie,"Defragmentation of data flow of type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES):
							fprintf(sortie,"Style registration");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
							fprintf(sortie,"Section style registration");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
							fprintf(sortie,"Default section style registered");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
							fprintf(sortie,"Section style of level %d registered",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
							fprintf(sortie,"Other style registration");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
							fprintf(sortie,"Default reference style registered");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
							fprintf(sortie,"Reference style of level %dregistered",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
							fprintf(sortie,"Message style registered");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
							fprintf(sortie,"Document head style registered");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
							fprintf(sortie,"Document foot style registered");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
							fprintf(sortie,"Root level set to %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES):
							fprintf(sortie,"Idea registration");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
							fprintf(sortie,"Normal idea registration");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
							fprintf(sortie,"%s idea registered",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
							fprintf(sortie,"Dependency from %s idea registered",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
							fprintf(sortie,"Automatic idea registration");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
							fprintf(sortie,"Default missing idea registered");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
							fprintf(sortie,"Missing idea of index %d registered",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
							fprintf(sortie,"Default generic idea registered");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
							fprintf(sortie,"Generic idea with %s parent reference registered",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN):
							fprintf(sortie,"Table of contents computation");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
							fprintf(sortie,"Dependency graph computation");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
							fprintf(sortie,"No idea, therefore no table of contents computation is needed");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
							fprintf(sortie,"Graph with %d idea(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
							fprintf(sortie,"Graph with %d dependency(ies), including %d unused",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
							fprintf(sortie,"Root idea research");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
							fprintf(sortie,"Graph structure check");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
							fprintf(sortie,"Table of contents computation");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
							fprintf(sortie,"Table of contents conversion and completion");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
							fprintf(sortie,"%s idea conversion",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
							fprintf(sortie,"Empty reference idea conversion");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
							fprintf(sortie,"Reference to %s idea completion",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
							fprintf(sortie,"Reference to empty reference idea completion");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE):
							fprintf(sortie,"Document generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
							fprintf(sortie,"Text generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
							fprintf(sortie,"Document head generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
							fprintf(sortie,"%s idea generation",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
							fprintf(sortie,"Empty reference idea generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
							fprintf(sortie,"Non-reducible reference to %s idea generation",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
							fprintf(sortie,"Non-reducible reference to empty reference idea generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
							fprintf(sortie,"Reference made from dependency generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
							fprintf(sortie,"Reducible reference to %s idea generation",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
							fprintf(sortie,"Reducible reference to empty reference idea generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
							fprintf(sortie,"External reference with index %d generation",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
							fprintf(sortie,"List of external reference(s) generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
							fprintf(sortie,"Document foot generation");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
							fprintf(sortie,"Document production in compiler output");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
							fprintf(sortie,"Document production");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
							fprintf(sortie,"Internal statistics production of table of contents computation");
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage: planfacile <options> <source file>\n\n\nOptions:\n\n\tGeneral:\n\n-h\t\tDisplay this help.\n-V\t\tDisplay the licence and the copyright.\n-v\t\tVerbose mode. (Put it several times, if necessary).\n-o <file>\tOutput file. If this option\n\t\tis not present, the standard output is used.\n-a\t\tSame as -SICYmgAdDpEcylGNTMUPRt.\n-n\t\tSame as -uir.\n-e\t\tTransform every warning into an error.\n-W\t\tDon't display the position in the source code\n\t\tof warnings and errors. (Faster and lighter in memory)\n-w\t\tDisplay absolute path of the source files in the\n\t\tcompiler messages. (Heavier in memory)\n\n\tSource file:\n\n-S\t\tIgnore non-readable source file.\n-I\t\tIgnore recursive file include.\n-s\t\tDisplay the behavior of the #standard command, and\n\t\tterminate on error in case of failure.\n\n\tCompilation:\n\n-O <option>\tDefine an option for compilation.\n-u\t\tDon't display user warnings.\n-C\t\tIgnore misplaced commands.\n\n\tIdeas:\n\n-i\t\tDon't display ideas redefinition.\n-Y\t\tIgnore ideas with empty reference.\n-m\t\tIgnore missing ideas with invalid index.\n-g\t\tIgnore generic ideas with invalid parent reference.\n-r\t\tDon't display an addition of a root idea.\n-A\t\tIgnore unresolved automatic ideas.\n\n\tReferences and dependencies:\n\n-d\t\tIgnore dependency with invalid source.\n-D\t\tIndicate unused dependencies for the table of contents\n\t\tcomputation.\n-p\t\tIgnore dependencies with invalid weighting.\n-E\t\tIgnore external references with invalid index.\n\n\tStyles:\n\n-c\t\tWrite comments in the document.\n-y\t\tDisplay style redefinition.\n-l\t\tIgnore style definition with invalid level.\n-G\t\tIgnore ideas with undefined section style.\n-N\t\tIgnore references with undefined style.\n-T\t\tIgnore undefined section name in references.\n\n\tMacros:\n\n-M\t\tDisplay macro redefinition.\n-U\t\tIgnore undefined macro call.\n-P\t\tAdjust the number of macro parameters during call,\n\t\tconforming to their definition.\n-R\t\tIgnore recursive macro calls.\n-t\t\tIgnore option definitions in macros.\n\n\tRemark:\n\n\t\tAll options, except -o, -O and -v, toggle :\n\t\tputting an option twice does not change the behavior\n\t\tof the compiler.\n\n\nSource file:\n\n\t\tThe source files are read in the order given in\n\t\tcommand line. - will be equivalent to the standard\n\t\tinput. If no files are present, the standard input\n\t\twill be used.\n\n");
							break;
						default:
							fprintf(sortie,"(Undefined message)");
							break;
					}
					break;
				default:
					temporaire=NULL;
					SECURISE(general_copie_speciale(general,T_S(temporaire)));
					SECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(CHARSET_ISO)));
					SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
					SECURISE(general_destruction(T_S(temporaire)));
					break;
			}
			break;
		case T_S_(LANGUE_NEUNEU):
			switch(charset)
			{
				case T_S_(CHARSET_ISO):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Erreur   ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Attention");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            dans le fichier %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            inclus depuis le fichier %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Mmoire insuffisante pour la poursuite de la compilation");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Option -%c non reconnue. Utilisez l'option -h pour obtenir la liste des options disponibles",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Supprimez la commande %s mal place",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Supprimez le texte mal plac");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Supprimez le caractre d'echappement #%c mal plac",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Supprimez la macro #%s mal place",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Supprimez le paramtre de macro #%d mal plac",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Supprimez l'option %s dfinie  l'intrieur de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Redfinition de la macro %s. Enlevez cette dfinition si le comportement actuel n'tait pas attendu",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Vous avez tent d'appeler une macro %s sans la dfinir. Supprimez cet appel ou dfinissez la macro",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Vous avez appell la macro %s dans un appel de cette macro. Supprimez cet appel",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Appellez la macro %s avec %d paramtre(s) au lieu des %d actuels",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Corrigez le code source avant le symbole %s, pour permettre une analyse correcte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Supprimez l'inclusion du fichier %s, car ce fichier est dj en cours d'analyse",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Le compilateur ne peut crire que dans un seul fichier. Supprimez les option -o en trop");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"L'criture du rsultat a choue, car le fichier %s n'a pas pu tre ouvert. Spcifiez un fichier valide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Le rpertoire d'xcution de PlanFacile a t supprim aprs le lancement du compilateur");
							break;
						case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
							fprintf(sortie,"Indiquez un chemin valide vers le fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
							fprintf(sortie,"Le fichier  analyser %s est inexistant. Donnez-en un valide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
							fprintf(sortie,"Le fichier %s n'est pas analysable. Vous devez spcifier un fichier normal",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Impossible d'ouvrir le fichier %s en lecture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Vous devez spcifier un fichier  la commande d'inclusion");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Tentative d'ouverture du fichier %s pour #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"Aucun fichier n'a pu tre ouvert pour #standard. Veuillez vrifier l'installation de PlanFacile");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Redfinition du style pour les sections de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Redfinition du style par dfaut pour les sections");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Redfinition du style pour les rfrences de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Redfinition du style par dfaut des rfrences");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Redfinition du style de message");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Redfinition de l'entte de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Redfinition du pied de document");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Redfinition du niveau racine");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de section. Un nombre entier positif tait attendu");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de rfrence. Un nombre entier positif ou un nom de niveau tait attendu");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du niveau racine. Un nombre entier positif ou un nom de niveau tait attendu");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Ajoutez la commande #start au dbut de votre code. Reportez-vous  la documentation pour la syntaxe de cette commande");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"Redfinition de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
							fprintf(sortie,"Donnez une rfrence  une ide normale");
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
							fprintf(sortie,"Donnez une rfrence  une ide manquante");
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
							fprintf(sortie,"Donnez une rfrence  une ide gnrique");
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Pertinence de la dpendance vers l'ide %s incorrecte. Un nombre entier positif tait attendu",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Indiquez un nombre entier strictement positif comme indice de l'ide manquante");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Redfinition de l'ide manquante par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Redfinition de l'ide manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Indiquez la rfrence d'une ide normale comme indice d'une ide gnrique");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Redfinition de l'ide gnrique par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Redfinition de l'ide gnrique de rfrence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"La dpendance vers l'ide %s ne sera pas utilise pour le calcul du plan. Supprimez la si elle tait non dsire",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
							fprintf(sortie,"Indiquez une rfrence  la dpendance, pour la rendre utile au calcul du plan");
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Le code source doit contenir une ide sans dpendances dans le texte. Ajoutez la si ncessaire, ou vrifiez vos dpendances");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Plusieurs ides dans dpendances dans leur texte ont t trouves. Une ide reprsentant le document a t automatiquement ajoute");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Ajoutez des dpendances dans le texte de l'ide de rfrence %s, car elle est inacessible depuis l'ide racine",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
							fprintf(sortie,"Le format de section pour l'ide %s est non dfini. Ajoutez ce format  votre code source",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
							fprintf(sortie,"Le format de rfrence pour la rfrence %s est non dfini. Ajoutez ce format  votre code source",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
							fprintf(sortie,"Ajoutez une ide manquante d'indice %d  l'aide de la commande #missing. Reportez vous  la documentation pour la syntaxe de cette commande",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
							fprintf(sortie,"Ajoutez une ide gnrique d'indice %s  l'aide de la commande #generic. Reportez vous  la documentation pour la syntaxe de cette commande",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
							fprintf(sortie,"Supprimez la dpendance vers l'ide %s, car elle est incorrecte. Une dpendance correcte contient une rfrence valide vers une ide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE):
							fprintf(sortie,"Ajoutez une rfrence  la dpendance pour la rendre valide");
							break;
						case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
							fprintf(sortie,"L'indice de la rfrence extrieure %s est incorrect. Un nombre entier strictement positif ne dpassant pas le nombre de rfrences de #extrefs tait attendu",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
							fprintf(sortie,"Le nom de section de niveau %s est indfini. Indiquez alors un niveau correct",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document gnr par PlanFacile 2.0 : %d ide(s) traite(s), dont %d manquante(s) et %d gnrique(s), ainsi que %d rfrence(s) traite(s) dont %d irrductible(s).",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Verbeux %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE):
							fprintf(sortie,"Analyse du code source");
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
							fprintf(sortie,"Analyse du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
							fprintf(sortie,"Inclusion du fichier source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
							fprintf(sortie,"Fin de l'analyse du fichier inclus");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES):
							fprintf(sortie,"Retouches sur le flux");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
							fprintf(sortie,"Paramtre d'indice %d trouv",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
							fprintf(sortie,"Macro normale %s dfinie avec %d paramtres",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
							fprintf(sortie,"Macro boucle %s dfinie avec %d paramtres obligatoires",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
							fprintf(sortie,"Dfragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
							fprintf(sortie,"Suppression de la commande d'inclusion du fichier %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
							fprintf(sortie,"Suppression de la commande d'inclusion standard");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS):
							fprintf(sortie,"Rduction des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
							fprintf(sortie,"Recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
							fprintf(sortie,"Enregistrement de l'option %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
							fprintf(sortie,"Abandon de l'option %s place dans un commentaire",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
							fprintf(sortie,"Abandon de l'option %s place dans la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
							fprintf(sortie,"Premire recherche des options");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
							fprintf(sortie,"Nouvelle recherche d'option requise");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
							fprintf(sortie,"Toutes les options ont t trouves");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
							fprintf(sortie,"Rduction des commandes de slection de code");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
							fprintf(sortie,"Rduction de la commande de label %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS):
							fprintf(sortie,"Rduction des macros");
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
							fprintf(sortie,"Macro normale %s trouve",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
							fprintf(sortie,"Macro boucle %s trouve",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
							fprintf(sortie,"Remplacement du paramtre %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
							fprintf(sortie,"Itration numro %d de la macro %s",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION):
							fprintf(sortie,"Vrification smantique");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
							fprintf(sortie,"Erreur utilisateur trouve");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
							fprintf(sortie,"Avertissement utilisateur trouv");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
							fprintf(sortie,"Dfragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES):
							fprintf(sortie,"Enregistrement des styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
							fprintf(sortie,"Enregistrement des styles de section");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
							fprintf(sortie,"Enregistrement du style de section par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de section de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
							fprintf(sortie,"Enregistrement des autres styles");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
							fprintf(sortie,"Enregistrement du style de rfrence par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
							fprintf(sortie,"Enregistrement du style de rfrence de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
							fprintf(sortie,"Enregistrement du style de message");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
							fprintf(sortie,"Enregistrement du style d'entte de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
							fprintf(sortie,"Enregistrement du style de pied de document");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
							fprintf(sortie,"Slection du niveau %d pour le niveau de la racine",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES):
							fprintf(sortie,"Enregistrement des ides");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
							fprintf(sortie,"Enregistrement des ides prsentes");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
							fprintf(sortie,"Enregistrement de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
							fprintf(sortie,"Enregistrement de la dpendance vers l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
							fprintf(sortie,"Enregistrement des ides automatiques");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'ide manquante par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'ide manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
							fprintf(sortie,"Enregistrement de l'ide gnrique par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
							fprintf(sortie,"Enregistrement de l'ide gnrique de rfrence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
							fprintf(sortie,"Gnration du graphe de dpendances");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
							fprintf(sortie,"Sans ides, pas de calcul de plan possible");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
							fprintf(sortie,"Graphe contenant %d ide(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
							fprintf(sortie,"Graphe contenant %d dpendance(s) dont %d inutile(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
							fprintf(sortie,"Recherche de l'ide racine");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
							fprintf(sortie,"Vrification de la topologie du graphe");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
							fprintf(sortie,"Transformation et compltion du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
							fprintf(sortie,"Transformation de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
							fprintf(sortie,"Transformation d'une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
							fprintf(sortie,"Compltion de la rfrence vers l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
							fprintf(sortie,"Compltion de la rfrence vers l'ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE):
							fprintf(sortie,"Gnration du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
							fprintf(sortie,"Gnration du texte du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
							fprintf(sortie,"Gnration de l'entte du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
							fprintf(sortie,"Gnration de l'ide de rfrence %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
							fprintf(sortie,"Gnration d'une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
							fprintf(sortie,"Gnration d'une rfrence irrductible vers l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
							fprintf(sortie,"Gnration d'une rfrence irrductible vers une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
							fprintf(sortie,"Gnration d'une rfrence provenant d'une dpendance");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
							fprintf(sortie,"Gnration d'une rfrence rductible vers l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
							fprintf(sortie,"Gnration d'une rfrence rductible vers une ide de rfrence vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
							fprintf(sortie,"Gnration d'une rfrence extrieure d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
							fprintf(sortie,"Gnration d'une liste de rfrences extrieures");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
							fprintf(sortie,"Gnration du pied du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
							fprintf(sortie,"Production du document sur la sortie");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
							fprintf(sortie,"Production du document");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
							fprintf(sortie,"Production des statistiques internes du plan");
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage : planfacile <options> <fichiers sources>\n\n\nOptions :\n\n\tGnral :\n\n-h\t\tAffiche cette aide.\n-V\t\tAffiche la license et le droit de copie.\n-v\t\tMode verbeux. (A placer plusieurs fois, si ncessaire).\n-o <fichier>\tFichier de sortie. Si cette option\n\t\tn'est pas indique, la sortie standard est utilise.\n-a\t\tEquivalent  -SICYmgAdDpEcylGNTMUPRt.\n-n\t\tEquivalent  -uir.\n-e\t\tTransforme tous les avertissements en erreur.\n-W\t\tDsactive l'affichage des positions dans le source\n\t\tdes avertissements et des erreurs. (Plus rapide et moins\n\t\tgourmand en mmoire)\n-w\t\tAffiche les chemins absolus des fichiers sources dans les\n\t\tmessages du compilateur. (Gourmand en mmoire)\n\n\tFichiers sources :\n\n-S\t\tIgnore les fichiers sources non ouvrables en lecture.\n-I\t\tIgnore les inclusions rcursives de fichiers.\n-s\t\tAffiche le comportement de #standard, et termine sur\n\t\tune erreur en cas d'chec.\n\n\tCompilation :\n\n-O <option>\tDfinit une option de compilation.\n-u\t\tDsactive l'affichage des avertissements utilisateurs.\n-C\t\tIgnore les commandes mal places dans les fichiers\n\t\tsources.\n\n\tIdes :\n\n-i\t\tDsactive l'affichage des redfinitions d'ides.\n-Y\t\tIgnore les ides dont la rfrence est vide.\n-m\t\tIgnore les ides manquantes dont l'indice est incorrect.\n-g\t\tIgnore les ides gnriques dont la rfrence  l'ide\n\t\tparente est incorrecte.\n-r\t\tDsactive l'affichage de l'ajout ventuel d'une ide\n\t\tracine.\n-A\t\tIgnore les ides automatiques non rsolues.\n\n\tDpendances et rfrences :\n\n-d\t\tIgnore les dpendances dont la source est incorrecte.\n-D\t\tIndique les dpendances non utilises pour le calcul du plan.\n-p\t\tIgnore les dpendances dont la pertinence est incorrecte.\n-E\t\tIgnore les rfrences extrieures dont l'indice est incorrect.\n\n\tStyles :\n\n-c\t\tTransmet les commentaires du source dans le document.\n-y\t\tAffiche toute redfinition de style.\n-l\t\tIgnore toute dfinition de style dont l'indice est incorrect.\n-G\t\tIgnore les ides dont le style de section n'est pas dfini.\n-N\t\tIgnore les rfrences dont le style n'est pas dfini.\n-T\t\tIgnore les noms de sections dans les rfrences, lorsqu'ils ne\n\t\tsont pas dfinis.\n\n\tMacros :\n\n-M\t\tAffiche toute redfinition de macro.\n-U\t\tIgnore les appels de macros dont le nom n'est pas dfini.\n-P\t\tAjuste le nombre de paramtres des macros lors des appels,\n\t\tconformment  leur dfinition.\n-R\t\tIgnore les appels rcursifs de macro.\n-t\t\tIgnore les commandes de dfinition d'option dans les macros.\n\n\tRemarque :\n\n\t\tToutes les options, hormis -o, -O et -v, fonctionnent\n\t\tcomme des bascules : placer deux fois une option ne change\n\t\tpas le comportement du compilateur.\n\n\nFichiers sources :\n\n\t\tLes diffrents fichiers sont lus dans l'ordre\n\t\tdonn en ligne de commande. - sera quivalent \n\t\tl'entre standard. Si aucun fichier n'est indiqu,\n\t\tl'entre standard sera implicitement dsigne.\n\n");
							break;
						default:
							fprintf(sortie,"(Message non dfini)");
							break;
					}
					break;
				default:
					temporaire=NULL;
					SECURISE(general_copie_speciale(general,T_S(temporaire)));
					SECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(CHARSET_ISO)));
					SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
					SECURISE(general_destruction(T_S(temporaire)));
					break;
			}
			break;
		case T_S_(LANGUE_SCHTROUMPF):
			switch(charset)
			{
				case T_S_(CHARSET_ISO):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Schtroumpf  ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Schtroumpf  ");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"               dans le schtroumpf %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"               inclus depuis le schtroumpf %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Mmoire insuffisante pour la poursuite de la compilation");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Option -%c non reconnue. Utilisez la schtroumpf -h pour obtenir la liste des schtroumpfs disponibles",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Commande %s mal schtroumpfe",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Commande de texte mal schtroumpfe");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Commande #%c mal schtroumpfe",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Commande #%s mal schtroumpfe",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Commande #%d mal schtroumpfe",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Option %s dfinie  l'intrieur de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Redfinition de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Appel de la schtroumpf %s non dfinie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Appel rcursif de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Appel de la schtroumpf %s avec %d schtroumpf(s) au lieu des %d attendu(s)",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Erreur de syntaxe prs du symbole %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Inclusion rcursive du schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Fichier de sortie dj spcifi");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"Impossible d'ouvrir le schtroumpf %s en criture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Impossible d'xcuter PlanFacile dans le rpertoire courant");
							break;
						case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
							fprintf(sortie,"Le chemin menant au schtroumpf %s est invalide",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
							fprintf(sortie,"Le schtroumpf %s est inexistant",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
							fprintf(sortie,"Le schtroumpf %s est un rpertoire ou de type bloc",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Impossible d'ouvrir le schtroumpf %s en lecture",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Impossible d'ouvrir le schtroumpf de nom vide en lecture");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Tentative d'ouverture du schtroumpf %s pour #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"Aucun schtroumpf n'a pu tre ouvert pour #standard");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Redfinition du schtroumpf pour les sections de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Redfinition du schtroumpf par dfaut pour les sections");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Redfinition du schtroumpf pour les schtroumpfs de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Redfinition du schtroumpf par dfaut des schtroumpfs");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Redfinition du schtroumpf de message");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Redfinition de l'entte de schtroumpf");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Redfinition du pied de schtroumpf");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Redfinition du niveau racine");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de section");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de schtroumpf");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du niveau racine");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Impossible de dterminer le niveau racine");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"Redfinition de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
							fprintf(sortie,"Ide de schtroumpf vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
							fprintf(sortie,"Schtroumpf manquante de schtroumpf vide incorrecte");
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
							fprintf(sortie,"Schtroumpf gnrique de schtroumpf vide incorrecte");
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Pertinence de la schtroumpf depuis la schtroumpf %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Indice de schtroumpf manquante incorrect");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Redfinition de la schtroumpf manquante par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Redfinition de la schtroumpf manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Rfrence parente de schtroumpf gnrique incorrecte");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Redfinition de la schtroumpf gnrique par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Redfinition de la schtroumpf gnrique de schtroumpf parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"Dpendance depuis la schtroumpf %s non utilise pour le calcul du plan",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
							fprintf(sortie,"Dpendance depuis la schtroumpf de schtroumpf vide non utilise pour le calcul du plan");
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Impossible de dterminer la schtroumpf racine");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Ajout d'une schtroumpf racine au schtroumpf");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Schtroumpf %s non atteignable depuis la racine du schtroumpf",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
							fprintf(sortie,"Format de section non dfini pour la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
							fprintf(sortie,"Format de schtroumpf non dfini pour la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
							fprintf(sortie,"Schtroumpf manquante d'indice %d non dfinie",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
							fprintf(sortie,"Schtroumpf gnrique de schtroumpf parente %s non dfinie",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
							fprintf(sortie,"Dpendance depuis la schtroumpf %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_VIDE):
							fprintf(sortie,"Dpendance depuis la schtroumpf de schtroumpf vide incorrecte");
							break;
						case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
							fprintf(sortie,"Indice de schtroumpf %s incorrect",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
							fprintf(sortie,"Nom de section de niveau %s indfini",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document gnr par PlanFacile 2.0 : %d schtroumpf(s) traite(s), dont %d manquante(s) et %d gnrique(s), ainsi que %d schtroumpf(s) traite(s) dont %d irrductible(s).",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Schtroumpf %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE):
							fprintf(sortie,"Analyse du schtroumpf source");
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
							fprintf(sortie,"Analyse du schtroumpf source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
							fprintf(sortie,"Inclusion du schtroumpf source %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
							fprintf(sortie,"Fin de l'analyse du schtroumpf inclus");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES):
							fprintf(sortie,"Retouches sur le flux");
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
							fprintf(sortie,"Paramtre d'indice %d schtroumpf",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
							fprintf(sortie,"Macro normale %s dfinie avec %d schtroumpfs",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
							fprintf(sortie,"Macro boucle %s dfinie avec %d schtroumpfs obligatoires",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
							fprintf(sortie,"Dfragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
							fprintf(sortie,"Suppression de la schtroumpf d'inclusion du schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
							fprintf(sortie,"Suppression de la schtroumpf d'inclusion standard");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS):
							fprintf(sortie,"Rduction des schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
							fprintf(sortie,"Recherche des schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
							fprintf(sortie,"Enregistrement de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
							fprintf(sortie,"Abandon de la schtroumpf %s schtroumpfe dans un commentaire",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
							fprintf(sortie,"Abandon de la schtroumpf %s schtroumpfe dans la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
							fprintf(sortie,"Premire recherche des schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
							fprintf(sortie,"Nouvelle recherche des schtroumpfs requise");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
							fprintf(sortie,"Toutes les schtroumpfs ont t trouves");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
							fprintf(sortie,"Rduction des schtroumpfs de slection de code");
							break;
						case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
							fprintf(sortie,"Rduction de la schtroumpf de label %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS):
							fprintf(sortie,"Rduction des schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
							fprintf(sortie,"Macro normale %s schtroumpfe",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
							fprintf(sortie,"Macro boucle %s schtroumpfe",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
							fprintf(sortie,"Remplacement du schtroumpf %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
							fprintf(sortie,"Itration numro %d de la schtroumpf %s",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION):
							fprintf(sortie,"Vrification smantique");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
							fprintf(sortie,"Erreur utilisateur schtroumpfe");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
							fprintf(sortie,"Avertissement utilisateur schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
							fprintf(sortie,"Dfragmentation d'un flux du type %2d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES):
							fprintf(sortie,"Enregistrement des schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
							fprintf(sortie,"Enregistrement des schtroumpfs de section");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
							fprintf(sortie,"Enregistrement du schtroumpf de section par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
							fprintf(sortie,"Enregistrement du schtroumpf de section de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
							fprintf(sortie,"Enregistrement des autres schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
							fprintf(sortie,"Enregistrement du schtroumpf de schtroumpf par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
							fprintf(sortie,"Enregistrement du schtroumpf de schtroumpf de niveau %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
							fprintf(sortie,"Enregistrement du schtroumpf de message");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
							fprintf(sortie,"Enregistrement du schtroumpf d'entte de schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
							fprintf(sortie,"Enregistrement du schtroumpf de pied de schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
							fprintf(sortie,"Slection du niveau %d pour le niveau de la racine",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES):
							fprintf(sortie,"Enregistrement des schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
							fprintf(sortie,"Enregistrement des schtroumpfs prsentes");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
							fprintf(sortie,"Enregistrement de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
							fprintf(sortie,"Enregistrement de la schtroumpf depuis la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
							fprintf(sortie,"Enregistrement des schtroumpfs automatiques");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
							fprintf(sortie,"Enregistrement de la schtroumpf manquante par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
							fprintf(sortie,"Enregistrement de la schtroumpf manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
							fprintf(sortie,"Enregistrement de la schtroumpf gnrique par dfaut");
							break;
						case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
							fprintf(sortie,"Enregistrement de la schtroumpf gnrique de schtroumpf parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
							fprintf(sortie,"Gnration du graphe de schtroumpfs");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
							fprintf(sortie,"Sans schtroumpfs, pas de calcul de plan possible");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
							fprintf(sortie,"Graphe contenant %d schtroumpf(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
							fprintf(sortie,"Graphe contenant %d schtroumpf(s) dont %d inutile(s)",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
							fprintf(sortie,"Recherche de la schtroumpf racine");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
							fprintf(sortie,"Vrification de la topologie du graphe");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
							fprintf(sortie,"Calcul du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
							fprintf(sortie,"Transformation et compltion du plan");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
							fprintf(sortie,"Transformation de la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
							fprintf(sortie,"Transformation d'une schtroumpf de schtroumpf vide");
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
							fprintf(sortie,"Compltion de la schtroumpf depuis la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
							fprintf(sortie,"Compltion de la schtroumpf depuis la schtroumpf de schtroumpf vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE):
							fprintf(sortie,"Gnration du schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
							fprintf(sortie,"Gnration du texte du schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
							fprintf(sortie,"Gnration de l'entte du schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
							fprintf(sortie,"Gnration de la schtroumpf de schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
							fprintf(sortie,"Gnration d'une schtroumpf de schtroumpf vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
							fprintf(sortie,"Gnration d'une schtroumpf irrductible vers la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
							fprintf(sortie,"Gnration d'une schtroumpf irrductible vers une schtroumpf de schtroumpf vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
							fprintf(sortie,"Gnration d'une schtroumpf provenant d'une schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
							fprintf(sortie,"Gnration d'une schtroumpf rductible vers la schtroumpf %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
							fprintf(sortie,"Gnration d'une schtroumpf rductible vers une schtroumpf de schtroumpf vide");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
							fprintf(sortie,"Gnration d'une schtroumpf extrieure d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
							fprintf(sortie,"Gnration d'une liste de schtroumpfs extrieures");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
							fprintf(sortie,"Gnration du pied du schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
							fprintf(sortie,"Production du schtroumpf sur la sortie");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
							fprintf(sortie,"Production du schtroumpf");
							break;
						case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
							fprintf(sortie,"Production des statistiques internes du plan");
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile schtroumpf 2.0.\nUsage : planfacile <schtroumpfs> <schtroumpfs>\n\n\nSchtroumpf :\n\n\tSchtroumpf :\n\n-h\t\tSchtroumpfe cette aide.\n-V\t\tSchtroumpfe la license et le schtroumpf de copie.\n-v\t\tMode schtroumpf. (A placer plusieurs fois, si ncessaire).\n-o <schtroumpf>\tSchtroumpf de sortie. Si cette schtroumpf\n\t\tn'est pas indique, la sortie standard est utilise.\n-a\t\tSchtroumpf  -SICYmgAdDpEcylGNTMUPRt.\n-n\t\tSchtroumpf  -uir.\n-e\t\tTransforme tous les avertissements en schtroumpf.\n-W\t\tSchtroumpfe l'affichage des positions dans le source\n\t\tdes avertissements et des schtroumpfs. (Plus rapide et moins\n\t\tschtroumpf en mmoire)\n-w\t\tSchtroumpfe les schtroumpfs absolus des schtroumpfs sources dans les\n\t\tschtroumpfs du compilateur. (Schtroumpf en mmoire)\n\n\tSchtroumpf :\n\n-S\t\tSchtroumpfe les schtroumpfs sources non ouvrables en lecture.\n-I\t\tSchtroumpfe les inclusions rcursives de schtroumpfs.\n-s\t\tSchtroumpfe le comportement de #standard, et termine sur\n\t\tune erreur en cas d'chec.\n\n\tSchtroumpf :\n\n-O <schtroumpf>\tDfinit une schtroumpf de compilation.\n-u\t\tSchtroumpfe l'affichage des avertissements utilisateurs.\n-C\t\tSchtroumpfe les schtroumpfs mal schtroumpfes dans les schtroumpfs\n\t\tsources.\n\n\tSchtroumpf :\n\n-i\t\tSchtroumpfe l'affichage des redfinitions de schtroumpfs.\n-Y\t\tSchtroumpfe les schtroumpfs dont la schtroumpf est vide.\n-m\t\tSchtroumpfe les schtroumpfs manquantes dont le schtroumpf est incorrect.\n-g\t\tSchtroumpfe les schtroumpfs gnriques dont la schtroumpf  la schtroumpf\n\t\tparente est incorrecte.\n-r\t\tSchtroumpfe l'affichage de l'ajout ventuel d'une schtroumpf\n\t\tracine.\n-A\t\tSchtroumpfe les schtroumpfs automatiques non rsolues.\n\n\tSchtroumpfs et schtroumpfs :\n\n-d\t\tSchtroumpfe les schtroumpfs dont la schtroumpf est incorrecte.\n-D\t\tSchtroumpfe les schtroumpfs non utilises pour le calcul du plan.\n-p\t\tSchtroumpfe les schtroumpfs dont la schtroumpf est incorrecte.\n-E\t\tSchtroumpfe les schtroumpfs extrieures dont le schtroumpf est incorrect.\n\n\tSchtroumpf :\n\n-c\t\tTransmet les commentaires du source dans le schtroumpf.\n-y\t\tSchtroumpfe toute redfinition de schtroumpf.\n-l\t\tSchtroumpfe toute dfinition de schtroumpf dont le schtroumpf est incorrect.\n-G\t\tSchtroumpfe les schtroumpfs dont le schtroumpf de section n'est pas dfini.\n-N\t\tSchtroumpfe les schtroumpfs dont le schtroumpf n'est pas dfini.\n-T\t\tSchtroumpfe les noms de sections dans les schtroumpfs, lorsqu'ils ne\n\t\tsont pas dfinis.\n\n\tSchtroumpf :\n\n-M\t\tSchtroumpfe toute redfinition de schtroumpf.\n-U\t\tSchtroumpfe les appels de schtroumpfs dont le nom n'est pas dfini.\n-P\t\tAjuste le nombre de schtroumpfs des schtroumpfs lors des appels,\n\t\tconformment  leur dfinition.\n-R\t\tSchtroumpfe les appels rcursifs de schtroumpf.\n-t\t\tSchtroumpfe les schtroumpfs de dfinition des schtroumpfs dans les schtroumpfs.\n\n\tSchtroumpf :\n\n\t\tToutes les schtroumpfs, hormis -o, -O et -v, fonctionnent\n\t\tcomme des schtroumpfs : placer deux fois une schtroumpf ne change\n\t\tpas le schtroumpf du compilateur.\n\n\nSchtroumpf :\n\n\t\tLes diffrents schtroumpfs sont lus dans l'ordre\n\t\tdonn en ligne de schtroumpf. - sera quivalent \n\t\tl'entre standard. Si aucun schtroumpf n'est indiqu,\n\t\tl'entre standard sera implicitement dsigne.\n\n");
							break;
						default:
							fprintf(sortie,"(Message non dfini)");
							break;
					}
					break;
				default:
					temporaire=NULL;
					SECURISE(general_copie_speciale(general,T_S(temporaire)));
					SECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(CHARSET_ISO)));
					SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
					SECURISE(general_destruction(T_S(temporaire)));
					break;
			}
			break;
		case T_S_(LANGUE_GRRR):
			switch(charset)
			{
				case T_S_(CHARSET_ISO):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Arghh");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Houla");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            dans ton torchon %s  la rayure %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            inclus depuis le PQ %s  la feuille %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," ! ");
							break;
						case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
							fprintf(sortie,"Je ne travaille pas dans ces conditions");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Y a la merdouille -%c dans la ligne de commande. Pour les bras casss dans ton genre, y'a la merdouille -h pour se cultiver",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"Le programmeur essaye de communiquer  %s ",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_INCORRECTE):
							fprintf(sortie,"Espce de gros dgueulasse ! Arrte de laisser trainer tes %s de partout",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
							fprintf(sortie,"Ehhh ! On n'crit pas n'importe o");
							break;
						case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
							fprintf(sortie,"Arrte de semer des #%c... On dirait le petit poucet",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
							fprintf(sortie,"Tu peux te carrer ton #%s l o on pense tous",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
							fprintf(sortie,"Et le numro complmentaire est le %d. Perdu ! Essaye encore",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OPTION_DANS_MACRO):
							fprintf(sortie,"Tu sais... Il y a une doc. C'est fait pour les crtins dans ton genre, qui justement, ne lisent jamais.\n        Tu saurais alors que dans la macro %s, tu peux pas foutre l'option %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_MACRO):
							fprintf(sortie,"Contrairement  toi, chuis pas con. Suffit me dire les choses une fois. En particulier pour la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_MACRO_INCONNUE):
							fprintf(sortie,"Boule de cristal... Dis-moi quel est l'avenir de la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_MACRO):
							fprintf(sortie,"Non ! Non ! Et non ! On a dit PAS DE RECURSIVITE DE MACRO ! Va apprendre  lire une doc et vire moi la macro %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PARAMETRES_MACRO):
							fprintf(sortie,"Je sais pas o tu as appris  compter, mais chez moi, %d est diffrent de %d.\n        Tu me copieras 100 fois la dfinition de la macro %s",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_ERREUR_SYNTAXE):
							fprintf(sortie,"Et chuis cens dchiffrer a ? Chuis pas Champollion, moi, bordel ! J'arrte les frais  %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_RECURSIVITE_FICHIER):
							fprintf(sortie,"Oh le salaupiaud ! Il essaye de remplir ma RAM, ce con ! Me faire bouffer du %s,  moi... On aura tout vu",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATION_SORTIE):
							fprintf(sortie,"Je peux pas tre au four et au moulin, hein");
							break;
						case T_S_(MESSAGE_OUVERTURE_SORTIE):
							fprintf(sortie,"L, j'ai le rsultat. T'as pas une cartouche d'encre pour copier dans %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
							fprintf(sortie,"Ah ben bonjour l'hospitalit");
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE):
							fprintf(sortie,"Euh, j'ai paum mes bsicles, j'peux pas lire %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
							fprintf(sortie,"Un fichier avec un nom vide... j'aurais tout vu");
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
							fprintf(sortie,"Comme tu sais pas y faire, va falloir encore que je me rabatte sur %s pour #standard",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_OUVERTURE_STANDARD):
							fprintf(sortie,"Tu l'as foutu o, ton fichier de meeeeeeerrdee");
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION):
							fprintf(sortie,"Euh, tu sais, j'ai pas besoin de me refaire une beaut hein... Surtout sur les parties %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
							fprintf(sortie,"Chuis pas Picasso, hein");
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE):
							fprintf(sortie,"Au niveau %d, on se rfre pas deux fois, hein",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
							fprintf(sortie,"Chuis pas encore snile, hein. J'ai encore l'oue fine");
							break;
						case T_S_(MESSAGE_REDEFINITION_MESSAGE):
							fprintf(sortie,"Tu me lourdes avec tes messages");
							break;
						case T_S_(MESSAGE_REDEFINITION_ENTETE):
							fprintf(sortie,"Ca commenait mal... L, c'est pire");
							break;
						case T_S_(MESSAGE_REDEFINITION_PIED):
							fprintf(sortie,"Ca tombe bien, ta conclusion tait  chier");
							break;
						case T_S_(MESSAGE_REDEFINITION_RACINE):
							fprintf(sortie,"Manger les pissenlits par la racine, c'est le pied");
							break;
						case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de section");
							break;
						case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du format de rfrence");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
							fprintf(sortie,"Niveau incorrect pour la dfinition du niveau racine");
							break;
						case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
							fprintf(sortie,"Impossible de dterminer le niveau racine");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE):
							fprintf(sortie,"Redfinition de l'ide %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
							fprintf(sortie,"Pertinence de la dpendance vers l'ide %s incorrecte",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
							fprintf(sortie,"Indice d'ide manquante incorrect");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
							fprintf(sortie,"Redfinition de l'ide manquante par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
							fprintf(sortie,"Redfinition de l'ide manquante d'indice %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
							fprintf(sortie,"Rfrence parente d'ide gnrique incorrecte");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
							fprintf(sortie,"Redfinition de l'ide gnrique par dfaut");
							break;
						case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
							fprintf(sortie,"Redfinition de l'ide gnrique de rfrence parente %s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_DEPENDANCE_INUTILE):
							fprintf(sortie,"Dpendance vers l'ide %s non utilise pour le calcul du plan",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
							fprintf(sortie,"Impossible de dterminer l'ide racine");
							break;
						case T_S_(MESSAGE_AJOUT_RACINE):
							fprintf(sortie,"Ajout d'une ide racine au document");
							break;
						case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
							fprintf(sortie,"Ide %s non atteignable depuis la racine du document",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage : planfacile <options> <fichiers sources>\n\n\nOptions :\n\n\tGnral :\n\n-h\t\tAffiche cette aide.\n-V\t\tAffiche la license et le droit de copie.\n-v\t\tMode verbeux. (A placer plusieurs fois, si ncessaire).\n-o <fichier>\tFichier de sortie. Si cette option\n\t\tn'est pas indique, la sortie standard est utilise.\n-a\t\tEquivalent  -SICmgAdDpEcylGNTMUPRt.\n-n\t\tEquivalent  -uir.\n-e\t\tTransforme tous les avertissements en erreur.\n-W\t\tDsactive l'affichage des positions dans le source\n\t\tdes avertissements et des erreurs. (Plus rapide et moins\n\t\tgourmand en mmoire)\n\n\tFichiers sources :\n\n-S\t\tIgnore les fichiers sources non ouvrables en lecture.\n-I\t\tIgnore les inclusions rcursives de fichiers.\n-s\t\tAffiche le comportement de #standard, et termine sur\n\t\tune erreur en cas d'chec.\n\n\tCompilation :\n\n-O <option>\tDfinit une option de compilation.\n-u\t\tDsactive l'affichage des avertissements utilisateurs.\n-C\t\tIgnore les commandes mal places dans les fichiers\n\t\tsources.\n\n\tIdes :\n\n-i\t\tDsactive l'affichage des redfinitions d'ides.\n-m\t\tIgnore les ides manquantes dont l'indice est incorrect.\n-g\t\tIgnore les ides gnriques dont la rfrence  l'ide\n\t\tparente est incorrecte.\n-r\t\tDsactive l'affichage de l'ajout ventuel d'une ide\n\t\tracine.\n-A\t\tIgnore les ides automatiques non rsolues.\n\n\tDpendances et rfrences :\n\n-d\t\tIgnore les dpendances dont la destination est incorrecte.\n-D\t\tIndique les dpendances non utilises pour le calcul du plan.\n-p\t\tIgnore les dpendances dont la pertinence est incorrecte.\n-E\t\tIgnore les rfrences extrieures dont l'indice est incorrect.\n\n\tStyles :\n\n-c\t\tTransmet les commentaires du source dans le document.\n-y\t\tAffiche toute redfinition de style.\n-l\t\tIgnore toute dfinition de style dont l'indice est incorrect.\n-G\t\tIgnore les ides dont le style de section n'est pas dfini.\n-N\t\tIgnore les rfrences dont le style n'est pas dfini.\n-T\t\tIgnore les noms de sections dans les rfrences, lorsqu'ils ne\n\t\tsont pas dfinis.\n\n\tMacros :\n\n-M\t\tAffiche toute redfinition de macro.\n-U\t\tIgnore les appels de macros dont le nom n'est pas dfini.\n-P\t\tAjuste le nombre de paramtres des macros lors des appels,\n\t\tconformment  leur dfinition.\n-R\t\tIgnore les appels rcursifs de macro.\n-t\t\tIgnore les commandes de dfinition d'option dans les macros.\n\n\tRemarque :\n\n\t\tToutes les options, hormis -o, -O et -v, fonctionnent\n\t\tcomme des bascules : placer deux fois une option ne change\n\t\tpas le comportement du compilateur.\n\n\nFichiers sources :\n\n\t\tLes diffrents fichiers sont lus dans l'ordre\n\t\tdonn en ligne de commande. - sera quivalent \n\t\tl'entre standard. Si aucun fichier n'est indiqu,\n\t\tl'entre standard sera implicitement dsigne.\n\n");
							break;
						default:
							fprintf(sortie,"Boulet...");
							break;
					}
					break;
				default:
					temporaire=NULL;
					SECURISE(general_copie_speciale(general,T_S(temporaire)));
					SECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(CHARSET_ISO)));
					SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
					SECURISE(general_destruction(T_S(temporaire)));
					break;
			}
			break;
		case T_S_(LANGUE_WIN):
			switch(charset)
			{
				case T_S_(CHARSET_ISO):
					switch(message)
					{
						case T_S_(MESSAGE_ERREUR):
							fprintf(sortie,"Erreur   ");
							break;
						case T_S_(MESSAGE_AVERTISSEMENT):
							fprintf(sortie,"Erreur   ");
							break;
						case T_S_(MESSAGE_LOCALISATION):
							fprintf(sortie,"            dans le fichier %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_INCLUSION):
							fprintf(sortie,"            inclus depuis le fichier %s  la ligne %d",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))));
							break;
						case T_S_(MESSAGE_VIRGULE):
							fprintf(sortie,",\n");
							break;
						case T_S_(MESSAGE_POINT):
							fprintf(sortie,".\n");
							break;
						case T_S_(MESSAGE_DOUBLE_POINTS):
							fprintf(sortie," : ");
							break;
						case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
							fprintf(sortie,"Option -%c non reconnue. Utilisez l'option -h pour obtenir la liste des options disponibles",
								*((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_UTILISATEUR):
							fprintf(sortie,"%s",
								((char*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_STATISTIQUES):
							fprintf(sortie,"Document gnr par PlanFacile 2.0 : %d ide(s) traite(s), dont %d manquante(s) et %d gnrique(s), ainsi que %d rfrence(s) traite(s) dont %d irrductible(s).",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(1))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(2))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(3))))),
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(4))))));
							break;
						case T_S_(MESSAGE_VERBEUX):
							fprintf(sortie,"Verbeux %d",
								*((int*)(T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(0))))));
							break;
						case T_S_(MESSAGE_AIDE):
							fprintf(sortie,"PlanFacile version 2.0.\nUsage : planfacile <options> <fichiers sources>\n\n\nOptions :\n\n\tGnral :\n\n-h\t\tAffiche cette aide.\n-V\t\tAffiche la license et le droit de copie.\n-v\t\tMode verbeux. (A placer plusieurs fois, si ncessaire).\n-o <fichier>\tFichier de sortie. Si cette option\n\t\tn'est pas indique, la sortie standard est utilise.\n-a\t\tEquivalent  -SICmgAdDpEcylGNTMUPRt.\n-n\t\tEquivalent  -uir.\n-e\t\tTransforme tous les avertissements en erreur.\n-W\t\tDsactive l'affichage des positions dans le source\n\t\tdes avertissements et des erreurs. (Plus rapide et moins\n\t\tgourmand en mmoire)\n-w\t\tAffiche les chemins absolus des fichiers sources dans les\n\t\tmessages du compilateur. (Gourmand en mmoire)\n\n\tFichiers sources :\n\n-S\t\tIgnore les fichiers sources non ouvrables en lecture.\n-I\t\tIgnore les inclusions rcursives de fichiers.\n-s\t\tAffiche le comportement de #standard, et termine sur\n\t\tune erreur en cas d'chec.\n\n\tCompilation :\n\n-O <option>\tDfinit une option de compilation.\n-u\t\tDsactive l'affichage des avertissements utilisateurs.\n-C\t\tIgnore les commandes mal places dans les fichiers\n\t\tsources.\n\n\tIdes :\n\n-i\t\tDsactive l'affichage des redfinitions d'ides.\n-m\t\tIgnore les ides manquantes dont l'indice est incorrect.\n-g\t\tIgnore les ides gnriques dont la rfrence  l'ide\n\t\tparente est incorrecte.\n-r\t\tDsactive l'affichage de l'ajout ventuel d'une ide\n\t\tracine.\n-A\t\tIgnore les ides automatiques non rsolues.\n\n\tDpendances et rfrences :\n\n-d\t\tIgnore les dpendances dont la source est incorrecte.\n-D\t\tIndique les dpendances non utilises pour le calcul du plan.\n-p\t\tIgnore les dpendances dont la pertinence est incorrecte.\n-E\t\tIgnore les rfrences extrieures dont l'indice est incorrect.\n\n\tStyles :\n\n-c\t\tTransmet les commentaires du source dans le document.\n-y\t\tAffiche toute redfinition de style.\n-l\t\tIgnore toute dfinition de style dont l'indice est incorrect.\n-G\t\tIgnore les ides dont le style de section n'est pas dfini.\n-N\t\tIgnore les rfrences dont le style n'est pas dfini.\n-T\t\tIgnore les noms de sections dans les rfrences, lorsqu'ils ne\n\t\tsont pas dfinis.\n\n\tMacros :\n\n-M\t\tAffiche toute redfinition de macro.\n-U\t\tIgnore les appels de macros dont le nom n'est pas dfini.\n-P\t\tAjuste le nombre de paramtres des macros lors des appels,\n\t\tconformment  leur dfinition.\n-R\t\tIgnore les appels rcursifs de macro.\n-t\t\tIgnore les commandes de dfinition d'option dans les macros.\n\n\tRemarque :\n\n\t\tToutes les options, hormis -o, -O et -v, fonctionnent\n\t\tcomme des bascules : placer deux fois une option ne change\n\t\tpas le comportement du compilateur.\n\n\nFichiers sources :\n\n\t\tLes diffrents fichiers sont lus dans l'ordre\n\t\tdonn en ligne de commande. - sera quivalent \n\t\tl'entre standard. Si aucun fichier n'est indiqu,\n\t\tl'entre standard sera implicitement dsigne.\n\n");
							break;
						default:
							fprintf(sortie,"L'application a rencontr une erreur inattendue\n            dans le module win32rnderr.dll  l'adresse 0x43AF32S6,\n            et va peut-tre se fermer.\n            Tout votre travail non enregistr est perdu.\n            Un rapport d'erreur a t gnr.\n            Vous devriez envoyer ce rapport  Mini$oft");
							break;
					}
					break;
				default:
					temporaire=NULL;
					SECURISE(general_copie_speciale(general,T_S(temporaire)));
					SECURISE(environnement_definition_charset(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(CHARSET_ISO)));
					SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
					SECURISE(general_destruction(T_S(temporaire)));
					break;
			}
			break;
		default:
			temporaire=NULL;
			SECURISE(general_copie_speciale(general,T_S(temporaire)));
			SECURISE(environnement_definition_langue(T_S(CHAMP_STOCKAGE(temporaire , environnement)),T_S_(LANGUE_EN)));
			SECURISE(messages_message(T_S(temporaire),sortie,message,messageparametres));
			SECURISE(general_destruction(T_S(temporaire)));
			break;
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messages_localisation(TRAVAIL(General) general)
{
	/* Dtermine la localisation  partir de la variable
	 * d'environnement $LANG. La dtermination sera
	 * influence par le jeu de langues et de charsets
	 * dfinis dans planfacile.
	 */
	STOCKAGE_SCALAIRE(Chaine) envlang;
	STOCKAGE_SCALAIRE(Chaine) localeslangue=NULL;
	STOCKAGE_SCALAIRE(Chaine) localespays=NULL;
	STOCKAGE_SCALAIRE(Chaine) localescharset=NULL;
	STOCKAGE_SCALAIRE(Chaine) locales;
	COREFERENCE_SCALAIRE(Caractere) indice;
	DEBUTZONESECURISEE
	SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_INCONNUE)));
	SECURISE(environnement_definition_charset(CHAMP_TRAVAIL(general , environnement),T_S_(CHARSET_INCONNU)));
	if((envlang=getenv(T_S_("LANG")))==NULL)
		return RESULTAT_OK;
	locales=strdup(T_S_(envlang));
	localeslangue=locales;
	for(indice=((COREFERENCE_SCALAIRE(Caractere))(locales)) ; S_C_(indice)!='\0' ; indice++)
		switch(T_S_(S_C_(indice)))
		{
			case T_S_('_'):
				S_C_(indice)='\0';
				localespays=((STOCKAGE_SCALAIRE(Chaine))(indice+1));
				break;
			case T_S_('.'):
				S_C_(indice)='\0';
				localescharset=((STOCKAGE_SCALAIRE(Chaine))(indice+1));
			default:
				break;
		}
	if(localeslangue!=NULL)
	{
		if(S_T_(strstr(localeslangue,T_S_("en")))!=NULL)
		{
			SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_EN)));
		}
		else if(S_T_(strstr(localeslangue,T_S_("fr")))!=NULL)
		{
			SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_FR)));
		}
		else if(S_T_(strstr(localeslangue,T_S_("grrr")))!=NULL)
		{
			SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_GRRR)));
		}
		else if(S_T_(strstr(localeslangue,T_S_("neuneu")))!=NULL)
		{
			SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_NEUNEU)));
		}
		else if(S_T_(strstr(localeslangue,T_S_("schtroumpf")))!=NULL)
		{
			SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_SCHTROUMPF)));
		}
		else if(S_T_(strstr(localeslangue,T_S_("win")))!=NULL)
		{
			SECURISE(environnement_definition_langue(CHAMP_TRAVAIL(general , environnement),T_S_(LANGUE_WIN)));
		}
	}
	if(localescharset!=NULL)
	{
		if(S_T_(strstr(localescharset,T_S_("ASCII")))!=NULL)
		{
			SECURISE(environnement_definition_charset(CHAMP_TRAVAIL(general , environnement),T_S_(CHARSET_ASCII)));
		}
		else if(S_T_(strstr(localescharset,T_S_("ISO-8859")))!=NULL)
		{
			SECURISE(environnement_definition_charset(CHAMP_TRAVAIL(general , environnement),T_S_(CHARSET_ISO)));
		}
		else if(S_T_(strstr(localescharset,T_S_("UTF-8")))!=NULL)
		{
			SECURISE(environnement_definition_charset(CHAMP_TRAVAIL(general , environnement),T_S_(CHARSET_UTF8)));
		}
	}
	free(locales);
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messages_parametres(TRAVAIL_SCALAIRE(Message) message , REFERENCE_SCALAIRE(Chaine) parametres)
{
	/* Renvoie les types des paramtres d'un message,
	 * dans leur ordre d'apparition.
	 * Le chaine en question n'a pas  tre libre.
	 */
	switch(message)
	{
		case T_S_(MESSAGE_AIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_AJOUT_RACINE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_AVERTISSEMENT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_COMMANDE_ECHAPPEMENT_INCORRECTE):
			T_R_(parametres)=T_S_("c");
			break;
		case T_S_(MESSAGE_COMMANDE_INCORRECTE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_COMMANDE_MACRO_INCORRECTE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_COMMANDE_PARAMETRE_INCORRECTE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_COMMANDE_TEXTE_INCORRECTE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_DEPENDANCE_INCORRECTE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_DEPENDANCE_INUTILE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_DEPENDANCE_VIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_DEPENDANCE_VIDE_INUTILE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_DOUBLE_POINTS):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_ERREUR):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_ERREUR_SYNTAXE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_IDEE_GENERIQUE_MANQUANTE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_IDEE_GENERIQUE_REFERENCE_VIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_IDEE_MANQUANTE_MANQUANTE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_IDEE_MANQUANTE_REFERENCE_VIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_IDEE_NON_ATTEIGNABLE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_IDEE_REFERENCE_VIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_INCLUSION):
			T_R_(parametres)=T_S_("sd");
			break;
		case T_S_(MESSAGE_INDICE_IDEE_GENERIQUE_INCORRECT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_INDICE_IDEE_MANQUANTE_INCORRECT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_INDICE_REFERENCE_INCORRECT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_LOCALISATION):
			T_R_(parametres)=T_S_("sd");
			break;
		case T_S_(MESSAGE_MACRO_INCONNUE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_MEMOIRE_INSUFFISANTE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_NOM_NIVEAU_INCORRECT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_OPTION_DANS_MACRO):
			T_R_(parametres)=T_S_("ss");
			break;
		case T_S_(MESSAGE_OPTION_LIGNE_COMMANDE):
			T_R_(parametres)=T_S_("c");
			break;
		case T_S_(MESSAGE_OUVERTURE_CHEMIN_INVALIDE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_OUVERTURE_ENTREE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_OUVERTURE_ENTREE_VIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_OUVERTURE_INEXISTANT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_OUVERTURE_REPERTOIRE_COURANT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_OUVERTURE_SORTIE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_OUVERTURE_STANDARD):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_OUVERTURE_STANDARD_SUIVANTE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_OUVERTURE_TYPE_INCORRECT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_PARAMETRES_MACRO):
			T_R_(parametres)=T_S_("sdd");
			break;
		case T_S_(MESSAGE_PERTINENCE_INCORRECTE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_POINT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_RACINE_NIVEAU_INCORRECT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_RACINE_NIVEAU_NON_DEFINI):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_RECURSIVITE_FICHIER):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_RECURSIVITE_MACRO):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_REDEFINITION_ENTETE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_IDEE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_REDEFINITION_IDEE_GENERIQUE_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_REDEFINITION_IDEE_MANQUANTE_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_MACRO):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_REDEFINITION_MESSAGE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_PIED):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_RACINE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_REFERENCE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_REDEFINITION_REFERENCE_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REDEFINITION_SECTION):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_REDEFINITION_SECTION_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REFERENCE_NIVEAU_INCORRECT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_REFERENCE_STYLE_MANQUANT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_SANS_IDEE_ORPHELINE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_SECTION_NIVEAU_INCORRECT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_SECTION_STYLE_MANQUANT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_STATISTIQUES):
			T_R_(parametres)=T_S_("ddddd");
			break;
		case T_S_(MESSAGE_UTILISATEUR):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_UTILISATION_SORTIE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_ANALYSE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_ANALYSE_FININCLUSION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_ANALYSE_INCLUSION):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_ANALYSE_SOURCE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_AUTOMATIQUES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_DEPENDANCE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_GENERIQUE_EXPLICITE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_IDEE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_MANQUANTE_EXPLICITE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_IDEES_PRESENTES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_MACROS):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_MACROS_BOUCLE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_MACROS_ITERATION):
			T_R_(parametres)=T_S_("sd");
			break;
		case T_S_(MESSAGE_VERBEUX_MACROS_NORMALE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_MACROS_PARAMETRE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_COMMENTAIRE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_ENREGISTREMENT):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_MACRO):
			T_R_(parametres)=T_S_("ss");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_OPTIONS):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_FIN):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_NOUVELLE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_RECHERCHE_PREMIERE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_OPTIONS_REDUCTION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_ATTEIGNABLES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_CALCUL):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_DEPENDANCES):
			T_R_(parametres)=T_S_("dd");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_IDEES):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_GRAPHE_VIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_RACINE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_IDEEVIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_PLAN_TRANSFORMATION_REFERENCEVIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES_DEFRAGMENTATION):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES_INCLUDE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_BOUCLE):
			T_R_(parametres)=T_S_("sd");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES_MACRO_NORMALE):
			T_R_(parametres)=T_S_("sd");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES_PARAMETRE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_RETOUCHES_STANDARD):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_DEPREF):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_ENTETE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREF):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_EXTREFS):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEE):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_IDEEVIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_PIED):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRR):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFIRRVIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFRED):
			T_R_(parametres)=T_S_("s");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_GENERATION_REFREDVIDE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_DOCUMENT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_SORTIE_PRODUCTION_STATS):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_AUTRES):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_ENTETE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_MESSAGE):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_PIED):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_RACINE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_REFERENCE_EXPLICITE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_SECTION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_DEFAUT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_STYLES_SECTION_EXPLICITE):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_VERIFICATION):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_VERIFICATION_AVERTISSEMENT):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VERBEUX_VERIFICATION_DEFRAGMENTATION):
			T_R_(parametres)=T_S_("d");
			break;
		case T_S_(MESSAGE_VERBEUX_VERIFICATION_ERREUR):
			T_R_(parametres)=T_S_("");
			break;
		case T_S_(MESSAGE_VIRGULE):
			T_R_(parametres)=T_S_("");
			break;
		default:
			T_R_(parametres)="";
			break;
	}
	return RESULTAT_OK;
}

