/*	Value_Pane

PIRL CVS ID: Value_Pane.java,v 1.8 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2004-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Viewers;

import	PIRL.PVL.*;

import	javax.swing.JTree;
import  javax.swing.event.*;
import	javax.swing.event.TreeSelectionListener;
import	javax.swing.event.TreeSelectionEvent;
import	javax.swing.tree.*;
import	javax.swing.JScrollPane;
import	javax.swing.JFrame;
import  javax.swing.*;
import	java.awt.*;
import	java.awt.event.*;
import	java.io.File;
import	java.io.IOException;
import	java.awt.event.WindowAdapter;
import	java.awt.event.WindowEvent;

/**	A <I>Value_Pane</I> provides a view of an array <I>Value</I>.
<P>
	The display uses a JTree to represent the array of Values. Any Value
	in the array that is itself an array may be expanded to display its
	contents. Each Value is shown as the String provided by the Value's
	<CODE>toString</CODE> method.
<P>
	This Swing GUI can be employed whenever the display of a Value array
	is needed by an application. A <CODE>main</CODE> method is provided
	using this class as an application for viewing the array Values from
	a file containing PVL statements.
<P>
	@see		Value
	@see		JTree
	@author		Bradford Castalia, UA/PIRL
	@version	1.8
*/
public class Value_Pane
	extends JScrollPane
{
private static final String
	ID = "PIRL.Viewers.Value_Pane (1.8 2012/04/16 06:22:59)";

/**	Default tree line style.
*/
public static String		Default_Line_Style
								= Parameter_Pane.Default_Line_Style;

//	The JTree view.
private JTree				Values_Tree;

//	The Value being viewed.
private	Value				The_Value = null;

/*	The Parameter_Pane that created this Value_Pane, if any.

	N.B.: "Enclosed" does not necessarily mean that this
	Value_Pane is actually enclosed in a Parameter_Pane. For example,
	it may be enclosed within a seperate JFrame such as a Value_View.
*/
private Parameter_Pane 		Enclosing_Parameter_Pane = null;


//	DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTORS	= 1 << 0,
	DEBUG_ALL			= -1,

	DEBUG				= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
/**	Creates a Value_Pane from the specified Value.
<P>
	@param	value	The Value to be displayed.
	@throws	PVL_Exception	If the Value is not an <CODE>ARRAY</CODE>
		type. The message is <CODE>BAD_ARGUMENT</CODE>.
*/
public Value_Pane
	(
	Value			value
	)
{
Value (value);
}

/**	Creates a Value_Pane from the specified Value.
<P>
	@param	value	The Value to be displayed.
	@param	enclosing_parameter_pane	The parent Parameter_Pane
		that interacts with this Value_Pane. May be null if there
		is no associated Parameter_Pane.
	@throws	PVL_Exception	If the Value is not an <CODE>ARRAY</CODE>
		type. The message is <CODE>BAD_ARGUMENT</CODE>.
*/
public Value_Pane
	(
	Value			value,
	Parameter_Pane	enclosing_parameter_pane
	)
{
Value (value);
Enclosing_Parameter_Pane = enclosing_parameter_pane;
}

/*==============================================================================
	Acessors
*/
/**	Gets the Value being viewed.
<P>
	@return	The Value viewed in this Value_Pane.
*/
public Value Value ()
{return The_Value;}

/**	Sets the Value to be viewed.
<P>
	@param	value	The new Value to View.
	@return	This Value_Pane.
*/
public Value_Pane Value
	(
	Value		value
	)
{
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	{
	System.out.println (">>> Value_Pane.Value: value -");
	try {value.Write ();}
	catch (Exception e) {}
	}
Value
	container = new Value ();
try {container.Add (value);}
catch (PVL_Exception exception)
	{
	//	This shouldn't happen.
	throw new Error
		("Unable to assemble a container Value!\n\n"
		+ ID + '\n'
		+ exception.getMessage ());
	}
The_Value = value;
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	{
	System.out.println
		("    Value_Pane.Value: container of "
			+ container.getChildCount () + " values -");
	try {container.Write ();}
	catch (Exception e) {}
	}

//	Create the JTree.
Values_Tree = new JTree (container);
Values_Tree.addTreeWillExpandListener (new Tree_Expansion_Listener ());
Values_Tree.setRootVisible (false);
Values_Tree.setShowsRootHandles (true);
((DefaultTreeCellRenderer)Values_Tree.getCellRenderer ())
	.setLeafIcon (null);
Values_Tree.getSelectionModel ().setSelectionMode
        (TreeSelectionModel.SINGLE_TREE_SELECTION);
Line_Style (Default_Line_Style);

//	Add the tree to the enclosing scroll pane. 
setViewportView (Values_Tree);
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	System.out.println ("<<< Value_Pane.Value");
return this;
}

/**	Sets the Value to be viewed.
<P>
	@param	value	The new Value to View.
	@return	This Value_Pane.
	@deprecated	Replaced by {@link #Value(Value)}
*/
public Value_Pane Reload
	(
	Value		value
	)
{return Value (value);}

/**	Gets the "JTree.lineStyle" property currently being used.
<P>
	@return	The "JTree.lineStyle" property String in effect.
*/
public String Line_Style ()
{return (String)Values_Tree.getClientProperty ("JTree.lineStyle");}

/**	Sets the "JTree.lineStyle" property to the specified style.
<P>
	@param	style	The String describing the style to use.
	@see	javax.swing.JComponent#putClientProperty(Object, Object)
*/
public void Line_Style
	(
	String		style
	)
{Values_Tree.putClientProperty ("JTree.lineStyle", style);}

/**	Gets the JTree being used to represent the Value in the display.
<P>
	@return	The JTree viewed in this Value_Pane.
*/
public JTree Tree ()
{return Values_Tree;}

/*=*****************************************************************************
	Tree_Expansion_Listener
*/
/**	A <I>TreeWillExpandListener</I> to handle expand and collapse
	of the Values_Tree.
*/
private class Tree_Expansion_Listener
	implements TreeWillExpandListener
{
/*	The amount of time, in milliseconds, that that must have transpired
	before the top level root row is allowed to collapse.
*/
private static final int	ROOT_PATH_COLLAPSE_DELAY = 50;

//	The Values_Tree path for the top level row.
private TreePath			Root_Path = null;

//	The time when the top level root row was expanded
private long				Root_Path_Expand_Time = 0;


/** Prevents the top level root path from being collapsed within
	{@link #ROOT_PATH_COLLAPSE_DELAY} milliseconds of it having
	been first expanded.
<P>
	@param	event	The TreeExpansionEvent.
*/
public void treeWillCollapse
	(
	TreeExpansionEvent	event
	)
	throws ExpandVetoException
{
if (event.getPath () == Root_Path && 
	System.currentTimeMillis () <
		(Root_Path_Expand_Time + ROOT_PATH_COLLAPSE_DELAY))
	throw new ExpandVetoException (event);
}

/** Registers the Values_Tree row that is expanded with an
	associated Parameter_Pane.
<P>
	The path to the top level root row is set and the  the first time this
	method is used, and 
<P>
	@param	event	The TreeExpansionEvent.
*/
public void treeWillExpand
	(
	TreeExpansionEvent	event
	) 
{
if (Enclosing_Parameter_Pane != null)
	Enclosing_Parameter_Pane.Last_Value_Path_Expanded (event.getPath ());
	
if (Root_Path == null)
	{
	//	Only occurs when the top level root path is expanded.
	Root_Path = event.getPath ();
	Root_Path_Expand_Time = System.currentTimeMillis ();
	}
}

}	//	End of class Tree_Expansion_Listener.

}	//	End of class Value_Pane.
