/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test for pgm.c
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <tests/check/common/pgmcheck.h>
#include <pgm/pgm.h>

/* test init twice */
PGM_START_TEST (test_init_twice)
{
  pgm_init (NULL, NULL);
  pgm_init (NULL, NULL);
  pgm_deinit ();
}
PGM_END_TEST;

/* test deinit twice */
PGM_START_TEST (test_deinit_twice)
{
  pgm_init (NULL, NULL);
  pgm_deinit ();
  pgm_deinit ();
}
PGM_END_TEST;

/* test version functions */
PGM_START_TEST (test_version)
{
  guint major, minor, micro, nano;
  gchar *version;

  pgm_version (&major, &minor, &micro, &nano);
  assert_equals_int (major, PGM_VERSION_MAJOR);
  assert_equals_int (minor, PGM_VERSION_MINOR);
  assert_equals_int (micro, PGM_VERSION_MICRO);
  assert_equals_int (nano, PGM_VERSION_NANO);

  version = pgm_version_string ();
  fail_if (version == NULL, "version string returns NULL");
  g_free (version);

  /* I assume none of these numbers would reach 282828 ever */
  major = minor = micro = nano = 282828;
  ASSERT_CRITICAL (pgm_version (NULL, &minor, &micro, &nano));
  assert_equals_int (minor, 282828);
  assert_equals_int (micro, 282828);
  assert_equals_int (nano,  282828);

  ASSERT_CRITICAL (pgm_version (&major, NULL, &micro, &nano));
  assert_equals_int (major, 282828);
  assert_equals_int (micro, 282828);
  assert_equals_int (nano,  282828);

  ASSERT_CRITICAL (pgm_version (&major, &minor, NULL, &nano));
  assert_equals_int (major, 282828);
  assert_equals_int (minor, 282828);
  assert_equals_int (nano,  282828);

  ASSERT_CRITICAL (pgm_version (&major, &minor, &micro, NULL));
  assert_equals_int (major, 282828);
  assert_equals_int (minor, 282828);
  assert_equals_int (micro, 282828);
}
PGM_END_TEST;

gboolean
do_quit (gpointer data)
{
  pgm_main_quit ();
  return FALSE;
}

gboolean
do_call_main (gpointer data)
{
  pgm_main ();
  pgm_main ();
  return FALSE;
}

PGM_START_TEST (test_main)
{
  pgm_init_check (NULL, NULL);

  g_timeout_add (500, do_quit, NULL);
  pgm_main ();

  g_timeout_add (500, do_call_main, NULL);
  g_timeout_add (1000, do_quit, NULL);
  pgm_main ();
  pgm_deinit ();
}
PGM_END_TEST;

Suite *
pgm_suite (void)
{
  Suite *s = suite_create ("Pgm");
  TCase *tc_chain = tcase_create ("pgm tests");

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_init_twice);
  tcase_add_test (tc_chain, test_deinit_twice);
  tcase_add_test (tc_chain, test_main);
  tcase_add_test (tc_chain, test_version);

  return s;
}

GST_CHECK_MAIN (pgm);
