//-----------------------------------------------------------------------------
/** @file pentobi/qml/MenuRecentFiles.qml
    @author Markus Enzenberger
    @copyright GNU General Public License version 3 or later */
//-----------------------------------------------------------------------------

import QtQuick.Controls 2.4
import "Main.js" as Logic

PentobiMenu {
    title: qsTr("Open Recent")
    enabled: recentFiles.entries.length > 0
    relativeWidth: 19

    function getText(recentFiles, index) {
        if (index >= recentFiles.length)
            return ""
        var text = recentFiles[index].displayName
        if (! text || text === "") {
            text = recentFiles[index].file
            text = text.substring(text.lastIndexOf("/") + 1)
        }
        text = text.replace("\.blksgf", "")
        return text
    }
    function openFile(index) {
        Logic.openRecentFile(recentFiles.entries[index].file,
                             recentFiles.entries[index].displayName)
    }

    // Instantiator in Menu doesn't work reliably with Qt 5.11 or 5.12.0 alpha
    PentobiMenuItem {
        visible: recentFiles.entries.length > 0
        // Invisible menu item still use space in Qt 5.11
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 0)
        onTriggered: openFile(0)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 1
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 1)
        onTriggered: openFile(1)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 2
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 2)
        onTriggered: openFile(2)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 3
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 3)
        onTriggered: openFile(3)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 4
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 4)
        onTriggered: openFile(4)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 5
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 5)
        onTriggered: openFile(5)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 6
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 6)
        onTriggered: openFile(6)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 7
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 7)
        onTriggered: openFile(7)
    }
    PentobiMenuItem {
        visible: recentFiles.entries.length > 8
        height: visible ? implicitHeight : 0
        text: getText(recentFiles.entries, 8)
        onTriggered: openFile(8)
    }
    PentobiMenuSeparator { }
    Action {
        //: Menu item for clearing the recent files list
        text: qsTr("Clear List")
        // recentFiles.clear() must be called after menu is closed because it
        // modifies the menu and otherwise the menu stays visible (tested with
        // Qt 5.15.1)
        onTriggered: Qt.callLater(function() {
            recentFiles.clear(gameModel.file)
        })
    }
}
