MACRO(GENERATE_DOCUMENTATION TARGETNAME DOXYGEN_CONFIG_FILE )
    FIND_PACKAGE(Doxygen)
    SET(DOXYFILE_FOUND false)
    IF(EXISTS ${PROJECT_SOURCE_DIR}/${DOXYGEN_CONFIG_FILE}.in)
        SET(DOXYFILE_FOUND true)
    ENDIF(EXISTS ${PROJECT_SOURCE_DIR}/${DOXYGEN_CONFIG_FILE}.in)
    IF( DOXYGEN_FOUND )
        IF( DOXYFILE_FOUND )
            set(ARGV_  ${ARGV})
            list(REMOVE_AT ARGV_ 0)
            foreach(A_ ${ARGV_} )
                if (A_ MATCHES "DOXYVAR_.*")
                    set(D_ ${A_})
                elseif(A_ MATCHES "DEPENDS")
                    set(D_ ${A_})
                else()
                    if (NOT "" STREQUAL "${${D_}}")
                        set(${D_} "${${D_}} ${A_}")
                    else()
                        set(${D_} ${A_})
                    endif()
                endif()
            endforeach(A_)
            ADD_CUSTOM_TARGET( ${TARGETNAME} ALL
                COMMAND ${CMAKE_COMMAND} -E chdir ${PROJECT_SOURCE_DIR} ${DOXYGEN_EXECUTABLE} "${PROJECT_BINARY_DIR}/${DOXYGEN_CONFIG_FILE}"
                DEPENDS ${DEPENDS}
            )
            configure_file(${DOXYGEN_CONFIG_FILE}.in ${DOXYGEN_CONFIG_FILE} ESACPE_QUOTES @ONLY)
        ELSE( DOXYFILE_FOUND )
            MESSAGE( STATUS "Doxygen configuration file not found Documentation will not be generated" )
        ENDIF( DOXYFILE_FOUND )
    ELSE(DOXYGEN_FOUND)
        MESSAGE(STATUS "Doxygen not found Documentation will not be generated")
    ENDIF(DOXYGEN_FOUND)
ENDMACRO(GENERATE_DOCUMENTATION)
