Index: patroni/patroni/validator.py
===================================================================
--- patroni.orig/patroni/validator.py
+++ patroni/patroni/validator.py
@@ -341,13 +341,6 @@ schema = Schema({
           "port": lambda i: assert_(int(i) <= 65535),
           Optional("pool_interval"): int
           },
-      "raft": {
-          "self_addr": validate_connect_address,
-          Optional("bind_addr"): validate_host_port_listen,
-          "partner_addrs": validate_host_port_list,
-          Optional("data_dir"): str,
-          Optional("password"): str
-          },
       "zookeeper": {
           "hosts": Or(comma_separated_host_port, [validate_host_port]),
           },
Index: patroni/tests/test_validator.py
===================================================================
--- patroni.orig/tests/test_validator.py
+++ patroni/tests/test_validator.py
@@ -41,13 +41,6 @@ config = {
         "port": 4000,
         "pool_interval": 1000
     },
-    "raft": {
-        "self_addr": "127.0.0.1:2222",
-        "bind_addr": "0.0.0.0:2222",
-        "partner_addrs": ["127.0.0.1:2223", "127.0.0.1:2224"],
-        "data_dir": "/",
-        "password": "12345"
-    },
     "zookeeper": {
         "hosts":  "127.0.0.1:3379,127.0.0.1:3380"
     },
@@ -149,7 +142,7 @@ class TestValidator(unittest.TestCase):
     def test_complete_config(self, mock_out, mock_err):
         schema(config)
         output = mock_out.getvalue()
-        self.assertEqual(['postgresql.bin_dir', 'raft.bind_addr', 'raft.self_addr'], parse_output(output))
+        self.assertEqual(['postgresql.bin_dir'], parse_output(output))
 
     def test_bin_dir_is_file(self, mock_out, mock_err):
         files.append(config["postgresql"]["data_dir"])
@@ -161,8 +154,7 @@ class TestValidator(unittest.TestCase):
         schema(c)
         output = mock_out.getvalue()
         self.assertEqual(['etcd.hosts.1', 'etcd.hosts.2', 'kubernetes.pod_ip', 'postgresql.bin_dir',
-                          'postgresql.data_dir', 'raft.bind_addr', 'raft.self_addr',
-                          'restapi.connect_address'], parse_output(output))
+                          'postgresql.data_dir', 'restapi.connect_address'], parse_output(output))
 
     @patch('socket.inet_pton', Mock(), create=True)
     def test_bin_dir_is_empty(self, mock_out, mock_err):
@@ -178,8 +170,8 @@ class TestValidator(unittest.TestCase):
         with patch('patroni.validator.open', mock_open(read_data='9')):
             schema(c)
         output = mock_out.getvalue()
-        self.assertEqual(['consul.host', 'etcd.host', 'postgresql.bin_dir', 'postgresql.data_dir', 'postgresql.listen',
-                          'raft.bind_addr', 'raft.self_addr', 'restapi.connect_address'], parse_output(output))
+        self.assertEqual(['consul.host', 'etcd.host', 'postgresql.bin_dir', 'postgresql.data_dir',
+                          'postgresql.listen', 'restapi.connect_address'], parse_output(output))
 
     @patch('subprocess.check_output', Mock(return_value=b"postgres (PostgreSQL) 12.1"))
     def test_data_dir_contains_pg_version(self, mock_out, mock_err):
@@ -197,7 +189,7 @@ class TestValidator(unittest.TestCase):
         with patch('patroni.validator.open', mock_open(read_data='12')):
             schema(config)
         output = mock_out.getvalue()
-        self.assertEqual(['raft.bind_addr', 'raft.self_addr'], parse_output(output))
+        self.assertEqual([], parse_output(output))
 
     @patch('subprocess.check_output', Mock(return_value=b"postgres (PostgreSQL) 12.1"))
     def test_pg_version_missmatch(self, mock_out, mock_err):
@@ -212,8 +204,7 @@ class TestValidator(unittest.TestCase):
         with patch('patroni.validator.open', mock_open(read_data='11')):
             schema(c)
         output = mock_out.getvalue()
-        self.assertEqual(['etcd.hosts', 'postgresql.data_dir',
-                          'raft.bind_addr', 'raft.self_addr'], parse_output(output))
+        self.assertEqual(['etcd.hosts', 'postgresql.data_dir'], parse_output(output))
 
     @patch('subprocess.check_output', Mock(return_value=b"postgres (PostgreSQL) 12.1"))
     def test_pg_wal_doesnt_exist(self, mock_out, mock_err):
@@ -226,7 +217,7 @@ class TestValidator(unittest.TestCase):
         with patch('patroni.validator.open', mock_open(read_data='11')):
             schema(c)
         output = mock_out.getvalue()
-        self.assertEqual(['postgresql.data_dir', 'raft.bind_addr', 'raft.self_addr'], parse_output(output))
+        self.assertEqual(['postgresql.data_dir'], parse_output(output))
 
     def test_data_dir_is_empty_string(self, mock_out, mock_err):
         directories.append(config["postgresql"]["data_dir"])
@@ -238,5 +229,5 @@ class TestValidator(unittest.TestCase):
         c["postgresql"]["bin_dir"] = ""
         schema(c)
         output = mock_out.getvalue()
-        self.assertEqual(['kubernetes', 'postgresql.bin_dir', 'postgresql.data_dir',
-                          'postgresql.pg_hba', 'raft.bind_addr', 'raft.self_addr'], parse_output(output))
+        self.assertEqual(['kubernetes', 'postgresql.bin_dir',
+                          'postgresql.data_dir', 'postgresql.pg_hba'], parse_output(output))
