/* $Id$

Copyright (C) 2000-2004  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

/*******************************************************************/
/*                                                                 */
/*                DECLARATIONS of PUBLIC FUNCTIONS                 */
/*                                                                 */
/*******************************************************************/
#include "parinf.h"

/* OBSOLETE */
GEN     bernvec(long nomb);
GEN     buchimag(GEN D, GEN c1, GEN c2, GEN gCO);
GEN     buchreal(GEN D, GEN gsens, GEN c1, GEN c2, GEN gRELSUP, long prec);
GEN     zidealstar(GEN nf, GEN x);
GEN     zidealstarinit(GEN nf, GEN x);
GEN     zidealstarinitgen(GEN nf, GEN x);
GEN     rootmod(GEN f, GEN p);
GEN     rootmod2(GEN f, GEN p);
GEN     factmod(GEN f, GEN p);
GEN     simplefactmod(GEN f, GEN p);
GEN     listcreate(void);
void    listkill(GEN list);
GEN     discrayabs(GEN bnr,GEN subgroup);
GEN     discrayabscond(GEN bnr,GEN subgroup);
GEN     discrayrel(GEN bnr,GEN subgroup);
GEN     discrayrelcond(GEN bnr,GEN subgroup);
GEN     isprincipalforce(GEN bnf,GEN x);
GEN     isprincipalgen(GEN bnf, GEN x);
GEN     isprincipalgenforce(GEN bnf,GEN x);

/* F2x.c */

GEN     F2c_to_ZC(GEN x);
GEN     F2m_to_ZM(GEN z);
void    F2v_add_inplace(GEN x, GEN y);
GEN     F2x_1_add(GEN y);
GEN     F2x_add(GEN x, GEN y);
long    F2x_degree(GEN x);
GEN     F2x_deriv(GEN x);
GEN     F2x_divrem(GEN x, GEN y, GEN *pr);
GEN     F2x_extgcd(GEN a, GEN b, GEN *ptu, GEN *ptv);
GEN     F2x_gcd(GEN a, GEN b);
GEN     F2x_mul(GEN x, GEN y);
GEN     F2x_rem(GEN x, GEN y);
GEN     F2x_sqr(GEN x);
GEN     F2x_to_F2v(GEN x, long n);
GEN     F2x_to_Flx(GEN x);
GEN     F2x_to_ZX(GEN x);
GEN     F2xC_to_ZXC(GEN x);
GEN     F2xV_to_F2m(GEN v, long n);
GEN     F2xq_conjvec(GEN x, GEN T);
GEN     F2xq_div(GEN x,GEN y,GEN T);
GEN     F2xq_inv(GEN x, GEN T);
GEN     F2xq_invsafe(GEN x, GEN T);
GEN     F2xq_log(GEN a, GEN g, GEN ord, GEN T);
GEN     F2xq_matrix_pow(GEN y, long n, long m, GEN P);
GEN     F2xq_mul(GEN x, GEN y, GEN pol);
GEN     F2xq_order(GEN a, GEN ord, GEN T);
GEN     F2xq_pow(GEN x, GEN n, GEN pol);
GEN     F2xq_powers(GEN x, long l, GEN T);
GEN     F2xq_sqr(GEN x,GEN pol);
GEN     F2xq_sqrt(GEN a, GEN T);
GEN     F2xq_sqrtn(GEN a, GEN n, GEN T, GEN *zeta);
ulong   F2xq_trace(GEN x, GEN T);
GEN     Flm_to_F2m(GEN x);
GEN     Flv_to_F2v(GEN x);
GEN     Flx_to_F2x(GEN x);
GEN     Z_to_F2x(GEN x, long sv);
GEN     ZM_to_F2m(GEN x);
GEN     ZV_to_F2v(GEN x);
GEN     ZX_to_F2x(GEN x);
GEN     ZXX_to_F2xX(GEN B, long v);
GEN     gener_F2xq(GEN T, GEN *po);
GEN     random_F2x(long d, long vs);

/* Flx.c */

GEN     Fl_to_Flx(ulong x, long sv);
GEN     Flc_to_ZC(GEN z);
GEN     Flm_to_FlxV(GEN x, long sv);
GEN     Flm_to_FlxX(GEN x, long v,long w);
GEN     Flm_to_ZM(GEN z);
GEN     Flv_to_Flx(GEN x, long vs);
GEN     Flv_to_ZV(GEN z);
GEN     Flv_polint(GEN xa, GEN ya, ulong p, long vs);
GEN     Flv_roots_to_pol(GEN a, ulong p, long vs);
GEN     Fly_to_FlxY(GEN B, long v);
GEN     Flx_Fl_add(GEN y, ulong x, ulong p);
GEN     Flx_Fl_mul(GEN y, ulong x, ulong p);
GEN     Flx_Fl_mul_to_monic(GEN y, ulong x, ulong p);
GEN     Flx_add(GEN x, GEN y, ulong p);
GEN     Flx_deflate(GEN x0, long d);
GEN     Flx_deriv(GEN z, ulong p);
GEN     Flx_div_by_X_x(GEN a, ulong x, ulong p, ulong *rem);
GEN     Flx_divrem(GEN x, GEN y, ulong p, GEN *pr);
ulong   Flx_eval(GEN x, ulong y, ulong p);
GEN     Flx_extgcd(GEN a, GEN b, ulong p, GEN *ptu, GEN *ptv);
ulong   Flx_extresultant(GEN a, GEN b, ulong p, GEN *ptU, GEN *ptV);
GEN     Flx_gcd(GEN a, GEN b, ulong p);
GEN     Flx_halfgcd(GEN a, GEN b, ulong p);
GEN     Flx_inflate(GEN x0, long d);
GEN     Flx_invMontgomery(GEN T, ulong p);
int     Flx_is_squarefree(GEN z, ulong p);
GEN     Flx_mul(GEN x, GEN y, ulong p);
GEN     Flx_neg(GEN x, ulong p);
GEN     Flx_neg_inplace(GEN x, ulong p);
GEN     Flx_normalize(GEN z, ulong p);
GEN     Flx_pow(GEN x, long n, ulong p);
GEN     Flx_recip(GEN x);
GEN     Flx_red(GEN z, ulong p);
GEN     Flx_rem_Montgomery(GEN x, GEN mg, GEN T, ulong p);
GEN     Flx_rem(GEN x, GEN y, ulong p);
GEN     Flx_renormalize(GEN x, long l);
ulong   Flx_resultant(GEN a, GEN b, ulong p);
GEN     Flx_shift(GEN a, long n);
GEN     Flx_sqr(GEN x, ulong p);
GEN     Flx_sub(GEN x, GEN y, ulong p);
GEN     Flx_to_Flv(GEN x, long N);
GEN     Flx_to_ZX(GEN z);
GEN     Flx_to_ZX_inplace(GEN z);
long    Flx_val(GEN x);
long    Flx_valrem(GEN x, GEN *Z);
GEN     FlxC_to_ZXC(GEN x);
GEN     FlxM_to_ZXM(GEN z);
GEN     FlxV_Flc_mul(GEN V, GEN W, ulong p);
GEN     FlxV_to_Flm(GEN v, long n);
GEN     FlxX_add(GEN P, GEN Q, ulong p);
GEN     FlxX_renormalize(GEN x, long lx);
GEN     FlxX_shift(GEN a, long n);
GEN     FlxX_to_Flm(GEN v, long n);
GEN     FlxX_to_ZXX(GEN B);
GEN     FlxY_Flx_div(GEN x, GEN y, ulong p);
GEN     FlxYqQ_pow(GEN x, GEN n, GEN S, GEN T, ulong p);
GEN     Flxq_charpoly(GEN x, GEN T, ulong p);
GEN     Flxq_conjvec(GEN x, GEN T, ulong p);
GEN     Flxq_div(GEN x, GEN y, GEN T, ulong p);
GEN     Flxq_inv(GEN x,GEN T,ulong p);
GEN     Flxq_invsafe(GEN x, GEN T, ulong p);
int     Flxq_issquare(GEN x, GEN T, ulong p);
GEN     Flxq_log(GEN a, GEN g, GEN ord, GEN T, ulong p);
GEN     Flxq_matrix_pow(GEN y, long n, long m, GEN P, ulong l);
GEN     Flxq_minpoly(GEN x, GEN T, ulong p);
GEN     Flxq_mul(GEN x, GEN y, GEN T, ulong p);
ulong   Flxq_norm(GEN x, GEN T, ulong p);
GEN     Flxq_order(GEN a, GEN ord, GEN T, ulong p);
GEN     Flxq_pow(GEN x, GEN n, GEN T, ulong p);
GEN     Flxq_powers(GEN x, long l, GEN T, ulong p);
GEN     Flxq_sqr(GEN y,GEN T,ulong p);
GEN     Flxq_sqrtn(GEN a, GEN n, GEN T, ulong p, GEN *zetan);
ulong   Flxq_trace(GEN x, GEN T, ulong p);
GEN     FlxqV_roots_to_pol(GEN V, GEN T, ulong p, long v);
GEN     FlxqX_Flxq_mul(GEN P, GEN U, GEN T, ulong p);
GEN     FlxqX_Flxq_mul_to_monic(GEN P, GEN U, GEN T, ulong p);
GEN     FlxqX_divrem(GEN x, GEN y, GEN T, ulong p, GEN *pr);
GEN     FlxqX_extgcd(GEN a, GEN b, GEN T, ulong p, GEN *ptu, GEN *ptv);
GEN     FlxqX_gcd(GEN P, GEN Q, GEN T, ulong p);
GEN     FlxqX_mul(GEN x, GEN y, GEN T, ulong p);
GEN     FlxqX_normalize(GEN z, GEN T, ulong p);
GEN     FlxqX_red(GEN z, GEN T, ulong p);
GEN     FlxqX_safegcd(GEN P, GEN Q, GEN T, ulong p);
GEN     FlxqX_sqr(GEN x, GEN T, ulong p);
GEN     FlxqXQ_inv(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXQ_invsafe(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXQ_mul(GEN x, GEN y, GEN S, GEN T, ulong p);
GEN     FlxqXQ_pow(GEN x, GEN n, GEN S, GEN T, ulong p);
GEN     FlxqXQ_sqr(GEN x, GEN S, GEN T, ulong p);
GEN     FlxqXV_prod(GEN V, GEN T, ulong p);
GEN     RgX_to_Flx(GEN x, ulong p);
GEN     Z_to_Flx(GEN x, ulong p, long v);
GEN     ZX_to_Flx(GEN x, ulong p);
GEN     ZXV_to_FlxV(GEN v, ulong p);
GEN     ZXX_to_FlxX(GEN B, ulong p, long v);
GEN     ZXXV_to_FlxXV(GEN V, ulong p, long v);
GEN     gener_Flxq(GEN T, ulong p, GEN *o);
GEN     pol1_FlxX(long v, long sv);
GEN     random_Flx(long d1, long v, ulong p);

/* FpE.c */

GEN     FpE_add(GEN P, GEN Q, GEN a4, GEN p);
GEN     FpE_dbl(GEN P, GEN a4, GEN p);
GEN     FpE_neg(GEN P, GEN p);
GEN     FpE_order(GEN z, GEN o, GEN a4, GEN p);
GEN     FpE_mul(GEN P, GEN n, GEN a4, GEN p);
GEN     FpE_sub(GEN P, GEN Q, GEN a4, GEN p);
GEN     FpE_tatepairing(GEN t, GEN s, GEN m, GEN a4, GEN p);
GEN     FpE_weilpairing(GEN t, GEN s, GEN m, GEN a4, GEN p);
GEN     random_FpE(GEN a4, GEN a6, GEN p);

/* FpX.c */

GEN     Fp_FpX_sub(GEN x, GEN y, GEN p);
GEN     Fp_FpXQ_log(GEN a, GEN g, GEN ord, GEN T, GEN p);
GEN     FpV_inv(GEN x, GEN p);
GEN     FpV_roots_to_pol(GEN V, GEN p, long v);
GEN     FpX_Fp_add(GEN x, GEN y, GEN p);
GEN     FpX_Fp_add_shallow(GEN y,GEN x,GEN p);
GEN     FpX_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpX_Fp_mul_to_monic(GEN y,GEN x,GEN p);
GEN     FpX_Fp_sub(GEN x, GEN y, GEN p);
GEN     FpX_Fp_sub_shallow(GEN y,GEN x,GEN p);
GEN     FpX_add(GEN x, GEN y, GEN p);
GEN     FpX_center(GEN x, GEN p, GEN pov2);
GEN     FpX_chinese_coprime(GEN x,GEN y,GEN Tx,GEN Ty,GEN Tz,GEN p);
GEN     FpX_deriv(GEN x, GEN p);
GEN     FpX_divrem(GEN x, GEN y, GEN p, GEN *pr);
GEN     FpX_div_by_X_x(GEN a, GEN x, GEN p, GEN *r);
GEN     FpX_eval(GEN x,GEN y,GEN p);
GEN     FpX_extgcd(GEN x, GEN y, GEN p, GEN *ptu, GEN *ptv);
GEN     FpX_gcd(GEN x, GEN y, GEN p);
GEN     FpX_halfgcd(GEN x, GEN y, GEN p);
GEN     FpX_invMontgomery(GEN T, GEN p);
int     FpX_is_squarefree(GEN f, GEN p);
GEN     FpX_mul(GEN x, GEN y, GEN p);
GEN     FpX_neg(GEN x, GEN p);
GEN     FpX_normalize(GEN z, GEN p);
GEN     FpX_red(GEN z, GEN p);
GEN     FpX_rem(GEN x, GEN y, GEN p);
GEN     FpX_rem_Montgomery(GEN x, GEN mg, GEN T, GEN p);
GEN     FpX_rescale(GEN P, GEN h, GEN p);
GEN     FpX_resultant(GEN a, GEN b, GEN p);
GEN     FpX_sqr(GEN x, GEN p);
GEN     FpX_sub(GEN x, GEN y, GEN p);
long    FpX_valrem(GEN x0, GEN t, GEN p, GEN *py);
GEN     FpXQ_charpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_conjvec(GEN x, GEN T, GEN p);
GEN     FpXQ_div(GEN x,GEN y,GEN T,GEN p);
GEN     FpXQ_inv(GEN x,GEN T,GEN p);
GEN     FpXQ_invsafe(GEN x, GEN T, GEN p);
int     FpXQ_issquare(GEN x, GEN T, GEN p);
GEN     FpXQ_log(GEN a, GEN g, GEN ord, GEN T, GEN p);
GEN     FpXQ_matrix_pow(GEN y, long n, long m, GEN P, GEN l);
GEN     FpXQ_minpoly(GEN x, GEN T, GEN p);
GEN     FpXQ_mul(GEN y,GEN x,GEN T,GEN p);
GEN     FpXQ_norm(GEN x, GEN T, GEN p);
GEN     FpXQ_order(GEN a, GEN ord, GEN T, GEN p);
GEN     FpXQ_pow(GEN x, GEN n, GEN T, GEN p);
GEN     FpXQ_powers(GEN x, long l, GEN T, GEN p);
GEN     FpXQ_red(GEN x, GEN T, GEN p);
GEN     FpXQ_sqr(GEN y, GEN T, GEN p);
GEN     FpXQ_sqrtn(GEN a, GEN n, GEN T, GEN p, GEN *zetan);
GEN     FpXQ_trace(GEN x, GEN T, GEN p);
GEN     FpXQC_to_mod(GEN z, GEN T, GEN p);
GEN     FpXV_prod(GEN V, GEN p);
GEN     FpXV_red(GEN z, GEN p);
GEN     FqV_inv(GEN x, GEN T, GEN p);
GEN     gener_FpXQ(GEN T, GEN p, GEN *o);
GEN     random_FpX(long d, long v, GEN p);

/* FpV.c */

GEN     Flc_Fl_div(GEN x, ulong y, ulong p);
void    Flc_Fl_div_inplace(GEN x, ulong y, ulong p);
GEN     Flc_Fl_mul(GEN x, ulong y, ulong p);
void    Flc_Fl_mul_inplace(GEN x, ulong y, ulong p);
GEN     Flm_Fl_mul(GEN y, ulong x, ulong p);
void    Flm_Fl_mul_inplace(GEN y, ulong x, ulong p);
GEN     Flm_Flc_mul(GEN x, GEN y, ulong p);
GEN     Flm_mul(GEN x, GEN y, ulong p);
GEN     Flm_transpose(GEN x);
GEN     Flv_add(GEN x, GEN y, ulong p);
void    Flv_add_inplace(GEN x, GEN y, ulong p);
ulong   Flv_dotproduct(GEN x, GEN y, ulong p);
GEN     Flv_sub(GEN x, GEN y, ulong p);
void    Flv_sub_inplace(GEN x, GEN y, ulong p);
ulong   Flv_sum(GEN x, ulong p);
GEN     Fp_to_mod(GEN z, GEN p);
GEN     FpC_FpV_mul(GEN x, GEN y, GEN p);
GEN     FpC_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpC_center(GEN z, GEN p, GEN pov2);
GEN     FpC_red(GEN z, GEN p);
GEN     FpC_to_mod(GEN z, GEN p);
GEN     FpM_FpC_mul(GEN x, GEN y, GEN p);
GEN     FpM_FpC_mul_FpX(GEN x, GEN y, GEN p, long v);
GEN     FpM_center(GEN z, GEN p, GEN pov2);
GEN     FpM_mul(GEN x, GEN y, GEN p);
GEN     FpM_red(GEN z, GEN p);
GEN     FpM_to_mod(GEN z, GEN p);
GEN     FpC_add(GEN x, GEN y, GEN p);
GEN     FpC_sub(GEN x, GEN y, GEN p);
GEN     FpV_add(GEN x, GEN y, GEN p);
GEN     FpV_sub(GEN x, GEN y, GEN p);
GEN     FpV_dotproduct(GEN x, GEN y, GEN p);
GEN     FpV_dotsquare(GEN x, GEN p);
GEN     FpV_red(GEN z, GEN p);
GEN     FpV_to_mod(GEN z, GEN p);
GEN     FpX_to_mod(GEN z, GEN p);

/* RgV.c */

GEN     RgC_Rg_add(GEN x, GEN y);
GEN     RgC_Rg_div(GEN x, GEN y);
GEN     RgC_Rg_mul(GEN x, GEN y);
GEN     RgC_RgM_mul(GEN x, GEN y);
GEN     RgC_RgV_mul(GEN x, GEN y);
GEN     RgC_add(GEN x, GEN y);
GEN     RgC_neg(GEN x);
GEN     RgC_sub(GEN x, GEN y);
GEN     RgM_Rg_add(GEN x, GEN y);
GEN     RgM_Rg_add_shallow(GEN x, GEN y);
GEN     RgM_Rg_div(GEN x, GEN y);
GEN     RgM_Rg_mul(GEN x, GEN y);
GEN     RgM_RgC_mul(GEN x, GEN y);
GEN     RgM_RgV_mul(GEN x, GEN y);
GEN     RgM_add(GEN x, GEN y);
GEN     RgM_det_triangular(GEN x);
int     RgM_isdiagonal(GEN x);
int     RgM_isidentity(GEN x);
int     RgM_isscalar(GEN x, GEN s);
GEN     RgM_mul(GEN x, GEN y);
GEN     RgM_neg(GEN x);
GEN     RgM_powers(GEN x, long l);
GEN     RgM_sqr(GEN x);
GEN     RgM_sub(GEN x, GEN y);
GEN     RgM_zc_mul(GEN x, GEN y);
GEN     RgM_zm_mul(GEN x, GEN y);
GEN     RgV_RgM_mul(GEN x, GEN y);
GEN     RgV_RgC_mul(GEN x, GEN y);
GEN     RgV_Rg_mul(GEN x, GEN y);
GEN     RgV_add(GEN x, GEN y);
GEN     RgV_dotproduct(GEN x, GEN y);
GEN     RgV_dotsquare(GEN x);
long    RgV_isin(GEN v, GEN x);
GEN     RgV_neg(GEN x);
GEN     RgV_sub(GEN x, GEN y);
GEN     RgV_sum(GEN v);
GEN     RgV_sumpart(GEN v, long n);
GEN     RgV_sumpart2(GEN v, long m, long n);
GEN     RgV_zc_mul(GEN x, GEN y);
GEN     RgV_zm_mul(GEN x, GEN y);
int     isdiagonal(GEN x);
GEN     matid(long n);
GEN     matid_Flm(long n);
GEN     scalarcol(GEN x, long n);
GEN     scalarcol_shallow(GEN x, long n);
GEN     scalarmat(GEN x, long n);
GEN     scalarmat_shallow(GEN x, long n);
GEN     scalarmat_s(long x, long n);

/* RgX.c */

GEN     QX_ZXQV_eval(GEN P, GEN V, GEN dV);
GEN     QXQ_powers(GEN a, long n, GEN T);
GEN     QXQV_to_mod(GEN V, GEN T);
GEN     QXQXV_to_mod(GEN V, GEN T);
GEN     RgM_to_RgXV(GEN x, long v);
GEN     RgM_to_RgXX(GEN x, long v,long w);
GEN     RgV_to_RgX(GEN x, long v);
GEN     RgXQC_red(GEN P, GEN T);
GEN     RgXQV_red(GEN P, GEN T);
GEN     RgXQX_RgXQ_mul(GEN x, GEN y, GEN T);
GEN     RgXQX_divrem(GEN x,GEN y,GEN T,GEN *r);
GEN     RgXQX_mul(GEN x,GEN y,GEN T);
GEN     RgXQX_pseudodivrem(GEN x, GEN y, GEN T, GEN *ptr);
GEN     RgXQX_pseudorem(GEN x, GEN y, GEN T);
GEN     RgXQX_red(GEN P, GEN T);
GEN     RgXQX_sqr(GEN x, GEN T);
GEN     RgXQX_translate(GEN P, GEN c, GEN T);
GEN     RgXQ_matrix_pow(GEN y, long n, long m, GEN P);
GEN     RgXQ_norm(GEN x, GEN T);
GEN     RgXQ_pow(GEN x, GEN n, GEN T);
GEN     RgXQ_powu(GEN x, ulong n, GEN T);
GEN     RgXQ_powers(GEN x, long l, GEN T);
GEN     RgXV_to_RgM(GEN v, long n);
GEN     RgXV_unscale(GEN v, GEN h);
GEN     RgXX_to_RgM(GEN v, long n);
GEN     RgXY_swap(GEN x, long n, long w);
GEN     RgX_RgXQ_eval(GEN f, GEN x, GEN T);
GEN     RgX_RgXQV_eval(GEN P, GEN V, GEN T);
GEN     RgX_Rg_add(GEN y, GEN x);
GEN     RgX_Rg_add_shallow(GEN y, GEN x);
GEN     RgX_Rg_div(GEN y, GEN x);
GEN     RgX_Rg_divexact(GEN x, GEN y);
GEN     RgX_Rg_mul(GEN y, GEN x);
GEN     RgX_Rg_sub(GEN y, GEN x);
GEN     RgX_add(GEN x, GEN y);
GEN     RgX_deflate(GEN x0, long d);
GEN     RgX_deriv(GEN x);
GEN     RgX_div_by_X_x(GEN a, GEN x, GEN *r);
GEN     RgX_divrem(GEN x,GEN y,GEN *r);
GEN     RgX_divs(GEN y, long x);
long    RgX_equal(GEN x, GEN y);
long    RgX_equal_var(GEN x, GEN y);
GEN     RgX_get_0(GEN x);
GEN     RgX_get_1(GEN x);
GEN     RgX_inflate(GEN x0, long d);
GEN     RgX_modXn_shallow(GEN a, long n);
GEN     RgX_mul(GEN x,GEN y);
GEN     RgX_mulXn(GEN x, long d);
GEN     RgX_muls(GEN y, long x);
GEN     RgX_mulspec(GEN a, GEN b, long na, long nb);
GEN     RgX_neg(GEN x);
GEN     RgX_pseudodivrem(GEN x, GEN y, GEN *ptr);
GEN     RgX_pseudorem(GEN x, GEN y);
GEN     RgX_recip(GEN x);
GEN     RgX_recip_shallow(GEN x);
GEN     RgX_renormalize(GEN x);
GEN     RgX_rescale(GEN P, GEN h);
GEN     RgX_shift(GEN a, long n);
GEN     RgX_shift_shallow(GEN x, long n);
GEN     RgX_sqr(GEN x);
GEN     RgX_sqrspec(GEN a, long na);
GEN     RgX_sub(GEN x, GEN y);
GEN     RgX_to_RgV(GEN x, long N);
GEN     RgX_translate(GEN P, GEN c);
GEN     RgX_unscale(GEN P, GEN h);
GEN     Rg_RgX_sub(GEN x, GEN y);

/* ZV.c */

GEN     ZC_ZV_mul(GEN x, GEN y);
GEN     ZC_Z_add(GEN x, GEN y);
GEN     ZC_Z_divexact(GEN X, GEN c);
GEN     ZC_Z_mul(GEN X, GEN c);
GEN     ZC_Z_sub(GEN x, GEN y);
GEN     ZC_add(GEN x, GEN y);
GEN     ZC_copy(GEN x);
GEN     ZC_hnfremdiv(GEN x, GEN y, GEN *Q);
GEN     ZC_lincomb(GEN u, GEN v, GEN X, GEN Y);
void    ZC_lincomb1_inplace(GEN X, GEN Y, GEN v);
GEN     ZC_neg(GEN M);
GEN     ZC_reducemodlll(GEN x,GEN y);
GEN     ZC_reducemodmatrix(GEN v, GEN y);
GEN     ZM_reducemodlll(GEN x,GEN y);
GEN     ZM_reducemodmatrix(GEN v, GEN y);
GEN     ZC_sub(GEN x, GEN y);
GEN     ZC_z_mul(GEN X, long c);
GEN     ZM_ZC_mul(GEN x, GEN y);
GEN     ZM_Z_divexact(GEN X, GEN c);
GEN     ZM_Z_mul(GEN X, GEN c);
GEN     ZM_add(GEN x, GEN y);
GEN     ZM_copy(GEN x);
GEN     ZM_det_triangular(GEN mat);
int     ZM_equal(GEN A, GEN B);
GEN     ZM_hnfremdiv(GEN x, GEN y, GEN *Q);
long    ZM_max_lg(GEN x);
GEN     ZM_mul(GEN x, GEN y);
GEN     ZM_neg(GEN x);
GEN     ZM_pow(GEN x, GEN n);
GEN     ZM_sub(GEN x, GEN y);
GEN     ZM_supnorm(GEN x);
GEN     ZM_to_Flm(GEN x, ulong p);
GEN     ZM_to_zm(GEN z);
GEN     ZM_zc_mul(GEN x, GEN y);
GEN     ZM_zm_mul(GEN x, GEN y);
GEN     ZMrow_ZC_mul(GEN x, GEN y, long i);
GEN     ZV_ZM_mul(GEN x, GEN y);
int     ZV_abscmp(GEN x, GEN y);
int     ZV_cmp(GEN x, GEN y);
int     ZV_equal0(GEN V);
GEN     ZV_content(GEN x);
GEN     ZV_dotproduct(GEN x,GEN y);
GEN     ZV_dotsquare(GEN x);
int     ZV_equal(GEN V, GEN W);
long    ZV_max_lg(GEN x);
void    ZV_neg_inplace(GEN M);
GEN     ZV_prod(GEN v);
GEN     ZV_sum(GEN v);
GEN     ZV_to_Flv(GEN x, ulong p);
GEN     ZV_to_nv(GEN z);
void    ZV_togglesign(GEN M);
GEN     zm_to_ZM(GEN z);
int     zv_cmp0(GEN V);
long    zv_content(GEN x);
int     zv_equal(GEN V, GEN W);
GEN     zv_neg(GEN x);
long    zv_prod(GEN v);
long    zv_sum(GEN v);
int     ZM_ishnf(GEN x);
int     ZM_isidentity(GEN x);
void    RgM_check_ZM(GEN A, const char *s);
void    RgV_check_ZV(GEN A, const char *s);

/* ZX.c */

void    RgX_check_ZX(GEN x, const char *s);
void    RgX_check_ZXY(GEN x, const char *s);
GEN     ZXV_Z_mul(GEN y, GEN x);
long    ZXY_max_lg(GEN x);
GEN     ZX_Z_add(GEN y,GEN x);
GEN     ZX_Z_divexact(GEN y,GEN x);
GEN     ZX_Z_mul(GEN y,GEN x);
GEN     ZX_Z_sub(GEN y, GEN x);
GEN     ZX_add(GEN x, GEN y);
GEN     ZX_copy(GEN x);
GEN     ZX_deriv(GEN x);
int     ZX_equal(GEN V, GEN W);
long    ZX_max_lg(GEN x);
GEN     ZX_mul(GEN x, GEN y);
GEN     ZX_mulspec(GEN a, GEN b, long na, long nb);
GEN     ZX_neg(GEN x);
GEN     ZX_rem(GEN x, GEN y);
GEN     ZX_renormalize(GEN x, long lx);
GEN     ZX_rescale(GEN P, GEN h);
GEN     ZX_sqr(GEN x);
GEN     ZX_sqrspec(GEN a, long na);
GEN     ZX_sub(GEN x, GEN y);
long    ZX_val(GEN x);
long    ZX_valrem(GEN x, GEN *Z);
GEN     Z_ZX_sub(GEN x, GEN y);
GEN     scalar_ZX(GEN x, long v);
GEN     scalar_ZX_shallow(GEN x, long v);
GEN     zx_to_ZX(GEN z);

/* alglin1.c */

GEN     F2m_deplin(GEN x);
ulong   F2m_det(GEN x);
ulong   F2m_det_sp(GEN x);
GEN     F2m_ker(GEN x);
GEN     F2m_ker_sp(GEN x, long deplin);
GEN     Flm_deplin(GEN x, ulong p);
ulong   Flm_det(GEN x, ulong p);
ulong   Flm_det_sp(GEN x, ulong p);
GEN     Flm_gauss(GEN a, GEN b, ulong p);
GEN     Flm_image(GEN x, ulong p);
GEN     Flm_indexrank(GEN x, ulong p);
GEN     Flm_inv(GEN x, ulong p);
GEN     Flm_ker(GEN x, ulong p);
GEN     Flm_ker_sp(GEN x, ulong p, long deplin);
long    Flm_rank(GEN x, ulong p);
GEN     FlxqM_ker(GEN x, GEN T, ulong p);
GEN     FpM_deplin(GEN x, GEN p);
GEN     FpM_det(GEN x, GEN p);
GEN     FpM_gauss(GEN a, GEN b, GEN p);
GEN     FpM_image(GEN x, GEN p);
GEN     FpM_indexrank(GEN x, GEN p);
GEN     FpM_intersect(GEN x, GEN y, GEN p);
GEN     FpM_inv(GEN x, GEN p);
GEN     FpM_invimage(GEN m, GEN v, GEN p);
GEN     FpM_ker(GEN x, GEN p);
long    FpM_rank(GEN x, GEN p);
GEN     FpM_suppl(GEN x, GEN p);
GEN     FqM_gauss(GEN a, GEN b, GEN T, GEN p);
GEN     FqM_ker(GEN x, GEN T, GEN p);
GEN     FqM_suppl(GEN x, GEN T, GEN p);
GEN     QM_inv(GEN M, GEN dM);
GEN     RgM_diagonal(GEN m);
GEN     RgM_diagonal_shallow(GEN m);
GEN     RgM_inv_upper(GEN a);
GEN     RgM_solve(GEN a, GEN b);
GEN     RgM_solve_realimag(GEN x, GEN y);
GEN     ZM_detmult(GEN A);
GEN     ZM_inv(GEN M, GEN dM);
GEN     apply0(GEN f, GEN A);
GEN     closemodinvertible(GEN x, GEN y);
GEN     deplin(GEN x);
GEN     det(GEN a);
GEN     det0(GEN a,long flag);
GEN     det2(GEN a);
GEN     detint(GEN x);
GEN     diagonal(GEN x);
GEN     diagonal_shallow(GEN x);
GEN     eigen(GEN x, long prec);
GEN     extract0(GEN x, GEN l1, GEN l2);
GEN     gauss(GEN a, GEN b);
GEN     gaussmodulo(GEN M, GEN D, GEN Y);
GEN     gaussmodulo2(GEN M, GEN D, GEN Y);
GEN     genapply(void *E, GEN (*f)(void *E, GEN x), GEN A);
GEN     genselect(void *E, long (*f)(void *E, GEN x), GEN A);
GEN     gtomat(GEN x);
GEN     gtrans(GEN x);
GEN     image(GEN x);
GEN     image2(GEN x);
GEN     imagecompl(GEN x);
GEN     indexrank(GEN x);
GEN     inverseimage(GEN mat, GEN y);
GEN     ker(GEN x);
GEN     keri(GEN x);
GEN     matimage0(GEN x,long flag);
GEN     matker0(GEN x, long flag);
GEN     matmuldiagonal(GEN x, GEN d);
GEN     matmultodiagonal(GEN x, GEN y);
GEN     matsolvemod0(GEN M, GEN D, GEN Y,long flag);
long    rank(GEN x);
GEN     reducemodinvertible(GEN x, GEN y);
GEN     reducemodlll(GEN x,GEN y);
GEN     select0(GEN A, GEN f);
GEN     shallowextract(GEN x, GEN L);
GEN     shallowtrans(GEN x);
GEN     split_realimag(GEN x, long r1, long r2);
GEN     suppl(GEN x);

/* alglin2.c */

GEN     Flm_charpoly(GEN x, long p);
GEN     Flm_hess(GEN x, ulong p);
GEN     QM_minors_coprime(GEN x, GEN pp);
GEN     QM_ImZ_hnf(GEN x);
GEN     QM_ImQ_hnf(GEN x);
GEN     gnorml1_fake(GEN x);
GEN     ZM_charpoly(GEN x);
GEN     adj(GEN x);
GEN     adjsafe(GEN x);
GEN     caract(GEN x, long v);
GEN     caradj(GEN x, long v, GEN *py);
GEN     carberkowitz(GEN x, long v);
GEN     carhess(GEN x, long v);
GEN     charpoly0(GEN x, long v,long flag);
GEN     gnorm(GEN x);
GEN     gnorml1(GEN x,long prec);
GEN     gnorml2(GEN x);
GEN     gsupnorm(GEN x, long prec);
void    gsupnorm_aux(GEN x, GEN *m, GEN *msq);
GEN     gtrace(GEN x);
GEN     hess(GEN x);
GEN     intersect(GEN x, GEN y);
GEN     jacobi(GEN a, long prec);
GEN     matadjoint0(GEN x, long flag);
GEN     matcompanion(GEN x);
GEN     matrixqz0(GEN x, GEN pp);
GEN     minpoly(GEN x, long v);
GEN     qfgaussred(GEN a);
GEN     qfgaussred_positive(GEN a);
GEN     qfsign(GEN a);

/* anal.c */

void    addhelp(const char *e, char *s);
void    alias0(const char *s, const char *old);
GEN     compile_str(const char *s);
GEN     chartoGENstr(char c);
long    delete_var(void);
entree* fetch_named_var(const char *s);
long    fetch_user_var(const char *s);
long    fetch_var(void);
GEN     fetch_var_value(long vx, GEN t);
GEN     gp_read_str(const char *t);
entree* install(void *f, char *name, char *code);
entree* is_entry(const char *s);
void    kill0(const char *e);
long    manage_var(long n, entree *ep);
void    pari_var_init(void);
long    pari_var_next(void);
long    pari_var_next_temp(void);
void    pari_var_create(entree *ep);
void    name_var(long n, const char *s);
GEN     readseq(char *t);
GEN     strntoGENstr(const char *s, long n0);
GEN     strtoGENstr(const char *s);
GEN     strtoi(const char *s);
GEN     strtor(const char *s, long prec);
GEN     type0(GEN x);

/* aprcl.c */

long    isprimeAPRCL(GEN N);

/* Qfb.c */

GEN     Qfb0(GEN x, GEN y, GEN z, GEN d, long prec);
void    check_quaddisc(GEN x, long *s, long *r, const char *f);
void    check_quaddisc_imag(GEN x, long *r, const char *f);
void    check_quaddisc_real(GEN x, long *r, const char *f);
long    cornacchia(GEN d, GEN p, GEN *px, GEN *py);
long    cornacchia2(GEN d, GEN p, GEN *px, GEN *py);
GEN     nucomp(GEN x, GEN y, GEN l);
GEN     nudupl(GEN x, GEN l);
GEN     nupow(GEN x, GEN n);
GEN     primeform(GEN x, GEN p, long prec);
GEN     primeform_u(GEN x, ulong p);
GEN     qfbcompraw(GEN x, GEN y);
GEN     qfbpowraw(GEN x, long n);
GEN     qfbred0(GEN x, long flag, GEN D, GEN isqrtD, GEN sqrtD);
GEN     qfbsolve(GEN Q, GEN n);
GEN     qfi(GEN x, GEN y, GEN z);
GEN     qfi_1(GEN x);
GEN     qficomp(GEN x, GEN y);
GEN     qficompraw(GEN x, GEN y);
GEN     qfipowraw(GEN x, long n);
GEN     qfisolvep(GEN Q, GEN p);
GEN     qfisqr(GEN x);
GEN     qfisqrraw(GEN x);
GEN     qfr(GEN x, GEN y, GEN z, GEN d);
GEN     qfr3_comp(GEN x, GEN y, struct qfr_data *S);
GEN     qfr3_pow(GEN x, GEN n, struct qfr_data *S);
GEN     qfr3_red(GEN x, struct qfr_data *S);
GEN     qfr3_rho(GEN x, struct qfr_data *S);
GEN     qfr3_to_qfr(GEN x, GEN z);
GEN     qfr5_comp(GEN x, GEN y, struct qfr_data *S);
GEN     qfr5_dist(GEN e, GEN d, long prec);
GEN     qfr5_pow(GEN x, GEN n, struct qfr_data *S);
GEN     qfr5_red(GEN x, struct qfr_data *S);
GEN     qfr5_rho(GEN x, struct qfr_data *S);
GEN     qfr5_to_qfr(GEN x, GEN d0);
GEN     qfr_1(GEN x);
void    qfr_data_init(GEN D, long prec, struct qfr_data *S);
GEN     qfr_to_qfr5(GEN x, long prec);
GEN     qfrcomp(GEN x, GEN y);
GEN     qfrcompraw(GEN x, GEN y);
GEN     qfrpow(GEN x, GEN n);
GEN     qfrpowraw(GEN x, long n);
GEN     qfrsolvep(GEN Q, GEN p);
GEN     qfrsqr(GEN x);
GEN     qfrsqrraw(GEN x);
GEN     quadgen(GEN x);
GEN     quadpoly(GEN x);
GEN     quadpoly0(GEN x, long v);
GEN     redimag(GEN x);
GEN     redreal(GEN x);
GEN     redrealnod(GEN x, GEN isqrtD);
GEN     rhoreal(GEN x);
GEN     rhorealnod(GEN x, GEN isqrtD);

/* arith1.c */

ulong   Fl_order(ulong a, ulong o, ulong p);
ulong   Fl_powu(ulong x, ulong n, ulong p);
ulong   Fl_sqrt(ulong a, ulong p);
GEN     Fp_log(GEN a, GEN g, GEN ord, GEN p);
GEN     Fp_order(GEN a, GEN o, GEN p);
GEN     Fp_pow(GEN a, GEN n, GEN m);
GEN     Fp_pows(GEN A, long k, GEN N);
GEN     Fp_powu(GEN x, ulong k, GEN p);
GEN     Fp_sqrt(GEN a, GEN p);
GEN     Fp_sqrtn(GEN a, GEN n, GEN p, GEN *zetan);
GEN     Z_chinese(GEN a, GEN b, GEN A, GEN B);
GEN     Z_chinese_all(GEN a, GEN b, GEN A, GEN B, GEN *pC);
GEN     Z_chinese_coprime(GEN a, GEN b, GEN A, GEN B, GEN C);
GEN     Z_chinese_post(GEN a, GEN b, GEN C, GEN U, GEN d);
void    Z_chinese_pre(GEN A, GEN B, GEN *pC, GEN *pU, GEN *pd);
long    Z_isanypower(GEN x, GEN *y);
long    Z_isfundamental(GEN x);
long    Z_ispowerall(GEN x, ulong k, GEN *pt);
long    Z_issquareall(GEN x, GEN *pt);
long    Zp_issquare(GEN a, GEN p);
GEN     bestappr0(GEN x, GEN a, GEN b);
GEN     bestappr(GEN x, GEN k);
long    cgcd(long a,long b);
ulong   ugcd(ulong a,ulong b);
GEN     chinese1(GEN x);
GEN     chinese1_coprime_Z(GEN x);
GEN     chinese(GEN x, GEN y);
GEN     classno2(GEN x);
GEN     classno(GEN x);
long    clcm(long a,long b);
GEN     contfrac0(GEN x, GEN b, long flag);
GEN     fibo(long n);
GEN     gboundcf(GEN x, long k);
GEN     gcf2(GEN b, GEN x);
GEN     gcf(GEN x);
ulong   pgener_Fl_local(ulong p, GEN L);
ulong   pgener_Fl(ulong p);
GEN     pgener_Fp_local(GEN p, GEN L);
GEN     pgener_Fp(GEN p);
ulong   pgener_Zl(ulong p);
GEN     pgener_Zp(GEN p);
long    gisanypower(GEN x, GEN *pty);
GEN     gisfundamental(GEN x);
GEN     gissquareall(GEN x, GEN *pt);
GEN     gissquare(GEN x);
GEN     gkronecker(GEN x, GEN y);
GEN     hclassno(GEN x);
long    hilbert(GEN x, GEN y, GEN p);
long    hilbertii(GEN x, GEN y, GEN p);
long    ispower(GEN x, GEN k, GEN *pty);
long    krois(GEN x, long y);
long    kronecker(GEN x, GEN y);
long    krosi(long s, GEN x);
long    kross(long x, long y);
long    krouu(ulong x, ulong y);
GEN     lcmii(GEN a, GEN b);
GEN     mpfact(long n);
GEN     order(GEN x);
GEN     pnqn(GEN x);
GEN     qfbclassno0(GEN x,long flag);
GEN     quaddisc(GEN x);
GEN     quadregulator(GEN x, long prec);
GEN     quadunit(GEN x);
GEN     sqrtint(GEN a);
GEN     mulu_interval(ulong a, ulong b);
long    uissquareall(ulong A, ulong *sqrtA);
GEN     znorder(GEN x, GEN o);
GEN     znlog(GEN x, GEN g, GEN o);
GEN     znprimroot(GEN m);
GEN     znprimroot0(GEN m);
GEN     znstar(GEN x);

/* arith2.c */

long    Z_issquarefree(GEN x);
GEN     Z_factor_limit(GEN n, ulong all);
GEN     Z_factor_until(GEN n, GEN limit);
GEN     Z_smoothen(GEN N, GEN L, GEN *pP, GEN *pe);
long    bigomega(GEN n);
GEN     boundfact(GEN n, ulong lim);
GEN     core(GEN n);
GEN     corepartial(GEN n, long l);
GEN     core0(GEN n,long flag);
GEN     core2(GEN n);
GEN     core2partial(GEN n, long l);
GEN     coredisc(GEN n);
GEN     coredisc0(GEN n,long flag);
GEN     coredisc2(GEN n);
GEN     divisors(GEN n);
GEN     divisorsu(ulong n);
GEN     factor_pn_1(GEN p, long n);
GEN     factorint(GEN n, long flag);
GEN     factoru(ulong n);
GEN     factoru_pow(ulong n);
GEN     gbigomega(GEN n);
GEN     gissquarefree(GEN x);
GEN     gmoebius(GEN n);
GEN     gnumbdiv(GEN n);
GEN     gomega(GEN n);
GEN     geulerphi(GEN n);
GEN     gsumdiv(GEN n);
GEN     gsumdivk(GEN n,long k);
byteptr initprimes(ulong maxnum);
ulong   init_primepointer(ulong a, ulong p, byteptr *ptr);
long    issquarefree(GEN x);
ulong   maxprime(void);
void    maxprime_check(ulong c);
long    moebius(GEN n);
GEN     numbdiv(GEN n);
long    omega(GEN n);
GEN     eulerphi(GEN n);
GEN     sumdiv(GEN n);
GEN     sumdivk(GEN n,long k);
ulong   eulerphiu(ulong n);
GEN     Z_factor(GEN n);

/* DedekZeta.c */

GEN     glambdak(GEN nfz, GEN s, long prec);
GEN     gzetak(GEN nfz, GEN s, long prec);
GEN     gzetakall(GEN nfz, GEN s, long flag, long prec);
GEN     initzeta(GEN pol, long prec);
GEN     dirzetak(GEN nf, GEN b);

/* base1.c */

GEN     FpX_FpC_nfpoleval(GEN nf, GEN pol, GEN a, GEN p);
GEN     Polred(GEN x, long flag, GEN fa);
GEN     T2_from_embed(GEN x, long r1);
void    check_ZKmodule(GEN x, const char *s);
void    checkbid(GEN bid);
GEN     checkbnf(GEN bnf);
void    checkbnr(GEN bnr);
void    checkbnrgen(GEN bnr);
void    checksqmat(GEN x, long N);
GEN     checknf(GEN nf);
GEN     checknfelt_mod(GEN nf, GEN x, const char *s);
void    checkprid(GEN bid);
void    checkrnf(GEN rnf);
GEN     factoredpolred(GEN x, GEN fa);
GEN     factoredpolred2(GEN x, GEN fa);
GEN     galoisapply(GEN nf, GEN aut, GEN x);
GEN     get_bnf(GEN x, long *t);
GEN     get_bnfpol(GEN x, GEN *bnf, GEN *nf);
GEN     get_nf(GEN x, long *t);
GEN     get_nfpol(GEN x, GEN *nf);
GEN     get_prid(GEN x);
GEN     idealfrobenius(GEN nf, GEN gal, GEN pr);
GEN     idealramgroups(GEN nf, GEN gal, GEN pr);
GEN     nf_get_allroots(GEN nf);
long    nf_get_prec(GEN x);
GEN     nfgaloismatrix(GEN nf, GEN s);
GEN     nfinit(GEN x, long prec);
GEN     nfinit0(GEN x, long flag, long prec);
GEN     nfinitall(GEN x, long flag, long prec);
GEN     nfinitred(GEN x, long prec);
GEN     nfinitred2(GEN x, long prec);
GEN     nfisincl(GEN a, GEN b);
GEN     nfisisom(GEN a, GEN b);
GEN     nfnewprec(GEN nf, long prec);
GEN     nfnewprec_shallow(GEN nf, long prec);
GEN     nfpoleval(GEN nf, GEN pol, GEN a);
long    nftyp(GEN x);
GEN     ordred(GEN x);
GEN     polgalois(GEN x, long prec);
GEN     polred(GEN x);
GEN     polred0(GEN x, long flag, GEN p);
GEN     polred2(GEN x);
GEN     polredabs(GEN x);
GEN     polredabs0(GEN x, long flag);
GEN     polredabs2(GEN x);
GEN     polredabsall(GEN x, long flun);
GEN     smallpolred(GEN x);
GEN     smallpolred2(GEN x);
GEN     tschirnhaus(GEN x);
GEN     ZX_Q_normalize(GEN pol, GEN *ptlc);
GEN     ZX_Z_normalize(GEN pol, GEN *ptk);
GEN     ZX_to_monic(GEN pol, GEN *lead);
GEN     ZX_primitive_to_monic(GEN pol, GEN *lead);

/* base2.c */

GEN     Fq_to_nf(GEN x, GEN modpr);
GEN     FqM_to_nfM(GEN z, GEN modpr);
GEN     FqV_to_nfV(GEN z, GEN modpr);
GEN     FqX_to_nfX(GEN x, GEN modpr);
long    ZpX_disc_val(GEN f, GEN p);
GEN     ZpX_gcd(GEN f1,GEN f2,GEN pm);
GEN     ZpX_reduced_resultant(GEN x, GEN y, GEN pm);
GEN     ZpX_reduced_resultant_fast(GEN f, GEN g, GEN p, long M);
void    checkmodpr(GEN modpr);
GEN     ZX_compositum_disjoint(GEN A, GEN B);
GEN     compositum(GEN P, GEN Q);
GEN     compositum2(GEN P, GEN Q);
GEN     nfdisc(GEN x);
GEN     rnf_fix_pol(GEN nf, GEN x, int lift);
GEN     indexpartial(GEN P, GEN DP);
GEN     modpr_genFq(GEN modpr);
GEN     nf_to_Fq_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     nf_to_Fq(GEN nf, GEN x, GEN modpr);
GEN     nfM_to_FqM(GEN z, GEN nf,GEN modpr);
GEN     nfV_to_FqV(GEN z, GEN nf,GEN modpr);
GEN     nfX_to_FqX(GEN x, GEN nf,GEN modpr);
GEN     nfbasis(GEN x, GEN *y,long flag,GEN p);
GEN     nfbasis0(GEN x,long flag,GEN p);
GEN     nfdisc0(GEN x,long flag, GEN p);
void    nfmaxord(nfmaxord_t *S, GEN f, long flag, GEN w);
GEN     nfmodprinit(GEN nf, GEN pr);
GEN     nfreducemodpr(GEN nf, GEN x, GEN modpr);
GEN     polcompositum0(GEN P, GEN Q,long flag);
GEN     idealprimedec(GEN nf,GEN p);
GEN     rnfbasis(GEN bnf, GEN order);
GEN     rnfdedekind(GEN nf, GEN T, GEN pr, long flag);
GEN     rnfdet(GEN nf, GEN order);
GEN     rnfdiscf(GEN nf, GEN pol);
GEN     rnfequation(GEN nf, GEN pol);
GEN     rnfequation0(GEN nf, GEN pol, long flall);
GEN     rnfequation2(GEN nf, GEN pol);
GEN     rnfequationall(GEN A, GEN B, long *pk, GEN *pLPRS);
GEN     rnfhnfbasis(GEN bnf, GEN order);
long    rnfisfree(GEN bnf, GEN order);
GEN     rnflllgram(GEN nf, GEN pol, GEN order,long prec);
GEN     rnfpolred(GEN nf, GEN pol, long prec);
GEN     rnfpolredabs(GEN nf, GEN pol, long flag);
GEN     rnfpseudobasis(GEN nf, GEN pol);
GEN     rnfsimplifybasis(GEN bnf, GEN order);
GEN     rnfsteinitz(GEN nf, GEN order);
long    factorial_lval(ulong n, ulong p);
GEN     zk_to_Fq_init(GEN nf, GEN *pr, GEN *T, GEN *p);
GEN     zk_to_Fq(GEN x, GEN modpr);
GEN     zkmodprinit(GEN nf, GEN pr);

/* base3.c */

GEN     Idealstar(GEN nf, GEN x,long flun);
GEN     RgC_to_nfC(GEN nf,GEN x);
GEN     RgM_to_nfM(GEN nf,GEN x);
GEN     RgX_to_nfX(GEN nf,GEN pol);
GEN     algtobasis(GEN nf, GEN x);
GEN     basistoalg(GEN nf, GEN x);
GEN     ideallist(GEN nf,long bound);
GEN     ideallist0(GEN nf,long bound, long flag);
GEN     ideallistarch(GEN nf, GEN list, GEN arch);
GEN     idealstar0(GEN nf, GEN x,long flag);
GEN     indices_to_vec01(GEN archp, long r);
GEN     matalgtobasis(GEN nf, GEN x);
GEN     matbasistoalg(GEN nf, GEN x);
GEN     nf_to_scalar_or_alg(GEN nf, GEN x);
GEN     nf_to_scalar_or_basis(GEN nf, GEN x);
GEN     nfadd(GEN nf, GEN x, GEN y);
GEN     nfarchstar(GEN nf,GEN x,GEN arch);
GEN     nfdiv(GEN nf, GEN x, GEN y);
GEN     nfdiveuc(GEN nf, GEN a, GEN b);
GEN     nfdivrem(GEN nf, GEN a, GEN b);
GEN     nfinv(GEN nf, GEN x);
GEN     nfinvmodideal(GEN nf, GEN x, GEN ideal);
GEN     nfmod(GEN nf, GEN a, GEN b);
GEN     nfmul(GEN nf,GEN x,GEN y);
GEN     nfmuli(GEN nf,GEN x,GEN y);
GEN     nfnorm(GEN nf, GEN x);
GEN     nfpow(GEN nf,GEN x,GEN k);
GEN     nfpow_u(GEN nf, GEN z, ulong n);
GEN     nfpowmodideal(GEN nf,GEN x,GEN k,GEN ideal);
GEN     nfsign(GEN nf,GEN alpha);
GEN     nfsign_arch(GEN nf,GEN alpha,GEN arch);
GEN     nfsign_from_logarch(GEN Larch, GEN invpi, GEN archp);
GEN     nfsqr(GEN nf,GEN x);
GEN     nfsqri(GEN nf, GEN x);
GEN     nftrace(GEN nf, GEN x);
long    nfval(GEN nf, GEN x, GEN vp);
GEN     rnfalgtobasis(GEN rnf, GEN x);
GEN     rnfbasistoalg(GEN rnf, GEN x);
GEN     set_sign_mod_divisor(GEN nf, GEN x, GEN y, GEN idele, GEN sarch);
GEN     vec01_to_indices(GEN arch);
GEN     vecmodii(GEN a, GEN b);
GEN     ideallog(GEN nf,GEN x,GEN bigideal);

GEN     multable(GEN nf, GEN x);
GEN     tablemul(GEN TAB, GEN x, GEN y);
GEN     tablemul_ei(GEN M, GEN x, long i);
GEN     tablemul_ei_ej(GEN M, long i, long j);
GEN     tablemulvec(GEN M, GEN x, GEN v);
GEN     tablesqr(GEN tab, GEN x);
GEN     zk_multable(GEN nf, GEN x);
GEN     ei_multable(GEN nf, long i);
GEN     zk_scalar_or_multable(GEN, GEN x);

/* base4.c */
GEN     RM_round_maxrank(GEN G);
GEN     famat_inv(GEN f);
GEN     famat_makecoprime(GEN nf, GEN g, GEN e, GEN pr, GEN prk, GEN EX);
GEN     famat_mul(GEN f, GEN g);
GEN     famat_pow(GEN f, GEN n);
GEN     famat_sqr(GEN f);
GEN     famat_reduce(GEN fa);
GEN     famat_to_nf(GEN nf, GEN f);
GEN     famat_to_nf_modideal_coprime(GEN nf, GEN g, GEN e, GEN id, GEN EX);
GEN     famat_to_nf_moddivisor(GEN nf, GEN g, GEN e, GEN bid);
GEN     idealtwoelt(GEN nf, GEN ix);
GEN     idealtwoelt0(GEN nf, GEN ix, GEN a);
GEN     idealtwoelt2(GEN nf, GEN x, GEN a);
GEN     idealadd(GEN nf, GEN x, GEN y);
GEN     idealaddmultoone(GEN nf, GEN list);
GEN     idealaddtoone(GEN nf, GEN x, GEN y);
GEN     idealaddtoone_i(GEN nf, GEN x, GEN y);
GEN     idealaddtoone0(GEN nf, GEN x, GEN y);
GEN     idealappr(GEN nf, GEN x);
GEN     idealappr0(GEN nf, GEN x, long fl);
GEN     idealapprfact(GEN nf, GEN x);
GEN     idealchinese(GEN nf, GEN x, GEN y);
GEN     idealcoprime(GEN nf, GEN x, GEN y);
GEN     idealcoprimefact(GEN nf, GEN x, GEN fy);
GEN     idealdiv(GEN nf, GEN x, GEN y);
GEN     idealdiv0(GEN nf, GEN x, GEN y,long flag);
GEN     idealdivexact(GEN nf, GEN x, GEN y);
GEN     idealdivpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealmulpowprime(GEN nf, GEN x, GEN vp, GEN n);
GEN     idealfactor(GEN nf, GEN x);
GEN     idealhnf(GEN nf, GEN x);
GEN     idealhnf_principal(GEN nf, GEN x);
GEN     idealhnf_shallow(GEN nf, GEN x);
GEN     idealhnf_two(GEN nf, GEN vp);
GEN     idealhnf0(GEN nf, GEN a, GEN b);
GEN     idealintersect(GEN nf, GEN x, GEN y);
GEN     idealinv(GEN nf, GEN ix);
GEN     idealred0(GEN nf, GEN I,GEN vdir);
GEN     idealmul(GEN nf, GEN ix, GEN iy);
GEN     idealmul0(GEN nf, GEN ix, GEN iy, long flag);
GEN     idealmul_HNF(GEN nf, GEN ix, GEN iy);
GEN     idealmulred(GEN nf, GEN ix, GEN iy);
GEN     idealnorm(GEN nf, GEN x);
GEN     idealpow(GEN nf, GEN ix, GEN n);
GEN     idealpow0(GEN nf, GEN ix, GEN n, long flag);
GEN     idealpowred(GEN nf, GEN ix, GEN n);
GEN     idealpows(GEN nf, GEN ideal, long iexp);
GEN     idealprodprime(GEN nf, GEN L);
GEN     idealsqr(GEN nf, GEN x);
long    idealtyp(GEN *ideal, GEN *arch);
long    idealval(GEN nf,GEN ix,GEN vp);
long    isideal(GEN nf,GEN x);
GEN     idealmin(GEN nf,GEN ix,GEN vdir);
GEN     nf_get_Gtwist(GEN nf, GEN vdir);
GEN     nf_get_Gtwist1(GEN nf, long i);
GEN     nfC_nf_mul(GEN nf, GEN v, GEN x);
GEN     nfdetint(GEN nf,GEN pseudo);
GEN     nfdivmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     nfhnf(GEN nf, GEN x);
GEN     nfhnfmod(GEN nf, GEN x, GEN d);
GEN     nfkermodpr(GEN nf, GEN x, GEN modpr);
GEN     nfmulmodpr(GEN nf, GEN x, GEN y, GEN modpr);
GEN     nfpowmodpr(GEN nf, GEN x, GEN k, GEN modpr);
GEN     nfreduce(GEN nf, GEN x, GEN ideal);
GEN     nfsnf(GEN nf, GEN x);
GEN     nfsolvemodpr(GEN nf, GEN a, GEN b, GEN modpr);
GEN     to_famat(GEN x, GEN y);
GEN     to_famat_shallow(GEN x, GEN y);
GEN     vecdiv(GEN x, GEN y);
GEN     vecinv(GEN x);
GEN     vecmul(GEN x, GEN y);
GEN     vecpow(GEN x, GEN n);

/* base5.c */

GEN     rnfelementabstorel(GEN rnf, GEN x);
GEN     rnfelementdown(GEN rnf, GEN x);
GEN     rnfelementreltoabs(GEN rnf, GEN x);
GEN     rnfelementup(GEN rnf, GEN x);
GEN     rnfidealabstorel(GEN rnf, GEN x);
GEN     rnfidealdown(GEN rnf, GEN x);
GEN     rnfidealhermite(GEN rnf, GEN x);
GEN     rnfidealmul(GEN rnf,GEN x,GEN y);
GEN     rnfidealnormabs(GEN rnf, GEN x);
GEN     rnfidealnormrel(GEN rnf, GEN x);
GEN     rnfidealreltoabs(GEN rnf, GEN x);
GEN     rnfidealtwoelement(GEN rnf,GEN x);
GEN     rnfidealup(GEN rnf, GEN x);
GEN     rnfinit(GEN nf,GEN pol);

/* bb_group.c */

GEN dlog_get_ordfa(GEN o);
GEN dlog_get_ord(GEN o);
GEN gen_PH_log(GEN a, GEN g, GEN ord, void *E, const struct bb_group *grp, GEN easy(void *E, GEN, GEN, GEN));
GEN gen_Shanks_sqrtn(GEN a, GEN n, GEN q, GEN *zetan, void *E, const struct bb_group *grp);
GEN gen_eltorder(GEN x, GEN o, void *E, const struct bb_group *grp);
GEN gen_plog(GEN x,GEN g0,GEN q, void *E, const struct bb_group *grp, GEN easy(void*E, GEN, GEN, GEN));
GEN gen_pow(GEN x, GEN n, void *E, GEN (*sqr)(void*,GEN),
                                   GEN (*mul)(void*,GEN,GEN));
GEN gen_powu(GEN x, ulong n, void *E, GEN (*sqr)(void*,GEN),
                                      GEN (*mul)(void*,GEN,GEN));

/* bibli1.c */

GEN     Q_from_QR(GEN x, long prec);
GEN     R_from_QR(GEN x, long prec);
GEN     algdep(GEN x, long n);
GEN     algdep0(GEN x, long n, long bit);
GEN     gram_matrix(GEN M);
GEN     lindep(GEN x);
GEN     lindep0(GEN x, long flag);
GEN     lindep2(GEN x, long bit);
GEN     minim(GEN a, GEN borne, GEN stockmax);
GEN     qfrep0(GEN a, GEN borne, long flag);
GEN     qfminim0(GEN a, GEN borne, GEN stockmax,long flag, long prec);
GEN     minim2(GEN a, GEN borne, GEN stockmax);
GEN     perf(GEN a);
char*   stackmalloc(size_t N);
GEN     zncoppersmith(GEN P0, GEN N, GEN X, GEN B) ;

/* bibli2.c */

GEN     QXQ_reverse(GEN a, GEN T);
GEN     binomial(GEN x, long k);
GEN     binomialuu(ulong n, ulong k);
int     cmp_nodata(void *data, GEN x, GEN y);
int     cmp_prime_ideal(GEN x, GEN y);
int     cmp_prime_over_p(GEN x, GEN y);
int     cmp_RgX(GEN x, GEN y);
int     cmp_universal(GEN x, GEN y);
GEN     convol(GEN x, GEN y);
int     gen_cmp_RgX(void *data, GEN x, GEN y);
GEN     polcyclo(long n, long v);
GEN     polcyclo_eval(long n, GEN x);
GEN     dirdiv(GEN x, GEN y);
GEN     dirmul(GEN x, GEN y);
GEN     gen_indexsort(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
GEN     gen_indexsort_uniq(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
long    gen_search(GEN x, GEN y, long flag, void *data, int (*cmp)(void*,GEN,GEN));
GEN     gen_setminus(GEN set1, GEN set2, int (*cmp)(GEN,GEN));
GEN     gen_sort(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
void    gen_sort_inplace(GEN x, void *E, int (*cmp)(void*,GEN,GEN), GEN *perm);
GEN     gen_sort_uniq(GEN x, void *E, int (*cmp)(void*,GEN,GEN));
long    getstack(void);
long    gettime(void);
GEN     gprec(GEN x, long l);
GEN     gprec_wtrunc(GEN x, long pr);
GEN     gprec_w(GEN x, long pr);
GEN     gtoset(GEN x);
GEN     indexlexsort(GEN x);
GEN     indexsort(GEN x);
GEN     indexvecsort(GEN x, GEN k);
GEN     laplace(GEN x);
GEN     lexsort(GEN x);
GEN     mathilbert(long n);
GEN     matqpascal(long n, GEN q);
GEN     merge_factor(GEN fx, GEN fy, void *data, int (*cmp)(void *,GEN,GEN));
GEN     modreverse(GEN x);
GEN     RgXQ_reverse(GEN a, GEN T);
GEN     numtoperm(long n, GEN x);
GEN     permtonum(GEN x);
GEN     polhermite(long n, long v);
GEN     polhermite_eval(long n, GEN x);
GEN     pollegendre(long n, long v);
GEN     pollegendre_eval(long n, GEN x);
GEN     polint(GEN xa, GEN ya, GEN x, GEN *dy);
GEN     polchebyshev(long n, long kind, long v);
GEN     polchebyshev_eval(long n, long kind, GEN x);
GEN     polchebyshev1(long n, long v);
GEN     polchebyshev2(long n, long v);
GEN     polrecip(GEN x);
GEN     setintersect(GEN x, GEN y);
long    setisset(GEN x);
GEN     setminus(GEN x, GEN y);
long    setsearch(GEN x, GEN y, long flag);
GEN     setunion(GEN x, GEN y);
GEN     sort(GEN x);
GEN     sort_factor(GEN y, void *data, int (*cmp)(void*,GEN,GEN));
GEN     stirling(long n, long m, long flag);
GEN     stirling1(ulong n, ulong m);
GEN     stirling2(ulong n, ulong m);
long    tablesearch(GEN T, GEN x, int (*cmp)(GEN,GEN));
GEN     vecbinome(long n);
GEN     vecsort(GEN x, GEN k);
GEN     vecsort0(GEN x, GEN k, long flag);
GEN     ZV_indexsort(GEN L);
long    ZV_search(GEN x, GEN y);
GEN     ZV_sort(GEN L);
GEN     ZV_sort_uniq(GEN L);
GEN     ZV_union_shallow(GEN x, GEN y);

/* bit.c */

GEN     binaire(GEN x);
long    bittest(GEN x, long n);
GEN     gbitand(GEN x, GEN y);
GEN     gbitneg(GEN x, long n);
GEN     gbitnegimply(GEN x, GEN y);
GEN     gbitor(GEN x, GEN y);
GEN     gbittest(GEN x, long n);
GEN     gbitxor(GEN x, GEN y);
GEN     ibitand(GEN x, GEN y);
GEN     ibitnegimply(GEN x, GEN y);
GEN     ibitor(GEN x, GEN y);
GEN     ibitxor(GEN x, GEN y);

/* buch1.c */

GEN     Buchquad(GEN D, double c1, double c2, long prec);
GEN     quadclassunit0(GEN x, long flag,GEN data, long prec);
GEN     quadhilbert(GEN D, long prec);
GEN     quadray(GEN bnf, GEN f, long prec);

/* buch2.c */

GEN     bnfcompress(GEN bnf);
GEN     bnfinit0(GEN P,long flag,GEN data,long prec);
GEN     bnfnewprec(GEN nf, long prec);
GEN     bnfnewprec_shallow(GEN nf, long prec);
GEN     bnrnewprec(GEN bnr, long prec);
GEN     bnrnewprec_shallow(GEN bnr, long prec);
GEN     Buchall(GEN P, long flag, long prec);
GEN     Buchall_param(GEN P, double bach, double bach2, long nbrelpid, long flun, long prec);
GEN     isprincipal(GEN bnf, GEN x);
GEN     bnfisprincipal0(GEN bnf, GEN x,long flall);
GEN     isprincipalfact(GEN bnf, GEN C, GEN L, GEN f, long flag);
GEN     isprincipalfact_or_fail(GEN bnf, GEN C, GEN P, GEN e);
GEN     bnfisunit(GEN bignf, GEN x);
GEN     signunits(GEN bignf);
GEN     nfsign_units(GEN bnf, GEN archp, int add_zu);

/* buch3.c */

GEN     ABC_to_bnr(GEN A, GEN B, GEN C, GEN *H, int gen);
GEN     Buchray(GEN bnf, GEN module, long flag);
GEN     bnrclassno(GEN bignf,GEN ideal);
GEN     bnrclassnolist(GEN bnf,GEN listes);
GEN     bnrconductor0(GEN A, GEN B, GEN C, long flag);
GEN     bnrconductor(GEN bnr, GEN H0, long flag);
GEN     bnrconductorofchar(GEN bnr,GEN chi);
GEN     bnrdisc0(GEN A, GEN B, GEN C, long flag);
GEN     bnrdisc(GEN bnr, GEN H, long flag);
GEN     bnrdisclist0(GEN bnf,GEN borne, GEN arch);
GEN     bnrinit0(GEN bignf,GEN ideal,long flag);
long    bnrisconductor0(GEN A, GEN B, GEN C);
long    bnrisconductor(GEN bnr, GEN H);
GEN     bnrisprincipal(GEN bnf, GEN x,long flag);
GEN     bnrsurjection(GEN bnr1, GEN bnr2);
GEN     buchnarrow(GEN bignf);
long    bnfcertify(GEN bnf);
long    bnfcertify0(GEN bnf, long flag);
GEN     decodemodule(GEN nf, GEN fa);
GEN     discrayabslist(GEN bnf,GEN listes);
GEN     discrayabslistarch(GEN bnf, GEN arch, long bound);
GEN     discrayabslistlong(GEN bnf, long bound);
GEN     idealmoddivisor(GEN bnr, GEN x);
GEN     isprincipalray(GEN bnf, GEN x);
GEN     isprincipalraygen(GEN bnf, GEN x);
GEN     rnfconductor(GEN bnf, GEN polrel, long flag);
long    rnfisabelian(GEN nf, GEN pol);
GEN     rnfnormgroup(GEN bnr, GEN polrel);
GEN     subgrouplist0(GEN bnr, GEN indexbound, long all);

/* buch4.c */

GEN     bnfisnorm(GEN bnf,GEN x,long flag);
GEN     rnfisnorm(GEN S, GEN x, long flag);
GEN     rnfisnorminit(GEN bnf, GEN relpol, int galois);
GEN     bnfissunit(GEN bnf,GEN suni,GEN x);
GEN     bnfsunit(GEN bnf,GEN s,long PREC);
long    nfhilbert(GEN bnf,GEN a,GEN b);
long    nfhilbert0(GEN bnf,GEN a,GEN b,GEN p);
long    hyperell_locally_soluble(GEN pol,GEN p);
long    nf_hyperell_locally_soluble(GEN nf,GEN pol,GEN p);

/* compile.c */

GEN     closure_deriv(GEN G);
long    localvars_find(GEN pack, entree *ep);
GEN     localvars_read_str(const char *str, GEN pack);
GEN     snm_closure(entree *ep, GEN data);
GEN     strtoclosure(const char *s, long n, ...);
GEN     strtofunction(const char *s);

/* concat.c */

GEN     concat(GEN x, GEN y);
GEN     concat1(GEN x);
GEN     shallowconcat(GEN x, GEN y);
GEN     shallowconcat1(GEN x);
GEN     vconcat(GEN A, GEN B);

/* default.c */
enum { d_SILENT = 0, d_ACKNOWLEDGE, d_INITRC, d_RETURN };

GEN default0(const char *a, const char *b);
long getrealprecision(void);
int pari_is_default(const char *s);
GEN sd_TeXstyle(const char *v, long flag);
GEN sd_colors(const char *v, long flag);
GEN sd_compatible(const char *v, long flag);
GEN sd_datadir(const char *v, long flag);
GEN sd_debug(const char *v, long flag);
GEN sd_debugfiles(const char *v, long flag);
GEN sd_debugmem(const char *v, long flag);
GEN sd_factor_add_primes(const char *v, long flag);
GEN sd_factor_proven(const char *v, long flag);
GEN sd_format(const char *v, long flag);
GEN sd_histsize(const char *v, long flag);
GEN sd_log(const char *v, long flag);
GEN sd_logfile(const char *v, long flag);
GEN sd_new_galois_format(const char *v, long flag);
GEN sd_output(const char *v, long flag);
GEN sd_parisize(const char *v, long flag);
GEN sd_path(const char *v, long flag);
GEN sd_prettyprinter(const char *v, long flag);
GEN sd_primelimit(const char *v, long flag);
GEN sd_realprecision(const char *v, long flag);
GEN sd_secure(const char *v, long flag);
GEN sd_seriesprecision(const char *v, long flag);
GEN sd_simplify(const char *v, long flag);
GEN sd_strictmatch(const char *v, long flag);
GEN sd_toggle(const char *v, long flag, const char *s, int *ptn);
GEN sd_string(const char *v, long flag, const char *s, char **f);
GEN sd_ulong(const char *v, long flag, const char *s, ulong *ptn, ulong Min, ulong Max, const char **msg);
GEN setdefault(const char *s, const char *v, long flag);
long setrealprecision(long n, long *prec);

/* ellanal.c */

GEN     ellanalyticrank(GEN e, GEN eps, long prec);
GEN     ellL1(GEN e, long r, long prec);

/* elldata.c */

GEN     ellconvertname(GEN s);
GEN     ellgenerators(GEN E);
GEN     ellidentify(GEN E);
GEN     ellsearch(GEN A);
GEN     ellsearchcurve(GEN name);
void    forell(void *E, long call(void*, GEN), long a, long b);

/* elliptic.c */

GEN     addell(GEN e, GEN z1, GEN z2);
GEN     akell(GEN e, GEN n);
GEN     anell(GEN e, long n);
GEN     bilhell(GEN e, GEN z1, GEN z2, long prec);
void    checkell(GEN e);
void    checkell_real(GEN e);
void    checkell_padic(GEN e);
void    checksmallell(GEN e);
void    checkellpt(GEN z);
void    checkell5(GEN e);
GEN     ell_to_small_red(GEN e, GEN *N);
GEN     ellap(GEN e, GEN p);
GEN     ellchangecurve(GEN e, GEN ch);
GEN     elldivpol(GEN e, long n, long v);
GEN     elleisnum(GEN om, long k, long flag, long prec);
GEN     elleta(GEN om, long prec);
GEN     ellglobalred(GEN e1);
GEN     ellgroup(GEN E, GEN p);
GEN     ellheight0(GEN e, GEN a, long flag,long prec);
GEN     ellinit(GEN x, long prec);
GEN     ellinit0(GEN x,long flag,long prec);
GEN     ellinit_padic(GEN x, GEN p, long prec);
GEN     ellinit_real(GEN x, long prec);
GEN     ellisoncurve(GEN e, GEN z);
GEN     elllseries(GEN e, GEN s, GEN A, long prec);
GEN     elllocalred(GEN e, GEN p1);
GEN     elllog(GEN e, GEN a, GEN g, GEN o);
GEN     ellminimalmodel(GEN E, GEN *ptv);
GEN     ellorder(GEN e, GEN p, GEN o);
GEN     ellordinate(GEN e, GEN x, long prec);
GEN     ellrandom(GEN e);
long    ellrootno(GEN e, GEN p);
long    ellrootno_global(GEN e, GEN N);
GEN     ellsigma(GEN om, GEN z, long flag, long prec);
GEN     elltaniyama(GEN e, long prec);
GEN     elltatepairing(GEN E, GEN t, GEN s, GEN m);
GEN     elltors0(GEN e, long flag);
GEN     ellweilpairing(GEN E, GEN t, GEN s, GEN m);
GEN     ellwp0(GEN e, GEN z, long flag, long prec, long PREC);
GEN     ellzeta(GEN om, GEN z, long prec);
GEN     ghell(GEN e, GEN a, long prec);
GEN     mathell(GEN e, GEN x, long prec);
int     oncurve(GEN e, GEN z);
GEN     orderell(GEN e, GEN p);
GEN     ellchangepoint(GEN x, GEN ch);
GEN     ellchangepointinv(GEN x, GEN ch);
GEN     pointell(GEN e, GEN z, long prec);
GEN     powell(GEN e, GEN z, GEN n);
GEN     smallellinit(GEN x);
GEN     subell(GEN e, GEN z1, GEN z2);
GEN     elltors(GEN e);
GEN     weipell(GEN e, long precdl);
GEN     zell(GEN e, GEN z, long prec);

/* ellsea.c */

GEN     ellmodulareqn(long l, long vx, long vy);
GEN     ellsea(GEN E, GEN p, long early_abort);

/* es.c */

GEN     GENtoGENstr_nospace(GEN x);
GEN     GENtoGENstr(GEN x);
char*   GENtoTeXstr(GEN x);
char*   GENtostr(GEN x);
GEN     Str(GEN g);
GEN     Strchr(GEN g);
GEN     Strexpand(GEN g);
GEN     Strtex(GEN g);
void    brute(GEN g, char format, long dec);
void    dbgGEN(GEN x, long nb);
void    error0(GEN g);
void    dbg_pari_heap(void);
int     file_is_binary(FILE *f);
void    err_flush(void);
void    err_printf(const char* pat, ...);
GEN     gp_read_file(char *s);
GEN     gp_read_stream(FILE *f);
GEN     gp_readvec_file(char *s);
GEN     gp_readvec_stream(FILE *f);
char*   itostr(GEN x);
void    matbrute(GEN g, char format, long dec);
char*   os_getenv(const char *s);
void    (*os_signal(int sig, void (*f)(int)))(int);
void    outmat(GEN x);
void    output(GEN x);
char*   RgV_to_str(GEN g, long flag);
GEN     pari_add_hist(GEN z);
void    pari_ask_confirm(const char *s);
void    pari_fclose(pariFILE *f);
void    pari_flush(void);
pariFILE* pari_fopen(const char *s, const char *mode);
pariFILE* pari_fopen_or_fail(const char *s, const char *mode);
pariFILE* pari_fopengz(const char *s);
void    pari_fprintf(FILE *file, const char *fmt, ...);
GEN     pari_get_hist(long p);
char*   pari_get_homedir(const char *user);
int     pari_is_dir(const char *name);
int     pari_is_file(const char *name);
int     pari_last_was_newline(void);
void    pari_set_last_newline(int last);
ulong   pari_nb_hist(void);
void    pari_printf(const char *fmt, ...);
void    pari_putc(char c);
void    pari_puts(const char *s);
pariFILE* pari_safefopen(const char *s, const char *mode);
char*   pari_sprintf(const char *fmt, ...);
int     pari_stdin_isatty(void);
char*   pari_strdup(const char *s);
char*   pari_strndup(const char *s, long n);
char*   pari_unique_dir(const char *s);
char*   pari_unique_filename(const char *s);
void    pari_unlink(const char *s);
void    pari_vfprintf(FILE *file, const char *fmt, va_list ap);
void    pari_vprintf(const char *fmt, va_list ap);
char*   pari_vsprintf(const char *fmt, va_list ap);
char*   path_expand(const char *s);
void    out_print0(PariOUT *out, GEN g, long flag);
void    out_printf(PariOUT *out, const char *fmt, ...);
void    out_putc(PariOUT *out, char c);
void    out_puts(PariOUT *out, const char *s);
void    out_term_color(PariOUT *out, long c);
void    out_vprintf(PariOUT *out, const char *fmt, va_list ap);
void    print(GEN g);
enum { f_RAW = 0, f_PRETTYMAT = 1, f_PRETTY = 3, f_TEX = 4 };
void    print0(GEN g, long flag);
void    print1(GEN g);
void    printf0(const char *fmt, GEN args);
void    printtex(GEN g);
char*   stack_strdup(const char *s);
void    strftime_expand(const char *s, char *buf, long max);
GEN     Strprintf(const char *fmt, GEN args);
FILE*   switchin(const char *name);
void    switchout(const char *name);
void    term_color(long c);
char*   term_get_color(char *s, long c);
void    texe(GEN g, char format, long dec);
const char* type_name(long t);
void    warning0(GEN g);
void    write0(const char *s, GEN g);
void    write1(const char *s, GEN g);
void    writebin(const char *name, GEN x);
void    writetex(const char *s, GEN g);

/* eval.c */

GEN     break0(long n);
GEN     closure_callgen1(GEN C, GEN x);
GEN     closure_callgen2(GEN C, GEN x, GEN y);
GEN     closure_callgenall(GEN C, long n, ...);
GEN     closure_callgenvec(GEN C, GEN args);
void    closure_callvoid1(GEN C, GEN x);
long    closure_context(long start);
void    closure_disassemble(GEN n);
void    closure_err(void);
GEN     closure_evalbrk(GEN C, long *status);
GEN     closure_evalgen(GEN C);
GEN     closure_evalnobrk(GEN C);
GEN     closure_evalres(GEN C);
void    closure_evalvoid(GEN C);
GEN     closure_trapgen(GEN C, long numerr);
GEN     get_lex(long vn);
GEN     gp_call(void *E, GEN x);
long    gp_callbool(void *E, GEN x);
long    gp_callvoid(void *E, GEN x);
GEN     gp_eval(void *E, GEN x);
long    gp_evalvoid(void *E, GEN x);
long    loop_break(void);
GEN     next0(long n);
void    pop_lex(long n);
void    push_lex(GEN a, GEN C);
GEN     return0(GEN x);
void    set_lex(long vn, GEN x);

/* FF.c */

GEN     FF_1(GEN a);
GEN     FF_Z_Z_muldiv(GEN x, GEN y, GEN z);
GEN     FF_Q_add(GEN x, GEN y);
GEN     FF_Z_add(GEN a, GEN b);
GEN     FF_Z_mul(GEN a, GEN b);
GEN     FF_add(GEN a, GEN b);
GEN     FF_charpoly(GEN x);
int     FF_equal0(GEN x);
int     FF_equal1(GEN x);
int     FF_equalm1(GEN x);
GEN     FF_conjvec(GEN x);
GEN     FF_div(GEN a, GEN b);
int     FF_equal(GEN a, GEN b);
GEN     FF_inv(GEN a);
long    FF_issquare(GEN x);
long    FF_issquareall(GEN x, GEN *pt);
long    FF_ispower(GEN x, GEN K, GEN *pt);
GEN     FF_log(GEN a, GEN b, GEN o);
GEN     FF_minpoly(GEN x);
GEN     FF_mod(GEN x);
GEN     FF_mul(GEN a, GEN b);
GEN     FF_mul2n(GEN a, long n);
GEN     FF_neg(GEN a);
GEN     FF_neg_i(GEN a);
GEN     FF_norm(GEN x);
GEN     FF_order(GEN x, GEN o);
GEN     FF_p(GEN x);
GEN     FF_p_i(GEN x);
GEN     FF_pow(GEN x, GEN n);
GEN     FF_primroot(GEN x, GEN *o);
int     FF_samefield(GEN x, GEN y);
GEN     FF_sqr(GEN a);
GEN     FF_sqrt(GEN a);
GEN     FF_sqrtn(GEN x, GEN n, GEN *zetan);
GEN     FF_sub(GEN x, GEN y);
GEN     FF_to_FpXQ(GEN x);
GEN     FF_to_FpXQ_i(GEN x);
GEN     FF_trace(GEN x);
GEN     FF_zero(GEN a);
GEN     FFX_factor(GEN f, GEN x);
GEN     FFX_roots(GEN f, GEN x);
GEN     Z_FF_div(GEN a, GEN b);
GEN     ffgen(GEN T, long v);
GEN     fflog(GEN x, GEN g, GEN o);
GEN     fforder(GEN x, GEN o);
GEN     ffprimroot(GEN x, GEN *o);
GEN     ffrandom(GEN ff);
int     is_Z_factor(GEN f);

/* galconj.c */

GEN     checkgal(GEN gal);
GEN     checkgroup(GEN g, GEN *S);
GEN     galois_group(GEN gal);
GEN     galoisconj(GEN nf, GEN d);
GEN     galoisconj0(GEN nf, long flag, GEN d, long prec);
GEN     galoisexport(GEN gal, long format);
GEN     galoisfixedfield(GEN gal, GEN v, long flag, long y);
GEN     galoisidentify(GEN gal);
GEN     galoisinit(GEN nf, GEN den);
GEN     galoisisabelian(GEN gal, long flag);
long    galoisisnormal(GEN gal, GEN sub);
GEN     galoispermtopol(GEN gal, GEN perm);
GEN     galoissubgroups(GEN G);
GEN     galoissubfields(GEN G, long flag, long v);
long    numberofconjugates(GEN T, long pdepart);
GEN     vandermondeinverse(GEN L, GEN T, GEN den, GEN prep);

/* gen1.c */
GEN     conjvec(GEN x,long prec);
GEN     gadd(GEN x, GEN y);
GEN     gaddsg(long x, GEN y);
GEN     gconj(GEN x);
GEN     gdiv(GEN x, GEN y);
GEN     gdivgs(GEN x, long s);
GEN     ginv(GEN x);
GEN     gmul(GEN x, GEN y);
GEN     gmul2n(GEN x, long n);
GEN     gmulsg(long s, GEN y);
GEN     gsqr(GEN x);
GEN     gsub(GEN x, GEN y);
GEN     gsubsg(long x, GEN y);
GEN     inv_ser(GEN b);
GEN     mulcxI(GEN x);
GEN     mulcxmI(GEN x);

/* galpol.c */

GEN     galoisnbpol(long a);
GEN     galoisgetpol(long a, long b, long s);

/* gen2.c */

GEN     gassoc_proto(GEN f(GEN,GEN),GEN,GEN);
GEN     map_proto_G(GEN f(GEN), GEN x);
GEN     map_proto_GG(GEN f(GEN,GEN), GEN x, GEN n);
GEN     map_proto_GL(GEN f(GEN,long), GEN x, long y);
GEN     map_proto_lG(long f(GEN), GEN x);
GEN     map_proto_lGG(long f(GEN,GEN), GEN x, GEN n);
GEN     map_proto_lGL(long f(GEN,long), GEN x, long y);

long    Q_pval(GEN x, GEN p);
long    RgX_val(GEN x);
long    RgX_valrem(GEN x, GEN *z);
long    RgX_valrem_inexact(GEN x, GEN *Z);
long    ZV_pval(GEN x, GEN p);
long    ZV_pvalrem(GEN x, GEN p, GEN *px);
long    ZV_lval(GEN x, ulong p);
long    ZV_lvalrem(GEN x, ulong p, GEN *px);
long    ZX_lvalrem(GEN x, ulong p, GEN *px);
long    ZX_lval(GEN x, ulong p);
long    ZX_pval(GEN x, GEN p);
long    ZX_pvalrem(GEN x, GEN p, GEN *px);
long    Z_lval(GEN n, ulong p);
long    Z_lvalrem(GEN n, ulong p, GEN *py);
long    Z_pval(GEN n, GEN p);
long    Z_pvalrem(GEN x, GEN p, GEN *py);
GEN     cgetp(GEN x);
GEN     cvstop2(long s, GEN y);
GEN     cvtop(GEN x, GEN p, long l);
GEN     cvtop2(GEN x, GEN y);
GEN     gabs(GEN x, long prec);
void    gaffect(GEN x, GEN y);
void    gaffsg(long s, GEN x);
int     gcmp(GEN x, GEN y);
int     gequal0(GEN x);
int     gequal1(GEN x);
int     gcmpX(GEN x);
int     gequalm1(GEN x);
int     gcmpsg(long x, GEN y);
GEN     gcvtop(GEN x, GEN p, long r);
int     gequal(GEN x, GEN y);
int     gequalsg(long s, GEN x);
long    gexpo(GEN x);
long    ggval(GEN x, GEN p);
int     gidentical(GEN x, GEN y);
long    glength(GEN x);
GEN     gmax(GEN x, GEN y);
GEN     gmaxgs(GEN x, long y);
GEN     gmin(GEN x, GEN y);
GEN     gmings(GEN x, long y);
GEN     gneg(GEN x);
GEN     gneg_i(GEN x);
GEN     RgX_to_ser(GEN x, long l);
GEN     RgX_to_ser_inexact(GEN x, long l);
int     gsigne(GEN x);
GEN     gtolist(GEN x);
long    gtolong(GEN x);
int     lexcmp(GEN x, GEN y);
GEN     listinsert(GEN list, GEN object, long index);
void    listpop(GEN L, long index);
GEN     listput(GEN list, GEN object, long index);
void    listsort(GEN list, long flag);
GEN     matsize(GEN x);
GEN     mklistcopy(GEN x);
GEN     normalize(GEN x);
GEN     normalizepol(GEN x);
GEN     normalizepol_approx(GEN x, long lx);
GEN     normalizepol_lg(GEN x, long lx);
ulong   padic_to_Fl(GEN x, ulong p);
GEN     padic_to_Fp(GEN x, GEN Y);
GEN     quadtofp(GEN x, long l);
long    sizedigit(GEN x);
long    u_lval(ulong x, ulong p);
long    u_lvalrem(ulong x, ulong p, ulong *py);
long    u_pval(ulong x, GEN p);
long    u_pvalrem(ulong x, GEN p, ulong *py);
GEN     vecmax(GEN x);
GEN     vecmin(GEN x);
long    z_lval(long s, ulong p);
long    z_lvalrem(long s, ulong p, long *py);
long    z_pval(long n, GEN p);
long    z_pvalrem(long n, GEN p, long *py);


/* gen3.c */

GEN     RgM_mulreal(GEN x, GEN y);
GEN     RgX_RgM_eval(GEN x, GEN y);
GEN     RgX_RgM_eval_col(GEN x, GEN M, long c);
GEN     RgX_RgMV_eval(GEN x, GEN y);
GEN     RgX_deflate_max(GEN x0, long *m);
GEN     ceil_safe(GEN x);
GEN     ceilr(GEN x);
GEN     centerlift(GEN x);
GEN     centerlift0(GEN x,long v);
GEN     compo(GEN x, long n);
GEN     deg1pol(GEN x1, GEN x0,long v);
GEN     deg1pol_shallow(GEN x1, GEN x0,long v);
long    degree(GEN x);
GEN     denom(GEN x);
GEN     deriv(GEN x, long v);
GEN     derivser(GEN x);
GEN     diffop(GEN x, GEN v, GEN dv);
GEN     diffop0(GEN x, GEN v, GEN dv, long n);
GEN     diviiround(GEN x, GEN y);
GEN     divrem(GEN x, GEN y, long v);
GEN     floor_safe(GEN x);
GEN     gand(GEN x, GEN y);
GEN     gceil(GEN x);
GEN     gcvtoi(GEN x, long *e);
GEN     gdeflate(GEN x, long v, long d);
GEN     gdivent(GEN x, GEN y);
GEN     gdiventgs(GEN x, long y);
GEN     gdiventsg(long x, GEN y);
GEN     gdiventres(GEN x, GEN y);
GEN     gdivmod(GEN x, GEN y, GEN *pr);
GEN     gdivround(GEN x, GEN y);
int     gdvd(GEN x, GEN y);
GEN     geq(GEN x, GEN y);
GEN     geval(GEN x);
GEN     gfloor(GEN x);
GEN     gtrunc2n(GEN x, long s);
GEN     gfrac(GEN x);
GEN     gge(GEN x, GEN y);
GEN     ggrando(GEN x, long n);
GEN     ggt(GEN x, GEN y);
GEN     gimag(GEN x);
GEN     gle(GEN x, GEN y);
GEN     glt(GEN x, GEN y);
GEN     gmod(GEN x, GEN y);
GEN     gmodgs(GEN x, long y);
GEN     gmodsg(long x, GEN y);
GEN     gmodulo(GEN x,GEN y);
GEN     gmodulsg(long x, GEN y);
GEN     gmodulss(long x, long y);
GEN     gne(GEN x, GEN y);
GEN     gnot(GEN x);
GEN     gor(GEN x, GEN y);
GEN     gpolvar(GEN y);
long    gprecision(GEN x);
GEN     greal(GEN x);
GEN     grndtoi(GEN x, long *e);
GEN     ground(GEN x);
GEN     gshift(GEN x, long n);
GEN     gsubst(GEN x, long v, GEN y);
GEN     gsubstpol(GEN x, GEN v, GEN y);
GEN     gsubstvec(GEN x, GEN v, GEN y);
GEN     gtocol(GEN x);
GEN     gtopoly(GEN x, long v);
GEN     gtopolyrev(GEN x, long v);
GEN     gtoser(GEN x, long v, long precdl);
GEN     gtovec(GEN x);
GEN     gtovecrev(GEN x);
GEN     gtovecsmall(GEN x);
GEN     gtrunc(GEN x);
long    gvar(GEN x);
long    gvar2(GEN x);
GEN     hqfeval(GEN q, GEN x);
GEN     imag_i(GEN x);
GEN     integ(GEN x, long v);
int     iscomplex(GEN x);
int     isexactzero(GEN g);
int     isrationalzeroscalar(GEN g);
int     isinexact(GEN x);
int     isinexactreal(GEN x);
int     isint(GEN n, GEN *ptk);
int     isrationalzero(GEN g);
int     issmall(GEN n, long *ptk);
GEN     lift(GEN x);
GEN     lift0(GEN x,long v);
GEN     mkcoln(long n, ...);
GEN     mkintn(long n, ...);
GEN     mkpoln(long n, ...);
GEN     mkvecn(long n, ...);
GEN     mkvecsmalln(long n, ...);
GEN     mulreal(GEN x, GEN y);
GEN     numer(GEN x);
long    padicprec(GEN x, GEN p);
GEN     polcoeff0(GEN x,long n,long v);
GEN     polcoeff_i(GEN x, long n, long v);
long    poldegree(GEN x,long v);
GEN     poleval(GEN x, GEN y);
GEN     pollead(GEN x,long v);
long    precision(GEN x);
GEN     precision0(GEN x,long n);
GEN     qf_apply_RgM(GEN q, GEN M);
GEN     qf_apply_ZM(GEN q, GEN M);
GEN     qfeval(GEN q, GEN x);
GEN     qfevalb(GEN q, GEN x, GEN y);
GEN     real_i(GEN x);
GEN     recip(GEN x);
GEN     round0(GEN x, GEN *pte);
GEN     roundr(GEN x);
GEN     roundr_safe(GEN x);
GEN     scalarpol(GEN x, long v);
GEN     scalarser(GEN x, long v, long prec);
GEN     simplify(GEN x);
GEN     simplify_shallow(GEN x);
GEN     tayl(GEN x, long v, long precdl);
GEN     toser_i(GEN x);
GEN     trunc0(GEN x, GEN *pte);
GEN     uu32toi(ulong a, ulong b);

/* groupid.c */

long    group_ident(GEN G, GEN S);
long    group_ident_trans(GEN G, GEN S);

/* hash.c */

hashtable *hash_create(ulong minsize, ulong (*hash)(void*), int (*eq)(void*,void*));
void hash_insert(hashtable *h, void *k, void *v);
hashentry *hash_search(hashtable *h, void *k);
hashentry *hash_remove(hashtable *h, void *k);
void hash_destroy(hashtable *h);
ulong hash_str(const char *str);
ulong hash_str2(const char *s);
ulong hash_GEN(GEN x);

/* hnf_snf.c */

GEN     Frobeniusform(GEN V, long n);
GEN     ZM_hnf(GEN x);
GEN     ZM_hnfall(GEN A, GEN *ptB, long remove);
GEN     ZM_hnfcenter(GEN M);
GEN     ZM_hnflll(GEN A, GEN *ptB, int remove);
GEN     ZM_hnfmod(GEN x, GEN d);
GEN     ZM_hnfmodall(GEN x, GEN dm, long flag);
GEN     ZM_hnfmodid(GEN x, GEN d);
GEN     ZM_hnfperm(GEN A, GEN *ptU, GEN *ptperm);
void    ZM_snfclean(GEN d, GEN u, GEN v);
GEN     ZM_snf(GEN x);
GEN     ZM_snf_group(GEN H, GEN *newU, GEN *newUi);
GEN     ZM_snfall(GEN x, GEN *ptU, GEN *ptV);
GEN     ZM_snfall_i(GEN x, GEN *ptU, GEN *ptV, int return_vec);
GEN     gsmith(GEN x);
GEN     gsmithall(GEN x);
GEN     hnf(GEN x);
GEN     hnf_divscale(GEN A, GEN B,GEN t);
GEN     hnf_solve(GEN A, GEN B);
GEN     hnf_invimage(GEN A, GEN b);
GEN     hnfall(GEN x);
int     hnfdivide(GEN A, GEN B);
GEN     hnflll(GEN x);
GEN     hnfmerge_get_1(GEN A, GEN B);
GEN     hnfmod(GEN x, GEN d);
GEN     hnfmodid(GEN x,GEN p);
GEN     hnfperm(GEN x);
GEN     matfrobenius(GEN M, long flag, long v);
GEN     mathnf0(GEN x, long flag);
GEN     matsnf0(GEN x, long flag);
GEN     smith(GEN x);
GEN     smithall(GEN x);
GEN     smithclean(GEN z);

/* ifactor1.c */

GEN     gnextprime(GEN n);
GEN     gprecprime(GEN n);
int     is_357_power(GEN x, GEN *pt, ulong *mask);
int     is_pth_power(GEN x, GEN *pt, ulong *curexp, ulong cutoffbits);
GEN     nextprime(GEN n);
GEN     precprime(GEN n);
ulong   unextprime(ulong n);

/* init.c */

void    allocatemem(ulong newsize);
long    timer_delay(pari_timer *T);
long    timer_get(pari_timer *T);
void    timer_start(pari_timer *T);
int     chk_gerepileupto(GEN x);
GENbin* copy_bin(GEN x);
GENbin* copy_bin_canon(GEN x);
void    dbg_block(void);
void    dbg_gerepile(pari_sp av);
void    dbg_gerepileupto(GEN q);
void    dbg_release(void);
long    err_catch(long errnum, jmp_buf *penv);
void    err_leave(long n);
GEN     gclone(GEN x);
void    gclone_refc(GEN x);
GEN     gcopy(GEN x);
GEN     gcopy_avma(GEN x, pari_sp *AVMA);
GEN     gcopy_lg(GEN x, long lx);
GEN     gerepile(pari_sp ltop, pari_sp lbot, GEN q);
void    gerepileallsp(pari_sp av, pari_sp tetpil, int n, ...);
void    gerepilecoeffssp(pari_sp av, pari_sp tetpil, long *g, int n);
void    gerepilemanysp(pari_sp av, pari_sp tetpil, GEN* g[], int n);
GEN     getheap(void);
void    gp_context_save(struct gp_context* rec);
void    gp_context_restore(struct gp_context* rec);
long    gsizeword(GEN x);
long    gsizebyte(GEN x);
void    gunclone(GEN x);
void    gunclone_deep(GEN x);
GEN     listcopy(GEN x);
void    timer_printf(pari_timer *T, const char *format, ...);
void    msgtimer(const char *format, ...);
GEN     newblock(size_t n);
void    pari_add_function(entree *ep);
void    pari_add_module(entree *ep);
void    pari_add_defaults_module(entree *ep);
void    pari_add_oldmodule(entree *ep);
void    pari_close(void);
void    pari_close_opts(ulong init_opts);
int     pari_daemon(void);
void    pari_err(int numerr, ...);
void    pari_init_opts(size_t parisize, ulong maxprime, ulong init_opts);
void    pari_init(size_t parisize, ulong maxprime);
void    pari_stackcheck_init(void *stack_base);
void    pari_sig_init(void (*f)(int));
void    pari_thread_alloc(struct pari_thread *t, size_t s, GEN arg);
void    pari_thread_close(void);
void    pari_thread_free(struct pari_thread *t);
void    pari_thread_init(void);
GEN     pari_thread_start(struct pari_thread *t);
GEN     pari_version(void);
void    pari_warn(int numerr, ...);
GEN     trap0(const char *e, GEN f, GEN r);
void    shiftaddress(GEN x, long dec);
void    shiftaddress_canon(GEN x, long dec);
long    timer(void);
long    timer2(void);
void    traverseheap( void(*f)(GEN, void *), void *data );

/* intnum.c */

GEN     intcirc(void *E, GEN (*eval) (void *, GEN), GEN a, GEN R, GEN tab, long prec);
GEN     intfouriercos(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, GEN x, GEN tab, long prec);
GEN     intfourierexp(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, GEN x, GEN tab, long prec);
GEN     intfouriersin(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, GEN x, GEN tab, long prec);
GEN     intfuncinit(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, long m, long flag, long prec);
GEN     intlaplaceinv(void *E, GEN (*eval) (void *, GEN), GEN sig, GEN x, GEN tab, long prec);
GEN     intmellininv(void *E, GEN (*eval) (void *, GEN), GEN sig, GEN x, GEN tab, long prec);
GEN     intmellininvshort(GEN sig, GEN x, GEN tab, long prec);
GEN     intnum(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, GEN tab, long prec);
GEN     intnuminit(GEN a, GEN b, long m, long prec);
GEN     intnuminitgen(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, long m, long flext, long prec);
GEN     intnumromb(void *E, GEN (*eval) (void *, GEN), GEN a, GEN b, long flag, long prec);
long    intnumstep(long prec);
GEN     sumnum(void *E, GEN (*f) (void *, GEN), GEN a, GEN sig, GEN tab, long flag, long prec);
GEN     sumnumalt(void *E, GEN (*f) (void *, GEN), GEN a, GEN s, GEN tab, long flag, long prec);
GEN     sumnuminit(GEN sig, long m, long sgn, long prec);

/* krasner.c */

GEN     padicfields0(GEN p, GEN n, long flag);
GEN     padicfields(GEN p, long m, long d, long flag);

/* kummer.c */

GEN     rnfkummer(GEN bnr, GEN subgroup, long all, long prec);

/* lll.c */
GEN     ZM_lll_norms(GEN x, double D, long flag, GEN *B);
GEN     kerint(GEN x);
GEN     lll(GEN x);
GEN     lllfp(GEN x, double D, long flag);
GEN     lllgen(GEN x);
GEN     lllgram(GEN x);
GEN     lllgramgen(GEN x);
GEN     lllgramint(GEN x);
GEN     lllgramkerim(GEN x);
GEN     lllgramkerimgen(GEN x);
GEN     lllint(GEN x);
GEN     lllintpartial(GEN mat);
GEN     lllintpartial_inplace(GEN mat);
GEN     lllkerim(GEN x);
GEN     lllkerimgen(GEN x);
GEN     matkerint0(GEN x,long flag);
GEN     qflll0(GEN x, long flag);
GEN     qflllgram0(GEN x, long flag);

/* members.c */

GEN     member_a1(GEN x);
GEN     member_a2(GEN x);
GEN     member_a3(GEN x);
GEN     member_a4(GEN x);
GEN     member_a6(GEN x);
GEN     member_area(GEN x);
GEN     member_b2(GEN x);
GEN     member_b4(GEN x);
GEN     member_b6(GEN x);
GEN     member_b8(GEN x);
GEN     member_bid(GEN x);
GEN     member_bnf(GEN x);
GEN     member_c4(GEN x);
GEN     member_c6(GEN x);
GEN     member_clgp(GEN x);
GEN     member_codiff(GEN x);
GEN     member_cyc(GEN clg);
GEN     member_diff(GEN x);
GEN     member_disc(GEN x);
GEN     member_e(GEN x);
GEN     member_eta(GEN x);
GEN     member_f(GEN x);
GEN     member_fu(GEN x);
GEN     member_futu(GEN x);
GEN     member_gen(GEN x);
GEN     member_group(GEN x);
GEN     member_index(GEN x);
GEN     member_j(GEN x);
GEN     member_mod(GEN x);
GEN     member_nf(GEN x);
GEN     member_no(GEN clg);
GEN     member_omega(GEN x);
GEN     member_orders(GEN x);
GEN     member_p(GEN x);
GEN     member_pol(GEN x);
GEN     member_reg(GEN x);
GEN     member_r1(GEN x);
GEN     member_r2(GEN x);
GEN     member_roots(GEN x);
GEN     member_sign(GEN x);
GEN     member_t2(GEN x);
GEN     member_tate(GEN x);
GEN     member_tufu(GEN x);
GEN     member_tu(GEN x);
GEN     member_w(GEN x);
GEN     member_zk(GEN x);
GEN     member_zkst(GEN bid);

/* mp.c */

ulong   Fl_inv(ulong x, ulong p);
int     Fp_ratlift(GEN x, GEN m, GEN amax, GEN bmax, GEN *a, GEN *b);
int     absi_cmp(GEN x, GEN y);
int     absi_equal(GEN x, GEN y);
int     absr_cmp(GEN x, GEN y);
GEN     addii_sign(GEN x, long sx, GEN y, long sy);
GEN     addir_sign(GEN x, long sx, GEN y, long sy);
GEN     addrr_sign(GEN x, long sx, GEN y, long sy);
GEN     addsi_sign(long x, GEN y, long sy);
GEN     addsr(long x, GEN y);
GEN     addumului(ulong a, ulong b, GEN Y);
void    affir(GEN x, GEN y);
void    affrr(GEN x, GEN y);
GEN     bezout(GEN a, GEN b, GEN *u, GEN *v);
long    cbezout(long a,long b,long *uu,long *vv);
int     cmpii(GEN x, GEN y);
int     cmprr(GEN x, GEN y);
long    dblexpo(double x);
ulong   dblmantissa(double x);
GEN     dbltor(double x);
GEN     diviiexact(GEN x, GEN y);
GEN     divir(GEN x, GEN y);
GEN     divis(GEN y, long x);
GEN     divis_rem(GEN x, long y, long *rem);
GEN     diviu_rem(GEN y, ulong x, ulong *rem);
GEN     diviuexact(GEN x, ulong y);
GEN     divri(GEN x, GEN y);
GEN     divrr(GEN x, GEN y);
GEN     divrs(GEN x, long y);
GEN     divru(GEN x, ulong y);
GEN     divsi(long x, GEN y);
GEN     divsr(long x, GEN y);
GEN     divur(ulong x, GEN y);
GEN     dvmdii(GEN x, GEN y, GEN *z);
int     equalii(GEN x, GEN y);
int     equalrr(GEN x, GEN y);
GEN     floorr(GEN x);
GEN     gcdii(GEN x, GEN y);
GEN     int2n(long n);
GEN     int2u(ulong n);
GEN     int_normalize(GEN x, long known_zero_words);
int     invmod(GEN a, GEN b, GEN *res);
ulong   invmod2BIL(ulong b);
GEN     invr(GEN b);
GEN     mantissa_real(GEN x, long *e);
GEN     modii(GEN x, GEN y);
void    modiiz(GEN x, GEN y, GEN z);
GEN     mulii(GEN x, GEN y);
GEN     mulir(GEN x, GEN y);
GEN     mulrr(GEN x, GEN y);
GEN     mulsi(long x, GEN y);
GEN     mulsr(long x, GEN y);
GEN     mulss(long x, long y);
GEN     mului(ulong x, GEN y);
GEN     mulur(ulong x, GEN y);
GEN     muluu(ulong x, ulong y);
int     ratlift(GEN x, GEN m, GEN amax, GEN bmax, GEN *a, GEN *b);
GEN     remi2n(GEN x, long n);
double  rtodbl(GEN x);
GEN     shifti(GEN x, long n);
GEN     sqri(GEN x);
GEN     sqrr(GEN x);
GEN     sqrs(long x);
GEN     sqrtr_abs(GEN x);
GEN     sqrtremi(GEN S, GEN *R);
GEN     sqru(ulong x);
GEN     subsr(long x, GEN y);
GEN     truedvmdii(GEN x, GEN y, GEN *z);
GEN     truedvmdis(GEN x, long y, GEN *z);
GEN     truedvmdsi(long x, GEN y, GEN *z);
GEN     trunc2nr(GEN x, long n);
GEN     trunc2nr_lg(GEN x, long lx, long n);
GEN     truncr(GEN x);
ulong   umodiu(GEN y, ulong x);
long    vals(ulong x);

/* nffactor.c */

GEN     FpM_ratlift(GEN M, GEN mod, GEN amax, GEN bmax, GEN denom);
GEN     FpX_ratlift(GEN P, GEN mod, GEN amax, GEN bmax, GEN denom);
GEN     nffactor(GEN nf,GEN x);
GEN     nffactormod(GEN nf,GEN pol,GEN pr);
GEN     nfgcd(GEN P, GEN Q, GEN nf, GEN den);
GEN     nfgcd_all(GEN P, GEN Q, GEN T, GEN den, GEN *Pnew);
GEN     nfroots(GEN nf,GEN pol);
GEN     polfnf(GEN a, GEN t);
GEN     rootsof1(GEN x);
GEN     rootsof1_kannan(GEN nf);

/* paricfg.c */

extern const char *paricfg_datadir;
extern const char *paricfg_version;
extern const char *paricfg_buildinfo;
extern const long  paricfg_version_code;
extern const char *paricfg_vcsversion;

/* part.c */

GEN     numbpart(GEN x);
GEN     partitions(long n, long amax);

/* perm.c */

GEN     abelian_group(GEN G);
GEN     cyclicgroup(GEN g, long s);
GEN     cyc_pow(GEN cyc, long exp);
GEN     cyc_pow_perm(GEN cyc, long exp);
GEN     dicyclicgroup(GEN g1, GEN g2, long s1, long s2);
GEN     group_abelianHNF(GEN G, GEN L);
GEN     group_abelianSNF(GEN G, GEN L);
long    group_domain(GEN G);
GEN     group_elts(GEN G, long n);
GEN     group_export(GEN G, long format);
long    group_isA4S4(GEN G);
long    group_isabelian(GEN G);
GEN     group_leftcoset(GEN G, GEN g);
long    group_order(GEN G);
long    group_perm_normalize(GEN N, GEN g);
GEN     group_quotient(GEN G, GEN H);
GEN     group_rightcoset(GEN G, GEN g);
GEN     group_set(GEN G, long n);
long    group_subgroup_isnormal(GEN G, GEN H);
GEN     group_subgroups(GEN G);
GEN     groupelts_abelian_group(GEN S);
GEN     groupelts_center(GEN S);
GEN     groupelts_set(GEN G, long n);
int     perm_commute(GEN p, GEN q);
GEN     perm_cycles(GEN v);
long    perm_order(GEN perm);
GEN     perm_pow(GEN perm, long exp);
GEN     quotient_group(GEN C, GEN G);
GEN     quotient_perm(GEN C, GEN p);
GEN     quotient_subgroup_lift(GEN C, GEN H, GEN S);
GEN     subgroups_tableset(GEN S, long n);
long    tableset_find_index(GEN tbl, GEN set);
GEN     trivialgroup(void);
GEN     vecperm_orbits(GEN v, long n);
int     vec_is1to1(GEN v);
int     vec_isconst(GEN v);
long    vecsmall_duplicate(GEN x);
long    vecsmall_duplicate_sorted(GEN x);
GEN     vecsmall_indexsort(GEN V);
void    vecsmall_sort(GEN V);
GEN     vecsmall_uniq(GEN V);
GEN     vecsmall_uniq_sorted(GEN V);
GEN     vecvecsmall_indexsort(GEN x);
GEN     vecvecsmall_sort(GEN x);
long    vecvecsmall_search(GEN x, GEN y, long flag);

/* polarit1.c */

long    Flx_nbfact(GEN z, ulong p);
GEN     Flx_nbfact_by_degree(GEN z, long *nb, ulong p);
long    Flx_nbroots(GEN f, ulong p);
GEN     FpX_degfact(GEN f, GEN p);
int     FpX_is_irred(GEN f, GEN p);
int     FpX_is_totally_split(GEN f, GEN p);
GEN     FpX_factor(GEN f, GEN p);
GEN     FpX_factorff(GEN P, GEN p, GEN T);
long    FpX_nbfact(GEN f, GEN p);
long    FpX_nbroots(GEN f, GEN p);
GEN     FpX_oneroot(GEN f, GEN p);
GEN     FpX_roots(GEN f, GEN p);
GEN     FpX_rootsff(GEN P, GEN p, GEN T);
GEN     FqX_deriv(GEN f, GEN T, GEN p);
GEN     FqX_factor(GEN x, GEN T, GEN p);
long    FqX_is_squarefree(GEN P, GEN T, GEN p);
long    FqX_nbfact(GEN u, GEN T, GEN p);
long    FqX_nbroots(GEN f, GEN T, GEN p);
GEN     FqX_roots(GEN f, GEN T, GEN p);
GEN     factcantor(GEN x, GEN p);
GEN     factorff(GEN f, GEN p, GEN a);
GEN     factormod0(GEN f, GEN p,long flag);
GEN     factorpadic0(GEN f,GEN p,long r,long flag);
GEN     factorpadic(GEN x, GEN p, long r);
GEN     gdeuc(GEN x, GEN y);
GEN     grem(GEN x, GEN y);
GEN     padicappr(GEN f, GEN a);
GEN     poldivrem(GEN x, GEN y, GEN *pr);
GEN     polrootsff(GEN f, GEN p, GEN T);
GEN     rootmod0(GEN f, GEN p,long flag);
GEN     rootpadic(GEN f, GEN p, long r);
GEN     rootpadicfast(GEN f, GEN p, long e);

/* Hensel.c */

GEN     Zp_sqrtlift(GEN b, GEN a, GEN p, long e);
GEN     Zp_sqrtnlift(GEN b, GEN n, GEN a, GEN p, long e);
GEN     ZpX_liftroot(GEN f, GEN a, GEN p, long e);
GEN     ZpX_liftroots(GEN f, GEN S, GEN q, long e);
GEN     ZpXQX_liftroot(GEN f, GEN a, GEN T, GEN p, long e);
GEN     ZpXQ_sqrtnlift(GEN b, GEN n, GEN a, GEN T, GEN p, long e);
GEN     ZpX_liftfact(GEN pol, GEN Q, GEN T, GEN p, long e, GEN pe);
GEN     polhensellift(GEN pol, GEN fct, GEN p, long exp);
ulong   quadratic_prec_mask(long n);

/* QX_factor.c */

GEN     QX_factor(GEN x);
GEN     ZX_factor(GEN x);
long    ZX_is_irred(GEN x);
GEN     ZX_squff(GEN f, GEN *ex);

/* polarit2.c */

GEN     Q_content(GEN x);
GEN     Q_denom(GEN x);
GEN     Q_div_to_int(GEN x, GEN c);
GEN     Q_gcd(GEN x, GEN y);
GEN     Q_mul_to_int(GEN x, GEN c);
GEN     Q_muli_to_int(GEN x, GEN d);
GEN     Q_primitive_part(GEN x, GEN *ptc);
GEN     Q_primpart(GEN x);
GEN     Q_remove_denom(GEN x, GEN *ptd);
GEN     RgXQ_charpoly(GEN x, GEN T, long v);
GEN     RgXQ_inv(GEN x, GEN y);
GEN     RgX_disc(GEN x);
GEN     RgX_extgcd(GEN x, GEN y, GEN *U, GEN *V);
GEN     RgX_extgcd_simple(GEN a, GEN b, GEN *pu, GEN *pv);
GEN     RgX_gcd(GEN x, GEN y);
GEN     RgX_gcd_simple(GEN x, GEN y);
int     RgXQ_ratlift(GEN y, GEN x, long amax, long bmax, GEN *P, GEN *Q);
GEN     RgX_resultant_all(GEN P, GEN Q, GEN *sol);
long    RgX_type(GEN x, GEN *ptp, GEN *ptpol, long *ptpa);
void    RgX_type_decode(long x, long *t1, long *t2);
int     RgX_type_is_composite(long t);
GEN     ZX_content(GEN x);
GEN     centermod(GEN x, GEN p);
GEN     centermod_i(GEN x, GEN p, GEN ps2);
GEN     centermodii(GEN x, GEN p, GEN po2);
GEN     content(GEN x);
GEN     deg1_from_roots(GEN L, long v);
GEN     divide_conquer_assoc(GEN x, void *data, GEN (*mul)(void*,GEN,GEN));
GEN     divide_conquer_prod(GEN x, GEN (*mul)(GEN,GEN));
GEN     factor(GEN x);
GEN     factor0(GEN x,long flag);
GEN     factorback(GEN fa);
GEN     factorback2(GEN fa,GEN e);
GEN     famat_mul_shallow(GEN f, GEN g);
GEN     gbezout(GEN x, GEN y, GEN *u, GEN *v);
GEN     gdivexact(GEN x, GEN y);
GEN     gen_factorback(GEN L, GEN e, GEN (*_mul)(void*,GEN,GEN), GEN (*_pow)(void*,GEN,GEN), void *data);
GEN     ggcd(GEN x, GEN y);
GEN     ggcd0(GEN x, GEN y);
GEN     ginvmod(GEN x, GEN y);
GEN     gisirreducible(GEN x);
GEN     glcm(GEN x, GEN y);
GEN     glcm0(GEN x, GEN y);
GEN     gp_factor0(GEN x, GEN flag);
GEN     idealfactorback(GEN nf, GEN L, GEN e, int red);
GEN     leftright_pow_fold(GEN x, GEN n, void *data, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     leftright_pow_u_fold(GEN x, ulong n, void *data, GEN (*sqr)(void*,GEN), GEN (*msqr)(void*,GEN));
GEN     newtonpoly(GEN x, GEN p);
GEN     nffactorback(GEN nf, GEN L, GEN e);
GEN     nfrootsQ(GEN x);
GEN     poldisc0(GEN x, long v);
GEN     polresultant0(GEN x, GEN y,long v,long flag);
GEN     polsym(GEN x, long n);
GEN     primitive_part(GEN x, GEN *c);
GEN     primpart(GEN x);
GEN     reduceddiscsmith(GEN pol);
GEN     resultant2(GEN x, GEN y);
GEN     resultant_all(GEN u, GEN v, GEN *sol);
GEN     rnfcharpoly(GEN nf, GEN T, GEN alpha, long v);
GEN     roots_from_deg1(GEN x);
GEN     roots_to_pol(GEN a, long v);
GEN     roots_to_pol_r1(GEN a, long v, long r1);
long    sturmpart(GEN x, GEN a, GEN b);
GEN     subresext(GEN x, GEN y, GEN *U, GEN *V);
GEN     sylvestermatrix(GEN x,GEN y);
GEN     vecbezout(GEN x, GEN y);
GEN     vecbezoutres(GEN x, GEN y);

/* polarit3.c */

GEN     FlxX_resultant(GEN u, GEN v, ulong p, long sx);
GEN     Flx_FlxY_resultant(GEN a, GEN b, ulong pp);
GEN     Flx_roots_naive(GEN f, ulong p);
GEN     FpV_polint(GEN xa, GEN ya, GEN p, long v);
GEN     FpX_FpXQ_eval(GEN f,GEN x,GEN T,GEN p);
GEN     FpX_FpXQV_eval(GEN f,GEN x,GEN T,GEN p);
GEN     FpX_FpXY_resultant(GEN a, GEN b0, GEN p);
GEN     FpX_factorff_irred(GEN P, GEN Q, GEN l);
void    FpX_ffintersect(GEN P,GEN Q,long n,GEN l,GEN *SP,GEN *SQ,GEN MA,GEN MB);
GEN     FpX_ffisom(GEN P,GEN Q,GEN l);
GEN     FpXQ_ffisom_inv(GEN S,GEN Tp, GEN p);
GEN     FpXQX_gcd(GEN P, GEN Q, GEN T, GEN p);
GEN     FpXQX_mul(GEN x, GEN y, GEN T, GEN p);
GEN     FpXQX_red(GEN z, GEN T, GEN p);
GEN     FpXQX_sqr(GEN x, GEN T, GEN p);
GEN     FpXQX_extgcd(GEN x, GEN y, GEN T, GEN p, GEN *ptu, GEN *ptv);
GEN     FpXQX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *pr);
GEN     FpXQX_FpXQ_mul(GEN P, GEN U, GEN T, GEN p);
GEN     FpXQXQ_div(GEN x,GEN y,GEN S, GEN T,GEN p);
GEN     FpXQXQ_inv(GEN x, GEN S, GEN T,GEN p);
GEN     FpXQXQ_invsafe(GEN x, GEN S, GEN T, GEN p);
GEN     FpXQXQ_mul(GEN x, GEN y, GEN S, GEN T, GEN p);
GEN     FpXQXQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
GEN     FpXQXQ_sqr(GEN x, GEN S, GEN T, GEN p);
GEN     FpXQXV_prod(GEN V, GEN Tp, GEN p);
GEN     FpXV_FpC_mul(GEN V, GEN W, GEN p);
GEN     FpXX_Fp_mul(GEN x, GEN y, GEN p);
GEN     FpXX_add(GEN x, GEN y, GEN p);
GEN     FpXX_red(GEN z, GEN p);
GEN     FpXX_sub(GEN x, GEN y, GEN p);
GEN     FpXY_eval(GEN Q, GEN y, GEN x, GEN p);
GEN     FpXY_evalx(GEN Q, GEN x, GEN p);
GEN     FpXY_evaly(GEN Q, GEN y, GEN p, long vy);
GEN     FpXYQQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
GEN     Fq_inv(GEN x, GEN T, GEN p);
GEN     Fq_invsafe(GEN x, GEN T, GEN p);
GEN     Fq_add(GEN x, GEN y, GEN T/*unused*/, GEN p);
GEN     Fq_Fp_mul(GEN x, GEN y, GEN T, GEN p);
GEN     Fq_mul(GEN x, GEN y, GEN T, GEN p);
GEN     Fq_neg(GEN x, GEN T, GEN p);
GEN     Fq_neg_inv(GEN x, GEN T, GEN p);
GEN     Fq_pow(GEN x, GEN n, GEN T, GEN p);
GEN     Fq_sub(GEN x, GEN y, GEN T/*unused*/, GEN p);
GEN     Fq_sqr(GEN x, GEN T, GEN p);
GEN     Fq_sqrt(GEN x, GEN T, GEN p);
GEN     FqC_to_FlxC(GEN v, GEN T, GEN pp);
GEN     FqM_to_FlxM(GEN x, GEN T, GEN pp);
GEN     FqV_roots_to_pol(GEN V, GEN T, GEN p, long v);
GEN     FqV_red(GEN z, GEN T, GEN p);
GEN     FqV_to_FlxV(GEN v, GEN T, GEN pp);
GEN     FqX_Fq_mul_to_monic(GEN P, GEN U, GEN T, GEN p);
GEN     FqX_eval(GEN x, GEN y, GEN T, GEN p);
GEN     FqX_normalize(GEN z, GEN T, GEN p);
GEN     FqX_translate(GEN P, GEN c, GEN T, GEN p);
GEN     QX_disc(GEN x);
GEN     QX_gcd(GEN a,GEN b);
GEN     QX_resultant(GEN A, GEN B);
GEN     QXQ_intnorm(GEN A, GEN B);
GEN     QXQ_inv(GEN A, GEN B);
GEN     QXQ_norm(GEN A, GEN B);
int     Rg_is_Fp(GEN x, GEN *p);
int     Rg_is_FpXQ(GEN x, GEN *pT, GEN *pp);
ulong   Rg_to_Fl(GEN x, ulong p);
GEN     Rg_to_Fp(GEN x, GEN p);
GEN     Rg_to_FpXQ(GEN x, GEN T, GEN p);
GEN     RgC_to_FpC(GEN x, GEN p);
int     RgM_is_FpM(GEN x, GEN *p);
GEN     RgM_to_FpM(GEN x, GEN p);
int     RgV_is_FpV(GEN x, GEN *p);
GEN     RgV_to_FpV(GEN x, GEN p);
int     RgX_is_FpX(GEN x, GEN *p);
GEN     RgX_to_FpX(GEN x, GEN p);
int     RgX_is_FpXQX(GEN x, GEN *pT, GEN *pp);
GEN     RgX_to_FpXQX(GEN x, GEN T, GEN p);
GEN     RgX_to_FqX(GEN x, GEN T, GEN p);
GEN     ZX_ZXY_rnfequation(GEN A, GEN B, long *lambda);
GEN     ZXQ_charpoly(GEN A, GEN T, long v);
GEN     ZX_disc(GEN x);
int     ZX_is_squarefree(GEN x);
GEN     ZX_gcd(GEN A, GEN B);
GEN     ZX_gcd_all(GEN A, GEN B, GEN *Anew);
GEN     ZX_resultant(GEN A, GEN B);
int     Z_incremental_CRT(GEN *H, ulong Hp, GEN q, GEN qp, ulong p);
GEN     Z_init_CRT(ulong Hp, ulong p);
int     ZM_incremental_CRT(GEN *H, GEN Hp, GEN q, GEN qp, ulong p);
GEN     ZM_init_CRT(GEN Hp, ulong p);
int     ZX_incremental_CRT(GEN *ptH, GEN Hp, GEN q, GEN qp, ulong p);
GEN     ZX_init_CRT(GEN Hp, ulong p, long v);
long    brent_kung_optpow(long d, long n);
GEN     ffinit(GEN p, long n, long v);
GEN     Kronecker_to_mod(GEN z, GEN pol);
GEN     init_Fq(GEN p, long n, long v);
GEN     pol_x_powers(long N, long v);
GEN     mod_to_Kronecker(GEN P, GEN Q);

/* prime.c */

long    BPSW_isprime(GEN x);
long    BPSW_psp(GEN N);
GEN     addprimes(GEN primes);
GEN     gisprime(GEN x, long flag);
GEN     gispseudoprime(GEN x, long flag);
long    isprime(GEN x);
long    ispseudoprime(GEN x, long flag);
long    millerrabin(GEN n, long k);
GEN     prime(long n);
GEN     primepi(GEN x);
GEN     primes(long n);
GEN     primes_zv(long m);
GEN     removeprimes(GEN primes);
int     uisprime(ulong n);
ulong   uprime(long n);
ulong   uprimepi(ulong n);

/* random.c */

GEN     genrand(GEN N);
GEN     getrand(void);
ulong   pari_rand(void);
GEN     randomi(GEN x);
GEN     randomr(long prec);
ulong   random_Fl(ulong n);
void    setrand(GEN seed);

/* rootpol.c */

GEN     cleanroots(GEN x,long l);
int     isrealappr(GEN x, long l);
GEN     roots(GEN x,long l);
GEN     roots0(GEN x,long flag,long l);

/* polsubcyclo.c */

GEN     factor_Aurifeuille(GEN p, long n);
GEN     factor_Aurifeuille_prime(GEN p, long n);
GEN     galoissubcyclo(GEN N, GEN sg, long flag, long v);
GEN     polsubcyclo(long n, long d, long v);

/* subfield.c */

GEN     nfsubfields(GEN nf, long d);

/* subgroup.c */

GEN     subgrouplist(GEN cyc, GEN bound);
void    forsubgroup(void *E, long fun(void*,GEN), GEN cyc, GEN B);

/* stark.c */

GEN     bnrL1(GEN bnr, GEN sbgrp, long flag, long prec);
GEN     bnrrootnumber(GEN bnr, GEN chi, long flag, long prec);
GEN     bnrstark(GEN bnr, GEN subgroup, long prec);

/* sumiter.c */

GEN     derivnum(void *E, GEN (*eval)(void *, GEN), GEN x, long prec);
GEN     derivfun(void *E, GEN (*eval)(void *, GEN), GEN x, long prec);
GEN     direuler(void *E, GEN (*eval)(void *, GEN), GEN ga, GEN gb, GEN c);
GEN     forvec_start(GEN x, long flag, GEN *d, GEN (**next)(GEN,GEN));
GEN     polzag(long n, long m);
GEN     prodeuler(void *E, GEN (*eval)(void *, GEN), GEN ga, GEN gb, long prec);
GEN     prodinf(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     prodinf1(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumalt(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumalt2(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumpos(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     sumpos2(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     suminf(void *E, GEN (*eval)(void *, GEN), GEN a, long prec);
GEN     zbrent(void *E, GEN (*eval)(void *, GEN), GEN a, GEN b, long prec);

/* thue.c */

GEN     bnfisintnorm(GEN x, GEN y);
GEN     bnfisintnormabs(GEN bnf, GEN a);
GEN     thue(GEN thueres, GEN rhs, GEN ne);
GEN     thueinit(GEN pol, long flag, long prec);

/* trans1.c */

GEN     Pi2n(long n, long prec);
GEN     PiI2(long prec);
GEN     PiI2n(long n, long prec);
GEN     Qp_exp(GEN x);
GEN     Qp_log(GEN x);
GEN     Qp_sqrt(GEN x);
GEN     Qp_sqrtn(GEN x, GEN n, GEN *zetan);
long    Zn_issquare(GEN x, GEN n);
GEN     Zn_sqrt(GEN x, GEN n);
GEN     agm(GEN x, GEN y, long prec);
GEN     consteuler(long prec);
GEN     constlog2(long prec);
GEN     constpi(long prec);
GEN     exp_Ir(GEN x);
GEN     exp1r_abs(GEN x);
GEN     gcos(GEN x, long prec);
GEN     gcotan(GEN x, long prec);
GEN     gexp(GEN x, long prec);
GEN     glog(GEN x, long prec);
GEN     gpow(GEN x, GEN n, long prec);
GEN     gpowgs(GEN x, long n);
GEN     gsin(GEN x, long prec);
void    gsincos(GEN x, GEN *s, GEN *c, long prec);
GEN     gsqrt(GEN x, long prec);
GEN     gsqrtn(GEN x, GEN n, GEN *zetan, long prec);
GEN     gtan(GEN x, long prec);
GEN     logr_abs(GEN x);
GEN     mpcos(GEN x);
GEN     mpeuler(long prec);
GEN     mpexp(GEN x);
GEN     mpexp1(GEN x);
GEN     mplog(GEN x);
GEN     mplog2(long prec);
GEN     mppi(long prec);
GEN     mpsin(GEN x);
void    mpsincos(GEN x, GEN *s, GEN *c);
GEN     powis(GEN x, long n);
GEN     powiu(GEN p, ulong k);
GEN     powrfrac(GEN x, long n, long d);
GEN     powrs(GEN x, long n);
GEN     powrshalf(GEN x, long s);
GEN     powru(GEN x, ulong n);
GEN     powruhalf(GEN x, ulong s);
GEN     powuu(ulong p, ulong k);
GEN     powgi(GEN x, GEN n);
GEN     teich(GEN x);
ulong   upowuu(ulong p, ulong k);

/* trans2.c */

GEN     Qp_gamma(GEN x);
GEN     bernfrac(long n);
GEN     bernreal(long n, long prec);
GEN     gach(GEN x, long prec);
GEN     gacos(GEN x, long prec);
GEN     garg(GEN x, long prec);
GEN     gash(GEN x, long prec);
GEN     gasin(GEN x, long prec);
GEN     gatan(GEN x, long prec);
GEN     gath(GEN x, long prec);
GEN     gch(GEN x, long prec);
GEN     ggamd(GEN x, long prec);
GEN     ggamma(GEN x, long prec);
GEN     glngamma(GEN x, long prec);
GEN     gpsi(GEN x, long prec);
GEN     gsh(GEN x, long prec);
GEN     gth(GEN x, long prec);
void    mpbern(long nomb, long prec);
GEN     mpfactr(long n, long prec);

/* trans3.c */

GEN     dilog(GEN x, long prec);
GEN     eint1(GEN x, long prec);
GEN     eta(GEN x, long prec);
GEN     eta0(GEN x, long flag,long prec);
GEN     gerfc(GEN x, long prec);
GEN     gpolylog(long m, GEN x, long prec);
GEN     gzeta(GEN x, long prec);
GEN     hyperu(GEN a, GEN b, GEN gx, long prec);
GEN     incgam(GEN a, GEN x, long prec);
GEN     incgam0(GEN a, GEN x, GEN z,long prec);
GEN     incgamc(GEN a, GEN x, long prec);
GEN     hbessel1(GEN n, GEN z, long prec);
GEN     hbessel2(GEN n, GEN z, long prec);
GEN     ibessel(GEN n, GEN z, long prec);
GEN     jbessel(GEN n, GEN z, long prec);
GEN     jbesselh(GEN n, GEN z, long prec);
GEN     mpeint1(GEN x, GEN expx);
GEN     mpveceint1(GEN C, GEN eC, long n);
GEN     mpvecpow(GEN e, long n);
GEN     nbessel(GEN n, GEN z, long prec);
GEN     jell(GEN x, long prec);
GEN     kbessel(GEN nu, GEN gx, long prec);
GEN     polylog0(long m, GEN x, long flag, long prec);
GEN     sumdedekind_coprime(GEN h, GEN k);
GEN     sumdedekind(GEN h, GEN k);
GEN     szeta(long x, long prec);
GEN     theta(GEN q, GEN z, long prec);
GEN     thetanullk(GEN q, long k, long prec);
GEN     trueeta(GEN x, long prec);
GEN     veceint1(GEN nmax, GEN C, long prec);
GEN     vecthetanullk(GEN q, long k, long prec);
GEN     weber0(GEN x, long flag,long prec);
GEN     weberf(GEN x, long prec);
GEN     weberf1(GEN x, long prec);
GEN     weberf2(GEN x, long prec);

/* level1.h */

INLINE ulong  Fl_add(ulong a, ulong b, ulong p);
INLINE long   Fl_center(ulong u, ulong p, ulong ps2);
INLINE ulong  Fl_div(ulong a, ulong b, ulong p);
INLINE ulong  Fl_mul(ulong a, ulong b, ulong p);
INLINE ulong  Fl_neg(ulong x, ulong p);
INLINE ulong  Fl_sqr(ulong a, ulong p);
INLINE ulong  Fl_sub(ulong a, ulong b, ulong p);
INLINE GEN    absi(GEN x);
INLINE GEN    absr(GEN x);
INLINE int    absrnz_equal1(GEN x);
INLINE int    absrnz_equal2n(GEN x);
INLINE GEN    addii(GEN x, GEN y);
INLINE void   addiiz(GEN x, GEN y, GEN z);
INLINE GEN    addir(GEN x, GEN y);
INLINE void   addirz(GEN x, GEN y, GEN z);
INLINE GEN    addis(GEN x, long s);
INLINE GEN    addri(GEN x, GEN y);
INLINE void   addriz(GEN x, GEN y, GEN z);
INLINE GEN    addrr(GEN x, GEN y);
INLINE void   addrrz(GEN x, GEN y, GEN z);
INLINE GEN    addrs(GEN x, long s);
INLINE GEN    addsi(long x, GEN y);
INLINE void   addsiz(long s, GEN y, GEN z);
INLINE void   addsrz(long s, GEN y, GEN z);
INLINE GEN    addss(long x, long y);
INLINE void   addssz(long s, long y, GEN z);
INLINE GEN    adduu(ulong x, ulong y);
INLINE void   affgr(GEN x, GEN y);
INLINE void   affii(GEN x, GEN y);
INLINE void   affiz(GEN x, GEN y);
INLINE void   affrr_fixlg(GEN y, GEN z);
INLINE void   affsi(long s, GEN x);
INLINE void   affsr(long s, GEN x);
INLINE void   affsz(long x, GEN y);
INLINE void   affui(ulong s, GEN x);
INLINE void   affur(ulong s, GEN x);
INLINE GEN    cgetg(long x, long y);
INLINE GEN    cgetg_copy(GEN x, long *plx);
INLINE GEN    cgeti(long x);
INLINE GEN    cgetineg(long x);
INLINE GEN    cgetipos(long x);
INLINE GEN    cgetr(long x);
INLINE int    cmpir(GEN x, GEN y);
INLINE int    cmpis(GEN x, long y);
INLINE int    cmpiu(GEN x, ulong y);
INLINE int    cmpri(GEN x, GEN y);
INLINE int    cmprs(GEN x, long y);
INLINE int    cmpsi(long x, GEN y);
INLINE int    cmpsr(long x, GEN y);
INLINE int    cmpui(ulong x, GEN y);
INLINE GEN    cxtofp(GEN x, long prec);
INLINE GEN    divii(GEN a, GEN b);
INLINE void   diviiz(GEN x, GEN y, GEN z);
INLINE void   divirz(GEN x, GEN y, GEN z);
INLINE void   divisz(GEN x, long s, GEN z);
INLINE void   divriz(GEN x, GEN y, GEN z);
INLINE void   divrrz(GEN x, GEN y, GEN z);
INLINE void   divrsz(GEN y, long s, GEN z);
INLINE GEN    divsi_rem(long x, GEN y, long *rem);
INLINE void   divsiz(long x, GEN y, GEN z);
INLINE void   divsrz(long s, GEN y, GEN z);
INLINE GEN    divss(long x, long y);
INLINE GEN    divss_rem(long x, long y, long *rem);
INLINE void   divssz(long x, long y, GEN z);
INLINE int    dvdii(GEN x, GEN y);
INLINE int    dvdiiz(GEN x, GEN y, GEN z);
INLINE int    dvdis(GEN x, long y);
INLINE int    dvdisz(GEN x, long y, GEN z);
INLINE int    dvdiu(GEN x, ulong y);
INLINE int    dvdiuz(GEN x, ulong y, GEN z);
INLINE int    dvdsi(long x, GEN y);
INLINE int    dvdui(ulong x, GEN y);
INLINE void   dvmdiiz(GEN x, GEN y, GEN z, GEN t);
INLINE GEN    dvmdis(GEN x, long y, GEN *z);
INLINE void   dvmdisz(GEN x, long y, GEN z, GEN t);
INLINE long   dvmdsBIL(long n, long *r);
INLINE GEN    dvmdsi(long x, GEN y, GEN *z);
INLINE void   dvmdsiz(long x, GEN y, GEN z, GEN t);
INLINE GEN    dvmdss(long x, long y, GEN *z);
INLINE void   dvmdssz(long x, long y, GEN z, GEN t);
INLINE ulong  dvmduBIL(ulong n, ulong *r);
INLINE int    equalis(GEN x, long y);
INLINE int    equaliu(GEN x, ulong y);
INLINE int    equalsi(long x, GEN y);
INLINE int    equalui(ulong x, GEN y);
INLINE long   evalexpo(long x);
INLINE long   evallg(long x);
INLINE long   evalvalp(long x);
INLINE long   expi(GEN x);
INLINE long   expu(ulong x);
INLINE void   fixlg(GEN z, long ly);
INLINE GEN    fractor(GEN x, long prec);
INLINE GEN    icopy(GEN x);
INLINE GEN    icopy_avma(GEN x, pari_sp av);
INLINE GEN    itor(GEN x, long prec);
INLINE long   itos(GEN x);
INLINE long   itos_or_0(GEN x);
INLINE ulong  itou(GEN x);
INLINE ulong  itou_or_0(GEN x);
INLINE GEN    leafcopy(GEN x);
INLINE double maxdd(double x, double y);
INLINE long   maxss(long x, long y);
INLINE long   maxuu(ulong x, ulong y);
INLINE double mindd(double x, double y);
INLINE long   minss(long x, long y);
INLINE long   minuu(ulong x, ulong y);
INLINE long   mod16(GEN x);
INLINE long   mod2(GEN x);
INLINE ulong  mod2BIL(GEN x);
INLINE long   mod32(GEN x);
INLINE long   mod4(GEN x);
INLINE long   mod64(GEN x);
INLINE long   mod8(GEN x);
INLINE GEN    modis(GEN x, long y);
INLINE void   modisz(GEN y, long s, GEN z);
INLINE GEN    modsi(long x, GEN y);
INLINE void   modsiz(long s, GEN y, GEN z);
INLINE GEN    modss(long x, long y);
INLINE void   modssz(long s, long y, GEN z);
INLINE GEN    mpabs(GEN x);
INLINE GEN    mpadd(GEN x, GEN y);
INLINE void   mpaddz(GEN x, GEN y, GEN z);
INLINE void   mpaff(GEN x, GEN y);
INLINE GEN    mpceil(GEN x);
INLINE int    mpcmp(GEN x, GEN y);
INLINE GEN    mpcopy(GEN x);
INLINE GEN    mpdiv(GEN x, GEN y);
INLINE long   mpexpo(GEN x);
INLINE GEN    mpfloor(GEN x);
INLINE GEN    mpmul(GEN x, GEN y);
INLINE void   mpmulz(GEN x, GEN y, GEN z);
INLINE GEN    mpneg(GEN x);
INLINE int    mpodd(GEN x);
INLINE GEN    mpround(GEN x);
INLINE GEN    mpshift(GEN x,long s);
INLINE GEN    mpsqr(GEN x);
INLINE GEN    mpsub(GEN x, GEN y);
INLINE void   mpsubz(GEN x, GEN y, GEN z);
INLINE GEN    mptrunc(GEN x);
INLINE void   muliiz(GEN x, GEN y, GEN z);
INLINE void   mulirz(GEN x, GEN y, GEN z);
INLINE GEN    mulis(GEN x, long s);
INLINE GEN    muliu(GEN x, ulong s);
INLINE GEN    mulri(GEN x, GEN s);
INLINE void   mulriz(GEN x, GEN y, GEN z);
INLINE void   mulrrz(GEN x, GEN y, GEN z);
INLINE GEN    mulrs(GEN x, long s);
INLINE GEN    mulru(GEN x, ulong s);
INLINE void   mulsiz(long s, GEN y, GEN z);
INLINE void   mulsrz(long s, GEN y, GEN z);
INLINE void   mulssz(long s, long y, GEN z);
INLINE GEN    negi(GEN x);
INLINE GEN    negr(GEN x);
INLINE GEN    new_chunk(size_t x);
INLINE GEN    rcopy(GEN x);
INLINE GEN    rdivii(GEN x, GEN y, long prec);
INLINE void   rdiviiz(GEN x, GEN y, GEN z);
INLINE GEN    rdivis(GEN x, long y, long prec);
INLINE GEN    rdivsi(long x, GEN y, long prec);
INLINE GEN    rdivss(long x, long y, long prec);
INLINE GEN    real2n(long n, long prec);
INLINE GEN    real_0(long prec);
INLINE GEN    real_0_bit(long bitprec);
INLINE GEN    real_1(long prec);
INLINE GEN    real_m1(long prec);
INLINE GEN    remii(GEN a, GEN b);
INLINE void   remiiz(GEN x, GEN y, GEN z);
INLINE GEN    remis(GEN x, long y);
INLINE void   remisz(GEN y, long s, GEN z);
INLINE GEN    remsi(long x, GEN y);
INLINE void   remsiz(long s, GEN y, GEN z);
INLINE GEN    remss(long x, long y);
INLINE void   remssz(long s, long y, GEN z);
INLINE GEN    rtor(GEN x, long prec);
INLINE long   sdivsi(long x, GEN y);
INLINE long   sdivsi_rem(long x, GEN y, long *rem);
INLINE long   sdivss_rem(long x, long y, long *rem);
INLINE void   setabssign(GEN x);
INLINE void   shift_left(GEN z2, GEN z1, long min, long M, ulong f,  ulong sh);
INLINE void   shift_right(GEN z2, GEN z1, long min, long M, ulong f, ulong sh);
INLINE ulong  shiftl(ulong x, ulong y);
INLINE ulong  shiftlr(ulong x, ulong y);
INLINE GEN    shiftr(GEN x, long n);
INLINE long   smodis(GEN x, long y);
INLINE long   smodss(long x, long y);
INLINE void   stackdummy(pari_sp av, pari_sp ltop);
INLINE GEN    stoi(long x);
INLINE GEN    stor(long x, long prec);
INLINE GEN    subii(GEN x, GEN y);
INLINE void   subiiz(GEN x, GEN y, GEN z);
INLINE GEN    subir(GEN x, GEN y);
INLINE void   subirz(GEN x, GEN y, GEN z);
INLINE GEN    subis(GEN x, long y);
INLINE void   subisz(GEN y, long s, GEN z);
INLINE GEN    subri(GEN x, GEN y);
INLINE void   subriz(GEN x, GEN y, GEN z);
INLINE GEN    subrr(GEN x, GEN y);
INLINE void   subrrz(GEN x, GEN y, GEN z);
INLINE GEN    subrs(GEN x, long y);
INLINE void   subrsz(GEN y, long s, GEN z);
INLINE GEN    subsi(long x, GEN y);
INLINE void   subsiz(long s, GEN y, GEN z);
INLINE void   subsrz(long s, GEN y, GEN z);
INLINE GEN    subss(long x, long y);
INLINE void   subssz(long x, long y, GEN z);
INLINE GEN    subuu(ulong x, ulong y);
INLINE void   togglesign(GEN x);
INLINE void   togglesign_safe(GEN *px);
INLINE void   affectsign(GEN x, GEN y);
INLINE void   affectsign_safe(GEN x, GEN *py);
INLINE GEN    truedivii(GEN a,GEN b);
INLINE GEN    truedivis(GEN a, long b);
INLINE GEN    truedivsi(long a, GEN b);
INLINE ulong  udivui_rem(ulong x, GEN y, ulong *rem);
INLINE ulong  umodui(ulong x, GEN y);
INLINE GEN    utoi(ulong x);
INLINE GEN    utoineg(ulong x);
INLINE GEN    utoipos(ulong x);
INLINE GEN    utor(ulong s, long prec);
INLINE GEN    uutoi(ulong x, ulong y);
INLINE GEN    uutoineg(ulong x, ulong y);
INLINE long   vali(GEN x);

/* pariinl.h */
INLINE GEN    bid_get_arch(GEN bid);
INLINE GEN    bid_get_cyc(GEN bid);
INLINE GEN    bid_get_gen(GEN bid);
INLINE GEN    bid_get_gen_nocheck(GEN bid);
INLINE GEN    bid_get_ideal(GEN bid);
INLINE GEN    bid_get_mod(GEN bid);
INLINE GEN    bnf_get_clgp(GEN bnf);
INLINE GEN    bnf_get_cyc(GEN bnf);
INLINE GEN    bnf_get_fu(GEN bnf);
INLINE GEN    bnf_get_fu_nocheck(GEN bnf);
INLINE GEN    bnf_get_gen(GEN bnf);
INLINE GEN    bnf_get_logfu(GEN bnf);
INLINE GEN    bnf_get_nf(GEN bnf);
INLINE GEN    bnf_get_no(GEN bnf);
INLINE GEN    bnf_get_reg(GEN bnf);
INLINE GEN    bnf_get_tuU(GEN bnf);
INLINE long   bnf_get_tuN(GEN bnf);
INLINE GEN    bnr_get_bnf(GEN bnr);
INLINE GEN    bnr_get_clgp(GEN bnr);
INLINE GEN    bnr_get_cyc(GEN bnr);
INLINE GEN    bnr_get_gen(GEN bnr);
INLINE GEN    bnr_get_gen_nocheck(GEN bnr);
INLINE GEN    bnr_get_no(GEN bnr);
INLINE GEN    bnr_get_bid(GEN bnr);
INLINE GEN    bnr_get_mod(GEN bnr);
INLINE GEN    bnr_get_nf(GEN bnr);
INLINE GEN    ell_get_a1(GEN e);
INLINE GEN    ell_get_a2(GEN e);
INLINE GEN    ell_get_a3(GEN e);
INLINE GEN    ell_get_a4(GEN e);
INLINE GEN    ell_get_a6(GEN e);
INLINE GEN    ell_get_b2(GEN e);
INLINE GEN    ell_get_b4(GEN e);
INLINE GEN    ell_get_b6(GEN e);
INLINE GEN    ell_get_b8(GEN e);
INLINE GEN    ell_get_c4(GEN e);
INLINE GEN    ell_get_c6(GEN e);
INLINE GEN    ell_get_disc(GEN e);
INLINE GEN    ell_get_j(GEN e);
INLINE GEN    ell_get_roots(GEN e);
INLINE int    ell_is_inf(GEN z);
INLINE int    ell_is_padic(GEN e);
INLINE int    ell_is_real(GEN e);
INLINE GEN    ellinf(void);
INLINE GEN    gal_get_pol(GEN gal);
INLINE GEN    gal_get_p(GEN gal);
INLINE GEN    gal_get_e(GEN gal);
INLINE GEN    gal_get_mod(GEN gal);
INLINE GEN    gal_get_roots(GEN gal);
INLINE GEN    gal_get_invvdm(GEN gal);
INLINE GEN    gal_get_den(GEN gal);
INLINE GEN    gal_get_group(GEN gal);
INLINE GEN    gal_get_gen(GEN gal);
INLINE GEN    gal_get_orders(GEN gal);
INLINE GEN    idealpseudomin(GEN I, GEN G);
INLINE GEN    idealpseudomin_nonscalar(GEN I, GEN G);
INLINE GEN    idealred_elt(GEN nf, GEN I);
INLINE GEN    idealred(GEN nf, GEN I);
INLINE GEN    nf_get_M(GEN nf);
INLINE GEN    nf_get_G(GEN nf);
INLINE GEN    nf_get_Tr(GEN nf);
INLINE GEN    nf_get_diff(GEN nf);
INLINE long   nf_get_degree(GEN nf);
INLINE GEN    nf_get_disc(GEN nf);
INLINE GEN    nf_get_index(GEN nf);
INLINE GEN    nf_get_invzk(GEN nf);
INLINE GEN    nf_get_pol(GEN nf);
INLINE long   nf_get_r1(GEN nf);
INLINE long   nf_get_r2(GEN nf);
INLINE GEN    nf_get_roots(GEN nf);
INLINE GEN    nf_get_roundG(GEN nf);
INLINE void   nf_get_sign(GEN nf, long *r1, long *r2);
INLINE long   nf_get_varn(GEN nf);
INLINE GEN    nf_get_zk(GEN nf);
INLINE long   pr_get_e(GEN pr);
INLINE long   pr_get_f(GEN pr);
INLINE GEN    pr_get_gen(GEN pr);
INLINE GEN    pr_get_p(GEN pr);
INLINE GEN    pr_get_tau(GEN pr);
INLINE int    pr_is_inert(GEN P);
INLINE GEN    pr_norm(GEN pr);
INLINE long   rnf_get_degree(GEN rnf);

INLINE GEN    FpXQ_add(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    FpXQ_sub(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    Flxq_add(GEN x,GEN y,GEN T,ulong p);
INLINE GEN    Flxq_sub(GEN x,GEN y,GEN T,ulong p);

INLINE GEN    FpXQX_div(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FpXQX_rem(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FlxqX_div(GEN x, GEN y, GEN T, ulong p);
INLINE GEN    FlxqX_rem(GEN x, GEN y, GEN T, ulong p);

INLINE GEN    Fq_red(GEN x, GEN T, GEN p);
INLINE GEN    FqX_Fp_mul(GEN P, GEN U, GEN T, GEN p);
INLINE GEN    FqX_Fq_mul(GEN P, GEN U, GEN T, GEN p);
INLINE GEN    FqX_add(GEN x,GEN y,GEN T,GEN p);
INLINE GEN    FqX_div(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FqX_divrem(GEN x, GEN y, GEN T, GEN p, GEN *z);
INLINE GEN    FqX_extgcd(GEN P,GEN Q,GEN T,GEN p, GEN *U, GEN *V);
INLINE GEN    FqX_gcd(GEN P, GEN Q, GEN T, GEN p);
INLINE GEN    FqX_mul(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FqX_red(GEN z, GEN T, GEN p);
INLINE GEN    FqX_rem(GEN x, GEN y, GEN T, GEN p);
INLINE GEN    FqX_sqr(GEN x, GEN T, GEN p);
INLINE GEN    FqX_sub(GEN x,GEN y,GEN T,GEN p);

INLINE GEN    FqXQ_add(GEN x, GEN y, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_div(GEN x, GEN y, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_inv(GEN x, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_invsafe(GEN x, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_mul(GEN x, GEN y, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_pow(GEN x, GEN n, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_sqr(GEN x, GEN S, GEN T, GEN p);
INLINE GEN    FqXQ_sub(GEN x, GEN y, GEN S, GEN T, GEN p);

INLINE ulong  F2m_coeff(GEN x, long a, long b);
INLINE void   F2m_clear(GEN x, long a, long b);
INLINE void   F2m_flip(GEN x, long a, long b);
INLINE void   F2m_set(GEN x, long a, long b);
INLINE void   F2v_clear(GEN x,long v);
INLINE ulong  F2v_coeff(GEN x,long v);
INLINE void   F2v_flip(GEN x,long v);
INLINE void   F2v_set(GEN x,long v);
INLINE void   F2x_clear(GEN x,long v);
INLINE ulong  F2x_coeff(GEN x,long v);
INLINE void   F2x_flip(GEN x,long v);
INLINE void   F2x_set(GEN x,long v);
INLINE int    F2x_equal1(GEN x);
INLINE GEN    F2x_div(GEN x, GEN y);
INLINE GEN    F2x_renormalize(GEN x, long lx);
INLINE GEN    F2m_copy(GEN x);
INLINE GEN    Flm_copy(GEN x);
INLINE GEN    Flv_copy(GEN x);
INLINE int    Flx_equal1(GEN x);
INLINE GEN    Flx_copy(GEN x);
INLINE GEN    Flx_div(GEN x, GEN y, ulong p);
INLINE GEN    FpV_FpC_mul(GEN x, GEN y, GEN p);
INLINE GEN    FpXQX_renormalize(GEN x, long lx);
INLINE GEN    FpXX_renormalize(GEN x, long lx);
INLINE GEN    FpX_div(GEN x, GEN y, GEN p);
INLINE GEN    FpX_renormalize(GEN x, long lx);
INLINE GEN    Fp_add(GEN a, GEN b, GEN m);
INLINE GEN    Fp_center(GEN u, GEN p, GEN ps2);
INLINE GEN    Fp_div(GEN a, GEN b, GEN m);
INLINE GEN    Fp_inv(GEN a, GEN m);
INLINE GEN    Fp_invsafe(GEN a, GEN m);
INLINE GEN    Fp_mul(GEN a, GEN b, GEN m);
INLINE GEN    Fp_mulu(GEN a, ulong b, GEN m);
INLINE GEN    Fp_neg(GEN b, GEN m);
INLINE GEN    Fp_red(GEN x, GEN p);
INLINE GEN    Fp_sqr(GEN a, GEN m);
INLINE GEN    Fp_sub(GEN a, GEN b, GEN m);
INLINE GEN    GENbinbase(GENbin *p);
INLINE GEN    Q_abs(GEN x);
INLINE int    QV_isscalar(GEN x);
INLINE GEN    RgC_fpnorml2(GEN x, long prec);
INLINE GEN    RgC_gtofp(GEN x, long prec);
INLINE GEN    RgM_fpnorml2(GEN x, long prec);
INLINE GEN    RgM_gtofp(GEN x, long prec);
INLINE GEN    RgM_inv(GEN a);
INLINE int    RgM_is_ZM(GEN x);
INLINE GEN    RgM_minor(GEN a, long i, long j);
INLINE GEN    RgM_shallowcopy(GEN x);
INLINE int    RgV_isscalar(GEN x);
INLINE int    RgX_is_monomial(GEN x);
INLINE int    RgX_is_rational(GEN x);
INLINE int    RgX_is_ZX(GEN x);
INLINE int    RgX_isscalar(GEN x);
INLINE GEN    RgX_shift_inplace(GEN x, long v);
INLINE void   RgX_shift_inplace_init(long v);
INLINE GEN    RgXQ_mul(GEN x,GEN y,GEN T);
INLINE GEN    RgXQ_sqr(GEN x,GEN T);
INLINE GEN    RgXQX_div(GEN x, GEN y, GEN T);
INLINE GEN    RgXQX_rem(GEN x, GEN y, GEN T);
INLINE GEN    RgX_div(GEN x, GEN y);
INLINE GEN    RgX_fpnorml2(GEN x, long prec);
INLINE GEN    RgX_gtofp(GEN x, long prec);
INLINE GEN    RgX_rem(GEN x, GEN y);
INLINE GEN    Rg_col_ei(GEN x, long n, long i);
INLINE GEN    ZC_hnfrem(GEN x, GEN y);
INLINE GEN    ZM_hnfrem(GEN x, GEN y);
INLINE GEN    ZM_lll(GEN x, double D, long f);
INLINE int    ZV_dvd(GEN x, GEN y);
INLINE int    ZV_isscalar(GEN x);
INLINE GEN    ZV_to_zv(GEN x);
INLINE GEN    ZX_ZXY_resultant(GEN a, GEN b);
INLINE GEN    ZXQ_mul(GEN x,GEN y,GEN T);
INLINE GEN    ZXQ_sqr(GEN x,GEN T);
INLINE long   Z_ispower(GEN x, ulong k);
INLINE long   Z_issquare(GEN x);
INLINE GEN    absfrac(GEN x);
INLINE GEN    affc_fixlg(GEN x, GEN res);
INLINE GEN    bin_copy(GENbin *p);
INLINE long   bit_accuracy(long x);
INLINE double bit_accuracy_mul(long x, double y);
INLINE int    both_odd(long x, long y);
INLINE GEN    cgetc(long x);
INLINE GEN    cgetalloc(long t, size_t l);
INLINE GEN    cxcompotor(GEN z, long prec);
INLINE void   cgiv(GEN x);
INLINE GEN    col_ei(long n, long i);
INLINE GEN    const_col(long n, GEN x);
INLINE GEN    const_vec(long n, GEN x);
INLINE GEN    const_vecsmall(long n, long c);
INLINE GEN    constant_term(GEN x);
INLINE GEN    cxnorm(GEN x);
INLINE GEN    cyclic_perm(long l, long d);
INLINE double dbllog2r(GEN x);
INLINE long   degpol(GEN x);
INLINE long   divsBIL(long n);
INLINE void   gabsz(GEN x, long prec, GEN z);
INLINE GEN    gaddgs(GEN y, long s);
INLINE void   gaddz(GEN x, GEN y, GEN z);
INLINE int    gcmpgs(GEN y, long s);
INLINE void   gdiventz(GEN x, GEN y, GEN z);
INLINE GEN    gdivsg(long s, GEN y);
INLINE void   gdivz(GEN x, GEN y, GEN z);
INLINE GEN    gen_I(void);
INLINE void   gerepileall(pari_sp av, int n, ...);
INLINE void   gerepilecoeffs(pari_sp av, GEN x, int n);
INLINE GEN    gerepilecopy(pari_sp av, GEN x);
INLINE void   gerepilemany(pari_sp av, GEN* g[], int n);
INLINE int    gequalgs(GEN y, long s);
INLINE GEN    gerepileupto(pari_sp av, GEN q);
INLINE GEN    gerepileuptoint(pari_sp av, GEN q);
INLINE GEN    gerepileuptoleaf(pari_sp av, GEN q);
INLINE GEN    gmaxsg(long s, GEN y);
INLINE GEN    gminsg(long s, GEN y);
INLINE void   gmodz(GEN x, GEN y, GEN z);
INLINE void   gmul2nz(GEN x, long s, GEN z);
INLINE GEN    gmulgs(GEN y, long s);
INLINE void   gmulz(GEN x, GEN y, GEN z);
INLINE void   gnegz(GEN x, GEN z);
INLINE void   gshiftz(GEN x, long s, GEN z);
INLINE GEN    gsubgs(GEN y, long s);
INLINE void   gsubz(GEN x, GEN y, GEN z);
INLINE double gtodouble(GEN x);
INLINE GEN    gtofp(GEN z, long prec);
INLINE long   gtos(GEN x);
INLINE long   gval(GEN x, long v);
INLINE GEN    identity_perm(long l);
INLINE int    equali1(GEN n);
INLINE int    equalim1(GEN n);
INLINE int    is_bigint(GEN n);
INLINE int    is_const_t(long t);
INLINE int    is_extscalar_t(long t);
INLINE int    is_intreal_t(long t);
INLINE int    is_matvec_t(long t);
INLINE int    is_noncalc_t(long tx);
INLINE int    is_pm1(GEN n);
INLINE int    is_rational_t(long t);
INLINE int    is_recursive_t(long t);
INLINE int    is_scalar_t(long t);
INLINE int    is_universal_constant(GEN x);
INLINE int    is_vec_t(long t);
INLINE int    isint1(GEN x);
INLINE int    isintm1(GEN x);
INLINE int    isintzero(GEN x);
INLINE int    ismpzero(GEN x);
INLINE int    isonstack(GEN x);
INLINE void   killblock(GEN x);
INLINE GEN    leading_term(GEN x);
INLINE long   lgpol(GEN x);
INLINE GEN    matpascal(long n);
INLINE GEN    mkcol(GEN x);
INLINE GEN    mkcol2(GEN x, GEN y);
INLINE GEN    mkcolcopy(GEN x);
INLINE GEN    mkcomplex(GEN x, GEN y);
INLINE GEN    mkfrac(GEN x, GEN y);
INLINE GEN    mkfraccopy(GEN x, GEN y);
INLINE GEN    mkintmod(GEN x, GEN y);
INLINE GEN    mkintmodu(ulong x, ulong y);
INLINE GEN    mkmat(GEN x);
INLINE GEN    mkmat2(GEN x, GEN y);
INLINE GEN    mkmatcopy(GEN x);
INLINE GEN    mkpolmod(GEN x, GEN y);
INLINE GEN    mkquad(GEN n, GEN x, GEN y);
INLINE GEN    mkrfrac(GEN x, GEN y);
INLINE GEN    mkvec(GEN x);
INLINE GEN    mkvec2(GEN x, GEN y);
INLINE GEN    mkvec2copy(GEN x, GEN y);
INLINE GEN    mkvec2s(long x, long y);
INLINE GEN    mkvec3(GEN x, GEN y, GEN z);
INLINE GEN    mkvec3s(long x, long y, long z);
INLINE GEN    mkvec4(GEN x, GEN y, GEN z, GEN t);
INLINE GEN    mkvec5(GEN x, GEN y, GEN z, GEN t, GEN u);
INLINE GEN    mkveccopy(GEN x);
INLINE GEN    mkvecs(long x);
INLINE GEN    mkvecsmall(long x);
INLINE GEN    mkvecsmall2(long x,long y);
INLINE GEN    mkvecsmall3(long x,long y,long z);
INLINE GEN    mkvecsmall4(long x,long y,long z,long t);
INLINE void   mpcosz(GEN x, GEN z);
INLINE void   mpexpz(GEN x, GEN z);
INLINE void   mplogz(GEN x, GEN z);
INLINE void   mpsinz(GEN x, GEN z);
INLINE GEN    mul_content(GEN cx, GEN cy);
INLINE GEN    mul_denom(GEN cx, GEN cy);
INLINE long   nbits2nlong(long x);
INLINE long   nbits2prec(long x);
INLINE long   nchar2nlong(long x);
INLINE long   ndec2nlong(long x);
INLINE long   ndec2prec(long x);
INLINE void   normalize_frac(GEN z);
INLINE int    odd(long x);
INLINE void   pari_free(void *pointer);
INLINE void*  pari_calloc(size_t size);
INLINE void*  pari_malloc(size_t bytes);
INLINE void*  pari_realloc(void *pointer,size_t size);
INLINE GEN    perm_conj(GEN s, GEN t);
INLINE GEN    perm_inv(GEN x);
INLINE GEN    perm_mul(GEN s, GEN t);
INLINE GEN    pol_0(long v);
INLINE GEN    pol_1(long v);
INLINE GEN    pol_x(long v);
INLINE GEN    pol0_F2x(long sv);
INLINE GEN    pol1_F2x(long sv);
INLINE GEN    polx_F2x(long sv);
INLINE GEN    pol0_Flx(long sv);
INLINE GEN    pol1_Flx(long sv);
INLINE GEN    polx_Flx(long sv);
INLINE GEN    polx_zx(long sv);
INLINE GEN    powii(GEN x, GEN n);
INLINE GEN    powIs(long n);
INLINE long   prec2ndec(long x);
INLINE GEN    quad_disc(GEN x);
INLINE GEN    qfb_disc(GEN x);
INLINE GEN    qfb_disc3(GEN x, GEN y, GEN z);
INLINE GEN    quadnorm(GEN q);
INLINE long   random_bits(long k);
INLINE long   remsBIL(long n);
INLINE GEN    resultant(GEN x, GEN y);
INLINE GEN    row(GEN A, long x1);
INLINE GEN    row_Flm(GEN A, long x0);
INLINE GEN    row_i(GEN A, long x0, long x1, long x2);
INLINE GEN    row_zm(GEN x, long i);
INLINE GEN    rowcopy(GEN A, long x0);
INLINE GEN    rowpermute(GEN A, GEN p);
INLINE GEN    rowslice(GEN A, long x1, long x2);
INLINE GEN    rowslicepermute(GEN A, GEN p, long x1, long x2);
INLINE GEN    shallowcopy(GEN x);
INLINE GEN    sqrfrac(GEN x);
INLINE GEN    sqrti(GEN x);
INLINE GEN    sqrtnr(GEN x, long n);
INLINE GEN    sqrtr(GEN x);
INLINE void   stack_alloc(pari_stack *s, long nb);
INLINE void** stack_base(pari_stack *s);
INLINE void   stack_delete(pari_stack *s);
INLINE void   stack_init(pari_stack *s, size_t size, void **data);
INLINE long   stack_new(pari_stack *s);
INLINE void   stack_pushp(pari_stack *s, void *u);
INLINE long   sturm(GEN x);
INLINE GEN    truecoeff(GEN x, long n);
INLINE GEN    trunc_safe(GEN x);
INLINE GEN    vec_ei(long n, long i);
INLINE GEN    vec_lengthen(GEN v, long n);
INLINE GEN    vec_setconst(GEN v, GEN x);
INLINE GEN    vec_shorten(GEN v, long n);
INLINE GEN    vec_to_vecsmall(GEN z);
INLINE GEN    vecpermute(GEN A, GEN p);
INLINE GEN    vecreverse(GEN A);
INLINE GEN    vecslice(GEN A, long y1, long y2);
INLINE GEN    vecslicepermute(GEN A, GEN p, long y1, long y2);
INLINE GEN    vecsplice(GEN a, long j);
INLINE GEN    vecsmall_append(GEN V, long s);
INLINE long   vecsmall_coincidence(GEN u, GEN v);
INLINE GEN    vecsmall_concat(GEN u, GEN v);
INLINE GEN    vecsmall_copy(GEN x);
INLINE GEN    vecsmall_ei(long n, long i);
INLINE long   vecsmall_isin(GEN v, long x);
INLINE GEN    vecsmall_lengthen(GEN v, long n);
INLINE int    vecsmall_lexcmp(GEN x, GEN y);
INLINE long   vecsmall_max(GEN v);
INLINE long   vecsmall_min(GEN v);
INLINE long   vecsmall_pack(GEN V, long base, long mod);
INLINE int    vecsmall_prefixcmp(GEN x, GEN y);
INLINE GEN    vecsmall_prepend(GEN V, long s);
INLINE GEN    vecsmall_shorten(GEN v, long n);
INLINE GEN    vecsmall_to_col(GEN z);
INLINE GEN    vecsmall_to_vec(GEN z);
INLINE void   vecsmalltrunc_append(GEN x, long t);
INLINE GEN    vecsmalltrunc_init(long l);
INLINE void   vectrunc_append(GEN x, GEN t);
INLINE GEN    vectrunc_init(long l);
INLINE GEN    zc_to_ZC(GEN x);
INLINE GEN    zero_F2m(long n, long m);
INLINE GEN    zero_F2m_copy(long n, long m);
INLINE GEN    zero_F2v(long m);
INLINE GEN    zero_F2x(long sv);
INLINE GEN    zero_Flm(long m, long n);
INLINE GEN    zero_Flm_copy(long m, long n);
INLINE GEN    zero_Flv(long n);
INLINE GEN    zero_Flx(long sv);
INLINE GEN    zero_zm(long x, long y);
INLINE GEN    zero_zv(long x);
INLINE GEN    zero_zx(long sv);
INLINE GEN    zerocol(long n);
INLINE GEN    zeromat(long m, long n);
INLINE GEN    zeromatcopy(long m, long n);
INLINE GEN    zeropadic(GEN p, long e);
INLINE GEN    zeropol(long v);
INLINE GEN    zeroser(long v, long e);
INLINE GEN    zerovec(long n);
INLINE GEN    zm_copy(GEN x);
INLINE GEN    zm_to_zxV(GEN x, long sv);
INLINE GEN    zm_transpose(GEN x);
INLINE GEN    zv_copy(GEN x);
INLINE GEN    zv_to_ZV(GEN x);
INLINE GEN    zv_to_zx(GEN x, long sv);
INLINE GEN    zx_renormalize(GEN x, long l);
INLINE GEN    zx_shift(GEN x, long n);
INLINE GEN    zx_to_zv(GEN x, long N);
