/*=========================================================================

   Program: ParaView
   Module:  pqFileNamePropertyWidget.h

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#ifndef pqFileNamePropertyWidget_h
#define pqFileNamePropertyWidget_h

#include "pqApplicationComponentsModule.h"
#include "pqPropertyWidget.h"

/**
* pqFileNamePropertyWidget is used for the "File Name" property on
* the Environment annotation filter. It customizes the resetButtonClicked()
* logic since the Environment filter's filename setup is custom.
*/
class PQAPPLICATIONCOMPONENTS_EXPORT pqFileNamePropertyWidget : public pqPropertyWidget
{
  Q_OBJECT
  typedef pqPropertyWidget Superclass;

public:
  pqFileNamePropertyWidget(vtkSMProxy* proxy, vtkSMProperty* property, QWidget* parent = 0);
  virtual ~pqFileNamePropertyWidget();

signals:
  /**
  * internal signal used to clear highlights from pqHighlightablePushButton.
  */
  void clearHighlight();
  void highlightResetButton();

protected slots:
  /**
  * update the property's value using the domain.
  */
  virtual void resetButtonClicked();

private:
  Q_DISABLE_COPY(pqFileNamePropertyWidget)
};

#endif
