//=======================================================================
// pkg.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_PKG_H
#define GPACO_PKG_H

#include "paco/basepkg.h"
#include <glibmm/ustring.h>
#include <glibmm/refptr.h>

namespace Gdk
{
	class Pixbuf;
}

namespace Gpaco {

typedef Paco::File File;

class PkgWindow;

enum {
	TAB_FILES,
	TAB_INFO,
	TAB_REMOVE,
	TAB_PACKAGE,
	N_TABS
};

class Pkg : public Paco::BasePkg
{
	public:

	Pkg(Glib::ustring const&);
	virtual ~Pkg();

	float sizePercent() const				{ return mSizePercent; }
	float filesPercent() const				{ return mFilesPercent; }
	Glib::RefPtr<Gdk::Pixbuf> icon() const	{ return mpIcon; }
	Glib::ustring const& summary() const	{ return mSummary; }
	PkgWindow const* window() const			{ return mpWindow; }
	PkgWindow* window()						{ return mpWindow; }
	bool changed() const					{ return mChanged; }

	void changed(bool set)					{ mChanged = set; }

	bool listFilesInst() const	{ return mFileType & INSTALLED_FILES; }
	bool listFilesMiss() const	{ return mFileType & MISSING_FILES; }
	void switchListFilesInst()	{ mFileType ^= INSTALLED_FILES; }
	void switchListFilesMiss()	{ mFileType ^= MISSING_FILES; }

	void readLog();
	void presentWindow(int);
	void deleteWindow();
	bool update(bool = true);

	private:

	float						mSizePercent;
	float						mFilesPercent;
	Glib::RefPtr<Gdk::Pixbuf>	mpIcon;
	Glib::ustring				mSummary;
	PkgWindow*					mpWindow;
	int 						mFileType;
	bool						mChanged;

	void getIcon(Glib::ustring const& path);

};

}	// namespace Gpaco


#endif  // GPACO_PKG_H
