/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget.pathlist;

import java.awt.Component;
import java.io.File;
import java.util.ResourceBundle;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import org.dbdoclet.io.FileSet;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.model.PathListModel;
import org.dbdoclet.service.ResourceServices;

public class FilterTypeRenderer extends DefaultTableCellRenderer {

	private static final long serialVersionUID = 1L;
	private PathListModel model;

	public FilterTypeRenderer(PathListModel model) {

		super();

		if (model == null) {
			throw new IllegalArgumentException(
					"The argument model may not be null!");
		}

		this.model = model;

		setHorizontalAlignment(SwingConstants.CENTER);
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {

		FileSet fileset = null;
		JiveFactory jf = JiveFactory.getInstance();
		ResourceBundle res = jf.getResourceBundle();
		
		if (row > -1) {

			fileset = model.getEntry(row);
			
			if (fileset.getFilterType() == FileSet.FILTER_NONE) {
				value = new String("");
			}
			
			if (fileset != null && fileset.isDirectory() == false) {
				
				File path = fileset.getPath();
				
				if (path != null && path.isFile()) {
					value = ResourceServices.getString(res, "C_FILE");
				}
			
			} else {
			}
		}

		Component comp = super.getTableCellRendererComponent(table, value, isSelected,
				hasFocus, row, column);
		
		if (fileset == null || fileset.isDirectory() == false) {
			comp.setEnabled(false);
			// comp.setBackground(Color.lightGray);
		} else {
			comp.setEnabled(true);
			// comp.setBackground(Color.white);
		}

		return comp;
	}
}
